/*
 * Decompiled with CFR 0.152.
 */
package org.xadisk.filesystem.virtual;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.locks.ReentrantLock;
import org.xadisk.bridge.proxies.interfaces.XAFileInputStream;
import org.xadisk.filesystem.Buffer;
import org.xadisk.filesystem.NativeSession;
import org.xadisk.filesystem.NativeXAFileSystem;
import org.xadisk.filesystem.exceptions.ClosedStreamException;
import org.xadisk.filesystem.exceptions.FileNotExistsException;
import org.xadisk.filesystem.exceptions.NoTransactionAssociatedException;
import org.xadisk.filesystem.pools.PooledBuffer;
import org.xadisk.filesystem.virtual.VirtualViewFile;

public class NativeXAFileInputStream
implements XAFileInputStream {
    private FileChannel physicalFileChannel;
    private FileInputStream physicalFileInputStream;
    private ByteBuffer byteBuffer;
    private final NativeXAFileSystem xaFileSystem;
    private boolean filledAtleastOnce = false;
    private final VirtualViewFile vvf;
    private boolean closed = false;
    private long position;
    private final ByteBuffer cachedWritableByteBuffer;
    private int headerLengthInByteBuffer;
    private final NativeSession owningSession;
    private final ReentrantLock asynchronousRollbackLock;
    private final PooledBuffer pooledBuffer;

    public NativeXAFileInputStream(VirtualViewFile vvf, NativeSession owningSession, NativeXAFileSystem xaFileSystem) throws FileNotExistsException {
        this.xaFileSystem = xaFileSystem;
        this.pooledBuffer = this.xaFileSystem.getBufferPool().checkOut();
        this.byteBuffer = this.pooledBuffer != null ? this.pooledBuffer.getBuffer() : new Buffer(xaFileSystem.getConfiguredBufferSize(), false, xaFileSystem).getBuffer();
        this.cachedWritableByteBuffer = this.byteBuffer;
        assert (this.cachedWritableByteBuffer != null);
        assert (!this.cachedWritableByteBuffer.isReadOnly());
        this.vvf = vvf;
        vvf.addBeingRead();
        this.position = 0L;
        this.owningSession = owningSession;
        this.asynchronousRollbackLock = owningSession.getAsynchronousRollbackLock();
        if (vvf.isMappedToAPhysicalFile()) {
            try {
                this.physicalFileInputStream = new FileInputStream(vvf.getMappedToPhysicalFile());
                this.physicalFileChannel = this.physicalFileInputStream.getChannel();
            }
            catch (FileNotFoundException fnfe) {
                throw new FileNotExistsException(vvf.getFileName().getAbsolutePath());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int available() throws NoTransactionAssociatedException, ClosedStreamException {
        try {
            this.asynchronousRollbackLock.lock();
            this.checkIfCanContinue();
            if (!this.filledAtleastOnce) {
                int n = 0;
                return n;
            }
            int n = this.byteBuffer.remaining();
            return n;
        }
        finally {
            this.asynchronousRollbackLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws NoTransactionAssociatedException {
        if (this.closed) {
            return;
        }
        try {
            this.asynchronousRollbackLock.lock();
            this.owningSession.checkIfCanContinue();
            if (this.physicalFileChannel != null) {
                try {
                    this.physicalFileInputStream.close();
                }
                catch (IOException ioe) {
                    this.xaFileSystem.notifySystemFailure(ioe);
                }
            }
            this.vvf.reduceBeingRead();
            if (this.pooledBuffer != null) {
                this.xaFileSystem.getBufferPool().checkIn(this.pooledBuffer);
            }
            this.closed = true;
        }
        finally {
            this.asynchronousRollbackLock.unlock();
        }
    }

    /*
     * Exception decompiling
     */
    public int read() throws ClosedStreamException, NoTransactionAssociatedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int read(byte[] b) throws ClosedStreamException, NoTransactionAssociatedException {
        return this.read(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] b, int off, int len) throws ClosedStreamException, NoTransactionAssociatedException {
        try {
            int eofMark;
            this.asynchronousRollbackLock.lock();
            this.checkIfCanContinue();
            if (!this.filledAtleastOnce && (eofMark = this.refillBuffer()) == -1) {
                int n = -1;
                return n;
            }
            int remaining = this.byteBuffer.remaining();
            if (remaining == 0 && (eofMark = this.refillBuffer()) == -1) {
                int n = -1;
                return n;
            }
            remaining = this.byteBuffer.remaining();
            if (remaining < len) {
                len = remaining;
            }
            this.byteBuffer.get(b, off, len);
            int n = len;
            return n;
        }
        finally {
            this.asynchronousRollbackLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(long n) throws NoTransactionAssociatedException, ClosedStreamException {
        try {
            long readPositionAfterSkip;
            this.asynchronousRollbackLock.lock();
            this.checkIfCanContinue();
            if (n < 0L) {
                throw new IllegalArgumentException("Argument should be a non-negative integer.");
            }
            long filesize = this.vvf.getLength();
            int bufferedBytesRemaining = 0;
            if (this.filledAtleastOnce) {
                bufferedBytesRemaining = this.byteBuffer.remaining();
            }
            if ((readPositionAfterSkip = this.position - (long)bufferedBytesRemaining + n) > filesize) {
                n -= readPositionAfterSkip - filesize;
                readPositionAfterSkip = filesize;
            }
            this.position(readPositionAfterSkip);
            long l = n;
            return l;
        }
        finally {
            this.asynchronousRollbackLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void position(long n) throws NoTransactionAssociatedException, ClosedStreamException {
        try {
            this.asynchronousRollbackLock.lock();
            this.checkIfCanContinue();
            long filesize = this.vvf.getLength();
            if (n < 0L || n > filesize) {
                throw new IllegalArgumentException("New position cannot be negative or more than file size.");
            }
            if (!this.filledAtleastOnce) {
                this.position = n;
                return;
            }
            long oldReadPosition = this.position - (long)this.byteBuffer.remaining();
            boolean isAhead = n - oldReadPosition > 0L;
            long amountOfMove = Math.abs(n - oldReadPosition);
            if (isAhead) {
                if (amountOfMove > (long)this.byteBuffer.remaining()) {
                    this.position = n;
                    this.byteBuffer.position(this.byteBuffer.limit());
                } else {
                    this.byteBuffer.position(this.byteBuffer.position() + (int)amountOfMove);
                }
            } else if (amountOfMove > (long)(this.byteBuffer.position() - this.headerLengthInByteBuffer)) {
                this.position = n;
                this.byteBuffer.position(this.byteBuffer.limit());
            } else {
                this.byteBuffer.position(this.byteBuffer.position() - (int)amountOfMove);
            }
        }
        finally {
            this.asynchronousRollbackLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long position() {
        try {
            this.asynchronousRollbackLock.lock();
            if (!this.filledAtleastOnce) {
                long l = 0L;
                return l;
            }
            long l = this.position - (long)(this.byteBuffer.remaining() - this.headerLengthInByteBuffer);
            return l;
        }
        finally {
            this.asynchronousRollbackLock.unlock();
        }
    }

    private int refillBuffer() {
        try {
            this.byteBuffer = this.cachedWritableByteBuffer;
            this.byteBuffer.clear();
            int numRead = 0;
            if (this.vvf.isUsingHeavyWriteOptimization()) {
                numRead = this.vvf.fillUpContentsFromChannel(this.byteBuffer, this.position);
                this.byteBuffer.flip();
                if (numRead != -1) {
                    this.filledAtleastOnce = true;
                    this.position += (long)numRead;
                }
                this.headerLengthInByteBuffer = 0;
                return numRead;
            }
            if (this.position <= this.vvf.getMappedToThePhysicalFileTill() - 1L) {
                long maxAmountToBeRead = this.vvf.getMappedToThePhysicalFileTill() - this.position;
                if (maxAmountToBeRead < (long)this.byteBuffer.limit()) {
                    this.byteBuffer.limit((int)maxAmountToBeRead);
                }
                this.physicalFileChannel.position(this.position);
                while (numRead == 0) {
                    numRead = this.physicalFileChannel.read(this.byteBuffer);
                }
                if (numRead != -1) {
                    this.position += (long)numRead;
                    this.filledAtleastOnce = true;
                }
                this.byteBuffer.flip();
                this.headerLengthInByteBuffer = 0;
                return numRead;
            }
            Buffer newBuffer = this.vvf.getInMemoryContentBuffer(this.position);
            if (newBuffer == null) {
                this.byteBuffer.flip();
                return -1;
            }
            if ((newBuffer = newBuffer.createReadOnlyClone()).getBuffer() == null) {
                int offsetInNewBuffer = (int)(this.position - newBuffer.getFileContentPosition());
                numRead = newBuffer.regenerateContentFromDisk(this.byteBuffer, offsetInNewBuffer);
                if (numRead != -1) {
                    this.position += (long)numRead;
                    this.filledAtleastOnce = true;
                }
                this.headerLengthInByteBuffer = 0;
                return numRead;
            }
            this.byteBuffer = newBuffer.getBuffer();
            int offsetInNewBuffer = (int)(this.position - newBuffer.getFileContentPosition());
            this.byteBuffer.position(newBuffer.getHeaderLength() + offsetInNewBuffer);
            this.byteBuffer.limit(newBuffer.getHeaderLength() + newBuffer.getFileContentLength());
            this.position = this.position + (long)newBuffer.getFileContentLength() - (long)offsetInNewBuffer;
            this.filledAtleastOnce = true;
            this.headerLengthInByteBuffer = this.byteBuffer.position();
            return 0;
        }
        catch (IOException ioe) {
            this.xaFileSystem.notifySystemFailure(ioe);
            return -1;
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    private void checkIfCanContinue() throws NoTransactionAssociatedException, ClosedStreamException {
        this.owningSession.checkIfCanContinue();
    }

    public File getSourceFileName() {
        return this.vvf.getFileName();
    }
}

