/*
 * Decompiled with CFR 0.152.
 */
package org.opends.admin.ads;

import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.opends.admin.ads.ADSContext;
import org.opends.admin.ads.ADSContextException;
import org.opends.server.admin.ManagedObjectNotFoundException;
import org.opends.server.admin.client.ManagementContext;
import org.opends.server.admin.client.ldap.JNDIDirContextAdaptor;
import org.opends.server.admin.client.ldap.LDAPManagementContext;
import org.opends.server.admin.std.client.BackendCfgClient;
import org.opends.server.admin.std.client.LDIFBackendCfgClient;
import org.opends.server.admin.std.client.RootCfgClient;
import org.opends.server.admin.std.meta.BackendCfgDefn;
import org.opends.server.admin.std.meta.LDIFBackendCfgDefn;
import org.opends.server.crypto.CryptoManagerImpl;
import org.opends.server.types.CryptoManagerException;
import org.opends.server.types.DN;

public class ADSContextHelper {
    public void removeAdministrationSuffix(InitialLdapContext ctx, String backendName) throws ADSContextException {
        try {
            SortedSet<DN> suffixes;
            ManagementContext mCtx = LDAPManagementContext.createFromContext(JNDIDirContextAdaptor.adapt(ctx));
            RootCfgClient root = mCtx.getRootConfiguration();
            BackendCfgClient backend = null;
            try {
                backend = root.getBackend(backendName);
            }
            catch (ManagedObjectNotFoundException managedObjectNotFoundException) {
                // empty catch block
            }
            if (backend != null && (suffixes = backend.getBaseDN()) != null && suffixes.remove(DN.decode(ADSContext.getAdministrationSuffixDN()))) {
                if (suffixes.size() > 0) {
                    backend.setBaseDN(suffixes);
                    backend.commit();
                } else {
                    root.removeBackend(backendName);
                }
            }
        }
        catch (Throwable t) {
            throw new ADSContextException(ADSContextException.ErrorType.ERROR_UNEXPECTED, t);
        }
    }

    public void createAdministrationSuffix(InitialLdapContext ctx, String backendName) throws ADSContextException {
        try {
            DN newDN;
            SortedSet<DN> suffixes;
            ManagementContext mCtx = LDAPManagementContext.createFromContext(JNDIDirContextAdaptor.adapt(ctx));
            RootCfgClient root = mCtx.getRootConfiguration();
            LDIFBackendCfgClient backend = null;
            try {
                backend = (LDIFBackendCfgClient)root.getBackend(backendName);
            }
            catch (ManagedObjectNotFoundException managedObjectNotFoundException) {
            }
            catch (ClassCastException cce) {
                throw new ADSContextException(ADSContextException.ErrorType.UNEXPECTED_ADS_BACKEND_TYPE, (Throwable)cce);
            }
            if (backend == null) {
                LDIFBackendCfgDefn provider = LDIFBackendCfgDefn.getInstance();
                backend = root.createBackend(provider, backendName, null);
                backend.setEnabled(true);
                backend.setLDIFFile(ADSContext.getAdminLDIFFile());
                backend.setBackendId(backendName);
                backend.setWritabilityMode(BackendCfgDefn.WritabilityMode.ENABLED);
                backend.setIsPrivateBackend(true);
            }
            if ((suffixes = backend.getBaseDN()) == null) {
                suffixes = new TreeSet<DN>();
            }
            if (!suffixes.contains(newDN = DN.decode(ADSContext.getAdministrationSuffixDN()))) {
                suffixes.add(newDN);
                backend.setBaseDN(suffixes);
                backend.commit();
            }
        }
        catch (Throwable t) {
            throw new ADSContextException(ADSContextException.ErrorType.ERROR_UNEXPECTED, t);
        }
    }

    public void registerInstanceKeyCertificate(InitialLdapContext ctx, Map<ADSContext.ServerProperty, Object> serverProperties, LdapName serverEntryDn) throws ADSContextException {
        assert (serverProperties.containsKey((Object)ADSContext.ServerProperty.INSTANCE_PUBLIC_KEY_CERTIFICATE));
        if (!serverProperties.containsKey((Object)ADSContext.ServerProperty.INSTANCE_PUBLIC_KEY_CERTIFICATE)) {
            return;
        }
        String keyID = (String)serverProperties.get((Object)ADSContext.ServerProperty.INSTANCE_KEY_ID);
        BasicAttributes keyAttrs = new BasicAttributes();
        BasicAttribute oc = new BasicAttribute("objectclass");
        oc.add("top");
        oc.add("ds-cfg-instance-key");
        keyAttrs.put(oc);
        if (null != keyID) {
            keyAttrs.put(new BasicAttribute(ADSContext.ServerProperty.INSTANCE_KEY_ID.getAttributeName(), keyID));
        }
        keyAttrs.put(new BasicAttribute(ADSContext.ServerProperty.INSTANCE_PUBLIC_KEY_CERTIFICATE.getAttributeName() + ";binary", serverProperties.get((Object)ADSContext.ServerProperty.INSTANCE_PUBLIC_KEY_CERTIFICATE)));
        String[] attrIDs = new String[]{"ds-cfg-key-id"};
        NamingEnumeration<SearchResult> results = null;
        try {
            results = ctx.search(ADSContext.getInstanceKeysContainerDN(), (Attributes)keyAttrs, attrIDs);
            boolean found = false;
            while (results.hasMore()) {
                Attribute keyIdAttr = results.next().getAttributes().get(attrIDs[0]);
                if (null != keyIdAttr) {
                    keyID = (String)keyIdAttr.get();
                }
                found = true;
            }
            if (!found) {
                if (null == keyID) {
                    keyID = CryptoManagerImpl.getInstanceKeyID((byte[])serverProperties.get((Object)ADSContext.ServerProperty.INSTANCE_PUBLIC_KEY_CERTIFICATE));
                    keyAttrs.put(new BasicAttribute(ADSContext.ServerProperty.INSTANCE_KEY_ID.getAttributeName(), keyID));
                }
                LdapName keyDn = new LdapName(ADSContext.ServerProperty.INSTANCE_KEY_ID.getAttributeName() + "=" + Rdn.escapeValue(keyID) + "," + ADSContext.getInstanceKeysContainerDN());
                ctx.createSubcontext(keyDn, (Attributes)keyAttrs).close();
            }
            if (serverEntryDn != null) {
                ctx.modifyAttributes(serverEntryDn, 2, (Attributes)new BasicAttributes(ADSContext.ServerProperty.INSTANCE_KEY_ID.getAttributeName(), keyID));
            }
        }
        catch (NamingException ne) {
            throw new ADSContextException(ADSContextException.ErrorType.ERROR_UNEXPECTED, (Throwable)ne);
        }
        catch (CryptoManagerException cme) {
            throw new ADSContextException(ADSContextException.ErrorType.ERROR_UNEXPECTED, (Throwable)cme);
        }
        finally {
            this.handleCloseNamingEnumeration(results);
        }
    }

    public void unregisterInstanceKeyCertificate(InitialLdapContext ctx, Map<ADSContext.ServerProperty, Object> serverProperties, LdapName serverEntryDn) throws ADSContextException {
        assert (serverProperties.containsKey((Object)ADSContext.ServerProperty.INSTANCE_PUBLIC_KEY_CERTIFICATE));
        if (!serverProperties.containsKey((Object)ADSContext.ServerProperty.INSTANCE_PUBLIC_KEY_CERTIFICATE)) {
            return;
        }
        BasicAttributes keyAttrs = new BasicAttributes();
        BasicAttribute oc = new BasicAttribute("objectclass");
        oc.add("top");
        oc.add("ds-cfg-instance-key");
        keyAttrs.put(oc);
        keyAttrs.put(new BasicAttribute(ADSContext.ServerProperty.INSTANCE_PUBLIC_KEY_CERTIFICATE.getAttributeName() + ";binary", serverProperties.get((Object)ADSContext.ServerProperty.INSTANCE_PUBLIC_KEY_CERTIFICATE)));
        String[] attrIDs = new String[]{"ds-cfg-key-id"};
        NamingEnumeration<SearchResult> results = null;
        try {
            results = ctx.search(ADSContext.getInstanceKeysContainerDN(), (Attributes)keyAttrs, attrIDs);
            while (results.hasMore()) {
                SearchResult res = results.next();
                ctx.destroySubcontext(res.getNameInNamespace());
            }
        }
        catch (NameNotFoundException res) {
        }
        catch (NamingException ne) {
            throw new ADSContextException(ADSContextException.ErrorType.ERROR_UNEXPECTED, (Throwable)ne);
        }
        finally {
            this.handleCloseNamingEnumeration(results);
        }
    }

    public String getOcCryptoInstanceKey() {
        return "ds-cfg-instance-key";
    }

    public String getAttrCryptoKeyCompromisedTime() {
        return "ds-cfg-key-compromised-time";
    }

    private void handleCloseNamingEnumeration(NamingEnumeration<?> ne) throws ADSContextException {
        if (ne != null) {
            try {
                ne.close();
            }
            catch (NamingException ex) {
                throw new ADSContextException(ADSContextException.ErrorType.ERROR_UNEXPECTED, (Throwable)ex);
            }
        }
    }
}

