/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.datamodel;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.opends.guitools.controlpanel.datamodel.SortableTableModel;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.quicksetup.util.Utils;
import org.opends.server.backends.task.TaskState;
import org.opends.server.tools.tasks.TaskEntry;

public class TaskTableModel
extends SortableTableModel
implements Comparator<TaskEntry> {
    private static final long serialVersionUID = -351142550147124L;
    private Set<TaskEntry> data = new HashSet<TaskEntry>();
    private ArrayList<TaskEntry> dataSourceArray = new ArrayList();
    LinkedHashSet<Message> displayedAttributes = new LinkedHashSet();
    final LinkedHashSet<Message> defaultAttributes = new LinkedHashSet();
    LinkedHashSet<Message> allAttributes;
    private String[] columnNames;
    private int sortColumn;
    private boolean sortAscending;

    public TaskTableModel() {
        this.defaultAttributes.add(ToolMessages.INFO_TASKINFO_FIELD_ID.get());
        this.defaultAttributes.add(ToolMessages.INFO_TASKINFO_FIELD_TYPE.get());
        this.defaultAttributes.add(ToolMessages.INFO_TASKINFO_FIELD_STATUS.get());
        this.defaultAttributes.add(AdminToolMessages.INFO_CTRL_PANEL_TASK_CANCELABLE.get());
        this.allAttributes = new LinkedHashSet();
        this.allAttributes.addAll(this.defaultAttributes);
        this.allAttributes.add(ToolMessages.INFO_TASKINFO_FIELD_SCHEDULED_START.get());
        this.allAttributes.add(ToolMessages.INFO_TASKINFO_FIELD_ACTUAL_START.get());
        this.allAttributes.add(ToolMessages.INFO_TASKINFO_FIELD_COMPLETION_TIME.get());
        this.allAttributes.add(ToolMessages.INFO_TASKINFO_FIELD_DEPENDENCY.get());
        this.allAttributes.add(ToolMessages.INFO_TASKINFO_FIELD_FAILED_DEPENDENCY_ACTION.get());
        this.allAttributes.add(ToolMessages.INFO_TASKINFO_FIELD_NOTIFY_ON_COMPLETION.get());
        this.allAttributes.add(ToolMessages.INFO_TASKINFO_FIELD_NOTIFY_ON_ERROR.get());
        this.columnNames = new String[0];
        this.sortColumn = 0;
        this.sortAscending = true;
        this.setAttributes(this.defaultAttributes);
    }

    public void setData(Set<TaskEntry> newData) {
        if (!newData.equals(this.data)) {
            this.data.clear();
            this.data.addAll(newData);
            this.updateDataArray();
            this.fireTableDataChanged();
        }
    }

    @Override
    public void forceResort() {
        this.updateDataArray();
        this.fireTableDataChanged();
    }

    public void forceDataStructureChange() {
        this.updateDataArray();
        this.fireTableStructureChanged();
        this.fireTableDataChanged();
    }

    private void updateDataArray() {
        TreeSet<TaskEntry> sortedSet = new TreeSet<TaskEntry>(this);
        sortedSet.addAll(this.data);
        this.dataSourceArray.clear();
        for (TaskEntry task : sortedSet) {
            this.dataSourceArray.add(task);
        }
    }

    public void setAttributes(LinkedHashSet<Message> attributes) {
        if (!this.allAttributes.containsAll(attributes)) {
            throw new IllegalArgumentException("Some of the provided attributes are not valid.");
        }
        this.displayedAttributes.clear();
        this.displayedAttributes.addAll(attributes);
        int columnCount = attributes.size();
        this.columnNames = new String[columnCount];
        int i = 0;
        for (Message attribute : attributes) {
            this.columnNames[i] = this.getHeader(attribute, 15);
            ++i;
        }
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return Message.class;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public Object getValueAt(int row, int column) {
        Message value;
        column = this.getFixedOrderColumn(column);
        TaskEntry taskEntry = this.get(row);
        switch (column) {
            case 0: {
                value = Message.raw(taskEntry.getId(), new Object[0]);
                break;
            }
            case 1: {
                value = taskEntry.getType();
                break;
            }
            case 2: {
                value = taskEntry.getState();
                break;
            }
            case 3: {
                if (taskEntry.isCancelable()) {
                    value = AdminToolMessages.INFO_CTRL_PANEL_TASK_IS_CANCELABLE.get();
                    break;
                }
                value = AdminToolMessages.INFO_CTRL_PANEL_TASK_IS_NOT_CANCELABLE.get();
                break;
            }
            case 4: {
                if (TaskState.isRecurring(this.get(row).getTaskState())) {
                    value = taskEntry.getScheduleTab();
                    break;
                }
                value = taskEntry.getScheduledStartTime();
                if (value != null && !value.equals(Message.EMPTY)) break;
                value = ToolMessages.INFO_TASKINFO_IMMEDIATE_EXECUTION.get();
                break;
            }
            case 5: {
                value = taskEntry.getActualStartTime();
                break;
            }
            case 6: {
                value = taskEntry.getCompletionTime();
                break;
            }
            case 7: {
                value = this.getValue(taskEntry.getDependencyIds(), ToolMessages.INFO_TASKINFO_NONE_SPECIFIED.get());
                break;
            }
            case 8: {
                value = taskEntry.getFailedDependencyAction();
                if (value != null) break;
                value = ToolMessages.INFO_TASKINFO_NONE.get();
                break;
            }
            case 9: {
                value = this.getValue(taskEntry.getCompletionNotificationEmailAddresses(), ToolMessages.INFO_TASKINFO_NONE_SPECIFIED.get());
                break;
            }
            case 10: {
                value = this.getValue(taskEntry.getErrorNotificationEmailAddresses(), ToolMessages.INFO_TASKINFO_NONE_SPECIFIED.get());
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid column: " + column);
            }
        }
        return value;
    }

    @Override
    public int getRowCount() {
        return this.dataSourceArray.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    public TaskEntry get(int row) {
        return this.dataSourceArray.get(row);
    }

    public LinkedHashSet<Message> getDisplayedAttributes() {
        return this.displayedAttributes;
    }

    public LinkedHashSet<Message> getAllAttributes() {
        return this.allAttributes;
    }

    @Override
    public int compare(TaskEntry desc1, TaskEntry desc2) {
        ArrayList<Integer> possibleResults = new ArrayList<Integer>();
        possibleResults.add(desc1.getId().compareTo(desc2.getId()));
        possibleResults.add(desc1.getType().compareTo(desc2.getType()));
        possibleResults.add(desc1.getState().compareTo(desc2.getState()));
        possibleResults.add(String.valueOf(desc1.isCancelable()).compareTo(String.valueOf(desc2.isCancelable())));
        int result = (Integer)possibleResults.get(this.getSortColumn());
        if (result == 0) {
            Iterator i$ = possibleResults.iterator();
            while (i$.hasNext()) {
                int i = (Integer)i$.next();
                if (i == 0) continue;
                result = i;
                break;
            }
        }
        if (!this.isSortAscending()) {
            result = -result;
        }
        return result;
    }

    @Override
    public boolean isSortAscending() {
        return this.sortAscending;
    }

    @Override
    public void setSortAscending(boolean sortAscending) {
        this.sortAscending = sortAscending;
    }

    @Override
    public int getSortColumn() {
        return this.sortColumn;
    }

    @Override
    public void setSortColumn(int sortColumn) {
        this.sortColumn = sortColumn;
    }

    private int getFixedOrderColumn(int column) {
        Message msg2;
        int fixedOrderColumn = 0;
        int i = 0;
        Message colMsg = null;
        for (Message msg2 : this.displayedAttributes) {
            if (i == column) {
                colMsg = msg2;
                break;
            }
            ++i;
        }
        Iterator i$ = this.allAttributes.iterator();
        while (i$.hasNext() && !(msg2 = (Message)i$.next()).equals(colMsg)) {
            ++fixedOrderColumn;
        }
        return fixedOrderColumn;
    }

    private Message getValue(List<String> values, Message valueIfEmpty) {
        Message msg;
        if (values.isEmpty()) {
            msg = valueIfEmpty;
        } else {
            String s = Utils.getStringFromCollection(values, "<br>");
            msg = values.size() > 1 ? Message.raw("<html>" + Utilities.applyFont(s, ColorAndFontConstants.tableFont), new Object[0]) : Message.raw(s, new Object[0]);
        }
        return msg;
    }
}

