/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.event;

import java.awt.Component;
import java.awt.Container;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.text.JTextComponent;

public class ComboKeySelectionManager
implements JComboBox.KeySelectionManager {
    private JComboBox combo;
    private JList list;
    private String lastSearchedString;
    private long lastSearchedTime;
    private long RESET_BETWEEN_TYPES = 700L;

    public ComboKeySelectionManager(JComboBox combo) {
        this.combo = combo;
        this.list = new JList();
    }

    public int selectionForKey(char key, ComboBoxModel model) {
        int selectedIndex = -1;
        long currentTime = System.currentTimeMillis();
        if (key == '\b') {
            if (this.lastSearchedString == null) {
                this.lastSearchedString = "";
            } else if (this.lastSearchedString.length() > 0) {
                this.lastSearchedString = this.lastSearchedString.substring(0, this.lastSearchedString.length() - 1);
            }
        } else {
            this.lastSearchedString = this.lastSearchedTime + this.RESET_BETWEEN_TYPES < currentTime ? String.valueOf(key) : (this.lastSearchedString == null ? String.valueOf(key) : this.lastSearchedString + key);
        }
        this.lastSearchedTime = currentTime;
        if (this.lastSearchedString.length() > 0) {
            for (int i = 0; i < model.getSize() && selectedIndex == -1; ++i) {
                String sValue;
                Object value = model.getElementAt(i);
                Component comp = this.combo.getRenderer().getListCellRendererComponent(this.list, value, i, true, true);
                sValue = comp instanceof Container ? ((sValue = this.getDisplayedStringValue((Container)comp)) == null ? "" : sValue.trim()) : String.valueOf(value);
                if (!sValue.toLowerCase().startsWith(this.lastSearchedString.toLowerCase())) continue;
                selectedIndex = i;
            }
        }
        return selectedIndex;
    }

    private String getDisplayedStringValue(Container c) {
        String sValue = null;
        if (c instanceof JLabel) {
            sValue = ((JLabel)c).getText();
        } else if (c instanceof JTextComponent) {
            sValue = ((JTextComponent)c).getText();
        } else {
            int nCount = c.getComponentCount();
            for (int i = 0; i < nCount && sValue == null; ++i) {
                Component child = c.getComponent(i);
                if (!(child instanceof Container)) continue;
                sValue = this.getDisplayedStringValue((Container)child);
            }
        }
        return sValue;
    }
}

