/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.opends.guitools.controlpanel.datamodel.BackendDescriptor;
import org.opends.guitools.controlpanel.datamodel.DBEnvironmentMonitoringTableModel;
import org.opends.guitools.controlpanel.datamodel.ServerDescriptor;
import org.opends.guitools.controlpanel.ui.GeneralMonitoringPanel;
import org.opends.guitools.controlpanel.ui.GenericDialog;
import org.opends.guitools.controlpanel.ui.MonitoringAttributesViewPanel;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;

public class DBEnvironmentMonitoringPanel
extends GeneralMonitoringPanel {
    private static final long serialVersionUID = 9031734563723229830L;
    private JTable table;
    private DBEnvironmentMonitoringTableModel tableModel;
    private JScrollPane scroll;
    private JLabel noDBsFound;
    private JLabel noMonitoringFound;
    private JButton showOperations;
    private LinkedHashSet<String> attributes = new LinkedHashSet();
    private LinkedHashSet<String> allAttributes = new LinkedHashSet();
    private MonitoringAttributesViewPanel<String> operationViewPanel;
    private GenericDialog operationViewDlg;

    public DBEnvironmentMonitoringPanel() {
        this.createLayout();
    }

    @Override
    public Component getPreferredFocusComponent() {
        return this.table;
    }

    private void createLayout() {
        GridBagConstraints gbc = new GridBagConstraints();
        JLabel lTitle = Utilities.createTitleLabel(AdminToolMessages.INFO_CTRL_PANEL_DB_ENVIRONMENT.get());
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.gridwidth = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets.top = 5;
        gbc.insets.bottom = 7;
        this.add((Component)lTitle, gbc);
        gbc.insets.bottom = 0;
        gbc.insets.top = 10;
        ++gbc.gridy;
        gbc.anchor = 17;
        gbc.gridwidth = 1;
        this.showOperations = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_OPERATIONS_VIEW.get());
        this.showOperations.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                DBEnvironmentMonitoringPanel.this.operationViewClicked();
            }
        });
        this.showOperations.setVisible(false);
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.add(Box.createHorizontalGlue(), gbc);
        ++gbc.gridx;
        gbc.weightx = 0.0;
        this.add((Component)this.showOperations, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 2;
        this.tableModel = new DBEnvironmentMonitoringTableModel();
        this.tableModel.setAttributes(this.attributes);
        this.table = Utilities.createSortableTable(this.tableModel, new DefaultTableCellRenderer());
        this.scroll = Utilities.createScrollPane(this.table);
        this.updateTableSize();
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)this.scroll, gbc);
        this.noDBsFound = Utilities.createDefaultLabel(AdminToolMessages.INFO_CTRL_PANEL_NO_DBS_FOUND.get());
        this.noDBsFound.setHorizontalAlignment(0);
        this.add((Component)this.noDBsFound, gbc);
        this.noMonitoringFound = Utilities.createDefaultLabel(AdminToolMessages.INFO_CTRL_PANEL_NO_DB_MONITORING_FOUND.get());
        this.noMonitoringFound.setHorizontalAlignment(0);
        this.add((Component)this.noMonitoringFound, gbc);
        this.setBorder(this.PANEL_BORDER);
    }

    public void updateContents() {
        boolean backendsFound = false;
        ServerDescriptor server = null;
        if (this.getInfo() != null) {
            server = this.getInfo().getServerDescriptor();
        }
        HashSet<BackendDescriptor> dbBackends = new HashSet<BackendDescriptor>();
        boolean updateAttributes = this.allAttributes.isEmpty();
        TreeSet<String> sortedAttrNames = new TreeSet<String>();
        if (server != null) {
            for (BackendDescriptor backend : server.getBackends()) {
                if (backend.getType() != BackendDescriptor.Type.LOCAL_DB) continue;
                dbBackends.add(backend);
                if (!updateAttributes) continue;
                sortedAttrNames.addAll(this.getMonitoringAttributes(backend));
            }
            boolean bl = backendsFound = !dbBackends.isEmpty();
        }
        if (updateAttributes) {
            this.allAttributes.addAll(sortedAttrNames);
            for (String attrName : this.allAttributes) {
                this.attributes.add(attrName);
                if (this.attributes.size() != 5) continue;
                break;
            }
            if (this.attributes.size() > 0) {
                this.setOperationsToDisplay(this.attributes);
                this.updateTableSize();
            }
        }
        this.tableModel.setData(dbBackends);
        this.showOperations.setVisible(backendsFound);
        this.scroll.setVisible(backendsFound && !this.allAttributes.isEmpty());
        this.noDBsFound.setVisible(!backendsFound);
        this.noMonitoringFound.setVisible(backendsFound && this.allAttributes.isEmpty());
        this.showOperations.setVisible(this.allAttributes.size() > 0);
    }

    private void updateTableSize() {
        Utilities.updateTableSizes(this.table, 8);
        Utilities.updateScrollMode(this.scroll, this.table);
    }

    private void operationViewClicked() {
        if (this.operationViewDlg == null) {
            this.operationViewPanel = MonitoringAttributesViewPanel.createStringInstance(this.allAttributes);
            this.operationViewDlg = new GenericDialog(Utilities.getFrame(this), this.operationViewPanel);
            this.operationViewDlg.setModal(true);
            Utilities.centerGoldenMean(this.operationViewDlg, Utilities.getParentDialog(this));
        }
        this.operationViewPanel.setSelectedAttributes(this.attributes);
        this.operationViewDlg.setVisible(true);
        if (!this.operationViewPanel.isCanceled()) {
            this.attributes = this.operationViewPanel.getAttributes();
            this.setOperationsToDisplay(this.attributes);
            this.updateTableSize();
        }
    }

    private void setOperationsToDisplay(LinkedHashSet<String> attributes) {
        this.attributes = attributes;
        this.tableModel.setAttributes(attributes);
        this.tableModel.forceDataStructureChange();
    }

    private Set<String> getMonitoringAttributes(BackendDescriptor backend) {
        HashSet<String> attrNames = new HashSet<String>();
        if (backend.getMonitoringEntry() != null) {
            SortedSet<String> allNames = backend.getMonitoringEntry().getAttributeNames();
            for (String attrName : allNames) {
                if (attrName.equalsIgnoreCase("objectclass") || attrName.equalsIgnoreCase("cn")) continue;
                attrNames.add(attrName);
            }
        }
        return attrNames;
    }
}

