/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.naming.ldap.InitialLdapContext;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.opends.guitools.controlpanel.browser.BrowserController;
import org.opends.guitools.controlpanel.datamodel.CustomSearchResult;
import org.opends.guitools.controlpanel.ui.AbstractNewEntryPanel;
import org.opends.guitools.controlpanel.ui.GenericDialog;
import org.opends.guitools.controlpanel.ui.LDAPEntrySelectionPanel;
import org.opends.guitools.controlpanel.ui.ViewEntryPanel;
import org.opends.guitools.controlpanel.ui.nodes.BasicNode;
import org.opends.guitools.controlpanel.util.BackgroundTask;
import org.opends.guitools.controlpanel.util.LDAPEntryReader;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.quicksetup.util.Utils;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.util.Base64;
import org.opends.server.util.LDIFException;

public class DuplicateEntryPanel
extends AbstractNewEntryPanel {
    private static final long serialVersionUID = -9879879123123123L;
    private JLabel lName;
    private JTextField name;
    private JLabel lParentDN;
    private JTextField parentDN;
    private JLabel lPassword;
    private JPasswordField password = Utilities.createPasswordField(25);
    private JLabel lconfirmPassword;
    private JPasswordField confirmPassword = Utilities.createPasswordField(25);
    private JLabel lPasswordInfo;
    private JButton browse;
    private JLabel dn;
    private GenericDialog browseDlg;
    private LDAPEntrySelectionPanel browsePanel;
    private CustomSearchResult entryToDuplicate;
    private String rdnAttribute;

    public DuplicateEntryPanel() {
        this.createLayout();
    }

    @Override
    public Component getPreferredFocusComponent() {
        return this.name;
    }

    @Override
    public boolean requiresScroll() {
        return true;
    }

    @Override
    public void setParent(BasicNode parentNode, BrowserController controller) {
        throw new IllegalArgumentException("this method must not be called");
    }

    public void setEntryToDuplicate(BasicNode node, BrowserController controller) {
        String aRdn;
        DN aParentDN;
        if (node == null) {
            throw new IllegalArgumentException("node is null.");
        }
        this.displayMessage(AdminToolMessages.INFO_CTRL_PANEL_READING_SUMMARY.get());
        this.setEnabledOK(false);
        this.entryToDuplicate = null;
        this.controller = controller;
        try {
            DN nodeDN = DN.decode(node.getDN());
            if (nodeDN.isNullDN()) {
                aParentDN = nodeDN;
                aRdn = "(1)";
            } else {
                aParentDN = nodeDN.getParent();
                aRdn = nodeDN.getRDN().getAttributeValue(0).toString() + "-1";
            }
        }
        catch (DirectoryException de) {
            throw new IllegalStateException("Unexpected error decoding dn: '" + node.getDN() + "' error: " + de, de);
        }
        this.parentDN.setText(aParentDN.toString());
        this.name.setText(aRdn);
        this.password.setText("");
        this.confirmPassword.setText("");
        this.readEntry(node);
    }

    @Override
    protected Message getProgressDialogTitle() {
        return AdminToolMessages.INFO_CTRL_PANEL_DUPLICATE_ENTRY_TITLE.get();
    }

    @Override
    public Message getTitle() {
        return AdminToolMessages.INFO_CTRL_PANEL_DUPLICATE_ENTRY_TITLE.get();
    }

    private void createLayout() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.addErrorPane(gbc);
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.insets.left = 0;
        this.lName = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_DUPLICATE_ENTRY_NAME_LABEL.get());
        this.add((Component)this.lName, gbc);
        this.name = Utilities.createTextField("", 30);
        gbc.weightx = 1.0;
        gbc.gridwidth = 2;
        gbc.weighty = 0.0;
        gbc.insets.left = 10;
        gbc.gridx = 1;
        this.add((Component)this.name, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.insets.top = 10;
        gbc.insets.left = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.fill = 1;
        this.lParentDN = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_DUPLICATE_ENTRY_PARENT_DN_LABEL.get());
        this.add((Component)this.lParentDN, gbc);
        this.parentDN = Utilities.createTextField("", 30);
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.insets.left = 10;
        gbc.gridx = 1;
        this.add((Component)this.parentDN, gbc);
        this.browse = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_BROWSE_BUTTON_LABEL.get());
        gbc.weightx = 0.0;
        gbc.gridx = 2;
        this.add((Component)this.browse, gbc);
        this.browse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                DuplicateEntryPanel.this.browseClicked();
            }
        });
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.insets.left = 0;
        this.lPassword = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_DUPLICATE_ENTRY_NEWPASSWORD_LABEL.get());
        this.add((Component)this.lPassword, gbc);
        gbc.weightx = 1.0;
        gbc.gridwidth = 2;
        gbc.weighty = 0.0;
        gbc.insets.left = 10;
        gbc.gridx = 1;
        this.add((Component)this.password, gbc);
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.insets.left = 0;
        this.lconfirmPassword = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_DUPLICATE_ENTRY_CONFIRMNEWPASSWORD_LABEL.get());
        this.add((Component)this.lconfirmPassword, gbc);
        gbc.weightx = 1.0;
        gbc.gridwidth = 2;
        gbc.weighty = 0.0;
        gbc.insets.left = 10;
        gbc.gridx = 1;
        this.add((Component)this.confirmPassword, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.insets.left = 0;
        this.lPasswordInfo = Utilities.createInlineHelpLabel(AdminToolMessages.INFO_CTRL_PANEL_DUPLICATE_ENTRY_PASSWORD_INFO.get());
        gbc.gridwidth = 3;
        this.add((Component)this.lPasswordInfo, gbc);
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.insets.left = 0;
        this.add((Component)Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_DUPLICATE_ENTRY_DN.get()), gbc);
        this.dn = Utilities.createDefaultLabel();
        gbc.gridx = 1;
        gbc.gridwidth = 2;
        gbc.insets.left = 10;
        this.add((Component)this.dn, gbc);
        DocumentListener listener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent ev) {
                DuplicateEntryPanel.this.updateDNValue();
            }

            @Override
            public void changedUpdate(DocumentEvent ev) {
                this.insertUpdate(ev);
            }

            @Override
            public void removeUpdate(DocumentEvent ev) {
                this.insertUpdate(ev);
            }
        };
        this.name.getDocument().addDocumentListener(listener);
        this.parentDN.getDocument().addDocumentListener(listener);
        this.addBottomGlue(gbc);
    }

    @Override
    protected void checkSyntax(ArrayList<Message> errors) {
        String parentDN;
        int origSize = errors.size();
        String name = this.name.getText().trim();
        this.setPrimaryValid(this.lName);
        this.setPrimaryValid(this.lParentDN);
        if (name.length() == 0) {
            errors.add(AdminToolMessages.ERR_CTRL_PANEL_DUPLICATE_ENTRY_NAME_EMPTY.get());
            this.setPrimaryInvalid(this.lName);
        }
        if (!Utils.isDn(parentDN = this.parentDN.getText().trim())) {
            errors.add(AdminToolMessages.ERR_CTRL_PANEL_DUPLICATE_ENTRY_PARENT_DN_NOT_VALID.get());
            this.setPrimaryInvalid(this.lParentDN);
        } else if (!this.entryExists(parentDN)) {
            errors.add(AdminToolMessages.ERR_CTRL_PANEL_DUPLICATE_ENTRY_PARENT_DOES_NOT_EXIST.get());
            this.setPrimaryInvalid(this.lParentDN);
        }
        char[] pwd1 = this.password.getPassword();
        char[] pwd2 = this.confirmPassword.getPassword();
        String sPwd1 = new String(pwd1);
        String sPwd2 = new String(pwd2);
        if (!sPwd1.equals(sPwd2)) {
            errors.add(AdminToolMessages.ERR_CTRL_PANEL_PASSWORD_DO_NOT_MATCH.get());
        }
        if (errors.size() == origSize) {
            try {
                this.getEntry();
            }
            catch (IOException ioe) {
                errors.add(AdminToolMessages.ERR_CTRL_PANEL_ERROR_CHECKING_ENTRY.get(ioe.toString()));
            }
            catch (LDIFException le) {
                errors.add(le.getMessageObject());
            }
        }
    }

    @Override
    protected String getLDIF() {
        String dn = this.dn.getText();
        StringBuilder sb = new StringBuilder();
        sb.append("dn: " + dn);
        for (String attrName : this.entryToDuplicate.getAttributeNames()) {
            List<Object> values = this.entryToDuplicate.getAttributeValues(attrName);
            if (attrName.equalsIgnoreCase("userpassword")) {
                sb.append("\n");
                String pwd = new String(this.password.getPassword());
                if (pwd.isEmpty()) continue;
                sb.append(attrName + ": " + pwd);
                continue;
            }
            if (!attrName.equalsIgnoreCase(this.rdnAttribute)) {
                if (!ViewEntryPanel.isEditable(attrName, this.getInfo().getServerDescriptor().getSchema())) continue;
                for (Object value : values) {
                    sb.append("\n");
                    if (value instanceof String) {
                        sb.append(attrName + ": " + value);
                        continue;
                    }
                    if (value instanceof byte[]) {
                        sb.append(attrName + ":: " + Base64.encode((byte[])value));
                        continue;
                    }
                    sb.append(attrName + ": " + value);
                }
                continue;
            }
            String newValue = null;
            try {
                DN theDN = DN.decode(dn);
                newValue = theDN.getRDN().getAttributeValue(0).toString();
            }
            catch (DirectoryException de) {
                throw new IllegalStateException("Unexpected error with dn: '" + dn + "' " + de, de);
            }
            if (values.size() == 1) {
                sb.append("\n");
                sb.append(attrName + ": " + newValue);
                continue;
            }
            String oldValue = null;
            try {
                DN oldDN = DN.decode(this.entryToDuplicate.getDN());
                oldValue = oldDN.getRDN().getAttributeValue(0).toString();
            }
            catch (DirectoryException de) {
                throw new IllegalStateException("Unexpected error with dn: '" + this.entryToDuplicate.getDN() + "' " + de, de);
            }
            for (Object value : values) {
                sb.append("\n");
                if (oldValue.equals(value)) {
                    sb.append(attrName + ": " + newValue);
                    continue;
                }
                sb.append(attrName + ": " + value);
            }
        }
        return sb.toString();
    }

    private void browseClicked() {
        if (this.browseDlg == null) {
            this.browsePanel = new LDAPEntrySelectionPanel();
            this.browsePanel.setTitle(AdminToolMessages.INFO_CTRL_PANEL_CHOOSE_PARENT_ENTRY_DN.get());
            this.browsePanel.setFilter(LDAPEntrySelectionPanel.Filter.DEFAULT);
            this.browsePanel.setMultipleSelection(false);
            this.browsePanel.setInfo(this.getInfo());
            this.browseDlg = new GenericDialog(Utilities.getFrame(this), this.browsePanel);
            Utilities.centerGoldenMean(this.browseDlg, Utilities.getParentDialog(this));
            this.browseDlg.setModal(true);
        }
        this.browseDlg.setVisible(true);
        String[] dns = this.browsePanel.getDNs();
        if (dns.length > 0) {
            for (String dn : dns) {
                this.parentDN.setText(dn);
            }
        }
    }

    private void readEntry(final BasicNode node) {
        final long t1 = System.currentTimeMillis();
        BackgroundTask<CustomSearchResult> task = new BackgroundTask<CustomSearchResult>(){

            @Override
            public CustomSearchResult processBackgroundTask() throws Throwable {
                InitialLdapContext ctx = DuplicateEntryPanel.this.controller.findConnectionForDisplayedEntry(node);
                LDAPEntryReader reader = new LDAPEntryReader(node.getDN(), ctx);
                DuplicateEntryPanel.this.sleepIfRequired(700L, t1);
                return reader.processBackgroundTask();
            }

            @Override
            public void backgroundTaskCompleted(CustomSearchResult sr, Throwable throwable) {
                if (throwable != null) {
                    Message title = AdminToolMessages.INFO_CTRL_PANEL_ERROR_SEARCHING_ENTRY_TITLE.get();
                    Message details = AdminToolMessages.ERR_CTRL_PANEL_ERROR_SEARCHING_ENTRY.get(node.getDN(), throwable.toString());
                    DuplicateEntryPanel.this.displayErrorMessage(title, details);
                } else {
                    DuplicateEntryPanel.this.entryToDuplicate = sr;
                    try {
                        DN dn = DN.decode(sr.getDN());
                        DuplicateEntryPanel.this.rdnAttribute = dn.getRDN().getAttributeType(0).getNameOrOID();
                        DuplicateEntryPanel.this.updateDNValue();
                        Boolean hasPassword = !sr.getAttributeValues("userpassword").isEmpty();
                        DuplicateEntryPanel.this.lPassword.setVisible(hasPassword);
                        DuplicateEntryPanel.this.password.setVisible(hasPassword);
                        DuplicateEntryPanel.this.lconfirmPassword.setVisible(hasPassword);
                        DuplicateEntryPanel.this.confirmPassword.setVisible(hasPassword);
                        DuplicateEntryPanel.this.lPasswordInfo.setVisible(hasPassword);
                        DuplicateEntryPanel.this.displayMainPanel();
                        DuplicateEntryPanel.this.setEnabledOK(true);
                    }
                    catch (DirectoryException de) {
                        DuplicateEntryPanel.this.displayErrorMessage(AdminToolMessages.INFO_CTRL_PANEL_ERROR_DIALOG_TITLE.get(), de.getMessageObject());
                    }
                }
            }
        };
        task.startBackgroundTask();
    }

    private void updateDNValue() {
        String value = this.name.getText().trim();
        if (value.length() > 0) {
            String rdn = Utilities.getRDNString(this.rdnAttribute, value);
            this.dn.setText(rdn + "," + this.parentDN.getText().trim());
        } else {
            this.dn.setText("," + this.parentDN.getText().trim());
        }
    }

    private void sleepIfRequired(long sleepTime, long startTime) {
        long tSleep = sleepTime - (System.currentTimeMillis() - startTime);
        if (tSleep > 0L) {
            try {
                Thread.sleep(tSleep);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

