/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.opends.guitools.controlpanel.browser.BasicNodeError;
import org.opends.guitools.controlpanel.browser.ReferralLimitExceededException;
import org.opends.guitools.controlpanel.event.ConfigurationChangeEvent;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;
import org.opends.guitools.controlpanel.ui.StatusGenericPanel;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.quicksetup.util.Utils;
import org.opends.server.types.LDAPURL;
import org.opends.server.types.OpenDsException;

public class ErrorSearchingEntryPanel
extends StatusGenericPanel {
    private static final long serialVersionUID = -8460172599072631973L;

    public ErrorSearchingEntryPanel() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 10;
        gbc.fill = 1;
        gbc.insets = new Insets(20, 20, 0, 20);
        this.createErrorPane();
        this.add((Component)this.errorPane, gbc);
        this.errorPane.setVisible(true);
    }

    @Override
    public Component getPreferredFocusComponent() {
        return this.errorPane;
    }

    @Override
    public void okClicked() {
    }

    @Override
    public Message getTitle() {
        return AdminToolMessages.INFO_CTRL_PANEL_ERROR_SEARCHING_ENTRY_TITLE.get();
    }

    @Override
    public void configurationChanged(ConfigurationChangeEvent ev) {
    }

    public void setError(String dn, Throwable t) {
        Message title = AdminToolMessages.INFO_CTRL_PANEL_ERROR_SEARCHING_ENTRY_TITLE.get();
        Message details = t instanceof OpenDsException ? AdminToolMessages.ERR_CTRL_PANEL_ERROR_SEARCHING_ENTRY.get(dn, ((OpenDsException)t).getMessageObject().toString()) : AdminToolMessages.ERR_CTRL_PANEL_ERROR_SEARCHING_ENTRY.get(dn, t.toString());
        this.updateErrorPane(this.errorPane, title, ColorAndFontConstants.errorTitleFont, details, ColorAndFontConstants.defaultFont);
    }

    public void setReferralError(String dn, String[] referrals, BasicNodeError error) {
        Message title = AdminToolMessages.INFO_CTRL_PANEL_ERROR_RESOLVING_REFERRAL_TITLE.get();
        MessageBuilder details = new MessageBuilder();
        StringBuilder sb = new StringBuilder();
        for (String ref : referrals) {
            if (sb.length() > 0) {
                sb.append("<br>");
            }
            sb.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + ref);
        }
        details.append(AdminToolMessages.INFO_CTRL_PANEL_ERROR_RESOLVING_REFERRAL_MSG.get(dn, sb));
        Exception ex = error.getException();
        if (ex instanceof NamingException) {
            Object arg = error.getArg();
            Message msg = null;
            if (arg != null) {
                try {
                    LDAPURL url = LDAPURL.decode(arg.toString(), false);
                    if (url.getHost() != null) {
                        String hostPort = url.getHost() + ":" + url.getPort();
                        msg = ex instanceof ReferralLimitExceededException ? Message.raw(ex.getLocalizedMessage(), new Object[0]) : (ex instanceof NameNotFoundException ? AdminToolMessages.ERR_CTRL_PANEL_COULD_NOT_FIND_PROVIDED_ENTRY_IN_REFERRAL.get(arg.toString(), hostPort) : Utils.getMessageForException((NamingException)ex, hostPort));
                    } else {
                        msg = ex instanceof ReferralLimitExceededException ? Message.raw(ex.getLocalizedMessage(), new Object[0]) : (ex instanceof NameNotFoundException ? AdminToolMessages.ERR_CTRL_PANEL_COULD_NOT_FIND_PROVIDED_ENTRY_IN_REFERRAL_NO_HOST.get(arg.toString()) : Utils.getMessageForException((NamingException)ex));
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (msg == null) {
                msg = ex instanceof ReferralLimitExceededException ? Message.raw(ex.getLocalizedMessage(), new Object[0]) : Utils.getMessageForException((NamingException)ex);
            }
            if (arg != null) {
                details.append("<br><br>" + AdminToolMessages.ERR_CTRL_PANEL_RESOLVING_REFERRAL_DETAILS.get(arg.toString(), msg));
            } else {
                details.append("<br><br>" + AdminToolMessages.INFO_CTRL_PANEL_DETAILS_THROWABLE.get(msg));
            }
        } else if (ex != null) {
            String msg = ex.getLocalizedMessage();
            if (msg == null) {
                msg = ex.toString();
            }
            details.append("<br><br>" + AdminToolMessages.INFO_CTRL_PANEL_DETAILS_THROWABLE.get(msg));
        }
        details.append("<br><br>" + AdminToolMessages.INFO_CTRL_PANEL_HOW_TO_EDIT_REFERRALS.get());
        this.updateErrorPane(this.errorPane, title, ColorAndFontConstants.errorTitleFont, details.toMessage(), ColorAndFontConstants.defaultFont);
    }
}

