/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.opends.admin.ads.ServerDescriptor;
import org.opends.admin.ads.util.ApplicationTrustManager;
import org.opends.admin.ads.util.ConnectionUtils;
import org.opends.guitools.controlpanel.ControlPanelArgumentParser;
import org.opends.guitools.controlpanel.datamodel.ConfigReadException;
import org.opends.guitools.controlpanel.datamodel.CustomSearchResult;
import org.opends.guitools.controlpanel.event.ConfigurationChangeEvent;
import org.opends.guitools.controlpanel.task.OnlineUpdateException;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;
import org.opends.guitools.controlpanel.ui.GenericDialog;
import org.opends.guitools.controlpanel.ui.StatusGenericPanel;
import org.opends.guitools.controlpanel.util.BackgroundTask;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.Installation;
import org.opends.quicksetup.UserData;
import org.opends.quicksetup.UserDataCertificateException;
import org.opends.quicksetup.ui.CertificateDialog;
import org.opends.quicksetup.util.UIKeyStore;
import org.opends.quicksetup.util.Utils;
import org.opends.server.types.DN;
import org.opends.server.types.OpenDsException;
import org.opends.server.util.DynamicConstants;

public class LocalOrRemotePanel
extends StatusGenericPanel {
    private static final long serialVersionUID = 5051556513294844797L;
    private JComboBox combo;
    private JLabel portLabel;
    private JTextField hostName;
    private JTextField port;
    private JPasswordField pwd;
    private JTextField dn;
    private JLabel pwdLabel;
    private JLabel dnLabel;
    private String usedUrl;
    private JLabel localInstallLabel;
    private JEditorPane localInstall;
    private JLabel localNotRunning;
    private boolean isLocalServerRunning;
    private boolean callOKWhenVisible;
    private static final Logger LOG = Logger.getLogger(LocalOrRemotePanel.class.getName());

    public LocalOrRemotePanel() {
        this.createLayout();
    }

    @Override
    public Message getTitle() {
        return AdminToolMessages.INFO_CTRL_PANEL_LOCAL_OR_REMOTE_PANEL_TITLE.get();
    }

    @Override
    public GenericDialog.ButtonType getButtonType() {
        return GenericDialog.ButtonType.OK_CANCEL;
    }

    public String getHostName() {
        return this.hostName.getText();
    }

    public int getPort() {
        int port = -1;
        try {
            port = new Integer(this.port.getText().trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return port;
    }

    public String getBindDN() {
        return this.dn.getText();
    }

    public char[] getBindPassword() {
        return this.pwd.getPassword();
    }

    public boolean isRemote() {
        int index = this.combo.getSelectedIndex();
        return index == 1;
    }

    public void setHostName(String hostName) {
        this.hostName.setText(hostName);
    }

    public void setPort(int port) {
        this.port.setText(String.valueOf(port));
    }

    public void setBindDN(String bindDN) {
        this.dn.setText(bindDN);
    }

    public void setBindPassword(char[] pwd) {
        this.pwd.setText(new String(pwd));
    }

    public void setRemote(boolean remote) {
        int index = remote ? 1 : 0;
        this.combo.setSelectedIndex(index);
        this.updateComponentState();
    }

    public void setCallOKWhenVisible(boolean callOKWhenVisible) {
        this.callOKWhenVisible = callOKWhenVisible;
    }

    public boolean isCallOKWhenVisible() {
        return this.callOKWhenVisible;
    }

    private void createLayout() {
        String localServerInstallPath;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        File instancePath = Installation.getLocal().getInstanceDirectory();
        try {
            localServerInstallPath = instancePath.getCanonicalPath();
        }
        catch (IOException ioe) {
            localServerInstallPath = instancePath.getAbsolutePath();
        }
        this.combo = Utilities.createComboBox();
        this.combo.setModel(new DefaultComboBoxModel<Object>(new Object[]{AdminToolMessages.INFO_CTRL_PANEL_LOCAL_SERVER.get(), AdminToolMessages.INFO_CTRL_PANEL_REMOTE_SERVER.get()}));
        this.combo.setSelectedIndex(0);
        gbc.gridwidth = 2;
        JLabel l = Utilities.createDefaultLabel(AdminToolMessages.INFO_CTRL_PANEL_LOCAL_OR_REMOTE.get());
        this.add((Component)l, gbc);
        gbc.gridwidth = 1;
        gbc.insets.top = 10;
        ++gbc.gridy;
        this.add((Component)this.combo, gbc);
        l.setLabelFor(this.combo);
        gbc.gridx = 1;
        this.localNotRunning = Utilities.createDefaultLabel();
        Utilities.setWarningLabel(this.localNotRunning, AdminToolMessages.INFO_CTRL_PANEL_LOCAL_SERVER_NOT_RUNNING.get());
        gbc.insets.left = 10;
        this.add((Component)this.localNotRunning, gbc);
        this.localNotRunning.setFocusable(true);
        this.hostName = Utilities.createMediumTextField();
        this.hostName.setText(UserData.getDefaultHostName());
        this.hostName.setToolTipText(AdminToolMessages.INFO_CTRL_PANEL_REMOTE_SERVER_TOOLTIP.get().toString());
        this.add((Component)this.hostName, gbc);
        gbc.insets.top = 10;
        ++gbc.gridy;
        gbc.insets.left = 0;
        gbc.weightx = 0.0;
        gbc.insets.right = 0;
        gbc.gridx = 0;
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                LocalOrRemotePanel.this.updateComponentState();
            }
        };
        this.combo.addActionListener(actionListener);
        gbc.gridx = 0;
        gbc.gridwidth = 1;
        this.localInstallLabel = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_INSTANCE_PATH_LABEL.get());
        gbc.insets.left = 0;
        this.add((Component)this.localInstallLabel, gbc);
        gbc.gridx = 1;
        gbc.insets.left = 10;
        gbc.fill = 2;
        gbc.weightx = 0.1;
        this.localInstall = Utilities.makeHtmlPane(localServerInstallPath, ColorAndFontConstants.defaultFont);
        this.add((Component)this.localInstall, gbc);
        this.localInstallLabel.setLabelFor(this.localInstall);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.insets.left = 0;
        this.add(Box.createHorizontalGlue(), gbc);
        ++gbc.gridy;
        gbc.insets.top = 10;
        gbc.insets.left = 0;
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        this.portLabel = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_ADMINISTRATION_PORT.get());
        this.add((Component)this.portLabel, gbc);
        gbc.gridx = 1;
        gbc.insets.left = 10;
        this.port = Utilities.createMediumTextField();
        this.port.setText(String.valueOf(ControlPanelArgumentParser.getDefaultAdministrationPort()));
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.add((Component)this.port, gbc);
        this.portLabel.setLabelFor(this.port);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.insets.left = 0;
        this.dnLabel = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_BIND_DN_LABEL.get());
        this.add((Component)this.dnLabel, gbc);
        gbc.insets.left = 10;
        gbc.gridx = 1;
        this.dn = Utilities.createTextField(ControlPanelArgumentParser.getDefaultBindDN(), 20);
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets.left = 10;
        this.add((Component)this.dn, gbc);
        this.dnLabel.setLabelFor(this.dn);
        gbc.insets.top = 10;
        gbc.insets.left = 0;
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        this.pwdLabel = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_BIND_PASSWORD_LABEL.get());
        gbc.insets.left = 0;
        this.add((Component)this.pwdLabel, gbc);
        gbc.insets.left = 10;
        gbc.gridx = 1;
        this.pwd = Utilities.createPasswordField();
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.add((Component)this.pwd, gbc);
        this.pwdLabel.setLabelFor(this.pwd);
        this.addBottomGlue(gbc);
    }

    @Override
    public Component getPreferredFocusComponent() {
        if (this.pwd.isVisible()) {
            return this.pwd;
        }
        return this.combo;
    }

    @Override
    public void configurationChanged(ConfigurationChangeEvent ev) {
    }

    @Override
    public void toBeDisplayed(boolean visible) {
        super.toBeDisplayed(visible);
        if (visible) {
            BackgroundTask<Void> worker = new BackgroundTask<Void>(){

                @Override
                public Void processBackgroundTask() throws Throwable {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    File instancePath = Installation.getLocal().getInstanceDirectory();
                    LocalOrRemotePanel.this.isLocalServerRunning = Utilities.isServerRunning(instancePath);
                    return null;
                }

                @Override
                public void backgroundTaskCompleted(Void returnValue, Throwable t) {
                    LocalOrRemotePanel.this.updateComponentState();
                    LocalOrRemotePanel.this.displayMainPanel();
                    Component comp = LocalOrRemotePanel.this.getPreferredFocusComponent();
                    if (comp != null) {
                        comp.requestFocusInWindow();
                    }
                    if (LocalOrRemotePanel.this.isCallOKWhenVisible()) {
                        LocalOrRemotePanel.this.okClicked();
                    }
                }
            };
            this.displayMessage(AdminToolMessages.INFO_CTRL_PANEL_LOADING_PANEL_SUMMARY.get());
            worker.startBackgroundTask();
            if (!this.isCallOKWhenVisible()) {
                this.pwd.setText("");
            }
        }
    }

    @Override
    public void okClicked() {
        boolean doChecks;
        this.setPrimaryValid(this.portLabel);
        this.setPrimaryValid(this.dnLabel);
        this.setPrimaryValid(this.pwdLabel);
        final LinkedHashSet<Message> errors = new LinkedHashSet<Message>();
        boolean dnInvalid = false;
        boolean pwdInvalid = false;
        final boolean isLocal = this.combo.getSelectedIndex() == 0;
        boolean bl = doChecks = !isLocal || this.isLocalServerRunning;
        if (doChecks) {
            if ("".equals(this.dn.getText().trim())) {
                dnInvalid = true;
                errors.add(QuickSetupMessages.INFO_EMPTY_DIRECTORY_MANAGER_DN.get());
            } else if (!Utils.isDn(this.dn.getText())) {
                dnInvalid = true;
                errors.add(QuickSetupMessages.INFO_NOT_A_DIRECTORY_MANAGER_DN.get());
            }
            if (this.pwd.getPassword().length == 0) {
                pwdInvalid = true;
                errors.add(QuickSetupMessages.INFO_EMPTY_PWD.get());
            }
            if (dnInvalid) {
                this.setPrimaryInvalid(this.dnLabel);
            }
            if (pwdInvalid) {
                this.setPrimaryInvalid(this.pwdLabel);
            }
            if (!isLocal) {
                if ("".equals(this.hostName.getText().trim())) {
                    errors.add(AdminToolMessages.INFO_EMPTY_REMOTE_HOST_NAME.get());
                }
                try {
                    int p = Integer.parseInt(this.port.getText());
                    if (p <= 0 || p > 65535) {
                        errors.add(AdminToolMessages.INFO_INVALID_REMOTE_SERVER_PORT.get(0, 65535));
                    }
                }
                catch (Throwable t) {
                    errors.add(AdminToolMessages.INFO_INVALID_REMOTE_SERVER_PORT.get(0, 65535));
                }
            }
        }
        if (errors.isEmpty()) {
            this.setEnabledOK(false);
            this.displayMessage(AdminToolMessages.INFO_CTRL_PANEL_VERIFYING_AUTHENTICATION_SUMMARY.get());
            BackgroundTask<InitialLdapContext> worker = new BackgroundTask<InitialLdapContext>(){

                @Override
                public InitialLdapContext processBackgroundTask() throws Throwable {
                    LocalOrRemotePanel.this.getInfo().stopPooling();
                    if (isLocal) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                LocalOrRemotePanel.this.displayMessage(AdminToolMessages.INFO_CTRL_PANEL_READING_CONFIGURATION_SUMMARY.get());
                            }
                        });
                        if (LocalOrRemotePanel.this.getInfo().isLocal() != isLocal) {
                            LocalOrRemotePanel.this.closeInfoConnections();
                        }
                        LocalOrRemotePanel.this.getInfo().setIsLocal(isLocal);
                        LocalOrRemotePanel.this.getInfo().regenerateDescriptor();
                        if (!LocalOrRemotePanel.this.isLocalServerRunning) {
                            return null;
                        }
                    }
                    InitialContext ctx = null;
                    try {
                        if (isLocal) {
                            LocalOrRemotePanel.this.usedUrl = LocalOrRemotePanel.this.getInfo().getAdminConnectorURL();
                            ctx = Utilities.getAdminDirContext(LocalOrRemotePanel.this.getInfo(), LocalOrRemotePanel.this.dn.getText(), String.valueOf(LocalOrRemotePanel.this.pwd.getPassword()));
                        } else {
                            LocalOrRemotePanel.this.usedUrl = ConnectionUtils.getLDAPUrl(LocalOrRemotePanel.this.hostName.getText().trim(), new Integer(LocalOrRemotePanel.this.port.getText().trim()), true);
                            ctx = Utils.createLdapsContext(LocalOrRemotePanel.this.usedUrl, LocalOrRemotePanel.this.dn.getText(), String.valueOf(LocalOrRemotePanel.this.pwd.getPassword()), LocalOrRemotePanel.this.getInfo().getConnectTimeout(), null, LocalOrRemotePanel.this.getInfo().getTrustManager());
                            LocalOrRemotePanel.this.checkVersion((InitialLdapContext)ctx);
                        }
                        try {
                            Thread.sleep(500L);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                LocalOrRemotePanel.this.displayMessage(AdminToolMessages.INFO_CTRL_PANEL_READING_CONFIGURATION_SUMMARY.get());
                            }
                        });
                        LocalOrRemotePanel.this.closeInfoConnections();
                        LocalOrRemotePanel.this.getInfo().setIsLocal(isLocal);
                        LocalOrRemotePanel.this.getInfo().setDirContext((InitialLdapContext)ctx);
                        LocalOrRemotePanel.this.getInfo().setUserDataDirContext(null);
                        LocalOrRemotePanel.this.getInfo().regenerateDescriptor();
                        return ctx;
                    }
                    catch (Throwable t) {
                        if (ctx != null) {
                            try {
                                ctx.close();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        throw t;
                    }
                }

                @Override
                public void backgroundTaskCompleted(InitialLdapContext ctx, Throwable throwable) {
                    boolean handleCertificateException = false;
                    boolean localServerErrorConnecting = false;
                    if (throwable != null) {
                        LOG.log(Level.INFO, "Error connecting: " + throwable, throwable);
                        if (LocalOrRemotePanel.this.isVersionException(throwable)) {
                            errors.add(((OpenDsException)throwable).getMessageObject());
                        } else if (Utils.isCertificateException(throwable)) {
                            ApplicationTrustManager.Cause cause = LocalOrRemotePanel.this.getInfo().getTrustManager().getLastRefusedCause();
                            LOG.log(Level.INFO, "Certificate exception cause: " + (Object)((Object)cause));
                            UserDataCertificateException.Type excType = null;
                            if (cause == ApplicationTrustManager.Cause.NOT_TRUSTED) {
                                excType = UserDataCertificateException.Type.NOT_TRUSTED;
                            } else if (cause == ApplicationTrustManager.Cause.HOST_NAME_MISMATCH) {
                                excType = UserDataCertificateException.Type.HOST_NAME_MISMATCH;
                            } else {
                                Message msg = Utils.getThrowableMsg(QuickSetupMessages.INFO_ERROR_CONNECTING_TO_LOCAL.get(), throwable);
                                errors.add(msg);
                            }
                            if (excType != null) {
                                int p;
                                String h;
                                try {
                                    URI uri = new URI(LocalOrRemotePanel.this.usedUrl);
                                    h = uri.getHost();
                                    p = uri.getPort();
                                }
                                catch (Throwable t) {
                                    LOG.log(Level.WARNING, "Error parsing ldap url of ldap url.", t);
                                    h = QuickSetupMessages.INFO_NOT_AVAILABLE_LABEL.get().toString();
                                    p = -1;
                                }
                                UserDataCertificateException udce = new UserDataCertificateException(null, QuickSetupMessages.INFO_CERTIFICATE_EXCEPTION.get(h, String.valueOf(p)), throwable, h, p, LocalOrRemotePanel.this.getInfo().getTrustManager().getLastRefusedChain(), LocalOrRemotePanel.this.getInfo().getTrustManager().getLastRefusedAuthType(), excType);
                                LocalOrRemotePanel.this.handleCertificateException(udce);
                                handleCertificateException = true;
                            }
                        } else if (throwable instanceof NamingException) {
                            boolean found = false;
                            String providedDn = LocalOrRemotePanel.this.dn.getText();
                            if (isLocal) {
                                Iterator<DN> it = LocalOrRemotePanel.this.getInfo().getServerDescriptor().getAdministrativeUsers().iterator();
                                while (it.hasNext() && !found) {
                                    found = Utils.areDnsEqual(providedDn, it.next().toString());
                                }
                                if (!found) {
                                    errors.add(QuickSetupMessages.INFO_NOT_A_DIRECTORY_MANAGER_IN_CONFIG.get());
                                } else {
                                    errors.add(Utils.getMessageForException((NamingException)throwable));
                                }
                                localServerErrorConnecting = true;
                            } else {
                                String hostPort = ServerDescriptor.getServerRepresentation(LocalOrRemotePanel.this.hostName.getText().trim(), new Integer(LocalOrRemotePanel.this.port.getText().trim()));
                                NamingException ne = (NamingException)throwable;
                                errors.add(Utils.getMessageForException(ne, hostPort));
                                LocalOrRemotePanel.this.setPrimaryInvalid(LocalOrRemotePanel.this.portLabel);
                            }
                            LocalOrRemotePanel.this.setPrimaryInvalid(LocalOrRemotePanel.this.dnLabel);
                            LocalOrRemotePanel.this.setPrimaryInvalid(LocalOrRemotePanel.this.pwdLabel);
                        } else if (throwable instanceof ConfigReadException) {
                            LOG.log(Level.WARNING, "Error reading configuration: " + throwable, throwable);
                            errors.add(((ConfigReadException)throwable).getMessageObject());
                        } else {
                            LOG.log(Level.SEVERE, "Unexpected error: " + throwable, throwable);
                            errors.add(Utils.getThrowableMsg(QuickSetupMessages.INFO_BUG_MSG.get(), throwable));
                        }
                    }
                    LocalOrRemotePanel.this.displayMainPanel();
                    LocalOrRemotePanel.this.setEnabledOK(true);
                    if (!errors.isEmpty()) {
                        if (!localServerErrorConnecting) {
                            LocalOrRemotePanel.this.displayErrorDialog(errors);
                        } else {
                            ArrayList<String> stringErrors = new ArrayList<String>();
                            for (Message err : errors) {
                                stringErrors.add(err.toString());
                            }
                            String msg = Utilities.getStringFromCollection(stringErrors, "<br>");
                            if (LocalOrRemotePanel.this.displayConfirmationDialog(AdminToolMessages.INFO_CTRL_PANEL_CONFIRMATION_REQUIRED_SUMMARY.get(), AdminToolMessages.INFO_CTRL_PANEL_ERROR_CONNECTING_TO_LOCAL.get(msg))) {
                                Utilities.getParentDialog(LocalOrRemotePanel.this).setVisible(false);
                            }
                        }
                        LocalOrRemotePanel.this.pwd.setSelectionStart(0);
                        LocalOrRemotePanel.this.pwd.setSelectionEnd(LocalOrRemotePanel.this.pwd.getPassword().length);
                        LocalOrRemotePanel.this.pwd.requestFocusInWindow();
                    } else if (!handleCertificateException) {
                        Utilities.getParentDialog(LocalOrRemotePanel.this).setVisible(false);
                    }
                    if (!handleCertificateException) {
                        LocalOrRemotePanel.this.startPooling();
                    }
                }
            };
            worker.startBackgroundTask();
        } else {
            this.displayErrorDialog(errors);
            if (dnInvalid) {
                this.dn.setSelectionStart(0);
                this.dn.setSelectionEnd(this.dn.getText().length());
                this.dn.requestFocusInWindow();
            }
            if (pwdInvalid) {
                this.pwd.setSelectionStart(0);
                this.pwd.setSelectionEnd(this.pwd.getPassword().length);
                this.pwd.requestFocusInWindow();
            }
        }
    }

    @Override
    public void cancelClicked() {
        this.setPrimaryValid(this.dnLabel);
        this.setPrimaryValid(this.pwdLabel);
        this.setPrimaryValid(this.portLabel);
        this.pwd.setText(null);
        super.cancelClicked();
    }

    private void handleCertificateException(UserDataCertificateException ce) {
        X509Certificate[] chain;
        CertificateDialog dlg = new CertificateDialog(null, ce);
        dlg.pack();
        Utilities.centerGoldenMean(dlg, Utilities.getParentDialog(this));
        dlg.setVisible(true);
        if (dlg.getUserAnswer() != CertificateDialog.ReturnType.NOT_ACCEPTED) {
            chain = ce.getChain();
            String authType = ce.getAuthType();
            String host = ce.getHost();
            if (chain != null && authType != null && host != null) {
                LOG.log(Level.INFO, "Accepting certificate presented by host " + host);
                this.getInfo().getTrustManager().acceptCertificate(chain, authType, host);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        LocalOrRemotePanel.this.okClicked();
                    }
                });
            } else {
                if (chain == null) {
                    LOG.log(Level.WARNING, "The chain is null for the UserDataCertificateException");
                }
                if (authType == null) {
                    LOG.log(Level.WARNING, "The auth type is null for the UserDataCertificateException");
                }
                if (host == null) {
                    LOG.log(Level.WARNING, "The host is null for the UserDataCertificateException");
                }
            }
        }
        if (dlg.getUserAnswer() == CertificateDialog.ReturnType.ACCEPTED_PERMANENTLY && (chain = ce.getChain()) != null) {
            try {
                UIKeyStore.acceptCertificate(chain);
            }
            catch (Throwable t) {
                LOG.log(Level.WARNING, "Error accepting certificate: " + t, t);
            }
        }
    }

    private void updateComponentState() {
        boolean isLocal = this.combo.getSelectedIndex() == 0;
        this.hostName.setVisible(!isLocal);
        this.port.setVisible(!isLocal);
        this.portLabel.setVisible(!isLocal);
        this.localInstall.setVisible(isLocal);
        this.localInstallLabel.setVisible(isLocal);
        boolean displayAuthentication = !isLocal || this.isLocalServerRunning;
        this.dn.setVisible(displayAuthentication);
        this.dnLabel.setVisible(displayAuthentication);
        this.pwd.setVisible(displayAuthentication);
        this.pwdLabel.setVisible(displayAuthentication);
        this.localNotRunning.setVisible(isLocal && !this.isLocalServerRunning);
    }

    private void startPooling() {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(LocalOrRemotePanel.this.getInfo().getPoolingPeriod());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                LocalOrRemotePanel.this.getInfo().startPooling();
            }
        });
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkVersion(InitialLdapContext ctx) throws OpenDsException {
        Message msg = null;
        try {
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(0);
            searchControls.setReturningAttributes(new String[]{"productName", "majorVersion", "pointVersion", "minorVersion"});
            NamingEnumeration<SearchResult> en = ctx.search("cn=Version,cn=monitor", "objectclass=*", searchControls);
            SearchResult sr = null;
            try {
                while (en.hasMore()) {
                    sr = en.next();
                }
            }
            finally {
                en.close();
            }
            CustomSearchResult csr = new CustomSearchResult(sr, "cn=Version,cn=monitor");
            String hostName = ConnectionUtils.getHostName(ctx);
            String productName = String.valueOf(Utilities.getFirstMonitoringValue(csr, "productName"));
            String major = String.valueOf(Utilities.getFirstMonitoringValue(csr, "majorVersion"));
            String point = String.valueOf(Utilities.getFirstMonitoringValue(csr, "pointVersion"));
            String minor = String.valueOf(Utilities.getFirstMonitoringValue(csr, "minorVersion"));
            if (!productName.equalsIgnoreCase(DynamicConstants.PRODUCT_NAME)) {
                msg = AdminToolMessages.ERR_NOT_SAME_PRODUCT_IN_REMOTE_SERVER_NOT_FOUND.get(hostName, productName, DynamicConstants.PRODUCT_NAME);
            } else if (!(String.valueOf(DynamicConstants.MAJOR_VERSION).equals(major) && String.valueOf(DynamicConstants.MINOR_VERSION).equals(minor) && String.valueOf(DynamicConstants.POINT_VERSION).equals(point))) {
                msg = AdminToolMessages.ERR_INCOMPATIBLE_VERSION_IN_REMOTE_SERVER.get(hostName, major, minor, point, DynamicConstants.MAJOR_VERSION, DynamicConstants.MINOR_VERSION, DynamicConstants.POINT_VERSION);
            }
        }
        catch (Throwable t) {
            msg = AdminToolMessages.ERR_VERSION_IN_REMOTE_SERVER_NOT_FOUND.get();
        }
        if (msg != null) {
            throw new OnlineUpdateException(msg, null);
        }
    }

    private boolean isVersionException(Throwable t) {
        OpenDsException oe;
        boolean isVersionException = false;
        if (t instanceof OpenDsException && (oe = (OpenDsException)t).getMessageObject() != null && (oe.getMessageObject().getDescriptor().equals(AdminToolMessages.ERR_INCOMPATIBLE_VERSION_IN_REMOTE_SERVER) || oe.getMessageObject().getDescriptor().equals(AdminToolMessages.ERR_VERSION_IN_REMOTE_SERVER_NOT_FOUND) || oe.getMessageObject().getDescriptor().equals(AdminToolMessages.ERR_NOT_SAME_PRODUCT_IN_REMOTE_SERVER_NOT_FOUND))) {
            isVersionException = true;
        }
        return isVersionException;
    }

    private void closeInfoConnections() {
        if (this.getInfo().getDirContext() != null) {
            try {
                this.getInfo().getDirContext().close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.getInfo().getUserDataDirContext() != null) {
            try {
                this.getInfo().getUserDataDirContext().close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

