/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.TreeSet;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import org.opends.guitools.controlpanel.event.ConfigurationChangeEvent;
import org.opends.guitools.controlpanel.ui.SchemaElementPanel;
import org.opends.guitools.controlpanel.ui.components.TitlePanel;
import org.opends.guitools.controlpanel.util.LowerCaseComparator;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.MatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.types.AttributeType;
import org.opends.server.types.Schema;

public class MatchingRulePanel
extends SchemaElementPanel {
    private static final long serialVersionUID = 2440493955626646008L;
    private TitlePanel titlePanel = new TitlePanel(Message.EMPTY, Message.EMPTY);
    private JLabel name = Utilities.createDefaultLabel();
    private JLabel oid = Utilities.createDefaultLabel();
    private JLabel description = Utilities.createDefaultLabel();
    private JLabel syntax = Utilities.createDefaultLabel();
    private JLabel type = Utilities.createDefaultLabel();
    private JList usedByAttributes = new JList(new DefaultListModel());

    public MatchingRulePanel() {
        this.createLayout();
    }

    @Override
    public Message getTitle() {
        return AdminToolMessages.INFO_CTRL_PANEL_MATCHING_RULE_PANEL_TITLE.get();
    }

    @Override
    public Component getPreferredFocusComponent() {
        return this.usedByAttributes;
    }

    @Override
    public void configurationChanged(ConfigurationChangeEvent ev) {
    }

    @Override
    public void okClicked() {
    }

    private void createLayout() {
        GridBagConstraints gbc = new GridBagConstraints();
        ++gbc.gridy;
        this.titlePanel.setTitle(AdminToolMessages.INFO_CTRL_PANEL_MATCHING_RULE_DETAILS.get());
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.gridwidth = 2;
        gbc.gridy = 0;
        gbc.insets.top = 5;
        gbc.insets.bottom = 7;
        this.add((Component)this.titlePanel, gbc);
        gbc.insets.bottom = 0;
        gbc.insets.top = 8;
        Message[] labels = new Message[]{AdminToolMessages.INFO_CTRL_PANEL_MATCHING_RULE_NAME.get(), AdminToolMessages.INFO_CTRL_PANEL_MATCHING_RULE_OID.get(), AdminToolMessages.INFO_CTRL_PANEL_MATCHING_RULE_DESCRIPTION.get(), AdminToolMessages.INFO_CTRL_PANEL_MATCHING_RULE_TYPE.get(), AdminToolMessages.INFO_CTRL_PANEL_MATCHING_RULE_SYNTAX.get()};
        JLabel[] values = new JLabel[]{this.name, this.oid, this.description, this.type, this.syntax};
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.anchor = 17;
        for (int i = 0; i < labels.length; ++i) {
            gbc.insets.left = 0;
            gbc.gridx = 0;
            JLabel l = Utilities.createPrimaryLabel(labels[i]);
            this.add((Component)l, gbc);
            gbc.insets.left = 10;
            gbc.gridx = 1;
            this.add((Component)values[i], gbc);
            ++gbc.gridy;
        }
        this.usedByAttributes.setVisibleRowCount(15);
        gbc.anchor = 18;
        gbc.insets.left = 0;
        gbc.gridx = 0;
        JLabel l = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_MATCHING_RULE_USED_BY.get());
        gbc.weightx = 0.0;
        gbc.fill = 2;
        this.add((Component)l, gbc);
        gbc.insets.left = 10;
        gbc.gridx = 1;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.insets.top = 10;
        this.add((Component)Utilities.createScrollPane(this.usedByAttributes), gbc);
        MouseAdapter clickListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent ev) {
                if (ev.getClickCount() == 1) {
                    MatchingRulePanel.this.usedBySelected();
                }
            }
        };
        this.usedByAttributes.addMouseListener(clickListener);
        KeyAdapter keyListener = new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent ev) {
                if (ev.getKeyChar() == ' ' || ev.getKeyChar() == '\n') {
                    MatchingRulePanel.this.usedBySelected();
                }
            }
        };
        this.usedByAttributes.addKeyListener(keyListener);
        this.setBorder(this.PANEL_BORDER);
    }

    public void update(MatchingRule matchingRule, Schema schema) {
        String n = matchingRule.getName();
        if (n == null) {
            n = NOT_APPLICABLE.toString();
        }
        this.titlePanel.setDetails(Message.raw(n, new Object[0]));
        this.name.setText(n);
        this.oid.setText(matchingRule.getOID());
        AttributeSyntax<?> s = null;
        String syntaxOID = matchingRule.getSyntaxOID();
        for (AttributeSyntax<?> candidate : schema.getSyntaxes().values()) {
            if (!candidate.getOID().equals(syntaxOID)) continue;
            s = candidate;
            break;
        }
        if (s != null) {
            this.syntax.setText(Utilities.getSyntaxText(s));
        } else {
            this.syntax.setText(syntaxOID);
        }
        n = matchingRule.getDescription();
        if (n == null) {
            n = NOT_APPLICABLE.toString();
        }
        this.description.setText(n);
        this.type.setText(MatchingRulePanel.getTypeValue(matchingRule).toString());
        LowerCaseComparator lowerCaseComparator = new LowerCaseComparator();
        TreeSet<String> attributes = new TreeSet<String>(lowerCaseComparator);
        for (AttributeType attr : schema.getAttributeTypes().values()) {
            if (!matchingRule.equals(attr.getApproximateMatchingRule()) && !matchingRule.equals(attr.getEqualityMatchingRule()) && !matchingRule.equals(attr.getSubstringMatchingRule()) && !matchingRule.equals(attr.getOrderingMatchingRule())) continue;
            attributes.add(attr.getNameOrOID());
        }
        DefaultListModel model = (DefaultListModel)this.usedByAttributes.getModel();
        model.clear();
        for (String attr : attributes) {
            model.addElement(attr);
        }
    }

    static Message getTypeValue(MatchingRule matchingRule) {
        Message text = matchingRule instanceof EqualityMatchingRule ? AdminToolMessages.INFO_CTRL_PANEL_INDEX_EQUALITY.get() : (matchingRule instanceof OrderingMatchingRule ? AdminToolMessages.INFO_CTRL_PANEL_INDEX_ORDERING.get() : (matchingRule instanceof SubstringMatchingRule ? AdminToolMessages.INFO_CTRL_PANEL_INDEX_SUBSTRING.get() : (matchingRule instanceof ApproximateMatchingRule ? AdminToolMessages.INFO_CTRL_PANEL_INDEX_APPROXIMATE.get() : NOT_APPLICABLE)));
        return text;
    }

    private void usedBySelected() {
        AttributeType attr;
        Schema schema;
        String o = (String)this.usedByAttributes.getSelectedValue();
        if (o != null && (schema = this.getInfo().getServerDescriptor().getSchema()) != null && (attr = schema.getAttributeType(o.toLowerCase())) != null) {
            this.notifySchemaSelectionListeners(attr);
        }
    }
}

