/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.opends.guitools.controlpanel.browser.BrowserController;
import org.opends.guitools.controlpanel.ui.AbstractNewEntryPanel;
import org.opends.guitools.controlpanel.ui.GenericDialog;
import org.opends.guitools.controlpanel.ui.LDAPEntrySelectionPanel;
import org.opends.guitools.controlpanel.ui.nodes.BasicNode;
import org.opends.guitools.controlpanel.ui.nodes.BrowserNodeInfo;
import org.opends.guitools.controlpanel.ui.nodes.DndBrowserNodes;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.server.types.DN;
import org.opends.server.types.LDAPURL;
import org.opends.server.types.OpenDsException;

public class NewGroupPanel
extends AbstractNewEntryPanel {
    private static final long serialVersionUID = -8173120152617813282L;
    private JLabel lName = Utilities.createPrimaryLabel();
    private JLabel lDescription = Utilities.createPrimaryLabel();
    private JLabel lMembers = Utilities.createPrimaryLabel();
    private JLabel lDn = Utilities.createPrimaryLabel();
    private JLabel lMemberDNs;
    private JLabel lLDAPURL;
    private JLabel lReferenceGroup;
    private JLabel[] labels = new JLabel[]{this.lName, this.lDescription, this.lMembers, this.lDn};
    private JTextField name = Utilities.createLongTextField();
    private JTextField description = Utilities.createLongTextField();
    private JRadioButton dynamicGroup;
    private JRadioButton staticGroup;
    private JRadioButton virtualGroup;
    private JTextArea staticMembers;
    private JButton addMembers;
    private JTextField filter = Utilities.createLongTextField();
    private JTextField referenceGroup = Utilities.createLongTextField();
    private JButton browseReferenceGroup;
    private GenericDialog membersDlg;
    private LDAPEntrySelectionPanel membersPanel;
    private GenericDialog referenceGroupDlg;
    private LDAPEntrySelectionPanel referenceGroupPanel;
    private JLabel dn = Utilities.createDefaultLabel();
    protected final JTextField[] fields = new JTextField[]{this.name, this.description, this.filter, this.referenceGroup};

    public NewGroupPanel() {
        this.createLayout();
    }

    @Override
    public void setParent(BasicNode parentNode, BrowserController controller) {
        super.setParent(parentNode, controller);
        this.dn.setText("," + parentNode.getDN());
        for (JTextField tf : this.fields) {
            tf.setText("");
        }
        this.staticMembers.setText("");
        this.filter.setText("ldap:///" + parentNode.getDN() + "??sub?(<your filter>)");
    }

    @Override
    public Message getTitle() {
        return AdminToolMessages.INFO_CTRL_PANEL_NEW_GROUP_PANEL_TITLE.get();
    }

    @Override
    public Component getPreferredFocusComponent() {
        return this.name;
    }

    @Override
    protected Message getProgressDialogTitle() {
        return AdminToolMessages.INFO_CTRL_PANEL_NEW_GROUP_PANEL_TITLE.get();
    }

    @Override
    protected boolean checkSyntaxBackground() {
        return this.staticGroup.isSelected();
    }

    @Override
    protected void checkSyntax(ArrayList<Message> errors) {
        boolean errorFound;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                for (JLabel label : NewGroupPanel.this.labels) {
                    NewGroupPanel.this.setPrimaryValid(label);
                }
                NewGroupPanel.this.setSecondaryValid(NewGroupPanel.this.lMemberDNs);
                NewGroupPanel.this.setSecondaryValid(NewGroupPanel.this.lLDAPURL);
                NewGroupPanel.this.setSecondaryValid(NewGroupPanel.this.lReferenceGroup);
            }
        };
        if (this.checkSyntaxBackground()) {
            SwingUtilities.invokeLater(runnable);
        } else {
            runnable.run();
        }
        JTextField[] requiredFields = new JTextField[]{this.name};
        Message[] msgs = new Message[]{AdminToolMessages.ERR_CTRL_PANEL_NAME_OF_GROUP_REQUIRED.get()};
        for (int i = 0; i < requiredFields.length; ++i) {
            String v = requiredFields[i].getText().trim();
            if (v.length() != 0) continue;
            errors.add(msgs[i]);
        }
        if (this.staticGroup.isSelected()) {
            String[] members = this.staticMembers.getText().split("\n");
            boolean oneMemberDefined = false;
            boolean errorFound2 = false;
            for (String member : members) {
                if ((member = member.trim()).length() <= 0) continue;
                try {
                    DN.decode(member);
                    if (!this.entryExists(member)) {
                        errorFound2 = true;
                        errors.add(AdminToolMessages.ERR_CTRL_PANEL_MEMBER_NOT_FOUND.get(member));
                        continue;
                    }
                    oneMemberDefined = true;
                }
                catch (OpenDsException ode) {
                    errorFound2 = true;
                    errors.add(AdminToolMessages.ERR_CTRL_PANEL_MEMBER_VALUE_NOT_VALID.get(member, ode.getMessageObject().toString()));
                }
            }
            if (!oneMemberDefined && !errorFound2) {
                errorFound2 = true;
                errors.add(AdminToolMessages.ERR_CTRL_PANEL_MEMBER_REQUIRED.get());
            }
            if (errorFound2) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        NewGroupPanel.this.setSecondaryInvalid(NewGroupPanel.this.lMemberDNs);
                        NewGroupPanel.this.setPrimaryInvalid(NewGroupPanel.this.lMembers);
                    }
                });
            }
        } else if (this.dynamicGroup.isSelected()) {
            errorFound = false;
            String f = this.filter.getText().trim();
            if (f.length() == 0) {
                errors.add(AdminToolMessages.ERR_CTRL_PANEL_GROUP_FILTER_REQUIRED.get());
                errorFound = true;
            } else {
                try {
                    LDAPURL.decode(f, true);
                }
                catch (OpenDsException ode) {
                    errors.add(AdminToolMessages.ERR_CTRL_PANEL_GROUP_FILTER_NOT_VALID.get(ode.getMessageObject().toString()));
                }
            }
            if (errorFound) {
                this.setSecondaryInvalid(this.lLDAPURL);
                this.setPrimaryInvalid(this.lMembers);
            }
        } else {
            errorFound = false;
            String ref = this.referenceGroup.getText().trim();
            try {
                DN.decode(ref);
                if (!this.entryExists(ref)) {
                    errorFound = true;
                    errors.add(AdminToolMessages.ERR_CTRL_PANEL_REFERENCE_GROUP_NOT_FOUND.get());
                } else if (!this.hasObjectClass(ref, "groupOfURLs")) {
                    errorFound = true;
                    errors.add(AdminToolMessages.ERR_CTRL_PANEL_REFERENCE_GROUP_NOT_DYNAMIC.get());
                }
            }
            catch (OpenDsException ode) {
                errorFound = true;
                errors.add(AdminToolMessages.ERR_CTRL_PANEL_REFERENCE_GROUP_NOT_VALID.get(ode.getMessageObject().toString()));
            }
            if (errorFound) {
                this.setSecondaryInvalid(this.lReferenceGroup);
                this.setPrimaryInvalid(this.lMembers);
            }
        }
    }

    private void createLayout() {
        JTextField[] toAddListener;
        GridBagConstraints gbc = new GridBagConstraints();
        Message[] ls = new Message[]{AdminToolMessages.INFO_CTRL_PANEL_NEW_GROUP_NAME_LABEL.get(), AdminToolMessages.INFO_CTRL_PANEL_NEW_GROUP_DESCRIPTION_LABEL.get(), AdminToolMessages.INFO_CTRL_PANEL_NEW_GROUP_MEMBERS_LABEL.get(), AdminToolMessages.INFO_CTRL_PANEL_NEW_GROUP_ENTRY_DN_LABEL.get()};
        int i = 0;
        for (Message l : ls) {
            this.labels[i].setText(l.toString());
            ++i;
        }
        Utilities.setRequiredIcon(this.lName);
        Utilities.setRequiredIcon(this.lMembers);
        gbc.gridwidth = 2;
        gbc.gridy = 0;
        this.addErrorPane(gbc);
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.weighty = 0.0;
        gbc.gridx = 1;
        gbc.anchor = 13;
        gbc.fill = 0;
        JLabel requiredLabel = this.createRequiredLabel();
        gbc.insets.bottom = 10;
        this.add((Component)requiredLabel, gbc);
        ++gbc.gridy;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets.bottom = 0;
        this.staticGroup = Utilities.createRadioButton(AdminToolMessages.INFO_CTRL_PANEL_STATIC_GROUP_LABEL.get());
        this.dynamicGroup = Utilities.createRadioButton(AdminToolMessages.INFO_CTRL_PANEL_DYNAMIC_GROUP_LABEL.get());
        this.virtualGroup = Utilities.createRadioButton(AdminToolMessages.INFO_CTRL_PANEL_VIRTUAL_STATIC_GROUP_LABEL.get());
        ButtonGroup group = new ButtonGroup();
        group.add(this.staticGroup);
        group.add(this.dynamicGroup);
        group.add(this.virtualGroup);
        this.staticGroup.setSelected(true);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                NewGroupPanel.this.checkEnabling();
            }
        };
        this.staticGroup.addActionListener(actionListener);
        this.dynamicGroup.addActionListener(actionListener);
        this.virtualGroup.addActionListener(actionListener);
        JLabel[] labels = new JLabel[]{this.lName, this.lDescription, this.lMembers};
        Component[] comps = new Component[]{this.name, this.description, this.staticGroup};
        Component[] inlineHelp = new Component[]{null, null, null};
        for (i = 0; i < labels.length; ++i) {
            gbc.insets.left = 0;
            gbc.weightx = 0.0;
            gbc.gridx = 0;
            gbc.gridwidth = 1;
            this.add((Component)labels[i], gbc);
            gbc.insets.left = 10;
            gbc.weightx = 1.0;
            gbc.gridx = 1;
            this.add(comps[i], gbc);
            if (inlineHelp[i] != null) {
                gbc.insets.top = 3;
                ++gbc.gridy;
                this.add(inlineHelp[i], gbc);
            }
            gbc.insets.top = 10;
            ++gbc.gridy;
        }
        gbc.insets.top = 5;
        this.lMemberDNs = Utilities.createDefaultLabel(AdminToolMessages.INFO_CTRL_PANEL_GROUP_MEMBER_DNS_LABEL.get());
        gbc.insets.left = 30;
        this.add((Component)this.lMemberDNs, gbc);
        this.staticMembers = Utilities.createTextArea(Message.EMPTY, 8, 40);
        JScrollPane scroll = Utilities.createScrollPane(this.staticMembers);
        gbc.weighty = 1.0;
        gbc.fill = 1;
        ++gbc.gridy;
        JPanel p = new JPanel(new GridBagLayout());
        p.setOpaque(false);
        this.lLDAPURL = Utilities.createDefaultLabel(AdminToolMessages.INFO_CTRL_PANEL_GROUP_FILTER_LABEL.get());
        this.add((Component)p, gbc);
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.gridx = 0;
        gbc2.weightx = 1.0;
        gbc2.weighty = 1.0;
        gbc2.fill = 1;
        p.add((Component)scroll, gbc2);
        gbc2.insets.left = 5;
        gbc2.weightx = 0.0;
        gbc2.fill = 2;
        ++gbc2.gridx;
        this.addMembers = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_ADD_MEMBERS_BUTTON.get());
        gbc2.anchor = 11;
        p.add((Component)this.addMembers, gbc2);
        this.addMembers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                NewGroupPanel.this.addMembersClicked();
            }
        });
        gbc.insets.left = 10;
        gbc.insets.top = 10;
        gbc.fill = 2;
        gbc.weighty = 0.0;
        ++gbc.gridy;
        this.add((Component)this.dynamicGroup, gbc);
        gbc.insets.top = 5;
        gbc.weightx = 0.0;
        ++gbc.gridy;
        p = new JPanel(new GridBagLayout());
        p.setOpaque(false);
        gbc.insets.left = 30;
        this.add((Component)p, gbc);
        gbc2 = new GridBagConstraints();
        gbc2.gridx = 0;
        gbc2.fill = 2;
        p.add((Component)this.lLDAPURL, gbc2);
        gbc2.insets.left = 5;
        gbc2.weightx = 1.0;
        ++gbc2.gridx;
        p.add((Component)this.filter, gbc2);
        this.lReferenceGroup = Utilities.createDefaultLabel(AdminToolMessages.INFO_CTRL_PANEL_DYNAMIC_GROUP_REFERENCE_LABEL.get());
        gbc.insets.left = 30;
        p = new JPanel(new GridBagLayout());
        p.setOpaque(false);
        ++gbc.gridy;
        this.add((Component)p, gbc);
        ++gbc.gridy;
        gbc.gridx = 1;
        gbc.insets.left = 10;
        gbc.insets.top = 10;
        gbc.fill = 2;
        gbc.weighty = 0.0;
        this.add((Component)this.virtualGroup, gbc);
        gbc.insets.top = 5;
        gbc.weightx = 0.0;
        gbc.insets.top = 10;
        ++gbc.gridy;
        gbc.insets.left = 0;
        gbc.weightx = 0.0;
        gbc.gridx = 0;
        gbc.gridwidth = 1;
        this.add((Component)this.lDn, gbc);
        gbc.insets.left = 10;
        gbc.weightx = 1.0;
        gbc.gridx = 1;
        this.add((Component)this.dn, gbc);
        gbc2 = new GridBagConstraints();
        gbc2.gridx = 0;
        gbc2.fill = 2;
        p.add((Component)this.lReferenceGroup, gbc2);
        gbc2.insets.left = 5;
        gbc2.weightx = 1.0;
        ++gbc2.gridx;
        p.add((Component)this.referenceGroup, gbc2);
        gbc2.weightx = 0.0;
        ++gbc2.gridx;
        this.browseReferenceGroup = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_BROWSE_BUTTON_LABEL.get());
        this.browseReferenceGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                NewGroupPanel.this.browseReferenceGroupClicked();
            }
        });
        p.add((Component)this.browseReferenceGroup, gbc2);
        DocumentListener listener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent ev) {
                NewGroupPanel.this.updateDNValue();
            }

            @Override
            public void changedUpdate(DocumentEvent ev) {
                this.insertUpdate(ev);
            }

            @Override
            public void removeUpdate(DocumentEvent ev) {
                this.insertUpdate(ev);
            }
        };
        for (JTextField tf : toAddListener = new JTextField[]{this.name}) {
            tf.getDocument().addDocumentListener(listener);
        }
        DropTargetListener dropTargetlistener = new DropTargetListener(){

            @Override
            public void dragEnter(DropTargetDragEvent e) {
            }

            @Override
            public void dragExit(DropTargetEvent e) {
            }

            @Override
            public void dragOver(DropTargetDragEvent e) {
            }

            @Override
            public void dropActionChanged(DropTargetDragEvent e) {
            }

            @Override
            public void drop(DropTargetDropEvent e) {
                try {
                    Transferable tr = e.getTransferable();
                    if (!tr.isDataFlavorSupported(DndBrowserNodes.INFO_FLAVOR)) {
                        e.rejectDrop();
                    }
                    DndBrowserNodes nodes = (DndBrowserNodes)tr.getTransferData(DndBrowserNodes.INFO_FLAVOR);
                    Component comp = e.getDropTargetContext().getComponent();
                    if (comp == NewGroupPanel.this.staticMembers) {
                        StringBuilder sb = new StringBuilder();
                        sb.append(NewGroupPanel.this.staticMembers.getText());
                        for (BrowserNodeInfo node : nodes.getNodes()) {
                            if (sb.length() > 0) {
                                sb.append("\n");
                            }
                            sb.append(node.getNode().getDN());
                        }
                        NewGroupPanel.this.staticMembers.setText(sb.toString());
                        NewGroupPanel.this.staticMembers.setCaretPosition(sb.length());
                    } else if (comp == NewGroupPanel.this.referenceGroup && nodes.getNodes().length > 0) {
                        String dn = nodes.getNodes()[0].getNode().getDN();
                        NewGroupPanel.this.referenceGroup.setText(dn);
                        NewGroupPanel.this.referenceGroup.setCaretPosition(dn.length());
                    }
                    e.acceptDrop(3);
                    e.getDropTargetContext().dropComplete(true);
                }
                catch (IOException io) {
                    e.rejectDrop();
                }
                catch (UnsupportedFlavorException ufe) {
                    e.rejectDrop();
                }
            }
        };
        new DropTarget(this.staticMembers, dropTargetlistener);
        new DropTarget(this.referenceGroup, dropTargetlistener);
        this.checkEnabling();
    }

    protected void updateDNValue() {
        String value = this.name.getText().trim();
        if (value.length() > 0) {
            String rdn = Utilities.getRDNString("cn", value);
            this.dn.setText(rdn + "," + this.parentNode.getDN());
        } else {
            this.dn.setText("," + this.parentNode.getDN());
        }
    }

    private void addMembersClicked() {
        if (this.membersDlg == null) {
            this.membersPanel = new LDAPEntrySelectionPanel();
            this.membersPanel.setTitle(AdminToolMessages.INFO_CTRL_PANEL_ADD_MEMBERS_LABEL.get());
            this.membersPanel.setFilter(LDAPEntrySelectionPanel.Filter.USERS);
            this.membersPanel.setMultipleSelection(true);
            this.membersPanel.setInfo(this.getInfo());
            this.membersDlg = new GenericDialog(Utilities.getFrame(this), this.membersPanel);
            Utilities.centerGoldenMean(this.membersDlg, Utilities.getParentDialog(this));
            this.membersDlg.setModal(true);
        }
        this.membersDlg.setVisible(true);
        String[] dns = this.membersPanel.getDNs();
        if (dns.length > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.staticMembers.getText());
            for (String dn : dns) {
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(dn);
            }
            this.staticMembers.setText(sb.toString());
            this.staticMembers.setCaretPosition(sb.length());
        }
    }

    private void browseReferenceGroupClicked() {
        if (this.referenceGroupDlg == null) {
            this.referenceGroupPanel = new LDAPEntrySelectionPanel();
            this.referenceGroupPanel.setTitle(AdminToolMessages.INFO_CTRL_PANEL_CHOOSE_REFERENCE_GROUP.get());
            this.referenceGroupPanel.setFilter(LDAPEntrySelectionPanel.Filter.DYNAMIC_GROUPS);
            this.referenceGroupPanel.setMultipleSelection(false);
            this.referenceGroupPanel.setInfo(this.getInfo());
            this.referenceGroupDlg = new GenericDialog(Utilities.getFrame(this), this.referenceGroupPanel);
            Utilities.centerGoldenMean(this.referenceGroupDlg, Utilities.getParentDialog(this));
            this.referenceGroupDlg.setModal(true);
        }
        this.referenceGroupDlg.setVisible(true);
        String[] dns = this.referenceGroupPanel.getDNs();
        if (dns.length > 0) {
            this.referenceGroup.setText(dns[0]);
        }
    }

    @Override
    protected String getLDIF() {
        StringBuilder sb = new StringBuilder();
        sb.append("dn: " + this.dn.getText() + "\n");
        String[] attrNames = new String[]{"cn", "description"};
        JTextField[] textFields = new JTextField[]{this.name, this.description};
        for (int i = 0; i < attrNames.length; ++i) {
            String value = textFields[i].getText().trim();
            if (value.length() <= 0) continue;
            sb.append(attrNames[i] + ": " + value + "\n");
        }
        sb.append("objectclass: top\n");
        if (this.staticGroup.isSelected()) {
            sb.append("objectClass: groupOfUniqueNames");
            String[] members = this.staticMembers.getText().split("\n");
            LinkedHashSet<DN> dns = new LinkedHashSet<DN>();
            for (String member : members) {
                if ((member = member.trim()).length() <= 0) continue;
                try {
                    dns.add(DN.decode(member));
                }
                catch (OpenDsException ode) {
                    throw new RuntimeException("Unexpected error decoding DN: " + member, ode);
                }
            }
            for (DN dn : dns) {
                sb.append("\nuniqueMember: " + dn.toString());
            }
        } else if (this.dynamicGroup.isSelected()) {
            sb.append("objectClass: groupOfURLs\n");
            sb.append("memberURL: " + this.filter.getText().trim());
        } else {
            sb.append("objectClass: ds-virtual-static-group\n");
            sb.append("objectClass: groupOfUniqueNames\n");
            sb.append("ds-target-group-dn: " + this.referenceGroup.getText().trim());
        }
        return sb.toString();
    }

    private void checkEnabling() {
        this.staticMembers.setEnabled(this.staticGroup.isSelected());
        this.addMembers.setEnabled(this.staticGroup.isSelected());
        this.filter.setEnabled(this.dynamicGroup.isSelected());
        this.referenceGroup.setEnabled(this.virtualGroup.isSelected());
        this.browseReferenceGroup.setEnabled(this.virtualGroup.isSelected());
        this.lMemberDNs.setEnabled(this.staticGroup.isSelected());
        this.lLDAPURL.setEnabled(this.dynamicGroup.isSelected());
        this.lReferenceGroup.setEnabled(this.virtualGroup.isSelected());
    }
}

