/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import org.opends.guitools.controlpanel.datamodel.BinaryValue;
import org.opends.guitools.controlpanel.datamodel.CustomSearchResult;
import org.opends.guitools.controlpanel.datamodel.ObjectClassValue;
import org.opends.guitools.controlpanel.datamodel.SortableTableModel;
import org.opends.guitools.controlpanel.task.OnlineUpdateException;
import org.opends.guitools.controlpanel.ui.GenericDialog;
import org.opends.guitools.controlpanel.ui.ViewEntryPanel;
import org.opends.guitools.controlpanel.ui.renderer.AttributeCellEditor;
import org.opends.guitools.controlpanel.ui.renderer.LDAPEntryTableCellRenderer;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.AttributeValues;
import org.opends.server.types.DN;
import org.opends.server.types.Entry;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.OpenDsException;
import org.opends.server.types.RDN;
import org.opends.server.types.Schema;
import org.opends.server.util.LDIFReader;

public class TableViewEntryPanel
extends ViewEntryPanel {
    private static final long serialVersionUID = 2135331526526472175L;
    private CustomSearchResult searchResult;
    private LDAPEntryTableModel tableModel;
    private LDAPEntryTableCellRenderer renderer;
    private JTable table;
    private boolean isReadOnly;
    private TreePath treePath;
    private JScrollPane scroll;
    private AttributeCellEditor editor;
    private JLabel requiredLabel;
    private JCheckBox showOnlyAttrsWithValues;

    public TableViewEntryPanel() {
        this.createLayout();
    }

    @Override
    public Component getPreferredFocusComponent() {
        return this.table;
    }

    private void createLayout() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        this.addTitlePanel(this, gbc);
        ++gbc.gridy;
        gbc.insets.top = 5;
        gbc.gridwidth = 1;
        this.showOnlyAttrsWithValues = Utilities.createCheckBox(AdminToolMessages.INFO_CTRL_PANEL_SHOW_ATTRS_WITH_VALUES_LABEL.get());
        this.showOnlyAttrsWithValues.setSelected(displayOnlyWithAttrs);
        this.showOnlyAttrsWithValues.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                TableViewEntryPanel.this.updateAttributeVisibility();
                ViewEntryPanel.displayOnlyWithAttrs = TableViewEntryPanel.this.showOnlyAttrsWithValues.isSelected();
            }
        });
        gbc.weightx = 0.0;
        gbc.anchor = 17;
        this.add((Component)this.showOnlyAttrsWithValues, gbc);
        ++gbc.gridx;
        gbc.anchor = 13;
        gbc.fill = 0;
        this.requiredLabel = this.createRequiredLabel();
        this.add((Component)this.requiredLabel, gbc);
        gbc.insets = new Insets(0, 0, 0, 0);
        this.add(Box.createVerticalStrut(10), gbc);
        this.showOnlyAttrsWithValues.setFont(this.requiredLabel.getFont());
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.insets.top = 10;
        gbc.gridwidth = 2;
        this.tableModel = new LDAPEntryTableModel();
        this.renderer = new LDAPEntryTableCellRenderer();
        this.table = Utilities.createSortableTable(this.tableModel, this.renderer);
        this.renderer.setTable(this.table);
        this.editor = new AttributeCellEditor();
        this.table.getColumnModel().getColumn(1).setCellEditor(this.editor);
        gbc.weighty = 1.0;
        gbc.fill = 1;
        ++gbc.gridy;
        this.scroll = Utilities.createScrollPane(this.table);
        this.add((Component)this.scroll, gbc);
    }

    @Override
    public void update(CustomSearchResult sr, boolean isReadOnly, TreePath path) {
        boolean sameEntry = false;
        if (this.searchResult != null && sr != null) {
            sameEntry = this.searchResult.getDN().equals(sr.getDN());
        }
        this.searchResult = sr;
        final Point p = sameEntry ? this.scroll.getViewport().getViewPosition() : new Point(0, 0);
        this.renderer.setSchema(this.getInfo().getServerDescriptor().getSchema());
        this.editor.setInfo(this.getInfo());
        this.requiredLabel.setVisible(!isReadOnly);
        this.isReadOnly = isReadOnly;
        this.treePath = path;
        this.updateTitle(sr, path);
        this.ignoreEntryChangeEvents = true;
        this.tableModel.displayEntry();
        Utilities.updateTableSizes(this.table);
        Utilities.updateScrollMode(this.scroll, this.table);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (p != null && TableViewEntryPanel.this.scroll.getViewport().contains(p)) {
                    TableViewEntryPanel.this.scroll.getViewport().setViewPosition(p);
                }
                TableViewEntryPanel.this.ignoreEntryChangeEvents = false;
            }
        });
    }

    @Override
    public GenericDialog.ButtonType getButtonType() {
        return GenericDialog.ButtonType.NO_BUTTON;
    }

    @Override
    public Entry getEntry() throws OpenDsException {
        if (SwingUtilities.isEventDispatchThread()) {
            this.editor.stopCellEditing();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        TableViewEntryPanel.this.editor.stopCellEditing();
                    }
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        Entry entry = null;
        LDIFImportConfig ldifImportConfig = null;
        try {
            String ldif = this.getLDIF();
            ldifImportConfig = new LDIFImportConfig(new StringReader(ldif));
            LDIFReader reader = new LDIFReader(ldifImportConfig);
            entry = reader.readEntry(this.checkSchema());
            this.addValuesInRDN(entry);
        }
        catch (IOException ioe) {
            throw new OnlineUpdateException(AdminToolMessages.ERR_CTRL_PANEL_ERROR_CHECKING_ENTRY.get(ioe.toString()), (Throwable)ioe);
        }
        finally {
            if (ldifImportConfig != null) {
                ldifImportConfig.close();
            }
        }
        return entry;
    }

    private String getLDIF() {
        StringBuilder sb = new StringBuilder();
        sb.append("dn: " + this.getDisplayedDN());
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            String attrName = (String)this.tableModel.getValueAt(i, 0);
            if (this.schemaReadOnlyAttributesLowerCase.contains(attrName.toLowerCase())) continue;
            Object value = this.tableModel.getValueAt(i, 1);
            this.appendLDIFLine(sb, attrName, value);
        }
        return sb.toString();
    }

    @Override
    protected String getDisplayedDN() {
        StringBuilder sb = new StringBuilder();
        try {
            DN oldDN = DN.decode(this.searchResult.getDN());
            if (oldDN.getNumComponents() > 0) {
                Schema schema;
                RDN rdn = oldDN.getRDN();
                ArrayList<AttributeType> attributeTypes = new ArrayList<AttributeType>();
                ArrayList<String> attributeNames = new ArrayList<String>();
                ArrayList<AttributeValue> attributeValues = new ArrayList<AttributeValue>();
                for (int i = 0; i < rdn.getNumValues(); ++i) {
                    String attrName = rdn.getAttributeName(i);
                    AttributeValue value = rdn.getAttributeValue(i);
                    String sValue = value.getValue().toString();
                    Set<String> values = this.getDisplayedStringValues(attrName);
                    if (!values.contains(sValue)) {
                        if (values.size() <= 0) continue;
                        String firstNonEmpty = null;
                        for (String v : values) {
                            if ((v = v.trim()).length() <= 0) continue;
                            firstNonEmpty = v;
                            break;
                        }
                        if (firstNonEmpty == null) continue;
                        AttributeType attr = rdn.getAttributeType(i);
                        attributeTypes.add(attr);
                        attributeNames.add(rdn.getAttributeName(i));
                        attributeValues.add(AttributeValues.create(attr, firstNonEmpty));
                        continue;
                    }
                    attributeTypes.add(rdn.getAttributeType(i));
                    attributeNames.add(rdn.getAttributeName(i));
                    attributeValues.add(value);
                }
                if (attributeTypes.size() == 0 && (schema = this.getInfo().getServerDescriptor().getSchema()) != null) {
                    for (int i = 0; i < this.table.getRowCount(); ++i) {
                        Object o;
                        String attrName = (String)this.table.getValueAt(i, 0);
                        if (this.isPassword(attrName) || attrName.equals("objectclass") || !this.table.isCellEditable(i, 1) || !((o = this.table.getValueAt(i, 1)) instanceof String)) continue;
                        String aName = Utilities.getAttributeNameWithoutOptions(attrName);
                        AttributeType attr = schema.getAttributeType(aName.toLowerCase());
                        if (attr == null) break;
                        attributeTypes.add(attr);
                        attributeNames.add(attrName);
                        attributeValues.add(AttributeValues.create(attr, (String)o));
                        break;
                    }
                }
                DN parent = oldDN.getParent();
                if (attributeTypes.size() > 0) {
                    RDN newRDN = new RDN(attributeTypes, attributeNames, attributeValues);
                    DN newDN = parent == null ? new DN(new RDN[]{newRDN}) : parent.concat(newRDN);
                    sb.append(newDN.toString());
                } else if (parent != null) {
                    sb.append("," + parent.toString());
                }
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("Unexpected error: " + t, t);
        }
        return sb.toString();
    }

    private Set<String> getDisplayedStringValues(String attrName) {
        LinkedHashSet<String> values = new LinkedHashSet<String>();
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            Object o;
            if (!attrName.equalsIgnoreCase((String)this.table.getValueAt(i, 0)) || !((o = this.table.getValueAt(i, 1)) instanceof String)) continue;
            values.add((String)o);
        }
        return values;
    }

    private void updateAttributeVisibility() {
        this.tableModel.updateAttributeVisibility();
    }

    @Override
    protected List<Object> getValues(String attrName) {
        return this.tableModel.getValues(attrName);
    }

    class AttributeValuePair {
        String attrName;
        Object value;

        public AttributeValuePair(String attrName, Object value) {
            this.attrName = attrName;
            this.value = value;
        }
    }

    protected class LDAPEntryTableModel
    extends SortableTableModel
    implements Comparator<AttributeValuePair> {
        private static final long serialVersionUID = -1240282431326505113L;
        private ArrayList<AttributeValuePair> dataArray = new ArrayList();
        private SortedSet<AttributeValuePair> allSortedValues = new TreeSet<AttributeValuePair>(this);
        Set<String> requiredAttrs = new HashSet<String>();
        private final String[] COLUMN_NAMES = new String[]{this.getHeader(Message.raw("Attribute", new Object[0]), 40), this.getHeader(Message.raw("Value", 40))};
        private int sortColumn = 0;
        private boolean sortAscending = true;

        protected LDAPEntryTableModel() {
        }

        public void displayEntry() {
            this.updateDataArray();
            this.fireTableDataChanged();
        }

        @Override
        public void forceResort() {
            this.updateDataArray();
            this.fireTableDataChanged();
        }

        @Override
        public int compare(AttributeValuePair desc1, AttributeValuePair desc2) {
            int[] possibleResults = new int[]{desc1.attrName.compareTo(desc2.attrName), this.compareValues(desc1.value, desc2.value)};
            int result = possibleResults[this.sortColumn];
            if (result == 0) {
                for (int i : possibleResults) {
                    if (i == 0) continue;
                    result = i;
                    break;
                }
            }
            if (!this.sortAscending) {
                result = -result;
            }
            return result;
        }

        private int compareValues(Object o1, Object o2) {
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            if (o1 instanceof ObjectClassValue) {
                o1 = TableViewEntryPanel.this.renderer.getString((ObjectClassValue)o1);
            } else if (o1 instanceof BinaryValue) {
                o1 = TableViewEntryPanel.this.renderer.getString((BinaryValue)o1);
            } else if (o1 instanceof byte[]) {
                o1 = TableViewEntryPanel.this.renderer.getString((byte[])o1);
            }
            if (o2 instanceof ObjectClassValue) {
                o2 = TableViewEntryPanel.this.renderer.getString((ObjectClassValue)o2);
            } else if (o2 instanceof BinaryValue) {
                o2 = TableViewEntryPanel.this.renderer.getString((BinaryValue)o2);
            } else if (o2 instanceof byte[]) {
                o2 = TableViewEntryPanel.this.renderer.getString((byte[])o2);
            }
            if (o1.getClass().equals(o2.getClass())) {
                if (o1 instanceof String) {
                    return ((String)o1).compareTo((String)o2);
                }
                if (o1 instanceof Integer) {
                    return ((Integer)o1).compareTo((Integer)o2);
                }
                if (o1 instanceof Long) {
                    return ((Long)o1).compareTo((Long)o2);
                }
                return String.valueOf(o1).compareTo(String.valueOf(o2));
            }
            return String.valueOf(o1).compareTo(String.valueOf(o2));
        }

        @Override
        public int getColumnCount() {
            return this.COLUMN_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return this.dataArray.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 0) {
                return this.dataArray.get((int)row).attrName;
            }
            return this.dataArray.get((int)row).value;
        }

        @Override
        public String getColumnName(int col) {
            return this.COLUMN_NAMES[col];
        }

        @Override
        public boolean isSortAscending() {
            return this.sortAscending;
        }

        @Override
        public void setSortAscending(boolean sortAscending) {
            this.sortAscending = sortAscending;
        }

        @Override
        public int getSortColumn() {
            return this.sortColumn;
        }

        @Override
        public void setSortColumn(int sortColumn) {
            this.sortColumn = sortColumn;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            if (col == 0) {
                return false;
            }
            if (!TableViewEntryPanel.this.isReadOnly) {
                return !TableViewEntryPanel.this.schemaReadOnlyAttributesLowerCase.contains(this.dataArray.get((int)row).attrName.toLowerCase());
            }
            return false;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            this.dataArray.get((int)row).value = value;
            if (value instanceof ObjectClassValue) {
                this.updateObjectClass((ObjectClassValue)value);
            } else {
                this.fireTableCellUpdated(row, col);
                TableViewEntryPanel.this.notifyListeners();
            }
        }

        private void updateDataArray() {
            this.allSortedValues.clear();
            this.requiredAttrs.clear();
            ArrayList<String> addedAttrs = new ArrayList<String>();
            Schema schema = TableViewEntryPanel.this.getInfo().getServerDescriptor().getSchema();
            List<Object> ocs = null;
            for (String string : TableViewEntryPanel.this.searchResult.getAttributeNames()) {
                if (string.equalsIgnoreCase("objectclass")) {
                    if (schema != null) {
                        ocs = TableViewEntryPanel.this.searchResult.getAttributeValues(string);
                        ObjectClassValue ocValue = TableViewEntryPanel.this.getObjectClassDescriptor(ocs, schema);
                        this.allSortedValues.add(new AttributeValuePair(string, ocValue));
                    }
                } else {
                    for (Object v : TableViewEntryPanel.this.searchResult.getAttributeValues(string)) {
                        this.allSortedValues.add(new AttributeValuePair(string, v));
                    }
                }
                addedAttrs.add(Utilities.getAttributeNameWithoutOptions(string).toLowerCase());
            }
            if (ocs != null && schema != null) {
                for (Object e : ocs) {
                    String attrName;
                    String oc = (String)e;
                    ObjectClass objectClass = schema.getObjectClass(oc.toLowerCase());
                    if (objectClass == null) continue;
                    for (AttributeType attr : objectClass.getRequiredAttributeChain()) {
                        attrName = attr.getNameOrOID();
                        if (!addedAttrs.contains(attrName.toLowerCase())) {
                            if (TableViewEntryPanel.this.isBinary(attrName) || TableViewEntryPanel.this.isPassword(attrName)) {
                                this.allSortedValues.add(new AttributeValuePair(attrName, new byte[0]));
                            } else {
                                this.allSortedValues.add(new AttributeValuePair(attrName, ""));
                            }
                        }
                        this.requiredAttrs.add(attrName.toLowerCase());
                    }
                    for (AttributeType attr : objectClass.getOptionalAttributeChain()) {
                        attrName = attr.getNameOrOID();
                        if (addedAttrs.contains(attrName.toLowerCase())) continue;
                        if (TableViewEntryPanel.this.isBinary(attrName) || TableViewEntryPanel.this.isPassword(attrName)) {
                            this.allSortedValues.add(new AttributeValuePair(attrName, new byte[0]));
                            continue;
                        }
                        this.allSortedValues.add(new AttributeValuePair(attrName, ""));
                    }
                }
            }
            this.dataArray.clear();
            for (AttributeValuePair attributeValuePair : this.allSortedValues) {
                if (TableViewEntryPanel.this.showOnlyAttrsWithValues.isSelected() && !this.isRequired(attributeValuePair) && !this.hasValue(attributeValuePair)) continue;
                this.dataArray.add(attributeValuePair);
            }
            TableViewEntryPanel.this.renderer.setRequiredAttrs(this.requiredAttrs);
        }

        void updateAttributeVisibility() {
            this.dataArray.clear();
            for (AttributeValuePair value : this.allSortedValues) {
                if (TableViewEntryPanel.this.showOnlyAttrsWithValues.isSelected() && !this.isRequired(value) && !this.hasValue(value)) continue;
                this.dataArray.add(value);
            }
            this.fireTableDataChanged();
            Utilities.updateTableSizes(TableViewEntryPanel.this.table);
            Utilities.updateScrollMode(TableViewEntryPanel.this.scroll, TableViewEntryPanel.this.table);
        }

        public List<Object> getValues(String attrName) {
            ArrayList<Object> values = new ArrayList<Object>();
            for (AttributeValuePair valuePair : this.dataArray) {
                if (!valuePair.attrName.equalsIgnoreCase(attrName) || !this.hasValue(valuePair)) continue;
                if (valuePair.value instanceof Collection) {
                    for (Object o : (Collection)valuePair.value) {
                        values.add(o);
                    }
                    continue;
                }
                values.add(valuePair.value);
            }
            return values;
        }

        private void updateObjectClass(ObjectClassValue newValue) {
            CustomSearchResult oldResult = TableViewEntryPanel.this.searchResult;
            CustomSearchResult newResult = new CustomSearchResult(TableViewEntryPanel.this.searchResult.getDN());
            for (String attrName : TableViewEntryPanel.this.schemaReadOnlyAttributesLowerCase) {
                List<Object> values = TableViewEntryPanel.this.searchResult.getAttributeValues(attrName);
                if (values.isEmpty()) continue;
                newResult.set(attrName, values);
            }
            TableViewEntryPanel.this.ignoreEntryChangeEvents = true;
            Schema schema = TableViewEntryPanel.this.getInfo().getServerDescriptor().getSchema();
            if (schema != null) {
                ArrayList<String> attributes = new ArrayList<String>();
                ArrayList<String> ocs = new ArrayList<String>();
                if (newValue.getStructural() != null) {
                    ocs.add(newValue.getStructural().toLowerCase());
                }
                for (String oc : newValue.getAuxiliary()) {
                    ocs.add(oc.toLowerCase());
                }
                for (String oc : ocs) {
                    ObjectClass objectClass = schema.getObjectClass(oc);
                    if (objectClass == null) continue;
                    for (AttributeType attr : objectClass.getRequiredAttributeChain()) {
                        attributes.add(attr.getNameOrOID().toLowerCase());
                    }
                    for (AttributeType attr : objectClass.getOptionalAttributeChain()) {
                        attributes.add(attr.getNameOrOID().toLowerCase());
                    }
                }
                for (String attrName : TableViewEntryPanel.this.editableOperationalAttrNames) {
                    attributes.add(attrName.toLowerCase());
                }
                for (AttributeValuePair currValue : this.allSortedValues) {
                    String attrNoOptions = Utilities.getAttributeNameWithoutOptions(currValue.attrName).toLowerCase();
                    if (!attributes.contains(attrNoOptions) || TableViewEntryPanel.this.schemaReadOnlyAttributesLowerCase.contains(currValue.attrName.toLowerCase())) continue;
                    TableViewEntryPanel.this.setValues(newResult, currValue.attrName);
                }
            }
            TableViewEntryPanel.this.update(newResult, TableViewEntryPanel.this.isReadOnly, TableViewEntryPanel.this.treePath);
            TableViewEntryPanel.this.ignoreEntryChangeEvents = false;
            TableViewEntryPanel.this.searchResult = oldResult;
            TableViewEntryPanel.this.notifyListeners();
        }

        private boolean isRequired(AttributeValuePair value) {
            return this.requiredAttrs.contains(Utilities.getAttributeNameWithoutOptions(value.attrName.toLowerCase()));
        }

        private boolean hasValue(AttributeValuePair value) {
            boolean hasValue;
            boolean bl = hasValue = value.value != null;
            if (hasValue) {
                if (value.value instanceof String) {
                    hasValue = ((String)value.value).length() > 0;
                } else if (value.value instanceof byte[]) {
                    hasValue = ((byte[])value.value).length > 0;
                }
            }
            return hasValue;
        }
    }
}

