/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui.components;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import javax.swing.text.JTextComponent;

public class NumericLimitedSizeDocumentFilter
extends DocumentFilter {
    private JTextComponent tf;
    private int maxSize;

    public NumericLimitedSizeDocumentFilter(JTextComponent tf, int maxSize) {
        this.tf = tf;
        this.maxSize = maxSize;
    }

    @Override
    public void insertString(DocumentFilter.FilterBypass fb, int offset, String text, AttributeSet attr) throws BadLocationException {
        int previousLength = fb.getDocument().getLength();
        String newText = text.replaceAll("[^0-9]", "");
        if (newText.length() > this.maxSize) {
            newText = newText.substring(0, this.maxSize);
        }
        if (newText.length() + previousLength > this.maxSize) {
            if (offset + newText.length() > this.maxSize) {
                int newOffset = offset + newText.length() - this.maxSize;
                fb.remove(0, newOffset);
                fb.insertString(newOffset, newText, attr);
            } else {
                fb.insertString(offset, newText, attr);
                fb.remove(this.maxSize, newText.length() + previousLength - this.maxSize);
            }
        } else {
            fb.insertString(offset, newText, attr);
        }
        this.updateCaretPosition(fb);
    }

    @Override
    public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attr) throws BadLocationException {
        if (length > 0) {
            fb.remove(offset, length);
        }
        this.insertString(fb, offset, text, attr);
    }

    private void updateCaretPosition(DocumentFilter.FilterBypass fb) throws BadLocationException {
        int totalLength = fb.getDocument().getLength();
        int caretPosition = this.tf.getCaretPosition();
        if (totalLength >= this.maxSize && caretPosition == fb.getDocument().getLength()) {
            this.tf.setCaretPosition(0);
        }
    }
}

