/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui.renderer;

import java.awt.Component;
import java.awt.Font;
import javax.swing.JTree;
import org.opends.guitools.controlpanel.browser.BrowserController;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;
import org.opends.guitools.controlpanel.ui.nodes.BasicNode;
import org.opends.guitools.controlpanel.ui.renderer.TreeCellRenderer;

public class BrowserCellRenderer
extends TreeCellRenderer {
    private static final long serialVersionUID = 6756291700611741513L;
    Font defaultFont = ColorAndFontConstants.treeFont;
    Font italicFont = this.defaultFont.deriveFont(2);
    Font boldFont = this.defaultFont.deriveFont(1);
    Font italicBoldFont = this.defaultFont.deriveFont(3);
    BasicNode inspectedNode;

    public void setInspectedNode(BasicNode node) {
        this.inspectedNode = node;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean isExpanded, boolean isLeaf, int row, boolean cellHasFocus) {
        BasicNode node = (BasicNode)value;
        super.getTreeCellRendererComponent(tree, node, isSelected, isExpanded, isLeaf, row, cellHasFocus);
        this.setIcon(node.getIcon());
        this.setText(node.getDisplayName());
        Font newFont = this.defaultFont;
        int style = node.getFontStyle();
        if (node == this.inspectedNode) {
            style |= 1;
        }
        newFont = (style & 2 & 1) != 0 ? this.italicBoldFont : ((style & 2) != 0 ? this.italicFont : ((style & 1) != 0 ? this.boldFont : this.defaultFont));
        this.setFont(newFont);
        return this;
    }

    public static int calculateRowHeight(BrowserController controller) {
        return 16;
    }
}

