/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.util;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opends.guitools.controlpanel.event.PrintStreamListener;

public class ApplicationPrintStream
extends PrintStream {
    private ArrayList<PrintStreamListener> listeners = new ArrayList();
    private static final Logger LOG = Logger.getLogger(ApplicationPrintStream.class.getName());
    private boolean notifyListeners = true;

    public ApplicationPrintStream() {
        super(new ByteArrayOutputStream(), true);
    }

    @Override
    public void println(String msg) {
        this.notifyListenersNewLine(msg);
        LOG.log(Level.INFO, msg);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException("b is null");
        }
        if (off + len > b.length) {
            throw new IndexOutOfBoundsException("len + off are bigger than the length of the byte array");
        }
        this.println(new String(b, off, len));
    }

    public void addListener(PrintStreamListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(PrintStreamListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyListenersNewLine(String msg) {
        if (this.notifyListeners) {
            for (PrintStreamListener listener : this.listeners) {
                listener.newLine(msg);
            }
        }
    }

    public void setNotifyListeners(boolean notifyListeners) {
        this.notifyListeners = notifyListeners;
    }
}

