/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.util;

import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class ControlPanelLog {
    private static String[] packages = new String[]{"org.opends"};
    private static File logFile = null;
    private static FileHandler fileHandler;

    public static void initLogFileHandler(File file) throws IOException {
        if (!ControlPanelLog.isInitialized()) {
            logFile = file;
            fileHandler = new FileHandler(logFile.getCanonicalPath());
            fileHandler.setFormatter(new SimpleFormatter());
            for (String packageName : packages) {
                Logger logger = Logger.getLogger(packageName);
                if (ControlPanelLog.disableLoggingToConsole()) {
                    logger.setUseParentHandlers(false);
                }
                logger.addHandler(fileHandler);
            }
            Logger logger = Logger.getLogger(packages[0]);
            logger.log(Level.INFO, ControlPanelLog.getInitialLogRecord());
        }
    }

    public static void initPackage(String packageName) throws IOException {
        Logger logger = Logger.getLogger(packageName);
        if (ControlPanelLog.disableLoggingToConsole()) {
            logger.setUseParentHandlers(false);
        }
        logger.addHandler(fileHandler);
        logger.log(Level.INFO, ControlPanelLog.getInitialLogRecord());
    }

    public static File getLogFile() {
        return logFile;
    }

    public static boolean isInitialized() {
        return logFile != null;
    }

    private static String getInitialLogRecord() {
        StringBuilder sb = new StringBuilder().append("Application launched " + DateFormat.getDateTimeInstance(1, 1).format(new Date()));
        return sb.toString();
    }

    private static boolean disableLoggingToConsole() {
        return !"true".equals(System.getenv("OPENDJ_LOG_TO_STDOUT"));
    }
}

