/*
 * Decompiled with CFR 0.152.
 */
package org.opends.messages;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opends.messages.MessageDescriptor;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;

@PublicAPI(stability=StabilityLevel.PRIVATE)
final class MessageDescriptorRegistry {
    private static final String REGISTRY_FILE = "descriptors.reg";
    private static final Set<Class<?>> REGISTERED_MESSAGE_CLASSES = new HashSet();
    private static final Map<Integer, MessageDescriptor> ID_TO_DESCRIPTORS = new HashMap<Integer, MessageDescriptor>();
    private static final Map<Class<?>, List<MessageDescriptor>> CLASS_TO_DESCRIPTORS = new HashMap();

    MessageDescriptorRegistry() {
    }

    public static MessageDescriptor getMessageDescriptor(int id) {
        return ID_TO_DESCRIPTORS.get(id);
    }

    public static List<MessageDescriptor> getMessageDescriptorsForClass(Class<?> mdClass) {
        return Collections.unmodifiableList(CLASS_TO_DESCRIPTORS.get(mdClass));
    }

    public static Set<Class<?>> getRegisteredClasses() {
        return Collections.unmodifiableSet(REGISTERED_MESSAGE_CLASSES);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        InputStream is = MessageDescriptor.class.getResourceAsStream(REGISTRY_FILE);
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        try {
            String line;
            while (null != (line = reader.readLine())) {
                String descClassName = line.trim();
                try {
                    Class<?> descClass = Class.forName(descClassName);
                    LinkedList<MessageDescriptor> mdList = new LinkedList<MessageDescriptor>();
                    CLASS_TO_DESCRIPTORS.put(descClass, mdList);
                    REGISTERED_MESSAGE_CLASSES.add(descClass);
                    Field[] fa = descClass.getFields();
                    if (fa == null) continue;
                    for (Field f : fa) {
                        Class<?> c = f.getType();
                        if (!MessageDescriptor.class.isAssignableFrom(c)) continue;
                        MessageDescriptor md = (MessageDescriptor)f.get(null);
                        mdList.add(md);
                        int id = md.getId();
                        if (id == -1) continue;
                        ID_TO_DESCRIPTORS.put(id, md);
                    }
                }
                catch (ClassNotFoundException e) {
                    System.err.println("Message class " + descClassName + " not found.");
                }
                catch (IllegalAccessException e) {
                    System.err.println("Error accessing class " + descClassName + ":  " + e.getMessage());
                }
            }
            return;
        }
        catch (IOException e) {
            System.err.println("Unable to register message files:  " + e.getMessage());
        }
    }
}

