/*
 * Decompiled with CFR 0.152.
 */
package org.opends.messages;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;

@PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=false, mayExtend=false, mayInvoke=true)
public enum Severity {
    INFORMATION(0, "INFO", "INFO"),
    MILD_WARNING(65536, "MILD_WARN", "WARN"),
    SEVERE_WARNING(131072, "SEVERE_WARN", "WARN"),
    MILD_ERROR(196608, "MILD_ERR", "ERR"),
    SEVERE_ERROR(262144, "SEVERE_ERR", "ERR"),
    FATAL_ERROR(327680, "FATAL_ERR", "ERR"),
    DEBUG(393216, "DEBUG", "DEBUG"),
    NOTICE(458752, "NOTICE", "NOTE");

    private static Set<String> PROPERTY_KEY_FORM_VALUES_SET;
    private static Map<String, Severity> PROPERTY_KEY_FORM_MAP;
    private static Map<Integer, Severity> MASK_VALUE_MAP;
    private final int mask;
    private final String propertyKeyForm;
    private final String messageDescriptorForm;

    public static Set<String> getPropertyKeyFormSet() {
        return Collections.unmodifiableSet(PROPERTY_KEY_FORM_VALUES_SET);
    }

    public static Severity parseMask(int mask) {
        Severity sev = MASK_VALUE_MAP.get(mask);
        if (sev == null) {
            throw new IllegalArgumentException("No Severity defined with int value " + mask);
        }
        return sev;
    }

    public static Severity parseString(String s) {
        Severity sev = PROPERTY_KEY_FORM_MAP.get(s);
        if (sev == null) {
            sev = Severity.valueOf(s);
        }
        return sev;
    }

    public static Severity parseMessageId(int msgId) {
        return Severity.parseMask(msgId & 0xF0000);
    }

    public int getMask() {
        return this.mask;
    }

    public String messageDesciptorName() {
        return this.messageDescriptorForm;
    }

    public String propertyKeyFormName() {
        return this.propertyKeyForm;
    }

    private Severity(int mask, String propertyKeyForm, String messageDescriptorName) {
        this.mask = mask;
        this.propertyKeyForm = propertyKeyForm;
        this.messageDescriptorForm = messageDescriptorName;
    }

    static {
        MASK_VALUE_MAP = new HashMap<Integer, Severity>();
        for (Severity c : EnumSet.allOf(Severity.class)) {
            MASK_VALUE_MAP.put(c.mask, c);
        }
        PROPERTY_KEY_FORM_MAP = new HashMap<String, Severity>();
        PROPERTY_KEY_FORM_VALUES_SET = new HashSet<String>();
        for (Severity s : EnumSet.allOf(Severity.class)) {
            PROPERTY_KEY_FORM_MAP.put(s.propertyKeyFormName(), s);
            PROPERTY_KEY_FORM_VALUES_SET.add(s.propertyKeyFormName());
        }
    }
}

