/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.Constants;
import org.opends.quicksetup.Installation;
import org.opends.quicksetup.util.Utils;

public class CurrentInstallStatus {
    private static final Logger LOG = Logger.getLogger(CurrentInstallStatus.class.getName());
    private boolean isInstalled;
    private boolean canOverwriteCurrentInstall;
    private Message installationMsg;

    public CurrentInstallStatus() {
        if (Utils.isWebStart()) {
            this.isInstalled = false;
        } else {
            Installation installation = Installation.getLocal();
            ArrayList<Message> msgs = new ArrayList<Message>();
            if (installation.getStatus().isServerRunning()) {
                msgs.add(QuickSetupMessages.INFO_INSTALLSTATUS_SERVERRUNNING.get(String.valueOf(this.getPort())));
            }
            if (this.dbFilesExist()) {
                this.canOverwriteCurrentInstall = true;
                msgs.add(QuickSetupMessages.INFO_INSTALLSTATUS_DBFILEEXIST.get());
            }
            if (this.configExists()) {
                this.canOverwriteCurrentInstall = false;
                this.isInstalled = true;
                msgs.add(QuickSetupMessages.INFO_INSTALLSTATUS_CONFIGFILEMODIFIED.get());
            }
            if (this.canOverwriteCurrentInstall) {
                this.installationMsg = !Utils.isCli() ? QuickSetupMessages.INFO_INSTALLSTATUS_CANOVERWRITECURRENTINSTALL_MSG.get() : QuickSetupMessages.INFO_INSTALLSTATUS_CANOVERWRITECURRENTINSTALL_MSG_CLI.get();
            } else if (this.isInstalled) {
                MessageBuilder buf = new MessageBuilder();
                if (Utils.isCli()) {
                    buf = new MessageBuilder();
                    for (Message msg : msgs) {
                        buf.append(Constants.LINE_SEPARATOR);
                        buf.append("- ").append(msg);
                    }
                    String cmd = Utils.isWindows() ? "setup.bat" : "setup";
                    this.installationMsg = QuickSetupMessages.INFO_INSTALLSTATUS_INSTALLED_CLI.get(cmd, buf.toString());
                } else {
                    buf.append("<ul>");
                    for (Message msg : msgs) {
                        buf.append("\n<li>");
                        buf.append(msg);
                        buf.append("</li>");
                    }
                    buf.append("</ul>");
                    this.installationMsg = QuickSetupMessages.INFO_INSTALLSTATUS_INSTALLED.get(buf.toString());
                }
            }
        }
        if (!this.isInstalled) {
            this.installationMsg = QuickSetupMessages.INFO_INSTALLSTATUS_NOT_INSTALLED.get();
        }
    }

    public boolean isInstalled() {
        return this.isInstalled;
    }

    public boolean canOverwriteCurrentInstall() {
        return this.canOverwriteCurrentInstall;
    }

    public Message getInstallationMsg() {
        return this.installationMsg;
    }

    private int getPort() {
        int port = -1;
        try {
            port = Installation.getLocal().getCurrentConfiguration().getPort();
        }
        catch (IOException ioe) {
            LOG.log(Level.INFO, "Failed to get port", ioe);
        }
        return port;
    }

    private boolean dbFilesExist() {
        File dbDir = Installation.getLocal().getDatabasesDirectory();
        File[] children = dbDir.listFiles();
        return children != null && children.length > 0;
    }

    private boolean configExists() {
        File configDir = Installation.getLocal().getConfigurationDirectory();
        File[] children = configDir.listFiles();
        return children != null && children.length > 0;
    }
}

