/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import org.opends.quicksetup.util.Utils;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;

public class LicenseFile {
    private static final String LICENSE_FILE_NAME = "license_to_accept.txt";
    private static final String LEGAL_FOLDER_NAME = "Legal";
    private static final String ACCEPTED_LICENSE_FILE_NAME = "licenseAccepted";
    private static File licFile = null;
    private static boolean approved = false;

    private static String getInstanceLegalDirectory() {
        String instanceDirname;
        String instanceLegalDirName;
        File instanceLegalDir;
        String installDirName = System.getProperty("INSTALL_ROOT");
        if (installDirName == null) {
            installDirName = System.getenv("INSTALL_ROOT");
        }
        if (installDirName == null) {
            installDirName = ".";
        }
        if (!(instanceLegalDir = new File(instanceLegalDirName = (instanceDirname = Utils.getInstancePathFromInstallPath(installDirName)) + File.separator + LEGAL_FOLDER_NAME)).exists()) {
            instanceLegalDir.mkdir();
        }
        return instanceLegalDirName;
    }

    private static String getName() {
        return LicenseFile.getInstanceLegalDirectory() + File.separatorChar + LICENSE_FILE_NAME;
    }

    private static File getFile() {
        if (licFile == null) {
            licFile = new File(LicenseFile.getName());
        }
        return licFile;
    }

    private static URL getWebStartLicenseFile() {
        String licenseResource = LEGAL_FOLDER_NAME + File.separatorChar + LICENSE_FILE_NAME;
        return Thread.currentThread().getContextClassLoader().getResource(licenseResource);
    }

    public static boolean exists() {
        if (Utils.isWebStart()) {
            return LicenseFile.getWebStartLicenseFile() != null;
        }
        return LicenseFile.getFile().exists();
    }

    public static String getText() {
        InputStream input = null;
        if (!Utils.isWebStart()) {
            try {
                input = new FileInputStream(LicenseFile.getFile());
            }
            catch (FileNotFoundException e) {
                return "";
            }
        }
        URL licenseURL = LicenseFile.getWebStartLicenseFile();
        if (licenseURL != null) {
            try {
                input = licenseURL.openStream();
            }
            catch (Exception e) {
                return "";
            }
        }
        StringBuilder sb = new StringBuilder();
        if (input != null) {
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader(input));
                String read = br.readLine();
                while (read != null) {
                    sb.append(read);
                    sb.append(ServerConstants.EOL);
                    read = br.readLine();
                }
            }
            catch (IOException ioe) {
                return "";
            }
        }
        StaticUtils.close(input);
        return sb.toString();
    }

    public static boolean getApproval() {
        return approved;
    }

    public static void setApproval(boolean p_approved) {
        approved = p_approved;
    }

    public static void createFileLicenseApproved(String installationPath) {
        if (LicenseFile.getApproval() && installationPath != null) {
            try {
                new File(installationPath + File.separatorChar + LEGAL_FOLDER_NAME + File.separatorChar + ACCEPTED_LICENSE_FILE_NAME).createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static boolean isAlreadyApproved() {
        File f = new File(LicenseFile.getInstanceLegalDirectory() + File.separatorChar + ACCEPTED_LICENSE_FILE_NAME);
        return f.exists();
    }
}

