/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.Window;
import javax.swing.SwingUtilities;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.ui.Utilities;

public class SplashScreen
extends Window {
    private static final long serialVersionUID = 8918803902867388766L;
    private Image image;
    private Object quickSetup;
    private Class<?> quickSetupClass;
    private static final int MIN_SPLASH_DISPLAY = 3000;

    public static void main(String[] args) {
        SplashScreen screen = new SplashScreen();
        screen.display(args);
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        g.drawImage(this.image, 0, 0, this);
    }

    protected SplashScreen() {
        super(new Frame());
        try {
            this.image = this.getSplashImage();
            MediaTracker mt = new MediaTracker(this);
            mt.addImage(this.image, 0);
            mt.waitForID(0);
            int width = this.image.getWidth(this);
            int height = this.image.getHeight(this);
            this.setPreferredSize(new Dimension(width, height));
            this.setSize(width, height);
            Utilities.centerOnScreen(this);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void display(String[] args) {
        if (SwingUtilities.isEventDispatchThread()) {
            final String[] fArgs = args;
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    SplashScreen.this.mainOutsideEventThread(fArgs);
                }
            });
            t.start();
        } else {
            this.mainOutsideEventThread(args);
        }
    }

    private Image getSplashImage() {
        String resource = QuickSetupMessages.INFO_SPLASH_ICON.get().toString();
        resource = "org/opends/quicksetup/" + resource;
        return Toolkit.getDefaultToolkit().createImage(this.getClass().getClassLoader().getResource(resource));
    }

    private void mainOutsideEventThread(String[] args) {
        this.displaySplashScreen();
        long splashDisplayStartTime = System.currentTimeMillis();
        this.constructApplication(args);
        this.sleepIfNecessary(splashDisplayStartTime);
        this.disposeSplashScreen();
        this.displayApplication();
    }

    private void displaySplashScreen() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    SplashScreen.this.setVisible(true);
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void constructApplication(String[] args) {
        try {
            this.quickSetupClass = Class.forName("org.opends.quicksetup.ui.QuickSetup");
            this.quickSetup = this.quickSetupClass.newInstance();
            this.quickSetupClass.getMethod("initialize", String[].class).invoke(this.quickSetup, new Object[]{args});
        }
        catch (Exception e) {
            InternalError error = new InternalError("Failed to invoke initialize method");
            error.initCause(e);
            throw error;
        }
    }

    protected void displayApplication() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    try {
                        SplashScreen.this.quickSetupClass.getMethod("display", new Class[0]).invoke(SplashScreen.this.quickSetup, new Object[0]);
                    }
                    catch (Exception e) {
                        InternalError error = new InternalError("Failed to invoke display method");
                        error.initCause(e);
                        throw error;
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void disposeSplashScreen() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    SplashScreen.this.setVisible(false);
                    SplashScreen.this.dispose();
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void sleepIfNecessary(long splashDisplayStartTime) {
        long t2 = System.currentTimeMillis();
        long sleepTime = 3000L - (t2 - splashDisplayStartTime);
        if (sleepTime > 0L) {
            try {
                Thread.sleep(sleepTime);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

