/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.opends.messages.Message;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.ButtonName;
import org.opends.quicksetup.ProgressDescriptor;
import org.opends.quicksetup.ProgressStep;
import org.opends.quicksetup.event.ButtonEvent;
import org.opends.quicksetup.ui.CustomHTMLEditorKit;
import org.opends.quicksetup.ui.GuiApplication;
import org.opends.quicksetup.ui.QuickSetup;
import org.opends.quicksetup.ui.QuickSetupStepPanel;
import org.opends.quicksetup.ui.UIFactory;

public class ProgressPanel
extends QuickSetupStepPanel {
    private static final long serialVersionUID = 8129425068163357170L;
    private JEditorPane progressBarLabel;
    private JProgressBar progressBar;
    private JButton btnCancel;
    private JEditorPane detailsTextArea;
    private Message lastText;
    private Component lastFocusComponent;

    public ProgressPanel(GuiApplication application) {
        super(application);
    }

    @Override
    protected Component createInputPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = UIFactory.getEmptyInsets();
        gbc.anchor = 18;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.progressBarLabel = UIFactory.makeHtmlPane(null, UIFactory.PROGRESS_FONT);
        this.progressBarLabel.setOpaque(false);
        this.progressBarLabel.setEditable(false);
        this.progressBarLabel.setFocusable(false);
        this.progressBarLabel.setFocusCycleRoot(false);
        CustomHTMLEditorKit htmlEditor = new CustomHTMLEditorKit();
        htmlEditor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ButtonEvent be = new ButtonEvent(ev.getSource(), ButtonName.LAUNCH_STATUS_PANEL);
                ProgressPanel.this.notifyButtonListeners(be);
            }
        });
        this.progressBarLabel.setEditorKit(htmlEditor);
        String summaryText = UIFactory.applyFontToHtml(String.valueOf(QuickSetupMessages.INFO_PROGRESSBAR_INITIAL_LABEL.get()), UIFactory.PROGRESS_FONT);
        this.progressBarLabel.setText(summaryText);
        this.progressBarLabel.addHyperlinkListener(this);
        panel.add((Component)this.progressBarLabel, gbc);
        gbc.insets.top = 5;
        gbc.insets.bottom = 10;
        panel.add((Component)this.createProgressBarPanel(), gbc);
        this.progressBar.setToolTipText(QuickSetupMessages.INFO_PROGRESSBAR_TOOLTIP.get().toString());
        JLabel l = UIFactory.makeJLabel(UIFactory.IconType.NO_ICON, QuickSetupMessages.INFO_PROGRESS_DETAILS_LABEL.get(), UIFactory.TextStyle.SECONDARY_FIELD_VALID);
        gbc.insets = UIFactory.getEmptyInsets();
        panel.add((Component)l, gbc);
        JScrollPane scroll = new JScrollPane();
        this.detailsTextArea = UIFactory.makeProgressPane(scroll);
        this.detailsTextArea.setBackground(UIFactory.CURRENT_STEP_PANEL_BACKGROUND);
        this.detailsTextArea.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    String url = e.getURL().toString();
                    ProgressPanel.this.lastText = ProgressPanel.this.getFormatter().getFormattedAfterUrlClick(url, ProgressPanel.this.lastText);
                    ProgressPanel.this.detailsTextArea.setText(ProgressPanel.this.lastText.toString());
                }
            }
        });
        this.detailsTextArea.setAutoscrolls(true);
        scroll.setViewportView(this.detailsTextArea);
        scroll.setBorder(UIFactory.TEXT_AREA_BORDER);
        scroll.setWheelScrollingEnabled(true);
        l.setLabelFor(this.detailsTextArea);
        gbc.insets.top = 4;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        panel.add((Component)scroll, gbc);
        this.addFocusListeners();
        return panel;
    }

    @Override
    protected Message getInstructions() {
        return null;
    }

    @Override
    protected Message getTitle() {
        return QuickSetupMessages.INFO_PROGRESS_PANEL_TITLE.get();
    }

    @Override
    protected boolean requiresScroll() {
        return false;
    }

    @Override
    public void endDisplay() {
        if (this.lastFocusComponent != null) {
            this.lastFocusComponent.requestFocusInWindow();
        }
    }

    @Override
    public void displayProgress(ProgressDescriptor descriptor) {
        ProgressStep status = descriptor.getProgressStep();
        String summaryText = UIFactory.applyFontToHtml(String.valueOf(descriptor.getProgressBarMsg()), UIFactory.PROGRESS_FONT);
        if (status.isLast()) {
            this.progressBar.setVisible(false);
            this.progressBarLabel.setFocusable(true);
            this.btnCancel.setVisible(false);
            if (!status.isError()) {
                summaryText = "<form>" + summaryText + "</form>";
            }
        }
        this.progressBarLabel.setText(summaryText);
        Integer v = descriptor.getProgressBarRatio();
        if (v != null && v > 0) {
            this.progressBar.setIndeterminate(false);
            this.progressBar.setValue(v);
        }
        this.lastText = descriptor.getDetailsMsg();
        this.detailsTextArea.setText(this.lastText.toString());
    }

    private JPanel createProgressBarPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = UIFactory.getEmptyInsets();
        gbc.fill = 2;
        this.btnCancel = UIFactory.makeJButton(QuickSetupMessages.INFO_CANCEL_BUTTON_LABEL.get(), QuickSetupMessages.INFO_CANCEL_BUTTON_TOOLTIP.get());
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QuickSetup qs;
                GuiApplication app = ProgressPanel.this.getApplication();
                if (app.confirmCancel(qs = ProgressPanel.this.getQuickSetup())) {
                    app.cancel();
                    ProgressPanel.this.btnCancel.setEnabled(false);
                }
            }
        });
        this.progressBar = new JProgressBar();
        this.progressBar.setIndeterminate(true);
        this.progressBar.setMaximum(100);
        gbc.gridwidth = -1;
        gbc.weightx = 0.0;
        panel.add(Box.createHorizontalStrut(220), gbc);
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        panel.add(Box.createHorizontalGlue(), gbc);
        gbc.gridwidth = -1;
        gbc.weightx = 0.0;
        panel.add((Component)this.progressBar, gbc);
        if (this.getApplication().isCancellable()) {
            gbc.insets.left = 15;
            gbc.fill = 0;
            gbc.anchor = 21;
            gbc.gridwidth = 1;
            panel.add((Component)this.btnCancel, gbc);
        }
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        panel.add(Box.createHorizontalGlue(), gbc);
        return panel;
    }

    private void addFocusListeners() {
        JComponent[] comps;
        FocusListener l = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                ProgressPanel.this.lastFocusComponent = e.getComponent();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        };
        for (JComponent comp : comps = new JComponent[]{this.progressBarLabel, this.progressBar, this.btnCancel, this.detailsTextArea}) {
            comp.addFocusListener(l);
        }
        this.lastFocusComponent = this.detailsTextArea;
    }
}

