/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.util;

import javax.swing.JFrame;
import org.opends.messages.Message;
import org.opends.quicksetup.ui.QuickSetupStepPanel;
import org.opends.quicksetup.ui.WebBrowserErrorDialog;
import org.opends.quicksetup.util.BackgroundTask;
import org.opends.quicksetup.util.WebBrowserException;
import org.opends.quicksetup.util.WebBrowserLauncher;

public class URLWorker
extends BackgroundTask<Object> {
    private QuickSetupStepPanel panel;
    private String url;

    public URLWorker(QuickSetupStepPanel panel, String url) {
        this.panel = panel;
        this.url = url;
    }

    @Override
    public Object processBackgroundTask() throws WebBrowserException {
        try {
            WebBrowserLauncher.openURL(this.url);
        }
        catch (Throwable t) {
            throw new WebBrowserException(this.url, Message.raw("Bug: throwable", new Object[0]), t);
        }
        return null;
    }

    @Override
    public void backgroundTaskCompleted(Object returnValue, Throwable throwable) {
        WebBrowserException ex = (WebBrowserException)throwable;
        if (ex != null) {
            WebBrowserErrorDialog dlg = new WebBrowserErrorDialog((JFrame)this.panel.getMainWindow(), ex);
            dlg.setModal(false);
            dlg.packAndShow();
        }
        this.panel.urlWorkerFinished(this);
    }

    public String getURL() {
        return this.url;
    }
}

