/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.webstart;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jnlp.DownloadService;
import javax.jnlp.DownloadServiceListener;
import javax.jnlp.ServiceManager;
import javax.jnlp.UnavailableServiceException;
import org.opends.messages.Message;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.ApplicationException;
import org.opends.quicksetup.ReturnCode;
import org.opends.quicksetup.util.Utils;

public class WebStartDownloader
implements DownloadServiceListener {
    private static final Logger LOG = Logger.getLogger(WebStartDownloader.class.getName());
    private ApplicationException ex;
    private boolean isFinished;
    private int downloadPercentage = 0;
    private int currentPercMin = 0;
    private int currentPercMax = 0;
    private int currentValidatingPercent = 0;
    private int currentUpgradingPercent = 0;
    private Status status = Status.DOWNLOADING;
    private Message summary = QuickSetupMessages.INFO_DOWNLOADING.get();

    public void start(final boolean forceDownload) {
        this.isFinished = false;
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    WebStartDownloader.this.startDownload(forceDownload);
                }
                catch (ApplicationException ex) {
                    WebStartDownloader.this.ex = ex;
                }
                catch (MalformedURLException mfe) {
                    WebStartDownloader.this.ex = new ApplicationException(ReturnCode.BUG, Utils.getThrowableMsg(QuickSetupMessages.INFO_BUG_MSG.get(), mfe), mfe);
                }
                catch (IOException ioe) {
                    StringBuilder buf = new StringBuilder();
                    String[] jars = WebStartDownloader.this.getJarUrls();
                    for (int i = 0; i < jars.length; ++i) {
                        if (i != 0) {
                            buf.append(",");
                        }
                        buf.append(jars[i]);
                    }
                    WebStartDownloader.this.ex = new ApplicationException(ReturnCode.DOWNLOAD_ERROR, Utils.getThrowableMsg(QuickSetupMessages.INFO_DOWNLOADING_ERROR.get(buf.toString()), ioe), ioe);
                }
                catch (Throwable t) {
                    WebStartDownloader.this.ex = new ApplicationException(ReturnCode.BUG, Utils.getThrowableMsg(QuickSetupMessages.INFO_BUG_MSG.get(), t), t);
                }
            }
        });
        t.start();
    }

    public Message getSummary() {
        return this.summary;
    }

    public void setSummary(Message summary) {
        this.summary = summary;
    }

    public boolean isFinished() {
        return this.isFinished;
    }

    public Status getStatus() {
        return this.status;
    }

    public int getDownloadPercentage() {
        return this.downloadPercentage;
    }

    public int getCurrentValidatingPercentage() {
        return this.currentValidatingPercent;
    }

    public int getCurrentUpgradingPercentage() {
        return this.currentUpgradingPercent;
    }

    private void startDownload(boolean forceDownload) throws IOException, ApplicationException {
        int i;
        DownloadService ds;
        try {
            ds = (DownloadService)ServiceManager.lookup((String)Utils.JNLP_SERVICE_NAME);
        }
        catch (UnavailableServiceException e) {
            LOG.log(Level.SEVERE, "Could not find service: " + Utils.JNLP_SERVICE_NAME, e);
            String setupFile = Utils.isWindows() ? "setup.bat" : "setup";
            throw new ApplicationException(ReturnCode.DOWNLOAD_ERROR, Utils.getThrowableMsg(QuickSetupMessages.INFO_DOWNLOADING_ERROR_NO_SERVICE_FOUND.get(Utils.JNLP_SERVICE_NAME, setupFile), e), e);
        }
        String[] urls = this.getJarUrls();
        String[] versions = this.getJarVersions();
        int[] percentageMax = new int[urls.length];
        int[] ratios = new int[urls.length];
        int totalRatios = 0;
        for (i = 0; i < percentageMax.length; ++i) {
            int ratio = urls[i].endsWith("OpenDS.jar") ? 23 : (urls[i].endsWith("je.jar") ? 11 : (urls[i].endsWith("zipped.jar") ? 110 : (urls[i].endsWith("aspectjrt.jar") ? 10 : 100 / urls.length)));
            ratios[i] = ratio;
            totalRatios += ratio;
        }
        for (i = 0; i < percentageMax.length; ++i) {
            int r = 0;
            for (int j = 0; j <= i; ++j) {
                r += ratios[j];
            }
            percentageMax[i] = 100 * r / totalRatios;
        }
        for (i = 0; i < urls.length && this.getException() == null; ++i) {
            this.currentPercMin = i == 0 ? 0 : percentageMax[i - 1];
            this.currentPercMax = percentageMax[i];
            String sUrl = urls[i];
            URL url = new URL(sUrl);
            String version = versions[i];
            boolean cached = ds.isResourceCached(url, version);
            if (cached && forceDownload) {
                try {
                    ds.removeResource(url, version);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                cached = false;
            }
            if (!cached) {
                ds.loadResource(url, version, (DownloadServiceListener)this);
            }
            this.downloadPercentage = this.currentPercMax;
        }
        this.isFinished = true;
    }

    public ApplicationException getException() {
        return this.ex;
    }

    public void downloadFailed(URL url, String version) {
        this.ex = new ApplicationException(ReturnCode.DOWNLOAD_ERROR, QuickSetupMessages.INFO_DOWNLOADING_ERROR.get(url.toString()), null);
    }

    public void progress(URL url, String version, long readSoFar, long total, int overallPercent) {
        if (overallPercent >= 0) {
            this.downloadPercentage = this.getPercentage(overallPercent);
        }
        this.status = Status.DOWNLOADING;
    }

    public void upgradingArchive(URL url, String version, int patchPercent, int overallPercent) {
        this.currentUpgradingPercent = overallPercent;
        this.status = Status.UPGRADING;
    }

    public void validating(URL url, String version, long entry, long total, int overallPercent) {
        this.currentValidatingPercent = total > 0L ? (int)(100L * entry / total) : 0;
        this.status = Status.VALIDATING;
    }

    private String[] getJarUrls() {
        String jars = System.getProperty("org.opends.quicksetup.lazyjarurls");
        return jars.split(" ");
    }

    private int getPercentage(int currentJarRatio) {
        return this.currentPercMin + currentJarRatio * (this.currentPercMax - this.currentPercMin) / 100;
    }

    private String[] getJarVersions() {
        return new String[this.getJarUrls().length];
    }

    public static enum Status {
        DOWNLOADING,
        VALIDATING,
        UPGRADING;

    }
}

