/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.adapter.server2x;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DereferenceAliasesPolicy;
import org.forgerock.opendj.ldap.ErrorResultException;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.LinkedAttribute;
import org.forgerock.opendj.ldap.RDN;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.GenericControl;
import org.forgerock.opendj.ldap.responses.Responses;
import org.forgerock.opendj.ldap.responses.Result;
import org.opends.server.core.BindOperation;
import org.opends.server.core.CompareOperation;
import org.opends.server.core.ExtendedOperation;
import org.opends.server.protocols.asn1.ASN1;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.asn1.ASN1Reader;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.protocols.ldap.LDAPAttribute;
import org.opends.server.protocols.ldap.LDAPControl;
import org.opends.server.protocols.ldap.LDAPFilter;
import org.opends.server.protocols.ldap.LDAPModification;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeBuilder;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteStringBuilder;
import org.opends.server.types.DereferencePolicy;
import org.opends.server.types.Entry;
import org.opends.server.types.LDAPException;
import org.opends.server.types.Modification;
import org.opends.server.types.ModificationType;
import org.opends.server.types.Operation;
import org.opends.server.types.RawAttribute;
import org.opends.server.types.RawFilter;
import org.opends.server.types.RawModification;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SearchResultReference;

public final class Converters {
    private Converters() {
        throw new AssertionError();
    }

    public static SearchResultEntry to(org.forgerock.opendj.ldap.responses.SearchResultEntry value) {
        if (value != null) {
            Entry entry = new Entry(Converters.to(value.getName()), null, null, null);
            SearchResultEntry searchResultEntry = new SearchResultEntry(entry, Converters.to(value.getControls()));
            ArrayList<AttributeValue> duplicateValues = new ArrayList<AttributeValue>();
            for (Attribute attribute : Converters.toAttributes(value.getAllAttributes())) {
                searchResultEntry.addAttribute(attribute, duplicateValues);
            }
            return searchResultEntry;
        }
        return null;
    }

    public static DereferencePolicy to(DereferenceAliasesPolicy dereferenceAliasesPolicy) {
        return DereferencePolicy.values()[dereferenceAliasesPolicy.intValue()];
    }

    public static org.opends.server.types.DN to(DN dn) {
        try {
            return org.opends.server.types.DN.decode(dn.toString());
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public static org.opends.server.types.RDN to(RDN rdn) {
        try {
            return org.opends.server.types.RDN.decode(rdn.toString());
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public static org.opends.server.types.ByteString to(ByteString value) {
        if (value != null) {
            return org.opends.server.types.ByteString.wrap(value.toByteArray());
        }
        return null;
    }

    public static org.opends.server.types.SearchScope to(SearchScope searchScope) {
        if (searchScope == null) {
            return null;
        }
        return org.opends.server.types.SearchScope.values()[searchScope.intValue()];
    }

    public static RawFilter to(Filter filter) {
        LDAPFilter ldapFilter = null;
        try {
            ldapFilter = LDAPFilter.decode(filter.toString());
        }
        catch (LDAPException e) {
            throw new IllegalStateException(e);
        }
        return ldapFilter;
    }

    public static SearchResultReference to(org.forgerock.opendj.ldap.responses.SearchResultReference searchResultReference) {
        return new SearchResultReference(searchResultReference.getURIs(), Converters.to(searchResultReference.getControls()));
    }

    public static org.opends.server.types.ByteString to(String value) {
        return org.opends.server.types.ByteString.valueOf(value);
    }

    public static LDAPControl to(Control control) {
        return new LDAPControl(control.getOID(), control.isCritical(), Converters.to(control.getValue()));
    }

    public static List<org.opends.server.types.Control> to(List<Control> listOfControl) {
        ArrayList<org.opends.server.types.Control> toListOfControl = new ArrayList<org.opends.server.types.Control>(listOfControl.size());
        for (Control c : listOfControl) {
            toListOfControl.add(Converters.to(c));
        }
        return toListOfControl;
    }

    public static RawAttribute to(org.forgerock.opendj.ldap.Attribute attribute) {
        ArrayList<org.opends.server.types.ByteString> listAttributeValues = new ArrayList<org.opends.server.types.ByteString>(attribute.size());
        for (ByteString b : attribute.toArray()) {
            listAttributeValues.add(Converters.to(b));
        }
        return new LDAPAttribute(attribute.getAttributeDescriptionAsString(), listAttributeValues);
    }

    public static List<RawAttribute> to(Iterable<org.forgerock.opendj.ldap.Attribute> listOfAttributes) {
        ArrayList<RawAttribute> toListOfAttributes = new ArrayList<RawAttribute>(((Collection)listOfAttributes).size());
        for (org.forgerock.opendj.ldap.Attribute a : listOfAttributes) {
            toListOfAttributes.add(Converters.to(a));
        }
        return toListOfAttributes;
    }

    public static RawModification to(org.forgerock.opendj.ldap.Modification modification) {
        return new LDAPModification(Converters.to(modification.getModificationType()), Converters.to(modification.getAttribute()));
    }

    public static List<RawModification> toRawModifications(List<org.forgerock.opendj.ldap.Modification> listOfModifications) {
        ArrayList<RawModification> toListOfModifications = new ArrayList<RawModification>(listOfModifications.size());
        for (org.forgerock.opendj.ldap.Modification m : listOfModifications) {
            toListOfModifications.add(Converters.to(m));
        }
        return toListOfModifications;
    }

    public static Attribute toAttribute(org.forgerock.opendj.ldap.Attribute attribute) {
        AttributeBuilder attrBuilder = new AttributeBuilder(attribute.getAttributeDescriptionAsString());
        for (ByteString b : attribute.toArray()) {
            attrBuilder.add(Converters.to(b));
        }
        return attrBuilder.toAttribute();
    }

    public static List<Attribute> toAttributes(Iterable<org.forgerock.opendj.ldap.Attribute> listOfAttributes) {
        ArrayList<Attribute> toListOfAttributes = new ArrayList<Attribute>(((Collection)listOfAttributes).size());
        for (org.forgerock.opendj.ldap.Attribute a : listOfAttributes) {
            toListOfAttributes.add(Converters.toAttribute(a));
        }
        return toListOfAttributes;
    }

    public static Modification toModification(org.forgerock.opendj.ldap.Modification modification) {
        return new Modification(Converters.to(modification.getModificationType()), Converters.toAttribute(modification.getAttribute()));
    }

    public static List<Modification> toModifications(List<org.forgerock.opendj.ldap.Modification> listOfModifications) {
        ArrayList<Modification> toListOfModifications = new ArrayList<Modification>(listOfModifications.size());
        for (org.forgerock.opendj.ldap.Modification m : listOfModifications) {
            toListOfModifications.add(Converters.toModification(m));
        }
        return toListOfModifications;
    }

    public static ModificationType to(org.forgerock.opendj.ldap.ModificationType modificationType) {
        return ModificationType.values()[modificationType.intValue()];
    }

    public static ByteString from(org.opends.server.types.ByteString value) {
        if (value != null) {
            return ByteString.wrap((byte[])value.toByteArray());
        }
        return null;
    }

    public static SearchScope from(org.opends.server.types.SearchScope searchScope) {
        if (searchScope == null) {
            return null;
        }
        return (SearchScope)SearchScope.values().get(searchScope.intValue());
    }

    public static Control from(LDAPControl ldapControl) {
        return GenericControl.newControl((String)ldapControl.getOID(), (boolean)ldapControl.isCritical(), (Object)Converters.from(ldapControl.getValue()));
    }

    public static Control from(org.opends.server.types.Control control) {
        String oid = null;
        boolean isCritical = false;
        ByteString value = null;
        ByteStringBuilder builder = new ByteStringBuilder();
        ASN1Writer writer = ASN1.getWriter(builder);
        try {
            control.write(writer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ByteString sdkByteString = Converters.from(builder.toByteString());
        org.forgerock.opendj.asn1.ASN1Reader sdkReaderASN1 = org.forgerock.opendj.asn1.ASN1.getReader((byte[])sdkByteString.toByteArray());
        try {
            sdkReaderASN1.readStartSequence();
            oid = sdkReaderASN1.readOctetStringAsString();
            if (sdkReaderASN1.hasNextElement() && sdkReaderASN1.peekType() == 1) {
                isCritical = sdkReaderASN1.readBoolean();
            }
            if (sdkReaderASN1.hasNextElement() && sdkReaderASN1.peekType() == 4) {
                value = sdkReaderASN1.readOctetString();
            }
            sdkReaderASN1.readEndSequence();
        }
        catch (DecodeException decodeException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return GenericControl.newControl((String)oid, (boolean)isCritical, value);
    }

    public static List<Control> from(List<org.opends.server.types.Control> listOfControl) {
        ArrayList<Control> fromListofControl = new ArrayList<Control>(listOfControl.size());
        for (org.opends.server.types.Control c : listOfControl) {
            fromListofControl.add(Converters.from(c));
        }
        return fromListofControl;
    }

    public static org.forgerock.opendj.ldap.responses.SearchResultReference from(SearchResultReference srvResultReference) {
        return Responses.newSearchResultReference((String)srvResultReference.getReferralURLString());
    }

    public static org.forgerock.opendj.ldap.Attribute from(Attribute attribute) {
        LinkedAttribute sdkAttribute = new LinkedAttribute(attribute.getNameWithOptions());
        for (AttributeValue value : attribute) {
            sdkAttribute.add(Converters.from(value.getValue()));
        }
        return sdkAttribute;
    }

    public static List<org.forgerock.opendj.ldap.Attribute> from(Iterable<Attribute> listOfAttributes) {
        ArrayList<org.forgerock.opendj.ldap.Attribute> fromListofAttributes = new ArrayList<org.forgerock.opendj.ldap.Attribute>(((Collection)listOfAttributes).size());
        for (Attribute a : listOfAttributes) {
            fromListofAttributes.add(Converters.from(a));
        }
        return fromListofAttributes;
    }

    public static org.forgerock.opendj.ldap.responses.SearchResultEntry from(SearchResultEntry srvResultEntry) {
        org.forgerock.opendj.ldap.responses.SearchResultEntry searchResultEntry = Responses.newSearchResultEntry((String)srvResultEntry.getDN().toString());
        if (srvResultEntry.getAttributes() != null) {
            for (Attribute a : srvResultEntry.getAttributes()) {
                searchResultEntry.addAttribute(Converters.from(a));
            }
        }
        if (srvResultEntry.getControls() != null) {
            for (org.opends.server.types.Control c : srvResultEntry.getControls()) {
                searchResultEntry.addControl(Converters.from(c));
            }
        }
        return searchResultEntry;
    }

    public static <T extends Result> T getResponseResult(Operation operation, T result) throws ErrorResultException {
        if (operation.getReferralURLs() != null) {
            for (String ref : operation.getReferralURLs()) {
                result.addReferralURI(ref);
            }
        }
        if (operation.getResponseControls() != null) {
            for (org.opends.server.types.Control c : operation.getResponseControls()) {
                result.addControl(Converters.from(c));
            }
        }
        result.setDiagnosticMessage(operation.getErrorMessage() != null ? operation.getErrorMessage().toString() : null);
        result.setMatchedDN(operation.getMatchedDN() != null ? operation.getMatchedDN().toString() : null);
        if (result.isSuccess()) {
            return result;
        }
        throw ErrorResultException.newErrorResult(result);
    }

    public static Result getResponseResult(Operation operation) throws ErrorResultException {
        return Converters.getResponseResult(operation, Converters.newSDKResult(operation));
    }

    private static Result newSDKResult(Operation operation) {
        ResultCode rc = Converters.getResultCode(operation);
        if (operation instanceof BindOperation) {
            return Responses.newBindResult((ResultCode)rc);
        }
        if (operation instanceof CompareOperation) {
            return Responses.newCompareResult((ResultCode)rc);
        }
        if (operation instanceof ExtendedOperation) {
            return Responses.newGenericExtendedResult((ResultCode)rc);
        }
        return Responses.newResult((ResultCode)rc);
    }

    public static ResultCode getResultCode(Operation operation) {
        return ResultCode.valueOf((int)operation.getResultCode().getIntValue());
    }

    public static org.opends.server.types.ByteString getCredentials(byte[] authenticationValue) {
        ASN1Reader reader = ASN1.getReader(authenticationValue);
        org.opends.server.types.ByteString saslCred = org.opends.server.types.ByteString.empty();
        try {
            reader.readOctetStringAsString();
            if (reader.hasNextElement()) {
                saslCred = reader.readOctetString();
            }
        }
        catch (ASN1Exception aSN1Exception) {
            // empty catch block
        }
        return saslCred.toByteString();
    }
}

