/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin;

import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import org.opends.messages.Message;
import org.opends.server.admin.AbstractManagedObjectDefinition;
import org.opends.server.admin.Constraint;
import org.opends.server.admin.ManagedObjectDefinitionI18NResource;
import org.opends.server.admin.client.AuthorizationException;
import org.opends.server.admin.client.ClientConstraintHandler;
import org.opends.server.admin.client.CommunicationException;
import org.opends.server.admin.client.ManagedObject;
import org.opends.server.admin.client.ManagementContext;
import org.opends.server.admin.condition.Condition;
import org.opends.server.admin.server.ServerConstraintHandler;
import org.opends.server.admin.server.ServerManagedObject;
import org.opends.server.config.ConfigException;

public class GenericConstraint
extends Constraint {
    private final ClientConstraintHandler clientHandler = new ClientHandler();
    private final Condition condition;
    private final AbstractManagedObjectDefinition<?, ?> definition;
    private final int id;
    private final ServerConstraintHandler serverHandler = new ServerHandler();

    public GenericConstraint(AbstractManagedObjectDefinition<?, ?> definition, int id, Condition condition) {
        this.definition = definition;
        this.id = id;
        this.condition = condition;
    }

    @Override
    public Collection<ClientConstraintHandler> getClientConstraintHandlers() {
        return Collections.singleton(this.clientHandler);
    }

    @Override
    public Collection<ServerConstraintHandler> getServerConstraintHandlers() {
        return Collections.singleton(this.serverHandler);
    }

    public final Message getSynopsis() {
        return this.getSynopsis(Locale.getDefault());
    }

    public final Message getSynopsis(Locale locale) {
        ManagedObjectDefinitionI18NResource resource = ManagedObjectDefinitionI18NResource.getInstance();
        String property = "constraint." + this.id + ".synopsis";
        return resource.getMessage(this.definition, property, locale);
    }

    @Override
    protected void initialize() throws Exception {
        this.condition.initialize(this.definition);
    }

    private class ServerHandler
    extends ServerConstraintHandler {
        private ServerHandler() {
        }

        @Override
        public boolean isUsable(ServerManagedObject<?> managedObject, Collection<Message> unacceptableReasons) throws ConfigException {
            if (!GenericConstraint.this.condition.evaluate(managedObject)) {
                unacceptableReasons.add(GenericConstraint.this.getSynopsis());
                return false;
            }
            return true;
        }
    }

    private class ClientHandler
    extends ClientConstraintHandler {
        private ClientHandler() {
        }

        @Override
        public boolean isAddAcceptable(ManagementContext context, ManagedObject<?> managedObject, Collection<Message> unacceptableReasons) throws AuthorizationException, CommunicationException {
            if (!GenericConstraint.this.condition.evaluate(context, managedObject)) {
                unacceptableReasons.add(GenericConstraint.this.getSynopsis());
                return false;
            }
            return true;
        }

        @Override
        public boolean isModifyAcceptable(ManagementContext context, ManagedObject<?> managedObject, Collection<Message> unacceptableReasons) throws AuthorizationException, CommunicationException {
            if (!GenericConstraint.this.condition.evaluate(context, managedObject)) {
                unacceptableReasons.add(GenericConstraint.this.getSynopsis());
                return false;
            }
            return true;
        }
    }
}

