/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin;

import java.text.NumberFormat;
import java.util.EnumSet;
import java.util.TreeSet;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.server.admin.ACIPropertyDefinition;
import org.opends.server.admin.AggregationPropertyDefinition;
import org.opends.server.admin.AttributeTypePropertyDefinition;
import org.opends.server.admin.BooleanPropertyDefinition;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.Configuration;
import org.opends.server.admin.ConfigurationClient;
import org.opends.server.admin.DNPropertyDefinition;
import org.opends.server.admin.DurationPropertyDefinition;
import org.opends.server.admin.DurationUnit;
import org.opends.server.admin.EnumPropertyDefinition;
import org.opends.server.admin.IPAddressMaskPropertyDefinition;
import org.opends.server.admin.IPAddressPropertyDefinition;
import org.opends.server.admin.IntegerPropertyDefinition;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.PropertyDefinitionVisitor;
import org.opends.server.admin.SizePropertyDefinition;
import org.opends.server.admin.SizeUnit;
import org.opends.server.admin.StringPropertyDefinition;
import org.opends.server.admin.UnknownPropertyDefinitionException;

public final class PropertyDefinitionUsageBuilder {
    private final MyPropertyDefinitionVisitor pimpl;

    public PropertyDefinitionUsageBuilder(boolean isDetailed) {
        this.pimpl = new MyPropertyDefinitionVisitor(isDetailed);
    }

    public Message getUsage(PropertyDefinition<?> pd) {
        return pd.accept(this.pimpl, null);
    }

    private class MyPropertyDefinitionVisitor
    extends PropertyDefinitionVisitor<Message, Void> {
        private final boolean isDetailed;
        private final NumberFormat numberFormat;

        private MyPropertyDefinitionVisitor(boolean isDetailed) {
            this.isDetailed = isDetailed;
            this.numberFormat = NumberFormat.getNumberInstance();
            this.numberFormat.setGroupingUsed(true);
            this.numberFormat.setMaximumFractionDigits(2);
        }

        @Override
        public <C extends ConfigurationClient, S extends Configuration> Message visitAggregation(AggregationPropertyDefinition<C, S> d, Void p) {
            return Message.raw("NAME", new Object[0]);
        }

        @Override
        public Message visitAttributeType(AttributeTypePropertyDefinition d, Void p) {
            return Message.raw("OID", new Object[0]);
        }

        @Override
        public Message visitACI(ACIPropertyDefinition d, Void p) {
            return Message.raw("ACI", new Object[0]);
        }

        @Override
        public Message visitBoolean(BooleanPropertyDefinition d, Void p) {
            if (this.isDetailed) {
                return Message.raw("false | true", new Object[0]);
            }
            return Message.raw("BOOLEAN", new Object[0]);
        }

        @Override
        public Message visitClass(ClassPropertyDefinition d, Void p) {
            if (this.isDetailed && !d.getInstanceOfInterface().isEmpty()) {
                return Message.raw("CLASS <= " + d.getInstanceOfInterface().get(0), new Object[0]);
            }
            return Message.raw("CLASS", new Object[0]);
        }

        @Override
        public Message visitDN(DNPropertyDefinition d, Void p) {
            if (this.isDetailed && d.getBaseDN() != null) {
                return Message.raw("DN <= " + d.getBaseDN(), new Object[0]);
            }
            return Message.raw("DN", new Object[0]);
        }

        @Override
        public Message visitDuration(DurationPropertyDefinition d, Void p) {
            MessageBuilder builder = new MessageBuilder();
            DurationUnit unit = d.getBaseUnit();
            if (this.isDetailed && d.getLowerLimit() > 0L) {
                builder.append(DurationUnit.toString(d.getLowerLimit()));
                builder.append(" <= ");
            }
            builder.append("DURATION (");
            builder.append(unit.getShortName());
            builder.append(")");
            if (this.isDetailed) {
                if (d.getUpperLimit() != null) {
                    builder.append(" <= ");
                    builder.append(DurationUnit.toString(d.getUpperLimit()));
                }
                if (d.isAllowUnlimited()) {
                    builder.append(" | unlimited");
                }
            }
            return builder.toMessage();
        }

        @Override
        public <E extends Enum<E>> Message visitEnum(EnumPropertyDefinition<E> d, Void p) {
            if (!this.isDetailed) {
                String name = d.getName();
                int i = name.lastIndexOf(45);
                if (i == -1 || i == name.length() - 1) {
                    return Message.raw(name.toUpperCase(), new Object[0]);
                }
                return Message.raw(name.substring(i + 1).toUpperCase(), new Object[0]);
            }
            TreeSet<String> values = new TreeSet<String>();
            for (Object value : EnumSet.allOf(d.getEnumClass())) {
                values.add(value.toString().trim().toLowerCase());
            }
            boolean isFirst = true;
            MessageBuilder builder = new MessageBuilder();
            for (String s : values) {
                if (!isFirst) {
                    builder.append(" | ");
                }
                builder.append(s);
                isFirst = false;
            }
            return builder.toMessage();
        }

        @Override
        public Message visitInteger(IntegerPropertyDefinition d, Void p) {
            MessageBuilder builder = new MessageBuilder();
            if (this.isDetailed) {
                builder.append(String.valueOf(d.getLowerLimit()));
                builder.append(" <= ");
            }
            builder.append("INTEGER");
            if (this.isDetailed) {
                if (d.getUpperLimit() != null) {
                    builder.append(" <= ");
                    builder.append(String.valueOf(d.getUpperLimit()));
                } else if (d.isAllowUnlimited()) {
                    builder.append(" | unlimited");
                }
            }
            return builder.toMessage();
        }

        @Override
        public Message visitIPAddress(IPAddressPropertyDefinition d, Void p) {
            return Message.raw("HOST_NAME", new Object[0]);
        }

        @Override
        public Message visitIPAddressMask(IPAddressMaskPropertyDefinition d, Void p) {
            return Message.raw("IP_ADDRESS_MASK", new Object[0]);
        }

        @Override
        public Message visitSize(SizePropertyDefinition d, Void p) {
            MessageBuilder builder = new MessageBuilder();
            if (this.isDetailed && d.getLowerLimit() > 0L) {
                SizeUnit unit = SizeUnit.getBestFitUnitExact(d.getLowerLimit());
                builder.append(this.numberFormat.format(unit.fromBytes(d.getLowerLimit())));
                builder.append(' ');
                builder.append(unit.getShortName());
                builder.append(" <= ");
            }
            builder.append("SIZE");
            if (this.isDetailed) {
                if (d.getUpperLimit() != null) {
                    long upperLimit = d.getUpperLimit();
                    SizeUnit unit = SizeUnit.getBestFitUnitExact(upperLimit);
                    if (unit == SizeUnit.BYTES && upperLimit < Long.MAX_VALUE) {
                        unit = SizeUnit.getBestFitUnitExact(upperLimit + 1L);
                        if (unit != SizeUnit.BYTES) {
                            ++upperLimit;
                            builder.append(" < ");
                        } else {
                            builder.append(" <= ");
                        }
                    } else {
                        builder.append(" <= ");
                    }
                    builder.append(this.numberFormat.format(unit.fromBytes(upperLimit)));
                    builder.append(' ');
                    builder.append(unit.getShortName());
                }
                if (d.isAllowUnlimited()) {
                    builder.append(" | unlimited");
                }
            }
            return builder.toMessage();
        }

        @Override
        public Message visitString(StringPropertyDefinition d, Void p) {
            if (d.getPattern() != null) {
                if (this.isDetailed) {
                    MessageBuilder builder = new MessageBuilder();
                    builder.append(d.getPatternUsage());
                    builder.append(" - ");
                    builder.append(d.getPatternSynopsis());
                    return builder.toMessage();
                }
                return Message.raw(d.getPatternUsage(), new Object[0]);
            }
            return Message.raw("STRING", new Object[0]);
        }

        @Override
        public <T> Message visitUnknown(PropertyDefinition<T> d, Void p) throws UnknownPropertyDefinitionException {
            return Message.raw("?", new Object[0]);
        }
    }
}

