/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.client.cli;

import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import org.opends.messages.ToolMessages;
import org.opends.server.backends.task.FailedDependencyAction;
import org.opends.server.backends.task.RecurringTask;
import org.opends.server.tools.ToolConstants;
import org.opends.server.types.DirectoryException;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.Argument;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.StringArgument;
import org.opends.server.util.cli.CLIException;

public class TaskScheduleArgs {
    public static final String NOW = "0";
    public StringArgument startArg;
    public StringArgument recurringArg;
    public StringArgument completionNotificationArg;
    public StringArgument errorNotificationArg;
    public StringArgument dependencyArg;
    public StringArgument failedDependencyActionArg;

    public TaskScheduleArgs() {
        try {
            this.createTaskArguments();
        }
        catch (ArgumentException ae) {
            throw new RuntimeException("Unexpected error: " + ae, ae);
        }
    }

    private void createTaskArguments() throws ArgumentException {
        this.startArg = new StringArgument("start", ToolConstants.OPTION_SHORT_START_DATETIME, "start", false, false, true, ToolMessages.INFO_START_DATETIME_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_START_DATETIME.get());
        this.recurringArg = new StringArgument("recurringTask", ToolConstants.OPTION_SHORT_RECURRING_TASK, "recurringTask", false, false, true, ToolMessages.INFO_RECURRING_TASK_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_RECURRING_TASK.get());
        this.completionNotificationArg = new StringArgument("completionNotify", ToolConstants.OPTION_SHORT_COMPLETION_NOTIFICATION_EMAIL, "completionNotify", false, true, true, ToolMessages.INFO_EMAIL_ADDRESS_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_TASK_COMPLETION_NOTIFICATION.get());
        this.errorNotificationArg = new StringArgument("errorNotify", ToolConstants.OPTION_SHORT_ERROR_NOTIFICATION_EMAIL, "errorNotify", false, true, true, ToolMessages.INFO_EMAIL_ADDRESS_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_TASK_ERROR_NOTIFICATION.get());
        this.dependencyArg = new StringArgument("dependency", ToolConstants.OPTION_SHORT_DEPENDENCY, "dependency", false, true, true, ToolMessages.INFO_TASK_ID_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_TASK_DEPENDENCY_ID.get());
        EnumSet<FailedDependencyAction> fdaValSet = EnumSet.allOf(FailedDependencyAction.class);
        this.failedDependencyActionArg = new StringArgument("failedDependencyAction", ToolConstants.OPTION_SHORT_FAILED_DEPENDENCY_ACTION, "failedDependencyAction", false, true, true, ToolMessages.INFO_ACTION_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_TASK_FAILED_DEPENDENCY_ACTION.get(StaticUtils.collectionToString(fdaValSet, ","), FailedDependencyAction.defaultValue().name()));
        for (Argument arg : this.getArguments()) {
            arg.setPropertyName(arg.getLongIdentifier());
        }
    }

    public Argument[] getArguments() {
        return new Argument[]{this.startArg, this.recurringArg, this.completionNotificationArg, this.errorNotificationArg, this.dependencyArg, this.failedDependencyActionArg};
    }

    public void validateArgs() throws ArgumentException, CLIException {
        LinkedList<String> addrs;
        if (this.startArg.isPresent() && !NOW.equals(this.startArg.getValue())) {
            try {
                Date date = StaticUtils.parseDateTimeString(this.startArg.getValue());
                Date currentDate = new Date(System.currentTimeMillis());
                if (currentDate.after(date)) {
                    throw new CLIException(ToolMessages.ERR_START_DATETIME_ALREADY_PASSED.get(this.startArg.getValue()));
                }
            }
            catch (ParseException pe) {
                throw new ArgumentException(ToolMessages.ERR_START_DATETIME_FORMAT.get());
            }
        }
        if (this.recurringArg.isPresent()) {
            try {
                RecurringTask.parseTaskTab(this.recurringArg.getValue());
            }
            catch (DirectoryException de) {
                throw new ArgumentException(ToolMessages.ERR_RECURRING_SCHEDULE_FORMAT_ERROR.get(de.getMessageObject()), (Throwable)de);
            }
        }
        if (this.completionNotificationArg.isPresent()) {
            addrs = this.completionNotificationArg.getValues();
            for (String addr : addrs) {
                if (StaticUtils.isEmailAddress(addr)) continue;
                throw new ArgumentException(ToolMessages.ERR_TASKTOOL_INVALID_EMAIL_ADDRESS.get(addr, this.completionNotificationArg.getLongIdentifier()));
            }
        }
        if (this.errorNotificationArg.isPresent()) {
            addrs = this.errorNotificationArg.getValues();
            for (String addr : addrs) {
                if (StaticUtils.isEmailAddress(addr)) continue;
                throw new ArgumentException(ToolMessages.ERR_TASKTOOL_INVALID_EMAIL_ADDRESS.get(addr, this.errorNotificationArg.getLongIdentifier()));
            }
        }
        if (this.failedDependencyActionArg.isPresent()) {
            if (!this.dependencyArg.isPresent()) {
                throw new ArgumentException(ToolMessages.ERR_TASKTOOL_FDA_WITH_NO_DEPENDENCY.get());
            }
            String fda = this.failedDependencyActionArg.getValue();
            if (null == FailedDependencyAction.fromString(fda)) {
                EnumSet<FailedDependencyAction> fdaValSet = EnumSet.allOf(FailedDependencyAction.class);
                throw new ArgumentException(ToolMessages.ERR_TASKTOOL_INVALID_FDA.get(fda, StaticUtils.collectionToString(fdaValSet, ",")));
            }
        }
    }

    public void validateArgsIfOffline() throws ArgumentException, CLIException {
        Argument[] incompatibleArgs;
        for (Argument arg : incompatibleArgs = new Argument[]{this.startArg, this.recurringArg, this.completionNotificationArg, this.errorNotificationArg, this.dependencyArg, this.failedDependencyActionArg}) {
            if (!arg.isPresent()) continue;
            throw new ArgumentException(ToolMessages.ERR_TASKTOOL_OPTIONS_FOR_TASK_ONLY.get(arg.getLongIdentifier()));
        }
        this.validateArgs();
    }

    public Date getStartDateTime() {
        Date start = null;
        if (this.startArg != null && this.startArg.isPresent()) {
            if (NOW.equals(this.startArg.getValue())) {
                start = new Date();
            } else {
                try {
                    start = StaticUtils.parseDateTimeString(this.startArg.getValue());
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
        return start;
    }

    public boolean isStartNow() {
        boolean isStartNow = true;
        if (this.startArg != null && this.startArg.isPresent()) {
            isStartNow = NOW.equals(this.startArg.getValue());
        }
        return isStartNow;
    }

    public String getRecurringDateTime() {
        String pattern = null;
        if (this.recurringArg != null && this.recurringArg.isPresent()) {
            pattern = this.recurringArg.getValue();
        }
        return pattern;
    }

    public List<String> getDependencyIds() {
        if (this.dependencyArg.isPresent()) {
            return this.dependencyArg.getValues();
        }
        return Collections.emptyList();
    }

    public FailedDependencyAction getFailedDependencyAction() {
        FailedDependencyAction fda = null;
        if (this.failedDependencyActionArg.isPresent()) {
            String fdaString = this.failedDependencyActionArg.getValue();
            fda = FailedDependencyAction.fromString(fdaString);
        }
        return fda;
    }

    public List<String> getNotifyUponCompletionEmailAddresses() {
        if (this.completionNotificationArg.isPresent()) {
            return this.completionNotificationArg.getValues();
        }
        return Collections.emptyList();
    }

    public List<String> getNotifyUponErrorEmailAddresses() {
        if (this.errorNotificationArg.isPresent()) {
            return this.errorNotificationArg.getValues();
        }
        return Collections.emptyList();
    }
}

