/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.server;

import org.opends.server.admin.LDAPProfile;
import org.opends.server.admin.ManagedObjectPath;
import org.opends.server.admin.RelationDefinition;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;

final class DNBuilder {
    public static DN create(ManagedObjectPath<?, ?> path) {
        return path.toDN();
    }

    public static DN create(ManagedObjectPath<?, ?> path, RelationDefinition<?, ?> relation) {
        DN dn = path.toDN();
        try {
            LDAPProfile profile = LDAPProfile.getInstance();
            DN localName = DN.decode(profile.getRelationRDNSequence(relation));
            return dn.concat(localName);
        }
        catch (DirectoryException e) {
            throw new RuntimeException(e);
        }
    }

    private DNBuilder() {
    }
}

