/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.std.meta;

import java.util.Collection;
import java.util.SortedSet;
import org.opends.server.admin.AdministratorAction;
import org.opends.server.admin.BooleanPropertyDefinition;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.DNPropertyDefinition;
import org.opends.server.admin.DefinedDefaultBehaviorProvider;
import org.opends.server.admin.EnumPropertyDefinition;
import org.opends.server.admin.ManagedObjectAlreadyExistsException;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.PropertyIsReadOnlyException;
import org.opends.server.admin.PropertyOption;
import org.opends.server.admin.PropertyProvider;
import org.opends.server.admin.StringPropertyDefinition;
import org.opends.server.admin.Tag;
import org.opends.server.admin.UndefinedDefaultBehaviorProvider;
import org.opends.server.admin.client.AuthorizationException;
import org.opends.server.admin.client.CommunicationException;
import org.opends.server.admin.client.ConcurrentModificationException;
import org.opends.server.admin.client.ManagedObject;
import org.opends.server.admin.client.MissingMandatoryPropertiesException;
import org.opends.server.admin.client.OperationRejectedException;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ServerManagedObject;
import org.opends.server.admin.std.client.LDIFBackendCfgClient;
import org.opends.server.admin.std.meta.BackendCfgDefn;
import org.opends.server.admin.std.server.BackendCfg;
import org.opends.server.admin.std.server.LDIFBackendCfg;
import org.opends.server.types.DN;

public final class LDIFBackendCfgDefn
extends ManagedObjectDefinition<LDIFBackendCfgClient, LDIFBackendCfg> {
    private static final LDIFBackendCfgDefn INSTANCE = new LDIFBackendCfgDefn();
    private static final BooleanPropertyDefinition PD_IS_PRIVATE_BACKEND;
    private static final ClassPropertyDefinition PD_JAVA_CLASS;
    private static final StringPropertyDefinition PD_LDIF_FILE;
    private static final EnumPropertyDefinition<BackendCfgDefn.WritabilityMode> PD_WRITABILITY_MODE;

    public static LDIFBackendCfgDefn getInstance() {
        return INSTANCE;
    }

    private LDIFBackendCfgDefn() {
        super("ldif-backend", BackendCfgDefn.getInstance());
    }

    @Override
    public LDIFBackendCfgClient createClientConfiguration(ManagedObject<? extends LDIFBackendCfgClient> impl) {
        return new LDIFBackendCfgClientImpl(impl);
    }

    @Override
    public LDIFBackendCfg createServerConfiguration(ServerManagedObject<? extends LDIFBackendCfg> impl) {
        return new LDIFBackendCfgServerImpl(impl);
    }

    @Override
    public Class<LDIFBackendCfg> getServerConfigurationClass() {
        return LDIFBackendCfg.class;
    }

    public StringPropertyDefinition getBackendIdPropertyDefinition() {
        return BackendCfgDefn.getInstance().getBackendIdPropertyDefinition();
    }

    public DNPropertyDefinition getBaseDNPropertyDefinition() {
        return BackendCfgDefn.getInstance().getBaseDNPropertyDefinition();
    }

    public BooleanPropertyDefinition getEnabledPropertyDefinition() {
        return BackendCfgDefn.getInstance().getEnabledPropertyDefinition();
    }

    public BooleanPropertyDefinition getIsPrivateBackendPropertyDefinition() {
        return PD_IS_PRIVATE_BACKEND;
    }

    public ClassPropertyDefinition getJavaClassPropertyDefinition() {
        return PD_JAVA_CLASS;
    }

    public StringPropertyDefinition getLDIFFilePropertyDefinition() {
        return PD_LDIF_FILE;
    }

    public EnumPropertyDefinition<BackendCfgDefn.WritabilityMode> getWritabilityModePropertyDefinition() {
        return PD_WRITABILITY_MODE;
    }

    static {
        PropertyDefinition.AbstractBuilder builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "is-private-backend");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "is-private-backend"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("false");
        builder.setDefaultBehaviorProvider(provider);
        PD_IS_PRIVATE_BACKEND = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_IS_PRIVATE_BACKEND);
        builder = ClassPropertyDefinition.createBuilder(INSTANCE, "java-class");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "java-class"));
        provider = new DefinedDefaultBehaviorProvider("org.opends.server.backends.LDIFBackend");
        builder.setDefaultBehaviorProvider(provider);
        ((ClassPropertyDefinition.Builder)builder).addInstanceOf("org.opends.server.api.Backend");
        PD_JAVA_CLASS = (ClassPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_JAVA_CLASS);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "ldif-file");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "ldif-file"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_LDIF_FILE = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_LDIF_FILE);
        builder = EnumPropertyDefinition.createBuilder(INSTANCE, "writability-mode");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "writability-mode"));
        provider = new DefinedDefaultBehaviorProvider("enabled");
        builder.setDefaultBehaviorProvider(provider);
        ((EnumPropertyDefinition.Builder)builder).setEnumClass(BackendCfgDefn.WritabilityMode.class);
        PD_WRITABILITY_MODE = (EnumPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_WRITABILITY_MODE);
        INSTANCE.registerTag(Tag.valueOf("database"));
    }

    private static class LDIFBackendCfgServerImpl
    implements LDIFBackendCfg {
        private ServerManagedObject<? extends LDIFBackendCfg> impl;
        private final String pBackendId;
        private final SortedSet<DN> pBaseDN;
        private final boolean pEnabled;
        private final boolean pIsPrivateBackend;
        private final String pJavaClass;
        private final String pLDIFFile;
        private final BackendCfgDefn.WritabilityMode pWritabilityMode;

        private LDIFBackendCfgServerImpl(ServerManagedObject<? extends LDIFBackendCfg> impl) {
            this.impl = impl;
            this.pBackendId = impl.getPropertyValue(INSTANCE.getBackendIdPropertyDefinition());
            this.pBaseDN = impl.getPropertyValues((PropertyDefinition)INSTANCE.getBaseDNPropertyDefinition());
            this.pEnabled = impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
            this.pIsPrivateBackend = impl.getPropertyValue(INSTANCE.getIsPrivateBackendPropertyDefinition());
            this.pJavaClass = impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
            this.pLDIFFile = impl.getPropertyValue(INSTANCE.getLDIFFilePropertyDefinition());
            this.pWritabilityMode = impl.getPropertyValue(INSTANCE.getWritabilityModePropertyDefinition());
        }

        @Override
        public void addLDIFChangeListener(ConfigurationChangeListener<LDIFBackendCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeLDIFChangeListener(ConfigurationChangeListener<LDIFBackendCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<BackendCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<BackendCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public String getBackendId() {
            return this.pBackendId;
        }

        @Override
        public SortedSet<DN> getBaseDN() {
            return this.pBaseDN;
        }

        @Override
        public boolean isEnabled() {
            return this.pEnabled;
        }

        @Override
        public boolean isIsPrivateBackend() {
            return this.pIsPrivateBackend;
        }

        @Override
        public String getJavaClass() {
            return this.pJavaClass;
        }

        @Override
        public String getLDIFFile() {
            return this.pLDIFFile;
        }

        @Override
        public BackendCfgDefn.WritabilityMode getWritabilityMode() {
            return this.pWritabilityMode;
        }

        @Override
        public Class<? extends LDIFBackendCfg> configurationClass() {
            return LDIFBackendCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }
    }

    private static class LDIFBackendCfgClientImpl
    implements LDIFBackendCfgClient {
        private ManagedObject<? extends LDIFBackendCfgClient> impl;

        private LDIFBackendCfgClientImpl(ManagedObject<? extends LDIFBackendCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public String getBackendId() {
            return this.impl.getPropertyValue(INSTANCE.getBackendIdPropertyDefinition());
        }

        @Override
        public void setBackendId(String value) throws PropertyIsReadOnlyException {
            this.impl.setPropertyValue(INSTANCE.getBackendIdPropertyDefinition(), value);
        }

        @Override
        public SortedSet<DN> getBaseDN() {
            return this.impl.getPropertyValues(INSTANCE.getBaseDNPropertyDefinition());
        }

        @Override
        public void setBaseDN(Collection<DN> values) {
            this.impl.setPropertyValues(INSTANCE.getBaseDNPropertyDefinition(), values);
        }

        @Override
        public Boolean isEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
        }

        @Override
        public void setEnabled(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getEnabledPropertyDefinition(), value);
        }

        @Override
        public boolean isIsPrivateBackend() {
            return this.impl.getPropertyValue(INSTANCE.getIsPrivateBackendPropertyDefinition());
        }

        @Override
        public void setIsPrivateBackend(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getIsPrivateBackendPropertyDefinition(), value);
        }

        @Override
        public String getJavaClass() {
            return this.impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void setJavaClass(String value) {
            this.impl.setPropertyValue(INSTANCE.getJavaClassPropertyDefinition(), value);
        }

        @Override
        public String getLDIFFile() {
            return this.impl.getPropertyValue(INSTANCE.getLDIFFilePropertyDefinition());
        }

        @Override
        public void setLDIFFile(String value) {
            this.impl.setPropertyValue(INSTANCE.getLDIFFilePropertyDefinition(), value);
        }

        @Override
        public BackendCfgDefn.WritabilityMode getWritabilityMode() {
            return this.impl.getPropertyValue(INSTANCE.getWritabilityModePropertyDefinition());
        }

        @Override
        public void setWritabilityMode(BackendCfgDefn.WritabilityMode value) {
            this.impl.setPropertyValue(INSTANCE.getWritabilityModePropertyDefinition(), value);
        }

        @Override
        public ManagedObjectDefinition<? extends LDIFBackendCfgClient, ? extends LDIFBackendCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, AuthorizationException, CommunicationException {
            this.impl.commit();
        }
    }
}

