/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.std.meta;

import java.util.Collection;
import org.opends.server.admin.AdministratorAction;
import org.opends.server.admin.BooleanPropertyDefinition;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.DefaultBehaviorException;
import org.opends.server.admin.DefinedDefaultBehaviorProvider;
import org.opends.server.admin.DefinitionDecodingException;
import org.opends.server.admin.DurationPropertyDefinition;
import org.opends.server.admin.InstantiableRelationDefinition;
import org.opends.server.admin.IntegerPropertyDefinition;
import org.opends.server.admin.ManagedObjectAlreadyExistsException;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.ManagedObjectNotFoundException;
import org.opends.server.admin.OptionalRelationDefinition;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.PropertyOption;
import org.opends.server.admin.PropertyProvider;
import org.opends.server.admin.Tag;
import org.opends.server.admin.client.AuthorizationException;
import org.opends.server.admin.client.CommunicationException;
import org.opends.server.admin.client.ConcurrentModificationException;
import org.opends.server.admin.client.IllegalManagedObjectNameException;
import org.opends.server.admin.client.ManagedObject;
import org.opends.server.admin.client.ManagedObjectDecodingException;
import org.opends.server.admin.client.MissingMandatoryPropertiesException;
import org.opends.server.admin.client.OperationRejectedException;
import org.opends.server.admin.server.ConfigurationAddListener;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ConfigurationDeleteListener;
import org.opends.server.admin.server.ServerManagedObject;
import org.opends.server.admin.std.client.ReplicationDomainCfgClient;
import org.opends.server.admin.std.client.ReplicationServerCfgClient;
import org.opends.server.admin.std.client.ReplicationSynchronizationProviderCfgClient;
import org.opends.server.admin.std.meta.ReplicationDomainCfgDefn;
import org.opends.server.admin.std.meta.ReplicationServerCfgDefn;
import org.opends.server.admin.std.meta.SynchronizationProviderCfgDefn;
import org.opends.server.admin.std.server.ReplicationDomainCfg;
import org.opends.server.admin.std.server.ReplicationServerCfg;
import org.opends.server.admin.std.server.ReplicationSynchronizationProviderCfg;
import org.opends.server.admin.std.server.SynchronizationProviderCfg;
import org.opends.server.config.ConfigException;
import org.opends.server.types.DN;

public final class ReplicationSynchronizationProviderCfgDefn
extends ManagedObjectDefinition<ReplicationSynchronizationProviderCfgClient, ReplicationSynchronizationProviderCfg> {
    private static final ReplicationSynchronizationProviderCfgDefn INSTANCE = new ReplicationSynchronizationProviderCfgDefn();
    private static final DurationPropertyDefinition PD_CONNECTION_TIMEOUT;
    private static final ClassPropertyDefinition PD_JAVA_CLASS;
    private static final IntegerPropertyDefinition PD_NUM_UPDATE_REPLAY_THREADS;
    private static final InstantiableRelationDefinition<ReplicationDomainCfgClient, ReplicationDomainCfg> RD_REPLICATION_DOMAINS;
    private static final OptionalRelationDefinition<ReplicationServerCfgClient, ReplicationServerCfg> RD_REPLICATION_SERVER;

    public static ReplicationSynchronizationProviderCfgDefn getInstance() {
        return INSTANCE;
    }

    private ReplicationSynchronizationProviderCfgDefn() {
        super("replication-synchronization-provider", SynchronizationProviderCfgDefn.getInstance());
    }

    @Override
    public ReplicationSynchronizationProviderCfgClient createClientConfiguration(ManagedObject<? extends ReplicationSynchronizationProviderCfgClient> impl) {
        return new ReplicationSynchronizationProviderCfgClientImpl(impl);
    }

    @Override
    public ReplicationSynchronizationProviderCfg createServerConfiguration(ServerManagedObject<? extends ReplicationSynchronizationProviderCfg> impl) {
        return new ReplicationSynchronizationProviderCfgServerImpl(impl);
    }

    @Override
    public Class<ReplicationSynchronizationProviderCfg> getServerConfigurationClass() {
        return ReplicationSynchronizationProviderCfg.class;
    }

    public DurationPropertyDefinition getConnectionTimeoutPropertyDefinition() {
        return PD_CONNECTION_TIMEOUT;
    }

    public BooleanPropertyDefinition getEnabledPropertyDefinition() {
        return SynchronizationProviderCfgDefn.getInstance().getEnabledPropertyDefinition();
    }

    public ClassPropertyDefinition getJavaClassPropertyDefinition() {
        return PD_JAVA_CLASS;
    }

    public IntegerPropertyDefinition getNumUpdateReplayThreadsPropertyDefinition() {
        return PD_NUM_UPDATE_REPLAY_THREADS;
    }

    public InstantiableRelationDefinition<ReplicationDomainCfgClient, ReplicationDomainCfg> getReplicationDomainsRelationDefinition() {
        return RD_REPLICATION_DOMAINS;
    }

    public OptionalRelationDefinition<ReplicationServerCfgClient, ReplicationServerCfg> getReplicationServerRelationDefinition() {
        return RD_REPLICATION_SERVER;
    }

    static {
        OptionalRelationDefinition.Builder<ReplicationServerCfgClient, ReplicationServerCfg> builder = DurationPropertyDefinition.createBuilder(INSTANCE, "connection-timeout");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setOption(PropertyOption.ADVANCED);
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "connection-timeout"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("5 seconds");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(provider);
        ((DurationPropertyDefinition.Builder)((Object)builder)).setBaseUnit("ms");
        ((DurationPropertyDefinition.Builder)((Object)builder)).setLowerLimit("0");
        PD_CONNECTION_TIMEOUT = (DurationPropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_CONNECTION_TIMEOUT);
        builder = ClassPropertyDefinition.createBuilder(INSTANCE, "java-class");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setOption(PropertyOption.MANDATORY);
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setOption(PropertyOption.ADVANCED);
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "java-class"));
        provider = new DefinedDefaultBehaviorProvider("org.opends.server.replication.plugin.MultimasterReplication");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(provider);
        ((ClassPropertyDefinition.Builder)((Object)builder)).addInstanceOf("org.opends.server.api.SynchronizationProvider");
        PD_JAVA_CLASS = (ClassPropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_JAVA_CLASS);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "num-update-replay-threads");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setOption(PropertyOption.ADVANCED);
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "num-update-replay-threads"));
        provider = new DefinedDefaultBehaviorProvider("10");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(provider);
        ((IntegerPropertyDefinition.Builder)((Object)builder)).setUpperLimit(65535);
        ((IntegerPropertyDefinition.Builder)((Object)builder)).setLowerLimit(1);
        PD_NUM_UPDATE_REPLAY_THREADS = (IntegerPropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_NUM_UPDATE_REPLAY_THREADS);
        builder = new InstantiableRelationDefinition.Builder<ReplicationDomainCfgClient, ReplicationDomainCfg>(INSTANCE, "replication-domain", "replication-domains", ReplicationDomainCfgDefn.getInstance());
        RD_REPLICATION_DOMAINS = (InstantiableRelationDefinition)builder.getInstance();
        INSTANCE.registerRelationDefinition(RD_REPLICATION_DOMAINS);
        builder = new OptionalRelationDefinition.Builder<ReplicationServerCfgClient, ReplicationServerCfg>(INSTANCE, "replication-server", ReplicationServerCfgDefn.getInstance());
        RD_REPLICATION_SERVER = (OptionalRelationDefinition)builder.getInstance();
        INSTANCE.registerRelationDefinition(RD_REPLICATION_SERVER);
        INSTANCE.registerTag(Tag.valueOf("replication"));
    }

    private static class ReplicationSynchronizationProviderCfgServerImpl
    implements ReplicationSynchronizationProviderCfg {
        private ServerManagedObject<? extends ReplicationSynchronizationProviderCfg> impl;
        private final long pConnectionTimeout;
        private final boolean pEnabled;
        private final String pJavaClass;
        private final int pNumUpdateReplayThreads;

        private ReplicationSynchronizationProviderCfgServerImpl(ServerManagedObject<? extends ReplicationSynchronizationProviderCfg> impl) {
            this.impl = impl;
            this.pConnectionTimeout = impl.getPropertyValue(INSTANCE.getConnectionTimeoutPropertyDefinition());
            this.pEnabled = impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
            this.pJavaClass = impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
            this.pNumUpdateReplayThreads = impl.getPropertyValue(INSTANCE.getNumUpdateReplayThreadsPropertyDefinition());
        }

        @Override
        public void addReplicationChangeListener(ConfigurationChangeListener<ReplicationSynchronizationProviderCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeReplicationChangeListener(ConfigurationChangeListener<ReplicationSynchronizationProviderCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<SynchronizationProviderCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<SynchronizationProviderCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public long getConnectionTimeout() {
            return this.pConnectionTimeout;
        }

        @Override
        public boolean isEnabled() {
            return this.pEnabled;
        }

        @Override
        public String getJavaClass() {
            return this.pJavaClass;
        }

        @Override
        public int getNumUpdateReplayThreads() {
            return this.pNumUpdateReplayThreads;
        }

        @Override
        public String[] listReplicationDomains() {
            return this.impl.listChildren(INSTANCE.getReplicationDomainsRelationDefinition());
        }

        @Override
        public ReplicationDomainCfg getReplicationDomain(String name) throws ConfigException {
            return this.impl.getChild(INSTANCE.getReplicationDomainsRelationDefinition(), name).getConfiguration();
        }

        @Override
        public void addReplicationDomainAddListener(ConfigurationAddListener<ReplicationDomainCfg> listener) throws ConfigException {
            this.impl.registerAddListener(INSTANCE.getReplicationDomainsRelationDefinition(), listener);
        }

        @Override
        public void removeReplicationDomainAddListener(ConfigurationAddListener<ReplicationDomainCfg> listener) {
            this.impl.deregisterAddListener(INSTANCE.getReplicationDomainsRelationDefinition(), listener);
        }

        @Override
        public void addReplicationDomainDeleteListener(ConfigurationDeleteListener<ReplicationDomainCfg> listener) throws ConfigException {
            this.impl.registerDeleteListener(INSTANCE.getReplicationDomainsRelationDefinition(), listener);
        }

        @Override
        public void removeReplicationDomainDeleteListener(ConfigurationDeleteListener<ReplicationDomainCfg> listener) {
            this.impl.deregisterDeleteListener(INSTANCE.getReplicationDomainsRelationDefinition(), listener);
        }

        @Override
        public boolean hasReplicationServer() {
            return this.impl.hasChild(INSTANCE.getReplicationServerRelationDefinition());
        }

        @Override
        public ReplicationServerCfg getReplicationServer() throws ConfigException {
            return this.impl.getChild(INSTANCE.getReplicationServerRelationDefinition()).getConfiguration();
        }

        @Override
        public void addReplicationServerAddListener(ConfigurationAddListener<ReplicationServerCfg> listener) throws ConfigException {
            this.impl.registerAddListener(INSTANCE.getReplicationServerRelationDefinition(), listener);
        }

        @Override
        public void removeReplicationServerAddListener(ConfigurationAddListener<ReplicationServerCfg> listener) {
            this.impl.deregisterAddListener(INSTANCE.getReplicationServerRelationDefinition(), listener);
        }

        @Override
        public void addReplicationServerDeleteListener(ConfigurationDeleteListener<ReplicationServerCfg> listener) throws ConfigException {
            this.impl.registerDeleteListener(INSTANCE.getReplicationServerRelationDefinition(), listener);
        }

        @Override
        public void removeReplicationServerDeleteListener(ConfigurationDeleteListener<ReplicationServerCfg> listener) {
            this.impl.deregisterDeleteListener(INSTANCE.getReplicationServerRelationDefinition(), listener);
        }

        @Override
        public Class<? extends ReplicationSynchronizationProviderCfg> configurationClass() {
            return ReplicationSynchronizationProviderCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }
    }

    private static class ReplicationSynchronizationProviderCfgClientImpl
    implements ReplicationSynchronizationProviderCfgClient {
        private ManagedObject<? extends ReplicationSynchronizationProviderCfgClient> impl;

        private ReplicationSynchronizationProviderCfgClientImpl(ManagedObject<? extends ReplicationSynchronizationProviderCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public long getConnectionTimeout() {
            return this.impl.getPropertyValue(INSTANCE.getConnectionTimeoutPropertyDefinition());
        }

        @Override
        public void setConnectionTimeout(Long value) {
            this.impl.setPropertyValue(INSTANCE.getConnectionTimeoutPropertyDefinition(), value);
        }

        @Override
        public Boolean isEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
        }

        @Override
        public void setEnabled(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getEnabledPropertyDefinition(), value);
        }

        @Override
        public String getJavaClass() {
            return this.impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void setJavaClass(String value) {
            this.impl.setPropertyValue(INSTANCE.getJavaClassPropertyDefinition(), value);
        }

        @Override
        public int getNumUpdateReplayThreads() {
            return this.impl.getPropertyValue(INSTANCE.getNumUpdateReplayThreadsPropertyDefinition());
        }

        @Override
        public void setNumUpdateReplayThreads(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getNumUpdateReplayThreadsPropertyDefinition(), value);
        }

        @Override
        public String[] listReplicationDomains() throws ConcurrentModificationException, AuthorizationException, CommunicationException {
            return this.impl.listChildren(INSTANCE.getReplicationDomainsRelationDefinition());
        }

        @Override
        public ReplicationDomainCfgClient getReplicationDomain(String name) throws DefinitionDecodingException, ManagedObjectDecodingException, ManagedObjectNotFoundException, ConcurrentModificationException, AuthorizationException, CommunicationException {
            return this.impl.getChild(INSTANCE.getReplicationDomainsRelationDefinition(), name).getConfiguration();
        }

        public <M extends ReplicationDomainCfgClient> M createReplicationDomain(ManagedObjectDefinition<M, ? extends ReplicationDomainCfg> d, String name, Collection<DefaultBehaviorException> exceptions) throws IllegalManagedObjectNameException {
            return (M)((ReplicationDomainCfgClient)this.impl.createChild(INSTANCE.getReplicationDomainsRelationDefinition(), d, name, exceptions).getConfiguration());
        }

        @Override
        public void removeReplicationDomain(String name) throws ManagedObjectNotFoundException, ConcurrentModificationException, OperationRejectedException, AuthorizationException, CommunicationException {
            this.impl.removeChild(INSTANCE.getReplicationDomainsRelationDefinition(), name);
        }

        @Override
        public boolean hasReplicationServer() throws ConcurrentModificationException, AuthorizationException, CommunicationException {
            return this.impl.hasChild(INSTANCE.getReplicationServerRelationDefinition());
        }

        @Override
        public ReplicationServerCfgClient getReplicationServer() throws DefinitionDecodingException, ManagedObjectDecodingException, ManagedObjectNotFoundException, ConcurrentModificationException, AuthorizationException, CommunicationException {
            return this.impl.getChild(INSTANCE.getReplicationServerRelationDefinition()).getConfiguration();
        }

        public <M extends ReplicationServerCfgClient> M createReplicationServer(ManagedObjectDefinition<M, ? extends ReplicationServerCfg> d, Collection<DefaultBehaviorException> exceptions) {
            return (M)((ReplicationServerCfgClient)this.impl.createChild(INSTANCE.getReplicationServerRelationDefinition(), d, exceptions).getConfiguration());
        }

        @Override
        public void removeReplicationServer() throws ManagedObjectNotFoundException, ConcurrentModificationException, OperationRejectedException, AuthorizationException, CommunicationException {
            this.impl.removeChild(INSTANCE.getReplicationServerRelationDefinition());
        }

        @Override
        public ManagedObjectDefinition<? extends ReplicationSynchronizationProviderCfgClient, ? extends ReplicationSynchronizationProviderCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, AuthorizationException, CommunicationException {
            this.impl.commit();
        }
    }
}

