/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.api;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.opends.server.types.DN;

public final class DITCacheMap<T>
extends AbstractMap<DN, T> {
    private int size = 0;
    private Map<DN, Node<T>> ditCacheMap = new HashMap<DN, Node<T>>();

    public DITCacheMap() {
    }

    public DITCacheMap(Map<? extends DN, ? extends T> m) {
        this.putAll(m);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.ditCacheMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get((DN)key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        for (Node<T> node : this.ditCacheMap.values()) {
            if (node.element == null || !node.element.equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public T get(Object key) {
        Node<T> node = this.ditCacheMap.get((DN)key);
        if (node != null) {
            return node.element;
        }
        return null;
    }

    public Collection<T> getSubtree(DN key) {
        return new DITSubtreeSet(key);
    }

    @Override
    public T put(DN key, T value) {
        Node<T> existingNode = this.ditCacheMap.get(key);
        if (existingNode != null) {
            Object returnValue = existingNode.element;
            existingNode.element = value;
            return returnValue;
        }
        Node node = new Node();
        node.dn = key;
        node.element = value;
        node.parent = null;
        node.child = null;
        node.next = null;
        node.previous = null;
        this.ditCacheMap.put(key, node);
        ++this.size;
        for (DN parentDN = key.getParent(); parentDN != null; parentDN = parentDN.getParent()) {
            Node<T> parentNode = this.ditCacheMap.get(parentDN);
            if (parentNode != null) {
                if (parentNode.child != null) {
                    Node lastNode = parentNode.child;
                    while (lastNode.next != null) {
                        lastNode = lastNode.next;
                    }
                    node.previous = lastNode;
                    lastNode.next = node;
                } else {
                    parentNode.child = node;
                }
                node.parent = parentNode;
                break;
            }
            Node newParentNode = new Node();
            newParentNode.dn = parentDN;
            newParentNode.element = null;
            newParentNode.parent = null;
            newParentNode.child = node;
            newParentNode.next = null;
            newParentNode.previous = null;
            this.ditCacheMap.put(parentDN, newParentNode);
            node.parent = newParentNode;
            node = newParentNode;
        }
        return null;
    }

    @Override
    public T remove(Object key) {
        DN dn = (DN)key;
        Node<T> node = this.ditCacheMap.get(dn);
        if (node == null) {
            return null;
        }
        Object returnValue = node.element;
        if (returnValue == null) {
            return null;
        }
        --this.size;
        node.element = null;
        if (node.child == null) {
            this.ditCacheMap.remove(dn);
            this.fixNodeReferences(node);
        }
        return returnValue;
    }

    private void fixNodeReferences(Node<T> node) {
        while (true) {
            Node parentNode;
            Node nextNode = node.next;
            Node previousNode = node.previous;
            if (nextNode != null) {
                nextNode.previous = previousNode;
            }
            if (previousNode != null) {
                previousNode.next = nextNode;
            }
            if ((parentNode = node.parent) == null || parentNode.child != node) break;
            if (nextNode != null) {
                parentNode.child = nextNode;
                break;
            }
            if (parentNode.element != null) break;
            this.ditCacheMap.remove(parentNode.dn);
            node.parent = null;
            node.previous = null;
            node.next = null;
            node = parentNode;
        }
    }

    public boolean removeSubtree(DN key, Collection<? super T> values) {
        Node<T> node = this.ditCacheMap.remove(key);
        if (node != null) {
            this.fixNodeReferences(node);
            this.adjustSizeAndCollectElements(node, values);
            return true;
        }
        return false;
    }

    private void adjustSizeAndCollectElements(Node<T> node, Collection<? super T> values) {
        if (node.element != null) {
            if (values != null) {
                values.add(node.element);
            }
            node.element = null;
            --this.size;
        }
        Node child = node.child;
        while (child != null) {
            Node next = child.next;
            this.adjustSizeAndCollectElements(child, values);
            child = next;
        }
        node.parent = null;
        node.child = null;
        node.previous = null;
        node.next = null;
        this.ditCacheMap.remove(node.dn);
    }

    @Override
    public void putAll(Map<? extends DN, ? extends T> m) {
        for (Map.Entry<DN, T> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.ditCacheMap.clear();
        this.size = 0;
    }

    @Override
    public Set<Map.Entry<DN, T>> entrySet() {
        return new DITCacheEntrySet();
    }

    int getMapSize() {
        return this.ditCacheMap.size();
    }

    private class DITSubtreeSet
    extends AbstractSet<T> {
        private DN key;

        public DITSubtreeSet(DN key) {
            this.key = key;
        }

        @Override
        public Iterator<T> iterator() {
            return new SubtreeSetIterator();
        }

        @Override
        public int size() {
            int size = 0;
            SubtreeSetIterator iterator = new SubtreeSetIterator(this.key);
            while (iterator.hasNext()) {
                iterator.next();
                ++size;
            }
            return size;
        }

        private class SubtreeSetIterator
        implements Iterator<T> {
            private DN key;
            private Node<T> rootNode;
            private Node<T> node;

            public SubtreeSetIterator() {
                this.key = DITSubtreeSet.this.key;
                this.rootNode = (Node)DITCacheMap.this.ditCacheMap.get(this.key);
                this.node = this.rootNode;
            }

            public SubtreeSetIterator(DN key) {
                this.key = key;
                this.rootNode = (Node)DITCacheMap.this.ditCacheMap.get(this.key);
                this.node = this.rootNode;
            }

            @Override
            public boolean hasNext() {
                if (this.rootNode != null) {
                    if (this.node == this.rootNode && this.rootNode.element != null) {
                        return true;
                    }
                    while (this.node != null) {
                        if (this.node.element != null) {
                            return true;
                        }
                        if (this.node.child != null) {
                            this.node = this.node.child;
                            continue;
                        }
                        while (this.node.next == null && this.node.parent != this.rootNode) {
                            this.node = this.node.parent;
                        }
                        this.node = this.node.next;
                    }
                }
                return false;
            }

            @Override
            public T next() {
                Object element = null;
                if (this.rootNode != null) {
                    if (this.node == this.rootNode) {
                        this.node = this.rootNode.child;
                        if (this.rootNode.element != null) {
                            return this.rootNode.element;
                        }
                    }
                    while (this.node != null) {
                        element = this.node.element != null ? (Object)this.node.element : null;
                        if (this.node.child != null) {
                            this.node = this.node.child;
                        } else {
                            while (this.node.next == null && this.node.parent != this.rootNode) {
                                this.node = this.node.parent;
                            }
                            this.node = this.node.next;
                        }
                        if (element == null) continue;
                        return element;
                    }
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    private class DITCacheMapEntry
    implements Map.Entry<DN, T> {
        private DN key;
        private T value;

        public DITCacheMapEntry(DN key, T value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public DN getKey() {
            return this.key;
        }

        @Override
        public T getValue() {
            return this.value;
        }

        @Override
        public T setValue(T value) {
            Node node = (Node)DITCacheMap.this.ditCacheMap.get(this.key);
            Object oldValue = this.value;
            node.element = value;
            this.value = value;
            return oldValue;
        }
    }

    private class DITCacheEntrySet
    extends AbstractSet<Map.Entry<DN, T>> {
        private DITCacheEntrySet() {
        }

        @Override
        public int size() {
            return DITCacheMap.this.size();
        }

        @Override
        public Iterator<Map.Entry<DN, T>> iterator() {
            return new EntryIterator();
        }

        private class EntryIterator
        implements Iterator<Map.Entry<DN, T>> {
            private Iterator<Map.Entry<DN, Node<T>>> ditCacheMapIterator;
            private Map.Entry<DN, Node<T>> currentEntry;
            private Map.Entry<DN, Node<T>> nextEntry;
            private boolean hasNext;

            public EntryIterator() {
                this.ditCacheMapIterator = DITCacheMap.this.ditCacheMap.entrySet().iterator();
                this.currentEntry = null;
                this.nextEntry = null;
                this.hasNext = false;
            }

            @Override
            public boolean hasNext() {
                if (this.hasNext) {
                    return true;
                }
                while (this.ditCacheMapIterator.hasNext()) {
                    Map.Entry entry = this.ditCacheMapIterator.next();
                    Node node = entry.getValue();
                    if (node == null || node.element == null) continue;
                    this.nextEntry = entry;
                    this.hasNext = true;
                    return true;
                }
                this.nextEntry = null;
                return false;
            }

            @Override
            public Map.Entry<DN, T> next() {
                if (this.nextEntry != null) {
                    Node node = this.nextEntry.getValue();
                    this.currentEntry = this.nextEntry;
                    this.nextEntry = null;
                    this.hasNext = false;
                    return new DITCacheMapEntry(node.dn, node.element);
                }
                while (this.ditCacheMapIterator.hasNext()) {
                    Map.Entry entry = this.ditCacheMapIterator.next();
                    Node node = entry.getValue();
                    if (node == null || node.element == null) continue;
                    this.currentEntry = entry;
                    this.hasNext = false;
                    return new DITCacheMapEntry(node.dn, node.element);
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                if (this.currentEntry != null) {
                    Map.Entry oldIteratorEntry = null;
                    if (this.hasNext()) {
                        oldIteratorEntry = this.nextEntry;
                    }
                    if (DITCacheMap.this.remove(this.currentEntry.getKey()) != null) {
                        this.ditCacheMapIterator = DITCacheMap.this.ditCacheMap.entrySet().iterator();
                        this.currentEntry = null;
                        this.nextEntry = null;
                        this.hasNext = false;
                        while (this.hasNext()) {
                            Object newIteratorEntry = this.next();
                            if (oldIteratorEntry == null || !oldIteratorEntry.getKey().equals(newIteratorEntry.getKey()) || !oldIteratorEntry.getValue().element.equals(newIteratorEntry.getValue())) continue;
                            this.nextEntry = this.currentEntry;
                            this.hasNext = true;
                            return;
                        }
                        this.currentEntry = null;
                        this.nextEntry = null;
                        this.hasNext = false;
                        return;
                    }
                }
                throw new IllegalStateException();
            }
        }
    }

    private static final class Node<T> {
        DN dn;
        T element;
        Node<T> parent;
        Node<T> child;
        Node<T> next;
        Node<T> previous;

        private Node() {
        }

        public String toString() {
            if (this.element == null) {
                return "glue";
            }
            return "node(" + String.valueOf(this.element) + ")";
        }
    }
}

