/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.api;

import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.opends.messages.Message;
import org.opends.server.admin.std.server.MonitorProviderCfg;
import org.opends.server.api.DirectoryThread;
import org.opends.server.config.ConfigException;
import org.opends.server.types.Attribute;
import org.opends.server.types.DirectoryConfig;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;

@PublicAPI(stability=StabilityLevel.VOLATILE, mayInstantiate=false, mayExtend=true, mayInvoke=false)
public abstract class MonitorProvider<T extends MonitorProviderCfg> {
    private static final ScheduledExecutorService SCHEDULER = Executors.newSingleThreadScheduledExecutor(new MonitorThreadFactory());
    private ScheduledFuture<?> scheduledFuture;

    public abstract void initializeMonitorProvider(T var1) throws ConfigException, InitializationException;

    public boolean isConfigurationAcceptable(MonitorProviderCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    public void finalizeMonitorProvider() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
        }
    }

    public abstract String getMonitorInstanceName();

    public ObjectClass getMonitorObjectClass() {
        return DirectoryConfig.getObjectClass("extensibleobject", true);
    }

    protected final void scheduleUpdate(Runnable updater, long initialDelay, long period, TimeUnit unit) {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
        }
        this.scheduledFuture = SCHEDULER.scheduleAtFixedRate(updater, initialDelay, period, unit);
    }

    public abstract List<Attribute> getMonitorData();

    private static final class MonitorThreadFactory
    implements ThreadFactory {
        private MonitorThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            DirectoryThread t = new DirectoryThread(r, "Monitor Provider State Updater");
            t.setDaemon(true);
            return t;
        }
    }
}

