/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.opends.messages.Message;
import org.opends.server.admin.std.server.VirtualAttributeCfg;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.core.SearchOperation;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteSequence;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConditionResult;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;
import org.opends.server.types.VirtualAttributeRule;

@PublicAPI(stability=StabilityLevel.VOLATILE, mayInstantiate=false, mayExtend=true, mayInvoke=false)
public abstract class VirtualAttributeProvider<T extends VirtualAttributeCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();

    public abstract void initializeVirtualAttributeProvider(T var1) throws ConfigException, InitializationException;

    public boolean isConfigurationAcceptable(VirtualAttributeCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    public void finalizeVirtualAttributeProvider() {
    }

    public abstract boolean isMultiValued();

    public abstract Set<AttributeValue> getValues(Entry var1, VirtualAttributeRule var2);

    public boolean hasValue(Entry entry, VirtualAttributeRule rule) {
        return !this.getValues(entry, rule).isEmpty();
    }

    public boolean hasValue(Entry entry, VirtualAttributeRule rule, AttributeValue value) {
        return this.getValues(entry, rule).contains(value);
    }

    public boolean hasAllValues(Entry entry, VirtualAttributeRule rule, Collection<AttributeValue> values) {
        Set<AttributeValue> virtualValues = this.getValues(entry, rule);
        return virtualValues.containsAll(values);
    }

    public boolean hasAnyValue(Entry entry, VirtualAttributeRule rule, Collection<AttributeValue> values) {
        Set<AttributeValue> virtualValues = this.getValues(entry, rule);
        for (AttributeValue value : values) {
            if (!virtualValues.contains(value)) continue;
            return true;
        }
        return false;
    }

    public ConditionResult matchesSubstring(Entry entry, VirtualAttributeRule rule, ByteString subInitial, List<ByteString> subAny, ByteString subFinal) {
        ByteString normalizedSubFinal;
        ArrayList<ByteSequence> normalizedSubAny;
        ByteString normalizedSubInitial;
        SubstringMatchingRule matchingRule = rule.getAttributeType().getSubstringMatchingRule();
        if (matchingRule == null) {
            return ConditionResult.UNDEFINED;
        }
        if (subInitial == null) {
            normalizedSubInitial = null;
        } else {
            try {
                normalizedSubInitial = matchingRule.normalizeSubstring(subInitial);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                return ConditionResult.UNDEFINED;
            }
        }
        if (subAny == null) {
            normalizedSubAny = null;
        } else {
            normalizedSubAny = new ArrayList<ByteSequence>(subAny.size());
            for (ByteString subAnyElement : subAny) {
                try {
                    normalizedSubAny.add(matchingRule.normalizeSubstring(subAnyElement));
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    return ConditionResult.UNDEFINED;
                }
            }
        }
        if (subFinal == null) {
            normalizedSubFinal = null;
        } else {
            try {
                normalizedSubFinal = matchingRule.normalizeSubstring(subFinal);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                return ConditionResult.UNDEFINED;
            }
        }
        ConditionResult result = ConditionResult.FALSE;
        for (AttributeValue value : this.getValues(entry, rule)) {
            try {
                if (!matchingRule.valueMatchesSubstring(value.getNormalizedValue(), normalizedSubInitial, normalizedSubAny, normalizedSubFinal)) continue;
                return ConditionResult.TRUE;
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                result = ConditionResult.UNDEFINED;
            }
        }
        return result;
    }

    public ConditionResult greaterThanOrEqualTo(Entry entry, VirtualAttributeRule rule, AttributeValue value) {
        ByteString normalizedValue;
        OrderingMatchingRule matchingRule = rule.getAttributeType().getOrderingMatchingRule();
        if (matchingRule == null) {
            return ConditionResult.UNDEFINED;
        }
        try {
            normalizedValue = value.getNormalizedValue();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            return ConditionResult.UNDEFINED;
        }
        ConditionResult result = ConditionResult.FALSE;
        for (AttributeValue v : this.getValues(entry, rule)) {
            try {
                ByteString nv = v.getNormalizedValue();
                int comparisonResult = matchingRule.compareValues(nv, normalizedValue);
                if (comparisonResult < 0) continue;
                return ConditionResult.TRUE;
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                result = ConditionResult.UNDEFINED;
            }
        }
        return result;
    }

    public ConditionResult lessThanOrEqualTo(Entry entry, VirtualAttributeRule rule, AttributeValue value) {
        ByteString normalizedValue;
        OrderingMatchingRule matchingRule = rule.getAttributeType().getOrderingMatchingRule();
        if (matchingRule == null) {
            return ConditionResult.UNDEFINED;
        }
        try {
            normalizedValue = value.getNormalizedValue();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            return ConditionResult.UNDEFINED;
        }
        ConditionResult result = ConditionResult.FALSE;
        for (AttributeValue v : this.getValues(entry, rule)) {
            try {
                ByteString nv = v.getNormalizedValue();
                int comparisonResult = matchingRule.compareValues(nv, normalizedValue);
                if (comparisonResult > 0) continue;
                return ConditionResult.TRUE;
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                result = ConditionResult.UNDEFINED;
            }
        }
        return result;
    }

    public ConditionResult approximatelyEqualTo(Entry entry, VirtualAttributeRule rule, AttributeValue value) {
        ByteString normalizedValue;
        ApproximateMatchingRule matchingRule = rule.getAttributeType().getApproximateMatchingRule();
        if (matchingRule == null) {
            return ConditionResult.UNDEFINED;
        }
        try {
            normalizedValue = matchingRule.normalizeValue(value.getValue());
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            return ConditionResult.UNDEFINED;
        }
        ConditionResult result = ConditionResult.FALSE;
        for (AttributeValue v : this.getValues(entry, rule)) {
            try {
                ByteString nv = matchingRule.normalizeValue(v.getValue());
                if (!matchingRule.approximatelyMatch(nv, normalizedValue)) continue;
                return ConditionResult.TRUE;
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                result = ConditionResult.UNDEFINED;
            }
        }
        return result;
    }

    public abstract boolean isSearchable(VirtualAttributeRule var1, SearchOperation var2, boolean var3);

    public abstract void processSearch(VirtualAttributeRule var1, SearchOperation var2);
}

