/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import org.opends.messages.BackendMessages;
import org.opends.messages.Message;
import org.opends.server.admin.Configuration;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.BackupBackendCfg;
import org.opends.server.api.Backend;
import org.opends.server.config.ConfigException;
import org.opends.server.core.AddOperation;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.SearchOperation;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.schema.BooleanSyntax;
import org.opends.server.schema.GeneralizedTimeSyntax;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeBuilder;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.AttributeValues;
import org.opends.server.types.Attributes;
import org.opends.server.types.BackupConfig;
import org.opends.server.types.BackupDirectory;
import org.opends.server.types.BackupInfo;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConditionResult;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.IndexType;
import org.opends.server.types.InitializationException;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.LDIFImportResult;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.RDN;
import org.opends.server.types.RestoreConfig;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchScope;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.Validator;

public class BackupBackend
extends Backend
implements ConfigurationChangeListener<BackupBackendCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private BackupBackendCfg currentConfig;
    private DN backupBaseDN;
    private DN[] baseDNs;
    private Entry backupBaseEntry;
    private HashSet<String> supportedControls;
    private HashSet<String> supportedFeatures;
    private HashMap<File, CachedBackupDirectory> backupDirectories;

    @Override
    public void configureBackend(Configuration config) throws ConfigException {
        if (config == null) {
            Message message = BackendMessages.ERR_BACKUP_CONFIG_ENTRY_NULL.get();
            throw new ConfigException(message);
        }
        Validator.ensureTrue(config instanceof BackupBackendCfg);
        this.currentConfig = (BackupBackendCfg)config;
    }

    @Override
    public void initializeBackend() throws ConfigException, InitializationException {
        try {
            this.backupBaseDN = DN.decode("cn=backups");
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = BackendMessages.ERR_BACKUP_CANNOT_DECODE_BACKUP_ROOT_DN.get(StaticUtils.getExceptionMessage(e));
            throw new InitializationException(message, (Throwable)e);
        }
        this.baseDNs = new DN[]{this.backupBaseDN};
        SortedSet<String> values = this.currentConfig.getBackupDirectory();
        this.backupDirectories = new LinkedHashMap<File, CachedBackupDirectory>(values.size());
        for (String s : values) {
            File dir = StaticUtils.getFileForPath(s);
            this.backupDirectories.put(dir, new CachedBackupDirectory(dir));
        }
        LinkedHashMap<ObjectClass, String> objectClasses = new LinkedHashMap<ObjectClass, String>(2);
        objectClasses.put(DirectoryServer.getTopObjectClass(), "top");
        ObjectClass untypedOC = DirectoryServer.getObjectClass("untypedobject", true);
        objectClasses.put(untypedOC, "untypedObject");
        LinkedHashMap<AttributeType, List<Attribute>> opAttrs = new LinkedHashMap<AttributeType, List<Attribute>>(0);
        LinkedHashMap<AttributeType, List<Attribute>> userAttrs = new LinkedHashMap<AttributeType, List<Attribute>>(1);
        RDN rdn = this.backupBaseDN.getRDN();
        int numAVAs = rdn.getNumValues();
        for (int i = 0; i < numAVAs; ++i) {
            AttributeType attrType = rdn.getAttributeType(i);
            ArrayList<Attribute> attrList = new ArrayList<Attribute>(1);
            attrList.add(Attributes.create(attrType, rdn.getAttributeValue(i)));
            userAttrs.put(attrType, attrList);
        }
        this.backupBaseEntry = new Entry(this.backupBaseDN, objectClasses, userAttrs, opAttrs);
        this.supportedControls = new HashSet(0);
        this.supportedFeatures = new HashSet(0);
        this.currentConfig.addBackupChangeListener(this);
        try {
            DirectoryServer.registerBaseDN(this.backupBaseDN, this, true);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = BackendMessages.ERR_BACKEND_CANNOT_REGISTER_BASEDN.get(this.backupBaseDN.toString(), StaticUtils.getExceptionMessage(e));
            throw new InitializationException(message, (Throwable)e);
        }
    }

    @Override
    public void finalizeBackend() {
        block2: {
            this.currentConfig.removeBackupChangeListener(this);
            try {
                DirectoryServer.deregisterBaseDN(this.backupBaseDN);
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) break block2;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    @Override
    public DN[] getBaseDNs() {
        return this.baseDNs;
    }

    @Override
    public long getEntryCount() {
        int numEntries = 1;
        AttributeType backupPathType = DirectoryServer.getAttributeType("ds-backup-directory-path", true);
        for (File dir : this.backupDirectories.keySet()) {
            try {
                File descriptorFile = new File(dir, "backup.info");
                if (!descriptorFile.exists()) continue;
                DN backupDirDN = BackupBackend.makeChildDN(this.backupBaseDN, backupPathType, dir.getAbsolutePath());
                this.getBackupDirectoryEntry(backupDirDN);
                ++numEntries;
            }
            catch (Exception exception) {}
        }
        return numEntries;
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public boolean isIndexed(AttributeType attributeType, IndexType indexType) {
        return true;
    }

    @Override
    public ConditionResult hasSubordinates(DN entryDN) throws DirectoryException {
        long ret = this.numSubordinates(entryDN, false);
        if (ret < 0L) {
            return ConditionResult.UNDEFINED;
        }
        if (ret == 0L) {
            return ConditionResult.FALSE;
        }
        return ConditionResult.TRUE;
    }

    @Override
    public long numSubordinates(DN entryDN, boolean subtree) throws DirectoryException {
        if (entryDN == null) {
            return -1L;
        }
        if (this.backupBaseDN.equals(entryDN)) {
            long count = 0L;
            for (File dir : this.backupDirectories.keySet()) {
                File descriptorFile = new File(dir, "backup.info");
                if (!descriptorFile.exists()) continue;
                if (subtree) {
                    try {
                        BackupDirectory backupDirectory = this.backupDirectories.get(dir).getBackupDirectory();
                        count += (long)backupDirectory.getBackups().keySet().size();
                    }
                    catch (Exception e) {
                        return -1L;
                    }
                }
                ++count;
            }
            return count;
        }
        DN parentDN = entryDN.getParentDNInSuffix();
        if (parentDN == null) {
            return -1L;
        }
        if (this.backupBaseDN.equals(parentDN)) {
            AttributeType t;
            long count = 0L;
            Entry backupDirEntry = this.getBackupDirectoryEntry(entryDN);
            List<Attribute> attrList = backupDirEntry.getAttribute(t = DirectoryServer.getAttributeType("ds-backup-directory-path", true));
            if (attrList != null && !attrList.isEmpty()) {
                for (AttributeValue v : attrList.get(0)) {
                    try {
                        File dir = new File(v.toString());
                        BackupDirectory backupDirectory = this.backupDirectories.get(dir).getBackupDirectory();
                        count += (long)backupDirectory.getBackups().keySet().size();
                    }
                    catch (Exception e) {
                        return -1L;
                    }
                }
            }
            return count;
        }
        if (this.backupBaseDN.equals(parentDN.getParentDNInSuffix())) {
            return 0L;
        }
        return -1L;
    }

    @Override
    public Entry getEntry(DN entryDN) throws DirectoryException {
        if (entryDN == null) {
            Message message = BackendMessages.ERR_BACKUP_GET_ENTRY_NULL.get();
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
        }
        if (entryDN.equals(this.backupBaseDN)) {
            return this.backupBaseEntry.duplicate(true);
        }
        DN parentDN = entryDN.getParentDNInSuffix();
        if (parentDN == null) {
            Message message = BackendMessages.ERR_BACKUP_INVALID_BASE.get(String.valueOf(entryDN));
            throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message);
        }
        if (parentDN.equals(this.backupBaseDN)) {
            return this.getBackupDirectoryEntry(entryDN);
        }
        if (this.backupBaseDN.equals(parentDN.getParentDNInSuffix())) {
            return this.getBackupEntry(entryDN);
        }
        Message message = BackendMessages.ERR_BACKUP_INVALID_BASE.get(String.valueOf(entryDN));
        throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message, this.backupBaseDN, null);
    }

    private Entry getBackupDirectoryEntry(DN entryDN) throws DirectoryException {
        BackupDirectory backupDirectory;
        AttributeType t = DirectoryServer.getAttributeType("ds-backup-directory-path", true);
        AttributeValue v = entryDN.getRDN().getAttributeValue(t);
        if (v == null) {
            Message message = BackendMessages.ERR_BACKUP_DN_DOES_NOT_SPECIFY_DIRECTORY.get(String.valueOf(entryDN));
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message, this.backupBaseDN, null);
        }
        try {
            File dir = new File(v.toString());
            backupDirectory = this.backupDirectories.get(dir).getBackupDirectory();
        }
        catch (ConfigException ce) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ce);
            }
            Message message = BackendMessages.ERR_BACKUP_INVALID_BACKUP_DIRECTORY.get(String.valueOf(entryDN), ce.getMessage());
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = BackendMessages.ERR_BACKUP_ERROR_GETTING_BACKUP_DIRECTORY.get(StaticUtils.getExceptionMessage(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
        }
        LinkedHashMap<ObjectClass, String> ocMap = new LinkedHashMap<ObjectClass, String>(2);
        ocMap.put(DirectoryServer.getTopObjectClass(), "top");
        ObjectClass backupDirOC = DirectoryServer.getObjectClass("ds-backup-directory", true);
        ocMap.put(backupDirOC, "ds-backup-directory");
        LinkedHashMap<AttributeType, List<Attribute>> opAttrs = new LinkedHashMap<AttributeType, List<Attribute>>(0);
        LinkedHashMap<AttributeType, List<Attribute>> userAttrs = new LinkedHashMap<AttributeType, List<Attribute>>(3);
        ArrayList<Attribute> attrList = new ArrayList<Attribute>(1);
        attrList.add(Attributes.create(t, v));
        userAttrs.put(t, attrList);
        t = DirectoryServer.getAttributeType("ds-backup-backend-dn", true);
        attrList = new ArrayList(1);
        attrList.add(Attributes.create(t, AttributeValues.create(t, backupDirectory.getConfigEntryDN().toString())));
        userAttrs.put(t, attrList);
        Entry e = new Entry(entryDN, ocMap, userAttrs, opAttrs);
        e.processVirtualAttributes();
        return e;
    }

    private Entry getBackupEntry(DN entryDN) throws DirectoryException {
        HashMap<String, String> properties;
        byte[] unsignedHash;
        byte[] signedHash;
        BackupDirectory backupDirectory;
        AttributeType idType = DirectoryServer.getAttributeType("ds-backup-id", true);
        AttributeValue idValue = entryDN.getRDN().getAttributeValue(idType);
        if (idValue == null) {
            Message message = BackendMessages.ERR_BACKUP_NO_BACKUP_ID_IN_DN.get(String.valueOf(entryDN));
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
        }
        String backupID = idValue.getValue().toString();
        DN parentDN = entryDN.getParentDNInSuffix();
        if (parentDN == null) {
            Message message = BackendMessages.ERR_BACKUP_NO_BACKUP_PARENT_DN.get(String.valueOf(entryDN));
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
        }
        AttributeType t = DirectoryServer.getAttributeType("ds-backup-directory-path", true);
        AttributeValue v = parentDN.getRDN().getAttributeValue(t);
        if (v == null) {
            Message message = BackendMessages.ERR_BACKUP_NO_BACKUP_DIR_IN_DN.get(String.valueOf(entryDN));
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
        }
        try {
            backupDirectory = this.backupDirectories.get(new File(v.getValue().toString())).getBackupDirectory();
        }
        catch (ConfigException ce) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ce);
            }
            Message message = BackendMessages.ERR_BACKUP_INVALID_BACKUP_DIRECTORY.get(String.valueOf(entryDN), ce.getMessageObject());
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = BackendMessages.ERR_BACKUP_ERROR_GETTING_BACKUP_DIRECTORY.get(StaticUtils.getExceptionMessage(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
        }
        BackupInfo backupInfo = backupDirectory.getBackupInfo(backupID);
        if (backupInfo == null) {
            Message message = BackendMessages.ERR_BACKUP_NO_SUCH_BACKUP.get(backupID, backupDirectory.getPath());
            throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message, parentDN, null);
        }
        LinkedHashMap<ObjectClass, String> ocMap = new LinkedHashMap<ObjectClass, String>(3);
        ocMap.put(DirectoryServer.getTopObjectClass(), "top");
        ObjectClass oc = DirectoryServer.getObjectClass("ds-backup-info", true);
        ocMap.put(oc, "ds-backup-info");
        oc = DirectoryServer.getObjectClass("extensibleobject", true);
        ocMap.put(oc, "extensibleObject");
        LinkedHashMap<AttributeType, List<Attribute>> opAttrs = new LinkedHashMap<AttributeType, List<Attribute>>(0);
        LinkedHashMap<AttributeType, List<Attribute>> userAttrs = new LinkedHashMap<AttributeType, List<Attribute>>();
        ArrayList<Attribute> attrList = new ArrayList<Attribute>(1);
        attrList.add(Attributes.create(idType, idValue));
        userAttrs.put(idType, attrList);
        backupInfo.getBackupDirectory();
        attrList = new ArrayList(1);
        attrList.add(Attributes.create(t, v));
        userAttrs.put(t, attrList);
        Date backupDate = backupInfo.getBackupDate();
        if (backupDate != null) {
            t = DirectoryServer.getAttributeType("ds-backup-date", true);
            attrList = new ArrayList(1);
            attrList.add(Attributes.create(t, AttributeValues.create(t, GeneralizedTimeSyntax.format(backupDate))));
            userAttrs.put(t, attrList);
        }
        t = DirectoryServer.getAttributeType("ds-backup-compressed", true);
        attrList = new ArrayList(1);
        attrList.add(Attributes.create(t, BooleanSyntax.createBooleanValue(backupInfo.isCompressed())));
        userAttrs.put(t, attrList);
        t = DirectoryServer.getAttributeType("ds-backup-encrypted", true);
        attrList = new ArrayList(1);
        attrList.add(Attributes.create(t, BooleanSyntax.createBooleanValue(backupInfo.isEncrypted())));
        userAttrs.put(t, attrList);
        t = DirectoryServer.getAttributeType("ds-backup-incremental", true);
        attrList = new ArrayList(1);
        attrList.add(Attributes.create(t, BooleanSyntax.createBooleanValue(backupInfo.isIncremental())));
        userAttrs.put(t, attrList);
        HashSet<String> dependencies = backupInfo.getDependencies();
        if (dependencies != null && !dependencies.isEmpty()) {
            t = DirectoryServer.getAttributeType("ds-backup-dependency", true);
            AttributeBuilder builder = new AttributeBuilder(t);
            for (String s : dependencies) {
                builder.add(AttributeValues.create(t, s));
            }
            attrList = new ArrayList(1);
            attrList.add(builder.toAttribute());
            userAttrs.put(t, attrList);
        }
        if ((signedHash = backupInfo.getSignedHash()) != null) {
            t = DirectoryServer.getAttributeType("ds-backup-signed-hash", true);
            attrList = new ArrayList(1);
            attrList.add(Attributes.create(t, AttributeValues.create(t, ByteString.wrap(signedHash))));
            userAttrs.put(t, attrList);
        }
        if ((unsignedHash = backupInfo.getUnsignedHash()) != null) {
            t = DirectoryServer.getAttributeType("ds-backup-unsigned-hash", true);
            attrList = new ArrayList(1);
            attrList.add(Attributes.create(t, AttributeValues.create(t, ByteString.wrap(unsignedHash))));
            userAttrs.put(t, attrList);
        }
        if ((properties = backupInfo.getBackupProperties()) != null && !properties.isEmpty()) {
            for (Map.Entry<String, String> e : properties.entrySet()) {
                t = DirectoryServer.getAttributeType(StaticUtils.toLowerCase(e.getKey()), true);
                attrList = new ArrayList(1);
                attrList.add(Attributes.create(t, AttributeValues.create(t, e.getValue())));
                userAttrs.put(t, attrList);
            }
        }
        Entry e = new Entry(entryDN, ocMap, userAttrs, opAttrs);
        e.processVirtualAttributes();
        return e;
    }

    @Override
    public void addEntry(Entry entry, AddOperation addOperation) throws DirectoryException {
        Message message = BackendMessages.ERR_BACKUP_ADD_NOT_SUPPORTED.get();
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
    }

    @Override
    public void deleteEntry(DN entryDN, DeleteOperation deleteOperation) throws DirectoryException {
        Message message = BackendMessages.ERR_BACKUP_DELETE_NOT_SUPPORTED.get();
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
    }

    @Override
    public void replaceEntry(Entry oldEntry, Entry newEntry, ModifyOperation modifyOperation) throws DirectoryException {
        Message message = BackendMessages.ERR_BACKUP_MODIFY_NOT_SUPPORTED.get();
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
    }

    @Override
    public void renameEntry(DN currentDN, Entry entry, ModifyDNOperation modifyDNOperation) throws DirectoryException {
        Message message = BackendMessages.ERR_BACKUP_MODIFY_DN_NOT_SUPPORTED.get();
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
    }

    @Override
    public void search(SearchOperation searchOperation) throws DirectoryException {
        DN baseDN = searchOperation.getBaseDN();
        Entry baseEntry = this.getEntry(baseDN);
        SearchScope scope = searchOperation.getScope();
        SearchFilter filter = searchOperation.getFilter();
        if (this.backupBaseDN.equals(baseDN)) {
            if ((scope == SearchScope.BASE_OBJECT || scope == SearchScope.WHOLE_SUBTREE) && filter.matchesEntry(baseEntry)) {
                searchOperation.returnEntry(baseEntry, null);
            }
            if (scope != SearchScope.BASE_OBJECT && !this.backupDirectories.isEmpty()) {
                AttributeType backupPathType = DirectoryServer.getAttributeType("ds-backup-directory-path", true);
                for (File dir : this.backupDirectories.keySet()) {
                    List<Attribute> attrList;
                    Entry backupDirEntry;
                    File descriptorFile = new File(dir, "backup.info");
                    if (!descriptorFile.exists()) continue;
                    DN backupDirDN = BackupBackend.makeChildDN(this.backupBaseDN, backupPathType, dir.getAbsolutePath());
                    try {
                        backupDirEntry = this.getBackupDirectoryEntry(backupDirDN);
                    }
                    catch (Exception e) {
                        if (!DebugLogger.debugEnabled()) continue;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        continue;
                    }
                    if (filter.matchesEntry(backupDirEntry)) {
                        searchOperation.returnEntry(backupDirEntry, null);
                    }
                    if (scope == SearchScope.SINGLE_LEVEL || (attrList = backupDirEntry.getAttribute(backupPathType)) == null || attrList.isEmpty()) continue;
                    for (AttributeValue v : attrList.get(0)) {
                        try {
                            File subtreeDir = new File(v.toString());
                            BackupDirectory backupDirectory = this.backupDirectories.get(subtreeDir).getBackupDirectory();
                            AttributeType idType = DirectoryServer.getAttributeType("ds-backup-id", true);
                            for (String backupID : backupDirectory.getBackups().keySet()) {
                                DN backupEntryDN = BackupBackend.makeChildDN(backupDirDN, idType, backupID);
                                Entry backupEntry = this.getBackupEntry(backupEntryDN);
                                if (!filter.matchesEntry(backupEntry)) continue;
                                searchOperation.returnEntry(backupEntry, null);
                            }
                        }
                        catch (Exception e) {
                            if (!DebugLogger.debugEnabled()) continue;
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                    }
                }
            }
        } else {
            DN parentDN = baseDN.getParentDNInSuffix();
            if (this.backupBaseDN.equals(parentDN)) {
                AttributeType t;
                List<Attribute> attrList;
                Entry backupDirEntry = this.getBackupDirectoryEntry(baseDN);
                if ((scope == SearchScope.BASE_OBJECT || scope == SearchScope.WHOLE_SUBTREE) && filter.matchesEntry(backupDirEntry)) {
                    searchOperation.returnEntry(backupDirEntry, null);
                }
                if (scope != SearchScope.BASE_OBJECT && (attrList = backupDirEntry.getAttribute(t = DirectoryServer.getAttributeType("ds-backup-directory-path", true))) != null && !attrList.isEmpty()) {
                    for (AttributeValue v : attrList.get(0)) {
                        try {
                            File dir = new File(v.toString());
                            BackupDirectory backupDirectory = this.backupDirectories.get(dir).getBackupDirectory();
                            AttributeType idType = DirectoryServer.getAttributeType("ds-backup-id", true);
                            for (String backupID : backupDirectory.getBackups().keySet()) {
                                DN backupEntryDN = BackupBackend.makeChildDN(baseDN, idType, backupID);
                                Entry backupEntry = this.getBackupEntry(backupEntryDN);
                                if (!filter.matchesEntry(backupEntry)) continue;
                                searchOperation.returnEntry(backupEntry, null);
                            }
                        }
                        catch (Exception e) {
                            if (!DebugLogger.debugEnabled()) continue;
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                    }
                }
            } else {
                if (parentDN == null || !this.backupBaseDN.equals(parentDN.getParentDNInSuffix())) {
                    Message message = BackendMessages.ERR_BACKUP_NO_SUCH_ENTRY.get(String.valueOf(this.backupBaseDN));
                    throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message);
                }
                if (scope == SearchScope.BASE_OBJECT || scope == SearchScope.WHOLE_SUBTREE) {
                    Entry backupEntry = this.getBackupEntry(baseDN);
                    if (backupEntry == null) {
                        Message message = BackendMessages.ERR_BACKUP_NO_SUCH_ENTRY.get(String.valueOf(this.backupBaseDN));
                        throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message);
                    }
                    if (filter.matchesEntry(backupEntry)) {
                        searchOperation.returnEntry(backupEntry, null);
                    }
                }
            }
        }
    }

    public HashSet<String> getSupportedControls() {
        return this.supportedControls;
    }

    public HashSet<String> getSupportedFeatures() {
        return this.supportedFeatures;
    }

    @Override
    public boolean supportsLDIFExport() {
        return false;
    }

    @Override
    public void exportLDIF(LDIFExportConfig exportConfig) throws DirectoryException {
        Message message = BackendMessages.ERR_BACKUP_EXPORT_NOT_SUPPORTED.get();
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
    }

    @Override
    public boolean supportsLDIFImport() {
        return false;
    }

    @Override
    public LDIFImportResult importLDIF(LDIFImportConfig importConfig) throws DirectoryException {
        Message message = BackendMessages.ERR_BACKUP_IMPORT_NOT_SUPPORTED.get();
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
    }

    @Override
    public boolean supportsBackup() {
        return false;
    }

    @Override
    public boolean supportsBackup(BackupConfig backupConfig, StringBuilder unsupportedReason) {
        return false;
    }

    @Override
    public void createBackup(BackupConfig backupConfig) throws DirectoryException {
        Message message = BackendMessages.ERR_BACKUP_BACKUP_AND_RESTORE_NOT_SUPPORTED.get();
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
    }

    @Override
    public void removeBackup(BackupDirectory backupDirectory, String backupID) throws DirectoryException {
        Message message = BackendMessages.ERR_BACKUP_BACKUP_AND_RESTORE_NOT_SUPPORTED.get();
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
    }

    @Override
    public boolean supportsRestore() {
        return false;
    }

    @Override
    public void restoreBackup(RestoreConfig restoreConfig) throws DirectoryException {
        Message message = BackendMessages.ERR_BACKUP_BACKUP_AND_RESTORE_NOT_SUPPORTED.get();
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(BackupBackendCfg cfg, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(BackupBackendCfg cfg) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        SortedSet<String> values = cfg.getBackupDirectory();
        this.backupDirectories = new LinkedHashMap<File, CachedBackupDirectory>(values.size());
        for (String s : values) {
            File dir = StaticUtils.getFileForPath(s);
            this.backupDirectories.put(dir, new CachedBackupDirectory(dir));
        }
        this.currentConfig = cfg;
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    public static DN makeChildDN(DN parentDN, AttributeType rdnAttrType, String rdnStringValue) {
        AttributeValue attrValue = AttributeValues.create(rdnAttrType, rdnStringValue);
        return parentDN.concat(RDN.create(rdnAttrType, attrValue));
    }

    @Override
    public void preloadEntryCache() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Operation not supported.");
    }

    private class CachedBackupDirectory {
        private final String directoryPath;
        private final File backupInfo;
        private long lastModified;
        private BackupDirectory backupDirectory;

        public CachedBackupDirectory(File directory) {
            this.directoryPath = directory.getPath();
            this.backupInfo = new File(this.directoryPath + File.separator + "backup.info");
            this.lastModified = -1L;
            this.backupDirectory = null;
        }

        public synchronized BackupDirectory getBackupDirectory() throws IOException, ConfigException {
            long currentModified = this.backupInfo.lastModified();
            if (this.backupDirectory == null || currentModified != this.lastModified) {
                this.backupDirectory = BackupDirectory.readBackupDirectoryDescriptor(this.directoryPath);
                this.lastModified = currentModified;
            }
            return this.backupDirectory;
        }
    }
}

