/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Transaction;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.opends.server.backends.jeb.AttributeIndex;
import org.opends.server.backends.jeb.EntryContainer;
import org.opends.server.backends.jeb.EntryIDSet;
import org.opends.server.backends.jeb.Index;
import org.opends.server.backends.jeb.SortValues;
import org.opends.server.backends.jeb.VLVIndex;
import org.opends.server.types.DirectoryException;

public class IndexBuffer {
    private EntryContainer entryContainer;
    private LinkedHashMap<Index, TreeMap<byte[], BufferedIndexValues>> bufferedIndexes = new LinkedHashMap();
    private LinkedHashMap<VLVIndex, BufferedVLVValues> bufferedVLVIndexes = new LinkedHashMap();

    public IndexBuffer(EntryContainer entryContainer) {
        this.entryContainer = entryContainer;
    }

    public TreeMap<byte[], BufferedIndexValues> getBufferedIndex(Index index) {
        return this.bufferedIndexes.get(index);
    }

    public void putBufferedIndex(Index index, TreeMap<byte[], BufferedIndexValues> bufferedValues) {
        this.bufferedIndexes.put(index, bufferedValues);
    }

    public BufferedVLVValues getVLVIndex(VLVIndex vlvIndex) {
        return this.bufferedVLVIndexes.get(vlvIndex);
    }

    public void putBufferedVLVIndex(VLVIndex vlvIndex, BufferedVLVValues bufferedVLVValues) {
        this.bufferedVLVIndexes.put(vlvIndex, bufferedVLVValues);
    }

    public void flush(Transaction txn) throws DatabaseException, DirectoryException {
        Index id2subtree;
        byte[] keyBytes;
        TreeMap bufferedValues;
        DatabaseEntry key = new DatabaseEntry();
        for (AttributeIndex attributeIndex : this.entryContainer.getAttributeIndexes()) {
            for (Index index : attributeIndex.getAllIndexes()) {
                bufferedValues = (TreeMap)this.bufferedIndexes.remove(index);
                if (bufferedValues == null) continue;
                Iterator keyIterator = bufferedValues.entrySet().iterator();
                while (keyIterator.hasNext()) {
                    Map.Entry bufferedKey = keyIterator.next();
                    keyBytes = (byte[])bufferedKey.getKey();
                    key.setData(keyBytes);
                    index.updateKey(txn, key, ((BufferedIndexValues)bufferedKey.getValue()).deletedIDs, ((BufferedIndexValues)bufferedKey.getValue()).addedIDs);
                    keyIterator.remove();
                }
            }
        }
        for (VLVIndex vlvIndex : this.entryContainer.getVLVIndexes()) {
            BufferedVLVValues bufferedVLVValues = (BufferedVLVValues)this.bufferedVLVIndexes.remove(vlvIndex);
            if (bufferedVLVValues == null) continue;
            vlvIndex.updateIndex(txn, bufferedVLVValues.addedValues, bufferedVLVValues.deletedValues);
        }
        Index id2children = this.entryContainer.getID2Children();
        bufferedValues = (TreeMap)this.bufferedIndexes.remove(id2children);
        if (bufferedValues != null) {
            Iterator keyIterator = bufferedValues.entrySet().iterator();
            while (keyIterator.hasNext()) {
                Map.Entry bufferedKey = keyIterator.next();
                keyBytes = (byte[])bufferedKey.getKey();
                key.setData(keyBytes);
                id2children.updateKey(txn, key, ((BufferedIndexValues)bufferedKey.getValue()).deletedIDs, ((BufferedIndexValues)bufferedKey.getValue()).addedIDs);
                keyIterator.remove();
            }
        }
        if ((bufferedValues = (TreeMap)this.bufferedIndexes.remove(id2subtree = this.entryContainer.getID2Subtree())) != null) {
            Iterator keyIterator = bufferedValues.descendingMap().entrySet().iterator();
            while (keyIterator.hasNext()) {
                Map.Entry bufferedKey = keyIterator.next();
                keyBytes = (byte[])bufferedKey.getKey();
                key.setData(keyBytes);
                id2subtree.updateKey(txn, key, ((BufferedIndexValues)bufferedKey.getValue()).deletedIDs, ((BufferedIndexValues)bufferedKey.getValue()).addedIDs);
                keyIterator.remove();
            }
        }
    }

    public static class BufferedVLVValues {
        TreeSet<SortValues> addedValues;
        TreeSet<SortValues> deletedValues;
    }

    public static class BufferedIndexValues {
        EntryIDSet addedIDs;
        EntryIDSet deletedIDs;
    }
}

