/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.opends.messages.JebMessages;
import org.opends.server.backends.jeb.AttributeIndex;
import org.opends.server.backends.jeb.EntryContainer;
import org.opends.server.backends.jeb.EntryIDSet;
import org.opends.server.backends.jeb.IndexQuery;
import org.opends.server.core.SearchOperation;
import org.opends.server.monitors.DatabaseEnvironmentMonitor;
import org.opends.server.types.AttributeType;
import org.opends.server.types.FilterType;
import org.opends.server.types.SearchFilter;

public class IndexFilter {
    public static final int FILTER_CANDIDATE_THRESHOLD = 10;
    private final EntryContainer entryContainer;
    private final SearchOperation searchOp;
    private final StringBuilder buffer;
    private final DatabaseEnvironmentMonitor monitor;

    public IndexFilter(EntryContainer entryContainer, SearchOperation searchOp, StringBuilder debugBuilder, DatabaseEnvironmentMonitor monitor) {
        this.entryContainer = entryContainer;
        this.searchOp = searchOp;
        this.buffer = debugBuilder;
        this.monitor = monitor;
    }

    public EntryIDSet evaluate() {
        if (this.buffer != null) {
            this.buffer.append("filter=");
        }
        return this.evaluateFilter(this.searchOp.getFilter());
    }

    private EntryIDSet evaluateFilter(SearchFilter filter) {
        EntryIDSet candidates;
        switch (filter.getFilterType()) {
            case AND: {
                if (this.buffer != null) {
                    this.buffer.append("(&");
                }
                candidates = this.evaluateLogicalAndFilter(filter);
                if (this.buffer == null) break;
                this.buffer.append(")");
                break;
            }
            case OR: {
                if (this.buffer != null) {
                    this.buffer.append("(|");
                }
                candidates = this.evaluateLogicalOrFilter(filter);
                if (this.buffer == null) break;
                this.buffer.append(")");
                break;
            }
            case EQUALITY: {
                if (this.buffer != null) {
                    filter.toString(this.buffer);
                }
                candidates = this.evaluateEqualityFilter(filter);
                break;
            }
            case GREATER_OR_EQUAL: {
                if (this.buffer != null) {
                    filter.toString(this.buffer);
                }
                candidates = this.evaluateGreaterOrEqualFilter(filter);
                break;
            }
            case SUBSTRING: {
                if (this.buffer != null) {
                    filter.toString(this.buffer);
                }
                candidates = this.evaluateSubstringFilter(filter);
                break;
            }
            case LESS_OR_EQUAL: {
                if (this.buffer != null) {
                    filter.toString(this.buffer);
                }
                candidates = this.evaluateLessOrEqualFilter(filter);
                break;
            }
            case PRESENT: {
                if (this.buffer != null) {
                    filter.toString(this.buffer);
                }
                candidates = this.evaluatePresenceFilter(filter);
                break;
            }
            case APPROXIMATE_MATCH: {
                if (this.buffer != null) {
                    filter.toString(this.buffer);
                }
                candidates = this.evaluateApproximateFilter(filter);
                break;
            }
            case EXTENSIBLE_MATCH: {
                if (this.buffer != null) {
                    filter.toString(this.buffer);
                }
                candidates = this.evaluateExtensibleFilter(filter);
                break;
            }
            default: {
                if (this.buffer != null) {
                    filter.toString(this.buffer);
                }
                candidates = new EntryIDSet();
            }
        }
        if (this.buffer != null) {
            candidates.toString(this.buffer);
        }
        return candidates;
    }

    private EntryIDSet evaluateLogicalAndFilter(SearchFilter andFilter) {
        EntryIDSet set;
        ArrayList rangeList;
        EntryIDSet results = new EntryIDSet();
        ArrayList<SearchFilter> fastComps = new ArrayList<SearchFilter>();
        ArrayList<SearchFilter> otherComps = new ArrayList<SearchFilter>();
        HashMap<AttributeType, ArrayList> rangeComps = new HashMap<AttributeType, ArrayList>();
        for (SearchFilter filter : andFilter.getFilterComponents()) {
            FilterType filterType = filter.getFilterType();
            if (filterType == FilterType.GREATER_OR_EQUAL || filterType == FilterType.LESS_OR_EQUAL) {
                rangeList = (ArrayList)rangeComps.get(filter.getAttributeType());
                if (rangeList == null) {
                    rangeList = new ArrayList();
                    rangeComps.put(filter.getAttributeType(), rangeList);
                }
                rangeList.add(filter);
                continue;
            }
            if (filterType == FilterType.EQUALITY || filterType == FilterType.PRESENT || filterType == FilterType.APPROXIMATE_MATCH) {
                fastComps.add(filter);
                continue;
            }
            otherComps.add(filter);
        }
        for (SearchFilter filter : fastComps) {
            set = this.evaluateFilter(filter);
            if (!this.retainAll(results, set)) continue;
            return results;
        }
        for (SearchFilter filter : otherComps) {
            set = this.evaluateFilter(filter);
            if (!this.retainAll(results, set)) continue;
            return results;
        }
        if (rangeComps.isEmpty()) {
            return results;
        }
        ArrayList<SearchFilter> remainComps = new ArrayList<SearchFilter>();
        for (Map.Entry rangeEntry : rangeComps.entrySet()) {
            rangeList = (ArrayList)rangeEntry.getValue();
            if (rangeList.size() == 2) {
                EntryIDSet set2;
                SearchFilter a = (SearchFilter)rangeList.get(0);
                SearchFilter b = (SearchFilter)rangeList.get(1);
                AttributeIndex attributeIndex = this.entryContainer.getAttributeIndex((AttributeType)rangeEntry.getKey());
                if (attributeIndex == null) {
                    if (!this.monitor.isFilterUseEnabled()) continue;
                    this.monitor.updateStats(SearchFilter.createANDFilter(rangeList), JebMessages.INFO_JEB_INDEX_FILTER_INDEX_TYPE_DISABLED.get("ordering", ((AttributeType)rangeEntry.getKey()).getNameOrOID()));
                    continue;
                }
                if (a.getFilterType() == FilterType.GREATER_OR_EQUAL && b.getFilterType() == FilterType.LESS_OR_EQUAL) {
                    set2 = attributeIndex.evaluateBoundedRange(a.getAssertionValue(), b.getAssertionValue());
                    if (this.buffer != null) {
                        a.toString(this.buffer);
                        b.toString(this.buffer);
                        set2.toString(this.buffer);
                    }
                    if (this.monitor.isFilterUseEnabled()) {
                        if (set2.isDefined()) {
                            this.monitor.updateStats(SearchFilter.createANDFilter(rangeList), set2.size());
                        } else if (!attributeIndex.orderingIndex.isTrusted()) {
                            this.monitor.updateStats(SearchFilter.createANDFilter(rangeList), JebMessages.INFO_JEB_INDEX_FILTER_INDEX_NOT_TRUSTED.get(attributeIndex.orderingIndex.getName()));
                        } else if (attributeIndex.orderingIndex.isRebuildRunning()) {
                            this.monitor.updateStats(SearchFilter.createANDFilter(rangeList), JebMessages.INFO_JEB_INDEX_FILTER_INDEX_REBUILD_IN_PROGRESS.get(attributeIndex.orderingIndex.getName()));
                        } else {
                            this.monitor.updateStats(SearchFilter.createANDFilter(rangeList), JebMessages.INFO_JEB_INDEX_FILTER_INDEX_LIMIT_EXCEEDED.get(attributeIndex.orderingIndex.getName()));
                        }
                    }
                    if (!this.retainAll(results, set2)) continue;
                    return results;
                }
                if (a.getFilterType() == FilterType.LESS_OR_EQUAL && b.getFilterType() == FilterType.GREATER_OR_EQUAL) {
                    set2 = attributeIndex.evaluateBoundedRange(b.getAssertionValue(), a.getAssertionValue());
                    if (this.buffer != null) {
                        a.toString(this.buffer);
                        b.toString(this.buffer);
                        set2.toString(this.buffer);
                    }
                    if (this.monitor.isFilterUseEnabled()) {
                        if (set2.isDefined()) {
                            this.monitor.updateStats(SearchFilter.createANDFilter(rangeList), set2.size());
                        } else if (!attributeIndex.orderingIndex.isTrusted()) {
                            this.monitor.updateStats(SearchFilter.createANDFilter(rangeList), JebMessages.INFO_JEB_INDEX_FILTER_INDEX_NOT_TRUSTED.get(attributeIndex.orderingIndex.getName()));
                        } else if (attributeIndex.orderingIndex.isRebuildRunning()) {
                            this.monitor.updateStats(SearchFilter.createANDFilter(rangeList), JebMessages.INFO_JEB_INDEX_FILTER_INDEX_REBUILD_IN_PROGRESS.get(attributeIndex.orderingIndex.getName()));
                        } else {
                            this.monitor.updateStats(SearchFilter.createANDFilter(rangeList), JebMessages.INFO_JEB_INDEX_FILTER_INDEX_LIMIT_EXCEEDED.get(attributeIndex.orderingIndex.getName()));
                        }
                    }
                    if (!this.retainAll(results, set2)) continue;
                    return results;
                }
            }
            for (SearchFilter filter : rangeList) {
                remainComps.add(filter);
            }
        }
        for (SearchFilter filter : remainComps) {
            EntryIDSet set3 = this.evaluateFilter(filter);
            if (!this.retainAll(results, set3)) continue;
            return results;
        }
        return results;
    }

    private boolean retainAll(EntryIDSet a, EntryIDSet b) {
        a.retainAll(b);
        return a.isDefined() && a.size() <= 10L;
    }

    private EntryIDSet evaluateLogicalOrFilter(SearchFilter orFilter) {
        ArrayList<EntryIDSet> candidateSets = new ArrayList<EntryIDSet>(orFilter.getFilterComponents().size());
        for (SearchFilter filter : orFilter.getFilterComponents()) {
            EntryIDSet set = this.evaluateFilter(filter);
            if (!set.isDefined()) {
                return set;
            }
            candidateSets.add(set);
        }
        return EntryIDSet.unionOfSets(candidateSets, false);
    }

    private EntryIDSet evaluateEqualityFilter(SearchFilter equalityFilter) {
        EntryIDSet candidates;
        AttributeIndex attributeIndex = this.entryContainer.getAttributeIndex(equalityFilter.getAttributeType());
        if (attributeIndex == null) {
            if (this.monitor.isFilterUseEnabled()) {
                this.monitor.updateStats(equalityFilter, JebMessages.INFO_JEB_INDEX_FILTER_INDEX_TYPE_DISABLED.get("equality", equalityFilter.getAttributeType().getNameOrOID()));
            }
            candidates = new EntryIDSet();
        } else {
            candidates = attributeIndex.evaluateEqualityFilter(equalityFilter, this.buffer, this.monitor);
        }
        return candidates;
    }

    private EntryIDSet evaluatePresenceFilter(SearchFilter filter) {
        EntryIDSet candidates;
        AttributeIndex attributeIndex = this.entryContainer.getAttributeIndex(filter.getAttributeType());
        if (attributeIndex == null) {
            if (this.monitor.isFilterUseEnabled()) {
                this.monitor.updateStats(filter, JebMessages.INFO_JEB_INDEX_FILTER_INDEX_TYPE_DISABLED.get("presence", filter.getAttributeType().getNameOrOID()));
            }
            candidates = new EntryIDSet();
        } else {
            candidates = attributeIndex.evaluatePresenceFilter(filter, this.buffer, this.monitor);
        }
        return candidates;
    }

    private EntryIDSet evaluateGreaterOrEqualFilter(SearchFilter filter) {
        EntryIDSet candidates;
        AttributeIndex attributeIndex = this.entryContainer.getAttributeIndex(filter.getAttributeType());
        if (attributeIndex == null) {
            if (this.monitor.isFilterUseEnabled()) {
                this.monitor.updateStats(filter, JebMessages.INFO_JEB_INDEX_FILTER_INDEX_TYPE_DISABLED.get("ordering", filter.getAttributeType().getNameOrOID()));
            }
            candidates = new EntryIDSet();
        } else {
            candidates = attributeIndex.evaluateGreaterOrEqualFilter(filter, this.buffer, this.monitor);
        }
        return candidates;
    }

    private EntryIDSet evaluateLessOrEqualFilter(SearchFilter filter) {
        EntryIDSet candidates;
        AttributeIndex attributeIndex = this.entryContainer.getAttributeIndex(filter.getAttributeType());
        if (attributeIndex == null) {
            if (this.monitor.isFilterUseEnabled()) {
                this.monitor.updateStats(filter, JebMessages.INFO_JEB_INDEX_FILTER_INDEX_TYPE_DISABLED.get("ordering", filter.getAttributeType().getNameOrOID()));
            }
            candidates = new EntryIDSet();
        } else {
            candidates = attributeIndex.evaluateLessOrEqualFilter(filter, this.buffer, this.monitor);
        }
        return candidates;
    }

    private EntryIDSet evaluateSubstringFilter(SearchFilter filter) {
        EntryIDSet candidates;
        AttributeIndex attributeIndex = this.entryContainer.getAttributeIndex(filter.getAttributeType());
        if (attributeIndex == null) {
            if (this.monitor.isFilterUseEnabled()) {
                this.monitor.updateStats(filter, JebMessages.INFO_JEB_INDEX_FILTER_INDEX_TYPE_DISABLED.get("substring or equality", filter.getAttributeType().getNameOrOID()));
            }
            candidates = new EntryIDSet();
        } else {
            candidates = attributeIndex.evaluateSubstringFilter(filter, this.buffer, this.monitor);
        }
        return candidates;
    }

    private EntryIDSet evaluateApproximateFilter(SearchFilter approximateFilter) {
        EntryIDSet candidates;
        AttributeIndex attributeIndex = this.entryContainer.getAttributeIndex(approximateFilter.getAttributeType());
        if (attributeIndex == null) {
            if (this.monitor.isFilterUseEnabled()) {
                this.monitor.updateStats(approximateFilter, JebMessages.INFO_JEB_INDEX_FILTER_INDEX_TYPE_DISABLED.get("approximate", approximateFilter.getAttributeType().getNameOrOID()));
            }
            candidates = new EntryIDSet();
        } else {
            candidates = attributeIndex.evaluateApproximateFilter(approximateFilter, this.buffer, this.monitor);
        }
        return candidates;
    }

    private EntryIDSet evaluateExtensibleFilter(SearchFilter extensibleFilter) {
        AttributeIndex attributeIndex;
        EntryIDSet candidates = extensibleFilter.getDNAttributes() ? IndexQuery.createNullIndexQuery().evaluate(null) : ((attributeIndex = this.entryContainer.getAttributeIndex(extensibleFilter.getAttributeType())) == null ? IndexQuery.createNullIndexQuery().evaluate(null) : attributeIndex.evaluateExtensibleFilter(extensibleFilter, this.buffer, this.monitor));
        return candidates;
    }
}

