/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import java.util.Collection;
import java.util.List;
import org.opends.messages.Message;
import org.opends.server.backends.jeb.EntryIDSet;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;

@PublicAPI(stability=StabilityLevel.VOLATILE, mayInstantiate=false, mayExtend=true, mayInvoke=false)
public abstract class IndexQuery {
    public abstract EntryIDSet evaluate(List<Message> var1);

    public static IndexQuery createIntersectionIndexQuery(Collection<IndexQuery> subIndexQueries) {
        return new IntersectionIndexQuery(subIndexQueries);
    }

    public static IndexQuery createUnionIndexQuery(Collection<IndexQuery> subIndexQueries) {
        return new UnionIndexQuery(subIndexQueries);
    }

    public static IndexQuery createNullIndexQuery() {
        return new NullIndexQuery();
    }

    private static final class UnionIndexQuery
    extends IndexQuery {
        private final Collection<IndexQuery> subIndexQueries;

        private UnionIndexQuery(Collection<IndexQuery> subIndexQueries) {
            this.subIndexQueries = subIndexQueries;
        }

        @Override
        public EntryIDSet evaluate(List<Message> debugMessages) {
            EntryIDSet entryIDs = null;
            for (IndexQuery query : this.subIndexQueries) {
                if (entryIDs == null) {
                    entryIDs = query.evaluate(debugMessages);
                } else {
                    entryIDs.addAll(query.evaluate(debugMessages));
                }
                if (!entryIDs.isDefined() || entryIDs.size() > 10L) continue;
                break;
            }
            return entryIDs;
        }
    }

    private static final class IntersectionIndexQuery
    extends IndexQuery {
        private final Collection<IndexQuery> subIndexQueries;

        private IntersectionIndexQuery(Collection<IndexQuery> subIndexQueries) {
            this.subIndexQueries = subIndexQueries;
        }

        @Override
        public EntryIDSet evaluate(List<Message> debugMessages) {
            EntryIDSet entryIDs = null;
            for (IndexQuery query : this.subIndexQueries) {
                if (entryIDs == null) {
                    entryIDs = query.evaluate(debugMessages);
                } else {
                    entryIDs.retainAll(query.evaluate(debugMessages));
                }
                if (!entryIDs.isDefined() || entryIDs.size() > 10L) continue;
                break;
            }
            return entryIDs;
        }
    }

    private static final class NullIndexQuery
    extends IndexQuery {
        private NullIndexQuery() {
        }

        @Override
        public EntryIDSet evaluate(List<Message> debugMessages) {
            return new EntryIDSet();
        }
    }
}

