/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import java.util.Iterator;
import java.util.TreeSet;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.ByteStringBuilder;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.RDN;
import org.opends.server.util.StaticUtils;

public class JebFormat {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    public static final byte FORMAT_VERSION = 1;
    public static final byte TAG_DATABASE_ENTRY = 96;
    public static final byte TAG_DIRECTORY_SERVER_ENTRY = 97;

    public static long entryIDFromDatabase(byte[] bytes) {
        long v = 0L;
        for (int i = 0; i < 8; ++i) {
            v <<= 8;
            v |= (long)(bytes[i] & 0xFF);
        }
        return v;
    }

    public static long entryIDUndefinedSizeFromDatabase(byte[] bytes) {
        if (bytes == null) {
            return 0L;
        }
        if (bytes.length == 8) {
            long v = 0L;
            v |= (long)(bytes[0] & 0x7F);
            for (int i = 1; i < 8; ++i) {
                v <<= 8;
                v |= (long)(bytes[i] & 0xFF);
            }
            return v;
        }
        return Long.MAX_VALUE;
    }

    public static long[] entryIDListFromDatabase(byte[] bytes) {
        byte[] decodedBytes = bytes;
        int count = decodedBytes.length / 8;
        long[] entryIDList = new long[count];
        int pos = 0;
        for (int i = 0; i < count; ++i) {
            long v = 0L;
            v |= ((long)decodedBytes[pos++] & 0xFFL) << 56;
            v |= ((long)decodedBytes[pos++] & 0xFFL) << 48;
            v |= ((long)decodedBytes[pos++] & 0xFFL) << 40;
            v |= ((long)decodedBytes[pos++] & 0xFFL) << 32;
            v |= ((long)decodedBytes[pos++] & 0xFFL) << 24;
            v |= ((long)decodedBytes[pos++] & 0xFFL) << 16;
            v |= ((long)decodedBytes[pos++] & 0xFFL) << 8;
            entryIDList[i] = v |= (long)decodedBytes[pos++] & 0xFFL;
        }
        return entryIDList;
    }

    public static int[] intArrayFromDatabaseBytes(byte[] bytes) {
        byte[] decodedBytes = bytes;
        int count = decodedBytes.length / 8;
        int[] entryIDList = new int[count];
        int pos = 0;
        for (int i = 0; i < count; ++i) {
            int v = 0;
            pos += 4;
            v = (int)((long)v | ((long)decodedBytes[pos++] & 0xFFL) << 24);
            v = (int)((long)v | ((long)decodedBytes[pos++] & 0xFFL) << 16);
            v = (int)((long)v | ((long)decodedBytes[pos++] & 0xFFL) << 8);
            entryIDList[i] = v = (int)((long)v | (long)decodedBytes[pos++] & 0xFFL);
        }
        return entryIDList;
    }

    public static byte[] entryIDToDatabase(long id) {
        byte[] bytes = new byte[8];
        long v = id;
        for (int i = 7; i >= 0; --i) {
            bytes[i] = (byte)(v & 0xFFL);
            v >>>= 8;
        }
        return bytes;
    }

    public static byte[] entryIDUndefinedSizeToDatabase(long count) {
        byte[] bytes = new byte[8];
        long v = count;
        for (int i = 7; i >= 1; --i) {
            bytes[i] = (byte)(v & 0xFFL);
            v >>>= 8;
        }
        bytes[0] = (byte)((v | 0x80L) & 0xFFL);
        return bytes;
    }

    public static byte[] entryIDListToDatabase(long[] entryIDArray) {
        if (entryIDArray.length == 0) {
            return null;
        }
        byte[] bytes = new byte[8 * entryIDArray.length];
        int pos = 0;
        for (int i = 0; i < entryIDArray.length; ++i) {
            long v = entryIDArray[i];
            bytes[pos++] = (byte)(v >>> 56 & 0xFFL);
            bytes[pos++] = (byte)(v >>> 48 & 0xFFL);
            bytes[pos++] = (byte)(v >>> 40 & 0xFFL);
            bytes[pos++] = (byte)(v >>> 32 & 0xFFL);
            bytes[pos++] = (byte)(v >>> 24 & 0xFFL);
            bytes[pos++] = (byte)(v >>> 16 & 0xFFL);
            bytes[pos++] = (byte)(v >>> 8 & 0xFFL);
            bytes[pos++] = (byte)(v & 0xFFL);
        }
        return bytes;
    }

    public static DN dnFromDNKey(byte[] dnKey, int offset, int length, DN prefix) throws DirectoryException {
        DN dn = prefix;
        int start = offset;
        boolean escaped = false;
        ByteStringBuilder buffer = new ByteStringBuilder();
        for (int i = start; i < length; ++i) {
            if (dnKey[i] == 92) {
                escaped = true;
                continue;
            }
            if (!escaped && dnKey[i] == 1) {
                buffer.append(1);
                escaped = false;
                continue;
            }
            if (!escaped && dnKey[i] == 0) {
                if (buffer.length() <= 0) continue;
                dn = dn.concat(RDN.decode(buffer.toString()));
                buffer.clear();
                continue;
            }
            if (escaped) {
                buffer.append(92);
                escaped = false;
            }
            buffer.append(dnKey[i]);
        }
        if (buffer.length() > 0) {
            dn = dn.concat(RDN.decode(buffer.toString()));
        }
        return dn;
    }

    public static int findDNKeyParent(byte[] dnKey, int offset, int length) {
        if (length == 0) {
            return -1;
        }
        for (int i = offset + length - 1; i >= offset; --i) {
            if (dnKey[i] != 0 || i - 1 < offset || dnKey[i - 1] == 92) continue;
            return i;
        }
        return offset;
    }

    public static byte[] dnToDNKey(DN dn, int prefixRDNs) {
        StringBuilder buffer = new StringBuilder();
        for (int i = dn.getNumComponents() - prefixRDNs - 1; i >= 0; --i) {
            buffer.append('\u0000');
            JebFormat.formatRDNKey(dn.getRDN(i), buffer);
        }
        return StaticUtils.getBytes(buffer.toString());
    }

    private static void formatRDNKey(RDN rdn, StringBuilder buffer) {
        if (!rdn.isMultiValued()) {
            rdn.toNormalizedString(buffer);
        } else {
            TreeSet<String> rdnElementStrings = new TreeSet<String>();
            for (int i = 0; i < rdn.getNumValues(); ++i) {
                StringBuilder b2 = new StringBuilder();
                rdn.getAVAString(i, b2);
                rdnElementStrings.add(b2.toString());
            }
            Iterator iterator = rdnElementStrings.iterator();
            buffer.append(((String)iterator.next()).replace("\u0001", "\\\u0001"));
            while (iterator.hasNext()) {
                buffer.append('\u0001');
                buffer.append(((String)iterator.next()).replace("\u0001", "\\\u0001"));
            }
        }
    }
}

