/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DiskOrderedCursor;
import com.sleepycat.je.DiskOrderedCursorConfig;
import com.sleepycat.je.EnvironmentStats;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.Transaction;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import org.opends.messages.JebMessages;
import org.opends.messages.Message;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.backends.jeb.AttributeIndex;
import org.opends.server.backends.jeb.DN2ID;
import org.opends.server.backends.jeb.EntryContainer;
import org.opends.server.backends.jeb.EntryID;
import org.opends.server.backends.jeb.EntryIDSet;
import org.opends.server.backends.jeb.ID2Entry;
import org.opends.server.backends.jeb.Index;
import org.opends.server.backends.jeb.JebException;
import org.opends.server.backends.jeb.JebFormat;
import org.opends.server.backends.jeb.RootContainer;
import org.opends.server.backends.jeb.SortValues;
import org.opends.server.backends.jeb.SortValuesSet;
import org.opends.server.backends.jeb.VLVIndex;
import org.opends.server.backends.jeb.VerifyConfig;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.Attributes;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConditionResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;

public class VerifyJob {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private VerifyConfig verifyConfig;
    RootContainer rootContainer;
    private long progressInterval = 10000L;
    private long keyCount = 0L;
    private long errorCount = 0L;
    long entryLimitExceededCount = 0L;
    long multiReferenceCount = 0L;
    long entryReferencesCount = 0L;
    long maxEntryPerValue = 0L;
    IdentityHashMap<Index, HashMap<ByteString, Long>> entryLimitMap = new IdentityHashMap();
    private boolean verifyDN2ID = false;
    private boolean verifyID2Children = false;
    private boolean verifyID2Subtree = false;
    ID2Entry id2entry = null;
    DN2ID dn2id = null;
    Index id2c = null;
    Index id2s = null;
    ArrayList<AttributeIndex> attrIndexList = new ArrayList();
    ArrayList<VLVIndex> vlvIndexList = new ArrayList();

    public VerifyJob(VerifyConfig verifyConfig) {
        this.verifyConfig = verifyConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long verifyBackend(RootContainer rootContainer, Entry statEntry) throws DatabaseException, JebException, DirectoryException {
        this.rootContainer = rootContainer;
        EntryContainer entryContainer = rootContainer.getEntryContainer(this.verifyConfig.getBaseDN());
        entryContainer.sharedLock.lock();
        try {
            ArrayList<String> completeList = this.verifyConfig.getCompleteList();
            ArrayList<String> cleanList = this.verifyConfig.getCleanList();
            boolean cleanMode = false;
            if (completeList.isEmpty() && cleanList.isEmpty()) {
                this.verifyDN2ID = true;
                if (rootContainer.getConfiguration().isSubordinateIndexesEnabled()) {
                    this.verifyID2Children = true;
                    this.verifyID2Subtree = true;
                }
                this.attrIndexList.addAll(entryContainer.getAttributeIndexes());
            } else {
                ArrayList<String> list;
                if (!completeList.isEmpty()) {
                    list = completeList;
                } else {
                    list = cleanList;
                    cleanMode = true;
                }
                for (String index : list) {
                    Message msg;
                    Message msg2;
                    String lowerName = index.toLowerCase();
                    if (lowerName.equals("dn2id")) {
                        this.verifyDN2ID = true;
                        continue;
                    }
                    if (lowerName.equals("id2children")) {
                        if (rootContainer.getConfiguration().isSubordinateIndexesEnabled()) {
                            this.verifyID2Children = true;
                            continue;
                        }
                        msg2 = JebMessages.NOTE_JEB_SUBORDINATE_INDEXES_DISABLED.get(rootContainer.getConfiguration().getBackendId());
                        throw new JebException(msg2);
                    }
                    if (lowerName.equals("id2subtree")) {
                        if (rootContainer.getConfiguration().isSubordinateIndexesEnabled()) {
                            this.verifyID2Subtree = true;
                            continue;
                        }
                        msg2 = JebMessages.NOTE_JEB_SUBORDINATE_INDEXES_DISABLED.get(rootContainer.getConfiguration().getBackendId());
                        throw new JebException(msg2);
                    }
                    if (lowerName.startsWith("vlv.")) {
                        if (lowerName.length() < 5) {
                            msg2 = JebMessages.ERR_JEB_VLV_INDEX_NOT_CONFIGURED.get(lowerName);
                            throw new JebException(msg2);
                        }
                        VLVIndex vlvIndex = entryContainer.getVLVIndex(lowerName.substring(4));
                        if (vlvIndex == null) {
                            msg = JebMessages.ERR_JEB_VLV_INDEX_NOT_CONFIGURED.get(lowerName.substring(4));
                            throw new JebException(msg);
                        }
                        this.vlvIndexList.add(vlvIndex);
                        continue;
                    }
                    AttributeType attrType = DirectoryServer.getAttributeType(lowerName);
                    if (attrType == null) {
                        msg = JebMessages.ERR_JEB_ATTRIBUTE_INDEX_NOT_CONFIGURED.get(index);
                        throw new JebException(msg);
                    }
                    AttributeIndex attrIndex = entryContainer.getAttributeIndex(attrType);
                    if (attrIndex == null) {
                        Message msg3 = JebMessages.ERR_JEB_ATTRIBUTE_INDEX_NOT_CONFIGURED.get(index);
                        throw new JebException(msg3);
                    }
                    this.attrIndexList.add(attrIndex);
                }
            }
            this.entryLimitMap = new IdentityHashMap(this.attrIndexList.size());
            this.id2entry = entryContainer.getID2Entry();
            this.dn2id = entryContainer.getDN2ID();
            this.id2c = entryContainer.getID2Children();
            this.id2s = entryContainer.getID2Subtree();
            long startTime = System.currentTimeMillis();
            Timer timer = new Timer();
            ProgressTask progressTask = new ProgressTask();
            if (cleanMode) {
                progressTask = new ProgressTask(true);
            }
            timer.scheduleAtFixedRate((TimerTask)progressTask, this.progressInterval, this.progressInterval);
            try {
                if (cleanMode) {
                    this.iterateIndex();
                } else {
                    this.iterateID2Entry();
                    for (VLVIndex vlvIndex : this.vlvIndexList) {
                        this.iterateVLVIndex(vlvIndex, false);
                    }
                }
            }
            finally {
                timer.cancel();
            }
            long finishTime = System.currentTimeMillis();
            long totalTime = finishTime - startTime;
            float rate = 0.0f;
            if (totalTime > 0L) {
                rate = 1000.0f * (float)this.keyCount / (float)totalTime;
            }
            this.addStatEntry(statEntry, "verify-error-count", String.valueOf(this.errorCount));
            this.addStatEntry(statEntry, "verify-key-count", String.valueOf(this.keyCount));
            if (cleanMode) {
                Message message = JebMessages.NOTE_JEB_VERIFY_CLEAN_FINAL_STATUS.get(this.keyCount, this.errorCount, totalTime / 1000L, Float.valueOf(rate));
                ErrorLogger.logError(message);
                if (this.multiReferenceCount > 0L) {
                    float averageEntryReferences = 0.0f;
                    if (this.keyCount > 0L) {
                        averageEntryReferences = (float)this.entryReferencesCount / (float)this.keyCount;
                    }
                    message = JebMessages.INFO_JEB_VERIFY_MULTIPLE_REFERENCE_COUNT.get(this.multiReferenceCount);
                    ErrorLogger.logError(message);
                    this.addStatEntry(statEntry, "verify-multiple-reference-count", String.valueOf(this.multiReferenceCount));
                    message = JebMessages.INFO_JEB_VERIFY_ENTRY_LIMIT_EXCEEDED_COUNT.get(this.entryLimitExceededCount);
                    ErrorLogger.logError(message);
                    this.addStatEntry(statEntry, "verify-entry-limit-exceeded-count", String.valueOf(this.entryLimitExceededCount));
                    message = JebMessages.INFO_JEB_VERIFY_AVERAGE_REFERENCE_COUNT.get(Float.valueOf(averageEntryReferences));
                    ErrorLogger.logError(message);
                    this.addStatEntry(statEntry, "verify-average-reference-count", String.valueOf(averageEntryReferences));
                    message = JebMessages.INFO_JEB_VERIFY_MAX_REFERENCE_COUNT.get(this.maxEntryPerValue);
                    ErrorLogger.logError(message);
                    this.addStatEntry(statEntry, "verify-max-reference-count", String.valueOf(this.maxEntryPerValue));
                }
            } else {
                Message message = JebMessages.NOTE_JEB_VERIFY_FINAL_STATUS.get(this.keyCount, this.errorCount, totalTime / 1000L, Float.valueOf(rate));
                ErrorLogger.logError(message);
                if (this.entryLimitMap.size() > 0) {
                    message = JebMessages.INFO_JEB_VERIFY_ENTRY_LIMIT_STATS_HEADER.get();
                    ErrorLogger.logError(message);
                    for (Map.Entry<Index, HashMap<ByteString, Long>> mapEntry : this.entryLimitMap.entrySet()) {
                        Index index = mapEntry.getKey();
                        Object[] values = mapEntry.getValue().values().toArray(new Long[0]);
                        Arrays.sort(values);
                        int x = values.length / 2;
                        long medianValue = values.length % 2 == 0 ? ((Long)values[x] + (Long)values[x - 1]) / 2L : (Long)values[x];
                        message = JebMessages.INFO_JEB_VERIFY_ENTRY_LIMIT_STATS_ROW.get(index.toString(), values.length, (Number)values[0], (Number)values[values.length - 1], medianValue);
                        ErrorLogger.logError(message);
                    }
                }
            }
        }
        finally {
            entryContainer.sharedLock.unlock();
        }
        return this.errorCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void iterateID2Entry() throws DatabaseException {
        DiskOrderedCursor cursor = this.id2entry.openCursor(new DiskOrderedCursorConfig());
        try {
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            Long storedEntryCount = this.id2entry.getRecordCount();
            while (cursor.getNext(key, data, null) == OperationStatus.SUCCESS) {
                Entry entry;
                EntryID entryID;
                try {
                    entryID = new EntryID(key);
                }
                catch (Exception e) {
                    ++this.errorCount;
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    TRACER.debugError("Malformed id2entry ID %s.%n", StaticUtils.bytesToHex(key.getData()));
                    continue;
                }
                ++this.keyCount;
                try {
                    entry = ID2Entry.entryFromDatabase(ByteString.wrap(data.getData()), this.rootContainer.getCompressedSchema());
                }
                catch (Exception e) {
                    ++this.errorCount;
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    TRACER.debugError("Malformed id2entry record for ID %d:%n%s%n", entryID.longValue(), StaticUtils.bytesToHex(data.getData()));
                    continue;
                }
                this.verifyEntry(entryID, entry);
            }
            if (this.keyCount != storedEntryCount) {
                ++this.errorCount;
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugError("The stored entry count in id2entry (%d) does not agree with the actual number of entry records found (%d).%n", storedEntryCount, this.keyCount);
                }
            }
        }
        finally {
            cursor.close();
        }
    }

    private void iterateIndex() throws JebException, DatabaseException, DirectoryException {
        if (this.verifyDN2ID) {
            this.iterateDN2ID();
        } else if (this.verifyID2Children) {
            this.iterateID2Children();
        } else if (this.verifyID2Subtree) {
            this.iterateID2Subtree();
        } else if (this.attrIndexList.size() > 0) {
            AttributeIndex attrIndex = this.attrIndexList.get(0);
            this.iterateAttrIndex(attrIndex.getAttributeType(), attrIndex.getEqualityIndex(), IndexType.EQ);
            this.iterateAttrIndex(attrIndex.getAttributeType(), attrIndex.getPresenceIndex(), IndexType.PRES);
            this.iterateAttrIndex(attrIndex.getAttributeType(), attrIndex.getSubstringIndex(), IndexType.SUBSTRING);
            this.iterateAttrIndex(attrIndex.getAttributeType(), attrIndex.getOrderingIndex(), IndexType.ORDERING);
            this.iterateAttrIndex(attrIndex.getAttributeType(), attrIndex.getApproximateIndex(), IndexType.APPROXIMATE);
        } else if (this.vlvIndexList.size() > 0) {
            this.iterateVLVIndex(this.vlvIndexList.get(0), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void iterateDN2ID() throws DatabaseException {
        DiskOrderedCursor cursor = this.dn2id.openCursor(new DiskOrderedCursorConfig());
        try {
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            while (cursor.getNext(key, data, null) == OperationStatus.SUCCESS) {
                Entry entry;
                EntryID entryID;
                ++this.keyCount;
                try {
                    entryID = new EntryID(data);
                }
                catch (Exception e) {
                    ++this.errorCount;
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    TRACER.debugError("File dn2id has malformed ID for DN <%s>:%n%s%n", new String(key.getData()), StaticUtils.bytesToHex(data.getData()));
                    continue;
                }
                try {
                    entry = this.id2entry.get(null, entryID, LockMode.DEFAULT);
                }
                catch (Exception e) {
                    ++this.errorCount;
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    continue;
                }
                if (entry == null) {
                    ++this.errorCount;
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugError("File dn2id has DN <%s> referencing unknown ID %d%n", new String(key.getData()), entryID.longValue());
                    continue;
                }
                if (Arrays.equals(JebFormat.dnToDNKey(entry.getDN(), this.verifyConfig.getBaseDN().getNumComponents()), key.getData())) continue;
                ++this.errorCount;
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugError("File dn2id has DN <%s> referencing entry with wrong DN <%s>%n", new String(key.getData()), entry.getDN().toNormalizedString());
            }
        }
        finally {
            cursor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void iterateID2Children() throws JebException, DatabaseException {
        DiskOrderedCursor cursor = this.id2c.openCursor(new DiskOrderedCursorConfig());
        try {
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            while (cursor.getNext(key, data, null) == OperationStatus.SUCCESS) {
                Entry entry;
                EntryIDSet entryIDList;
                EntryID entryID;
                ++this.keyCount;
                try {
                    entryID = new EntryID(key);
                }
                catch (Exception e) {
                    ++this.errorCount;
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    TRACER.debugError("File id2children has malformed ID %s%n", StaticUtils.bytesToHex(key.getData()));
                    continue;
                }
                try {
                    JebFormat.entryIDListFromDatabase(data.getData());
                    entryIDList = new EntryIDSet(key.getData(), data.getData());
                }
                catch (Exception e) {
                    ++this.errorCount;
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    TRACER.debugError("File id2children has malformed ID list for ID %s:%n%s%n", entryID, StaticUtils.bytesToHex(data.getData()));
                    continue;
                }
                this.updateIndexStats(entryIDList);
                if (!entryIDList.isDefined()) continue;
                try {
                    entry = this.id2entry.get(null, entryID, LockMode.DEFAULT);
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    ++this.errorCount;
                    continue;
                }
                if (entry == null) {
                    ++this.errorCount;
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugError("File id2children has unknown ID %d%n", entryID.longValue());
                    continue;
                }
                for (EntryID id : entryIDList) {
                    Entry childEntry;
                    try {
                        childEntry = this.id2entry.get(null, id, LockMode.DEFAULT);
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        ++this.errorCount;
                        continue;
                    }
                    if (childEntry == null) {
                        ++this.errorCount;
                        if (!DebugLogger.debugEnabled()) continue;
                        TRACER.debugError("File id2children has ID %d referencing unknown ID %d%n", entryID.longValue(), id.longValue());
                        continue;
                    }
                    if (childEntry.getDN().isDescendantOf(entry.getDN()) && childEntry.getDN().getNumComponents() == entry.getDN().getNumComponents() + 1) continue;
                    ++this.errorCount;
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugError("File id2children has ID %d with DN <%s> referencing ID %d with non-child DN <%s>%n", entryID.longValue(), entry.getDN().toString(), id.longValue(), childEntry.getDN().toString());
                }
            }
        }
        finally {
            cursor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void iterateID2Subtree() throws JebException, DatabaseException {
        DiskOrderedCursor cursor = this.id2s.openCursor(new DiskOrderedCursorConfig());
        try {
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            while (cursor.getNext(key, data, null) == OperationStatus.SUCCESS) {
                Entry entry;
                EntryIDSet entryIDList;
                EntryID entryID;
                ++this.keyCount;
                try {
                    entryID = new EntryID(key);
                }
                catch (Exception e) {
                    ++this.errorCount;
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    TRACER.debugError("File id2subtree has malformed ID %s%n", StaticUtils.bytesToHex(key.getData()));
                    continue;
                }
                try {
                    JebFormat.entryIDListFromDatabase(data.getData());
                    entryIDList = new EntryIDSet(key.getData(), data.getData());
                }
                catch (Exception e) {
                    ++this.errorCount;
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    TRACER.debugError("File id2subtree has malformed ID list for ID %s:%n%s%n", entryID, StaticUtils.bytesToHex(data.getData()));
                    continue;
                }
                this.updateIndexStats(entryIDList);
                if (!entryIDList.isDefined()) continue;
                try {
                    entry = this.id2entry.get(null, entryID, LockMode.DEFAULT);
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    ++this.errorCount;
                    continue;
                }
                if (entry == null) {
                    ++this.errorCount;
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugError("File id2subtree has unknown ID %d%n", entryID.longValue());
                    continue;
                }
                for (EntryID id : entryIDList) {
                    Entry subordEntry;
                    try {
                        subordEntry = this.id2entry.get(null, id, LockMode.DEFAULT);
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        ++this.errorCount;
                        continue;
                    }
                    if (subordEntry == null) {
                        ++this.errorCount;
                        if (!DebugLogger.debugEnabled()) continue;
                        TRACER.debugError("File id2subtree has ID %d referencing unknown ID %d%n", entryID.longValue(), id.longValue());
                        continue;
                    }
                    if (subordEntry.getDN().isDescendantOf(entry.getDN())) continue;
                    ++this.errorCount;
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugError("File id2subtree has ID %d with DN <%s> referencing ID %d with non-subordinate DN <%s>%n", entryID.longValue(), entry.getDN().toString(), id.longValue(), subordEntry.getDN().toString());
                }
            }
        }
        finally {
            cursor.close();
        }
    }

    private void incrEntryLimitStats(Index index, byte[] key) {
        ByteString octetString;
        Long counter;
        HashMap<ByteString, Long> hashMap = this.entryLimitMap.get(index);
        if (hashMap == null) {
            hashMap = new HashMap();
            this.entryLimitMap.put(index, hashMap);
        }
        if ((counter = hashMap.get(octetString = ByteString.wrap(key))) == null) {
            counter = 1L;
        } else {
            Long l = counter;
            Long l2 = counter = Long.valueOf(counter + 1L);
        }
        hashMap.put(octetString, counter);
    }

    private void updateIndexStats(EntryIDSet entryIDSet) {
        if (!entryIDSet.isDefined()) {
            ++this.entryLimitExceededCount;
            ++this.multiReferenceCount;
        } else {
            if (entryIDSet.size() > 1L) {
                ++this.multiReferenceCount;
            }
            this.entryReferencesCount += entryIDSet.size();
            this.maxEntryPerValue = Math.max(this.maxEntryPerValue, entryIDSet.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void iterateVLVIndex(VLVIndex vlvIndex, boolean verifyID) throws JebException, DatabaseException, DirectoryException {
        if (vlvIndex == null) {
            return;
        }
        DiskOrderedCursor cursor = vlvIndex.openCursor(new DiskOrderedCursorConfig());
        try {
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            SortValues lastValues = null;
            while (cursor.getNext(key, data, null) == OperationStatus.SUCCESS) {
                SortValuesSet sortValuesSet = new SortValuesSet(key.getData(), data.getData(), vlvIndex);
                for (int i = 0; i < sortValuesSet.getEntryIDs().length; ++i) {
                    Entry entry;
                    ++this.keyCount;
                    SortValues values = sortValuesSet.getSortValues(i);
                    if (lastValues != null && lastValues.compareTo(values) >= 1) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugError("Values %s and %s are incorrectly ordered", lastValues, values, this.keyDump(vlvIndex, sortValuesSet.getKeySortValues()));
                        }
                        ++this.errorCount;
                    }
                    if (i == sortValuesSet.getEntryIDs().length - 1 && key.getData().length != 0) {
                        byte[] encodedKey = vlvIndex.encodeKey(values.getEntryID(), values.getValues());
                        if (!Arrays.equals(key.getData(), encodedKey)) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugError("Incorrect key for SortValuesSet in VLV index %s. Last values bytes %s, Key bytes %s", vlvIndex.getName(), encodedKey, key);
                            }
                            ++this.errorCount;
                        }
                    }
                    lastValues = values;
                    if (!verifyID) continue;
                    EntryID id = new EntryID(values.getEntryID());
                    try {
                        entry = this.id2entry.get(null, id, LockMode.DEFAULT);
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        ++this.errorCount;
                        continue;
                    }
                    if (entry == null) {
                        ++this.errorCount;
                        if (!DebugLogger.debugEnabled()) continue;
                        TRACER.debugError("Reference to unknown ID %d%n%s", id.longValue(), this.keyDump(vlvIndex, sortValuesSet.getKeySortValues()));
                        continue;
                    }
                    SortValues entryValues = new SortValues(id, entry, vlvIndex.sortOrder);
                    if (entryValues.compareTo(values) == 0) continue;
                    ++this.errorCount;
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugError("Reference to entry ID %d which does not match the values%n%s", id.longValue(), this.keyDump(vlvIndex, sortValuesSet.getKeySortValues()));
                }
            }
        }
        finally {
            cursor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void iterateAttrIndex(AttributeType attrType, Index index, IndexType indexType) throws JebException, DatabaseException {
        if (index == null) {
            return;
        }
        DiskOrderedCursor cursor = index.openCursor(new DiskOrderedCursorConfig());
        try {
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            while (cursor.getNext(key, data, null) == OperationStatus.SUCCESS) {
                EntryIDSet entryIDList;
                ++this.keyCount;
                try {
                    JebFormat.entryIDListFromDatabase(data.getData());
                    entryIDList = new EntryIDSet(key.getData(), data.getData());
                }
                catch (Exception e) {
                    ++this.errorCount;
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    TRACER.debugError("Malformed ID list: %s%n%s", StaticUtils.bytesToHex(data.getData()), this.keyDump(index, key.getData()));
                    continue;
                }
                this.updateIndexStats(entryIDList);
                if (!entryIDList.isDefined()) continue;
                final byte[] value = key.getData();
                EntryID prevID = null;
                for (EntryID id : entryIDList) {
                    Entry entry;
                    if (prevID != null && id.equals(prevID) && DebugLogger.debugEnabled()) {
                        TRACER.debugError("Duplicate reference to ID %d%n%s", id.longValue(), this.keyDump(index, key.getData()));
                    }
                    prevID = id;
                    try {
                        entry = this.id2entry.get(null, id, LockMode.DEFAULT);
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        ++this.errorCount;
                        continue;
                    }
                    if (entry == null) {
                        ++this.errorCount;
                        if (!DebugLogger.debugEnabled()) continue;
                        TRACER.debugError("Reference to unknown ID %d%n%s", id.longValue(), this.keyDump(index, key.getData()));
                        continue;
                    }
                    final AtomicBoolean foundMatchingKey = new AtomicBoolean(false);
                    AbstractSet<byte[]> dummySet = new AbstractSet<byte[]>(){

                        @Override
                        public Iterator<byte[]> iterator() {
                            return Collections.emptySet().iterator();
                        }

                        @Override
                        public int size() {
                            return 0;
                        }

                        @Override
                        public boolean add(byte[] e) {
                            if (Arrays.equals(e, value)) {
                                foundMatchingKey.set(true);
                            }
                            return true;
                        }
                    };
                    index.indexer.indexEntry(entry, (Set<byte[]>)dummySet);
                    if (foundMatchingKey.get()) continue;
                    ++this.errorCount;
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugError("Reference to entry <%s> which does not match the value%n%s", entry.getDN(), this.keyDump(index, value));
                }
            }
        }
        finally {
            cursor.close();
        }
    }

    private void verifyEntry(EntryID entryID, Entry entry) {
        if (this.verifyDN2ID) {
            this.verifyDN2ID(entryID, entry);
        }
        if (this.verifyID2Children) {
            this.verifyID2Children(entryID, entry);
        }
        if (this.verifyID2Subtree) {
            this.verifyID2Subtree(entryID, entry);
        }
        this.verifyIndex(entryID, entry);
    }

    private void verifyDN2ID(EntryID entryID, Entry entry) {
        DN dn = entry.getDN();
        try {
            EntryID id = this.dn2id.get(null, dn, LockMode.DEFAULT);
            if (id == null) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugError("File dn2id is missing key %s.%n", dn.toNormalizedString());
                }
                ++this.errorCount;
            } else if (!id.equals(entryID)) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugError("File dn2id has ID %d instead of %d for key %s.%n", id.longValue(), entryID.longValue(), dn.toNormalizedString());
                }
                ++this.errorCount;
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
                TRACER.debugError("File dn2id has error reading key %s: %s.%n", dn.toNormalizedString(), e.getMessage());
            }
            ++this.errorCount;
        }
        DN parentDN = this.getParent(dn);
        if (parentDN != null) {
            try {
                EntryID id = this.dn2id.get(null, parentDN, LockMode.DEFAULT);
                if (id == null) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugError("File dn2id is missing key %s.%n", parentDN.toNormalizedString());
                    }
                    ++this.errorCount;
                }
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    TRACER.debugError("File dn2id has error reading key %s: %s.%n", parentDN.toNormalizedString(), e.getMessage());
                }
                ++this.errorCount;
            }
        }
    }

    private void verifyID2Children(EntryID entryID, Entry entry) {
        DN dn = entry.getDN();
        DN parentDN = this.getParent(dn);
        if (parentDN != null) {
            EntryID parentID = null;
            try {
                parentID = this.dn2id.get(null, parentDN, LockMode.DEFAULT);
                if (parentID == null) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugError("File dn2id is missing key %s.%n", parentDN.toNormalizedString());
                    }
                    ++this.errorCount;
                }
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    TRACER.debugError("File dn2id has error reading key %s: %s.", parentDN.toNormalizedString(), e.getMessage());
                }
                ++this.errorCount;
            }
            if (parentID != null) {
                try {
                    ConditionResult cr = this.id2c.containsID(null, parentID.getDatabaseEntry(), entryID);
                    if (cr == ConditionResult.FALSE) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugError("File id2children is missing ID %d for key %d.%n", entryID.longValue(), parentID.longValue());
                        }
                        ++this.errorCount;
                    } else if (cr == ConditionResult.UNDEFINED) {
                        this.incrEntryLimitStats(this.id2c, parentID.getDatabaseEntry().getData());
                    }
                }
                catch (DatabaseException e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        TRACER.debugError("File id2children has error reading key %d: %s.", parentID.longValue(), e.getMessage());
                    }
                    ++this.errorCount;
                }
            }
        }
    }

    private void verifyID2Subtree(EntryID entryID, Entry entry) {
        DN dn = this.getParent(entry.getDN());
        while (dn != null) {
            EntryID id = null;
            try {
                id = this.dn2id.get(null, dn, LockMode.DEFAULT);
                if (id == null) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugError("File dn2id is missing key %s.%n", dn.toNormalizedString());
                    }
                    ++this.errorCount;
                }
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    TRACER.debugError("File dn2id has error reading key %s: %s.%n", dn.toNormalizedString(), e.getMessage());
                }
                ++this.errorCount;
            }
            if (id != null) {
                try {
                    ConditionResult cr = this.id2s.containsID(null, id.getDatabaseEntry(), entryID);
                    if (cr == ConditionResult.FALSE) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugError("File id2subtree is missing ID %d for key %d.%n", entryID.longValue(), id.longValue());
                        }
                        ++this.errorCount;
                    } else if (cr == ConditionResult.UNDEFINED) {
                        this.incrEntryLimitStats(this.id2s, id.getDatabaseEntry().getData());
                    }
                }
                catch (DatabaseException e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        TRACER.debugError("File id2subtree has error reading key %d: %s.%n", id.longValue(), e.getMessage());
                    }
                    ++this.errorCount;
                }
            }
            dn = this.getParent(dn);
        }
    }

    private String keyDump(Index index, byte[] keyBytes) {
        StringBuilder buffer = new StringBuilder(128);
        buffer.append("File: ");
        buffer.append(index.toString());
        buffer.append(ServerConstants.EOL);
        buffer.append("Key:");
        buffer.append(ServerConstants.EOL);
        StaticUtils.byteArrayToHexPlusAscii(buffer, keyBytes, 6);
        return buffer.toString();
    }

    private String keyDump(VLVIndex vlvIndex, SortValues keySortValues) {
        StringBuilder buffer = new StringBuilder(128);
        buffer.append("File: ");
        buffer.append(vlvIndex.toString());
        buffer.append(ServerConstants.EOL);
        buffer.append("Key (last sort values):");
        if (keySortValues == null) {
            buffer.append("UNBOUNDED (0x00)");
        } else {
            buffer.append(keySortValues.toString());
        }
        return buffer.toString();
    }

    private void verifyIndex(EntryID entryID, Entry entry) {
        for (AttributeIndex attrIndex : this.attrIndexList) {
            try {
                List<Attribute> attrList = entry.getAttribute(attrIndex.getAttributeType());
                if (attrList == null) continue;
                this.verifyAttribute(attrIndex, entryID, attrList);
            }
            catch (DirectoryException e) {
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
                TRACER.debugError("Error normalizing values of attribute %s in entry <%s>: %s.%n", attrIndex.getAttributeType().toString(), entry.getDN().toString(), String.valueOf(e.getMessageObject()));
            }
        }
        for (VLVIndex vlvIndex : this.vlvIndexList) {
            try {
                if (!vlvIndex.shouldInclude(entry) || vlvIndex.containsValues(null, entryID.longValue(), vlvIndex.getSortValues(entry))) continue;
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugError("Missing entry %s in VLV index %s", entry.getDN().toString(), vlvIndex.getName());
                }
                ++this.errorCount;
            }
            catch (DirectoryException e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    TRACER.debugError("Error checking entry %s against filter or base DN for VLV index %s: %s", entry.getDN().toString(), vlvIndex.getName(), String.valueOf(e.getMessageObject()));
                }
                ++this.errorCount;
            }
            catch (DatabaseException e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    TRACER.debugError("Error reading VLV index %s for entry %s: %s", vlvIndex.getName(), entry.getDN().toString(), StaticUtils.getBacktrace(e));
                }
                ++this.errorCount;
            }
            catch (JebException e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    TRACER.debugError("Error reading VLV index %s for entry %s: %s", vlvIndex.getName(), entry.getDN().toString(), StaticUtils.getBacktrace(e));
                }
                ++this.errorCount;
            }
        }
    }

    private void verifyAttribute(AttributeIndex attrIndex, EntryID entryID, List<Attribute> attrList) throws DirectoryException {
        Transaction txn = null;
        Index equalityIndex = attrIndex.getEqualityIndex();
        Index presenceIndex = attrIndex.getPresenceIndex();
        Index substringIndex = attrIndex.getSubstringIndex();
        Index orderingIndex = attrIndex.getOrderingIndex();
        Index approximateIndex = attrIndex.getApproximateIndex();
        DatabaseEntry presenceKey = AttributeIndex.presenceKey;
        if (attrList != null && !attrList.isEmpty() && presenceIndex != null) {
            try {
                ConditionResult cr = presenceIndex.containsID(txn, presenceKey, entryID);
                if (cr == ConditionResult.FALSE) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugError("Missing ID %d%n%s", entryID.longValue(), this.keyDump(presenceIndex, presenceKey.getData()));
                    }
                    ++this.errorCount;
                } else if (cr == ConditionResult.UNDEFINED) {
                    this.incrEntryLimitStats(presenceIndex, presenceKey.getData());
                }
            }
            catch (DatabaseException e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    TRACER.debugError("Error reading database: %s%n%s", e.getMessage(), this.keyDump(presenceIndex, presenceKey.getData()));
                }
                ++this.errorCount;
            }
        }
        if (attrList != null) {
            for (Attribute attr : attrList) {
                for (AttributeValue value : attr) {
                    ConditionResult cr;
                    DatabaseEntry key;
                    byte[] normalizedBytes = value.getNormalizedValue().toByteArray();
                    if (equalityIndex != null) {
                        DatabaseEntry key2 = new DatabaseEntry(normalizedBytes);
                        try {
                            ConditionResult cr2 = equalityIndex.containsID(txn, key2, entryID);
                            if (cr2 == ConditionResult.FALSE) {
                                if (DebugLogger.debugEnabled()) {
                                    TRACER.debugError("Missing ID %d%n%s", entryID.longValue(), this.keyDump(equalityIndex, normalizedBytes));
                                }
                                ++this.errorCount;
                            } else if (cr2 == ConditionResult.UNDEFINED) {
                                this.incrEntryLimitStats(equalityIndex, normalizedBytes);
                            }
                        }
                        catch (DatabaseException e) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugCaught(DebugLogLevel.ERROR, e);
                                TRACER.debugError("Error reading database: %s%n%s", e.getMessage(), this.keyDump(equalityIndex, normalizedBytes));
                            }
                            ++this.errorCount;
                        }
                    }
                    if (substringIndex != null) {
                        Set<ByteString> keyBytesSet = attrIndex.substringKeys(normalizedBytes);
                        key = new DatabaseEntry();
                        for (ByteString keyBytes : keyBytesSet) {
                            key.setData(keyBytes.toByteArray());
                            try {
                                ConditionResult cr3 = substringIndex.containsID(txn, key, entryID);
                                if (cr3 == ConditionResult.FALSE) {
                                    if (DebugLogger.debugEnabled()) {
                                        TRACER.debugError("Missing ID %d%n%s", entryID.longValue(), this.keyDump(substringIndex, key.getData()));
                                    }
                                    ++this.errorCount;
                                    continue;
                                }
                                if (cr3 != ConditionResult.UNDEFINED) continue;
                                this.incrEntryLimitStats(substringIndex, key.getData());
                            }
                            catch (DatabaseException e) {
                                if (DebugLogger.debugEnabled()) {
                                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                                    TRACER.debugError("Error reading database: %s%n%s", e.getMessage(), this.keyDump(substringIndex, key.getData()));
                                }
                                ++this.errorCount;
                            }
                        }
                    }
                    if (orderingIndex != null) {
                        OrderingMatchingRule orderingRule = attr.getAttributeType().getOrderingMatchingRule();
                        normalizedBytes = orderingRule.normalizeValue(value.getValue()).toByteArray();
                        key = new DatabaseEntry(normalizedBytes);
                        try {
                            cr = orderingIndex.containsID(txn, key, entryID);
                            if (cr == ConditionResult.FALSE) {
                                if (DebugLogger.debugEnabled()) {
                                    TRACER.debugError("Missing ID %d%n%s", entryID.longValue(), this.keyDump(orderingIndex, normalizedBytes));
                                }
                                ++this.errorCount;
                            } else if (cr == ConditionResult.UNDEFINED) {
                                this.incrEntryLimitStats(orderingIndex, normalizedBytes);
                            }
                        }
                        catch (DatabaseException e) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugCaught(DebugLogLevel.ERROR, e);
                                TRACER.debugError("Error reading database: %s%n%s", e.getMessage(), this.keyDump(orderingIndex, normalizedBytes));
                            }
                            ++this.errorCount;
                        }
                    }
                    if (approximateIndex == null) continue;
                    ApproximateMatchingRule approximateRule = attr.getAttributeType().getApproximateMatchingRule();
                    normalizedBytes = approximateRule.normalizeValue(value.getValue()).toByteArray();
                    key = new DatabaseEntry(normalizedBytes);
                    try {
                        cr = approximateIndex.containsID(txn, key, entryID);
                        if (cr == ConditionResult.FALSE) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugError("Missing ID %d%n%s", entryID.longValue(), this.keyDump(orderingIndex, normalizedBytes));
                            }
                            ++this.errorCount;
                            continue;
                        }
                        if (cr != ConditionResult.UNDEFINED) continue;
                        this.incrEntryLimitStats(approximateIndex, normalizedBytes);
                    }
                    catch (DatabaseException e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                            TRACER.debugError("Error reading database: %s%n%s", e.getMessage(), this.keyDump(approximateIndex, normalizedBytes));
                        }
                        ++this.errorCount;
                    }
                }
            }
        }
    }

    private DN getParent(DN dn) {
        if (dn.equals(this.verifyConfig.getBaseDN())) {
            return null;
        }
        return dn.getParentDNInSuffix();
    }

    private void addStatEntry(Entry statEntry, String t, String v) {
        if (statEntry != null) {
            Attribute a = Attributes.create(t, v);
            statEntry.addAttribute(a, null);
        }
    }

    class ProgressTask
    extends TimerTask {
        private long totalCount;
        private long previousCount = 0L;
        private long previousTime = System.currentTimeMillis();
        private EnvironmentStats prevEnvStats;
        private static final int bytesPerMegabyte = 0x100000;

        public ProgressTask() throws DatabaseException {
            this.prevEnvStats = VerifyJob.this.rootContainer.getEnvironmentStats(new StatsConfig());
            this.totalCount = VerifyJob.this.rootContainer.getEntryContainer(VerifyJob.this.verifyConfig.getBaseDN()).getEntryCount();
        }

        public ProgressTask(boolean indexIterator) throws DatabaseException {
            this.prevEnvStats = VerifyJob.this.rootContainer.getEnvironmentStats(new StatsConfig());
            if (indexIterator) {
                if (VerifyJob.this.verifyDN2ID) {
                    this.totalCount = VerifyJob.this.dn2id.getRecordCount();
                } else if (VerifyJob.this.verifyID2Children) {
                    this.totalCount = VerifyJob.this.id2c.getRecordCount();
                } else if (VerifyJob.this.verifyID2Subtree) {
                    this.totalCount = VerifyJob.this.id2s.getRecordCount();
                } else if (VerifyJob.this.attrIndexList.size() > 0) {
                    AttributeIndex attrIndex = VerifyJob.this.attrIndexList.get(0);
                    this.totalCount = 0L;
                    if (attrIndex.getEqualityIndex() != null) {
                        this.totalCount += attrIndex.getEqualityIndex().getRecordCount();
                    }
                    if (attrIndex.getPresenceIndex() != null) {
                        this.totalCount += attrIndex.getPresenceIndex().getRecordCount();
                    }
                    if (attrIndex.getSubstringIndex() != null) {
                        this.totalCount += attrIndex.getSubstringIndex().getRecordCount();
                    }
                    if (attrIndex.getOrderingIndex() != null) {
                        this.totalCount += attrIndex.getOrderingIndex().getRecordCount();
                    }
                    if (attrIndex.getApproximateIndex() != null) {
                        this.totalCount += attrIndex.getApproximateIndex().getRecordCount();
                    }
                } else if (VerifyJob.this.vlvIndexList.size() > 0) {
                    this.totalCount = VerifyJob.this.vlvIndexList.get(0).getRecordCount();
                }
            } else {
                this.totalCount = VerifyJob.this.rootContainer.getEntryContainer(VerifyJob.this.verifyConfig.getBaseDN()).getEntryCount();
            }
        }

        @Override
        public void run() {
            long latestTime;
            long latestCount;
            block4: {
                latestCount = VerifyJob.this.keyCount;
                long deltaCount = latestCount - this.previousCount;
                latestTime = System.currentTimeMillis();
                long deltaTime = latestTime - this.previousTime;
                if (deltaTime == 0L) {
                    return;
                }
                float rate = 1000.0f * (float)deltaCount / (float)deltaTime;
                Message message = JebMessages.NOTE_JEB_VERIFY_PROGRESS_REPORT.get(latestCount, this.totalCount, VerifyJob.this.errorCount, Float.valueOf(rate));
                ErrorLogger.logError(message);
                try {
                    Runtime runtime = Runtime.getRuntime();
                    long freeMemory = runtime.freeMemory() / 0x100000L;
                    EnvironmentStats envStats = VerifyJob.this.rootContainer.getEnvironmentStats(new StatsConfig());
                    long nCacheMiss = envStats.getNCacheMiss() - this.prevEnvStats.getNCacheMiss();
                    float cacheMissRate = 0.0f;
                    if (deltaCount > 0L) {
                        cacheMissRate = (float)nCacheMiss / (float)deltaCount;
                    }
                    message = JebMessages.INFO_JEB_VERIFY_CACHE_AND_MEMORY_REPORT.get(freeMemory, Float.valueOf(cacheMissRate));
                    ErrorLogger.logError(message);
                    this.prevEnvStats = envStats;
                }
                catch (DatabaseException e) {
                    if (!DebugLogger.debugEnabled()) break block4;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
            this.previousCount = latestCount;
            this.previousTime = latestTime;
        }
    }

    static enum IndexType {
        PRES,
        EQ,
        SUBSTRING,
        ORDERING,
        APPROXIMATE;

    }
}

