/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb.importLDIF;

import com.sleepycat.util.PackedInteger;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.opends.messages.JebMessages;
import org.opends.messages.Message;
import org.opends.server.backends.jeb.importLDIF.ImportIDSet;
import org.opends.server.backends.jeb.importLDIF.Importer;
import org.opends.server.loggers.ErrorLogger;

public final class IndexInputBuffer
implements Comparable<IndexInputBuffer> {
    private final Importer.IndexManager indexMgr;
    private final FileChannel channel;
    private final long begin;
    private final long end;
    private final int id;
    private long offset;
    private final ByteBuffer cache;
    private Integer indexID = null;
    private ByteBuffer keyBuf = ByteBuffer.allocate(128);
    private RecordState recordState = RecordState.START;

    public IndexInputBuffer(Importer.IndexManager indexMgr, FileChannel channel, long begin, long end, int id, int cacheSize) throws IOException {
        this.indexMgr = indexMgr;
        this.channel = channel;
        this.begin = begin;
        this.end = end;
        this.offset = 0L;
        this.id = id;
        this.cache = ByteBuffer.allocate(Math.max(cacheSize - 384, 256));
        this.loadCache();
        this.cache.flip();
        this.keyBuf.flip();
    }

    private void loadCache() throws IOException {
        long bytesToRead;
        this.channel.position(this.begin + this.offset);
        long leftToRead = this.end - (this.begin + this.offset);
        if (leftToRead < (long)this.cache.remaining()) {
            this.cache.limit((int)((long)this.cache.position() + leftToRead));
            bytesToRead = (int)leftToRead;
        } else {
            bytesToRead = Math.min(this.end - this.offset, (long)this.cache.remaining());
        }
        int bytesRead = 0;
        while ((long)bytesRead < bytesToRead) {
            bytesRead += this.channel.read(this.cache);
        }
        this.offset += (long)bytesRead;
        this.indexMgr.addBytesRead(bytesRead);
    }

    public boolean hasMoreData() throws IOException {
        boolean ret = this.begin + this.offset >= this.end;
        return this.cache.remaining() != 0 || !ret;
    }

    public int getKeyLen() {
        return this.keyBuf.limit();
    }

    public void getKey(ByteBuffer b) {
        this.keyBuf.get(b.array(), 0, this.keyBuf.limit());
        b.limit(this.keyBuf.limit());
    }

    public Integer getIndexID() {
        if (this.indexID == null) {
            try {
                this.getNextRecord();
            }
            catch (IOException ex) {
                Message message = JebMessages.ERR_JEB_IMPORT_BUFFER_IO_ERROR.get(this.indexMgr.getBufferFileName());
                ErrorLogger.logError(message);
                throw new RuntimeException(ex);
            }
        }
        return this.indexID;
    }

    public void getNextRecord() throws IOException {
        switch (this.recordState) {
            case START: {
                break;
            }
            case NEED_INSERT_ID_SET: {
                this.mergeIDSet(null);
                this.mergeIDSet(null);
                break;
            }
            case NEED_DELETE_ID_SET: {
                this.mergeIDSet(null);
            }
        }
        this.indexID = this.getInt();
        this.ensureData(20);
        byte[] ba = this.cache.array();
        int p = this.cache.position();
        int len = PackedInteger.getReadIntLength((byte[])ba, (int)p);
        int keyLen = PackedInteger.readInt((byte[])ba, (int)p);
        this.cache.position(p + len);
        if (keyLen > this.keyBuf.capacity()) {
            this.keyBuf = ByteBuffer.allocate(keyLen);
        }
        this.ensureData(keyLen);
        this.keyBuf.clear();
        this.cache.get(this.keyBuf.array(), 0, keyLen);
        this.keyBuf.limit(keyLen);
        this.recordState = RecordState.NEED_INSERT_ID_SET;
    }

    private int getInt() throws IOException {
        this.ensureData(4);
        return this.cache.getInt();
    }

    public void mergeIDSet(ImportIDSet idSet) throws IOException {
        if (this.recordState == RecordState.START) {
            throw new IllegalStateException();
        }
        this.ensureData(20);
        int p = this.cache.position();
        byte[] ba = this.cache.array();
        int len = PackedInteger.getReadIntLength((byte[])ba, (int)p);
        int keyCount = PackedInteger.readInt((byte[])ba, (int)p);
        this.cache.position(p += len);
        for (int k = 0; k < keyCount; ++k) {
            if (this.ensureData(9)) {
                p = this.cache.position();
            }
            len = PackedInteger.getReadLongLength((byte[])ba, (int)p);
            long l = PackedInteger.readLong((byte[])ba, (int)p);
            this.cache.position(p += len);
            if (idSet == null) continue;
            idSet.addEntryID(l);
        }
        switch (this.recordState) {
            case START: {
                throw new IllegalStateException();
            }
            case NEED_INSERT_ID_SET: {
                this.recordState = RecordState.NEED_DELETE_ID_SET;
                break;
            }
            case NEED_DELETE_ID_SET: {
                this.recordState = RecordState.START;
            }
        }
    }

    private boolean ensureData(int len) throws IOException {
        boolean ret = false;
        if (this.cache.remaining() == 0) {
            this.cache.clear();
            this.loadCache();
            this.cache.flip();
            ret = true;
        } else if (this.cache.remaining() < len) {
            this.cache.compact();
            this.loadCache();
            this.cache.flip();
            ret = true;
        }
        return ret;
    }

    int compare(ByteBuffer cKey, Integer cIndexID) {
        int rc;
        if (this.keyBuf.limit() == 0) {
            this.getIndexID();
        }
        int returnCode = (rc = Importer.indexComparator.compare(this.keyBuf.array(), 0, this.keyBuf.limit(), cKey.array(), cKey.limit())) != 0 ? 1 : (this.indexID.intValue() == cIndexID.intValue() ? 0 : 1);
        return returnCode;
    }

    @Override
    public int compareTo(IndexInputBuffer o) {
        if (this == o) {
            return 0;
        }
        if (this.keyBuf.limit() == 0) {
            this.getIndexID();
        }
        if (o.keyBuf.limit() == 0) {
            o.getIndexID();
        }
        byte[] oKey = o.keyBuf.array();
        int oLen = o.keyBuf.limit();
        int returnCode = Importer.indexComparator.compare(this.keyBuf.array(), 0, this.keyBuf.limit(), oKey, oLen);
        if (returnCode == 0 && (returnCode = this.indexID - o.getIndexID()) == 0) {
            returnCode = this.id - o.id;
        }
        return returnCode;
    }

    private static enum RecordState {
        START,
        NEED_INSERT_ID_SET,
        NEED_DELETE_ID_SET;

    }
}

