/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb.importLDIF;

import com.sleepycat.util.PackedInteger;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.opends.server.backends.jeb.EntryID;
import org.opends.server.backends.jeb.importLDIF.Importer;

public final class IndexOutputBuffer
implements Comparable<IndexOutputBuffer> {
    private static final int REC_OVERHEAD = 5;
    private static final int INT_SIZE = 4;
    private static final byte DEL = 0;
    private static final byte INS = 1;
    private final int size;
    private final byte[] buffer;
    private long id;
    private final byte[] intBytes = new byte[4];
    private int keyOffset = 0;
    private int recordOffset = 0;
    private int bytesLeft = 0;
    private int keys = 0;
    private int position = 0;
    private ComparatorBuffer<byte[]> comparator;
    private Importer.IndexKey indexKey;
    private static final int CAP = 32;
    private ByteBuffer keyBuffer = ByteBuffer.allocate(32);
    private boolean discard = false;

    public IndexOutputBuffer(int size) {
        this.size = size;
        this.buffer = new byte[size];
        this.bytesLeft = size;
        this.recordOffset = size - 1;
    }

    public void reset() {
        this.bytesLeft = this.size;
        this.keyOffset = 0;
        this.recordOffset = this.size - 1;
        this.keys = 0;
        this.position = 0;
        this.comparator = null;
        this.indexKey = null;
    }

    public void setID(long id) {
        this.id = id;
    }

    private long getBufferID() {
        return this.id;
    }

    public boolean isPoison() {
        return this.size == 0;
    }

    public boolean isDiscard() {
        return this.discard;
    }

    public void setDiscard() {
        this.discard = true;
    }

    public boolean isSpaceAvailable(byte[] kBytes, long id) {
        return this.getRecordSize(kBytes.length, id) + 4 < this.bytesLeft;
    }

    public void setComparator(ComparatorBuffer<byte[]> comparator) {
        this.comparator = comparator;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public void sort() {
        this.sort(0, this.keys);
    }

    public void add(byte[] keyBytes, EntryID entryID, int indexID, boolean insert) {
        this.recordOffset = this.addRecord(keyBytes, entryID.longValue(), indexID, insert);
        System.arraycopy(this.getIntBytes(this.recordOffset), 0, this.buffer, this.keyOffset, 4);
        this.keyOffset += 4;
        this.bytesLeft = this.recordOffset - this.keyOffset;
        ++this.keys;
    }

    private int addRecord(byte[] key, long id, int indexID, boolean insert) {
        int retOffset;
        int offSet = retOffset = this.recordOffset - this.getRecordSize(key.length, id);
        this.buffer[offSet++] = insert ? (byte)1 : 0;
        System.arraycopy(this.getIntBytes(indexID), 0, this.buffer, offSet, 4);
        offSet += 4;
        offSet = PackedInteger.writeLong((byte[])this.buffer, (int)offSet, (long)id);
        offSet = PackedInteger.writeInt((byte[])this.buffer, (int)offSet, (int)key.length);
        System.arraycopy(key, 0, this.buffer, offSet, key.length);
        return retOffset;
    }

    public static int getRequiredSize(int keyLen, long id) {
        return PackedInteger.getWriteIntLength((int)keyLen) + keyLen + PackedInteger.getWriteLongLength((long)id) + 5 + 4;
    }

    private int getRecordSize(int keyLen, long id) {
        return PackedInteger.getWriteIntLength((int)keyLen) + keyLen + PackedInteger.getWriteLongLength((long)id) + 5;
    }

    public void writeID(ByteArrayOutputStream stream, int index) {
        int offSet = this.getIntegerValue(index * 4);
        int len = PackedInteger.getReadLongLength((byte[])this.buffer, (int)(offSet + 5));
        stream.write(this.buffer, offSet + 5, len);
    }

    public boolean isInsert(int index) {
        int recOffset = this.getIntegerValue(index * 4);
        return this.buffer[recOffset] != 0;
    }

    public int getKeySize() {
        int offSet = this.getIntegerValue(this.position * 4) + 5;
        offSet += PackedInteger.getReadIntLength((byte[])this.buffer, (int)offSet);
        return PackedInteger.readInt((byte[])this.buffer, (int)offSet);
    }

    public byte[] getKey() {
        return this.getKey(this.position);
    }

    private ByteBuffer getKeyBuf(int x) {
        this.keyBuffer.clear();
        int offSet = this.getIntegerValue(x * 4) + 5;
        offSet += PackedInteger.getReadIntLength((byte[])this.buffer, (int)offSet);
        int keyLen = PackedInteger.readInt((byte[])this.buffer, (int)offSet);
        offSet += PackedInteger.getReadIntLength((byte[])this.buffer, (int)offSet);
        if (keyLen > this.keyBuffer.capacity()) {
            this.keyBuffer = ByteBuffer.allocate(keyLen);
        }
        this.keyBuffer.put(this.buffer, offSet, keyLen);
        this.keyBuffer.flip();
        return this.keyBuffer;
    }

    private byte[] getKey(int x) {
        int offSet = this.getIntegerValue(x * 4) + 5;
        offSet += PackedInteger.getReadIntLength((byte[])this.buffer, (int)offSet);
        int keyLen = PackedInteger.readInt((byte[])this.buffer, (int)offSet);
        offSet += PackedInteger.getReadIntLength((byte[])this.buffer, (int)offSet);
        byte[] key = new byte[keyLen];
        System.arraycopy(this.buffer, offSet, key, 0, keyLen);
        return key;
    }

    private int getIndexID(int x) {
        return this.getIntegerValue(this.getIntegerValue(x * 4) + 1);
    }

    public int getIndexID() {
        return this.getIntegerValue(this.getIntegerValue(this.position * 4) + 1);
    }

    private boolean is(int x, int y, CompareOp op) {
        int xoffSet = this.getIntegerValue(x * 4);
        int xIndexID = this.getIntegerValue(xoffSet + 1);
        xoffSet += 5;
        xoffSet += PackedInteger.getReadIntLength((byte[])this.buffer, (int)xoffSet);
        int xKeyLen = PackedInteger.readInt((byte[])this.buffer, (int)xoffSet);
        int xKey = PackedInteger.getReadIntLength((byte[])this.buffer, (int)xoffSet) + xoffSet;
        int yoffSet = this.getIntegerValue(y * 4);
        int yIndexID = this.getIntegerValue(yoffSet + 1);
        yoffSet += 5;
        yoffSet += PackedInteger.getReadIntLength((byte[])this.buffer, (int)yoffSet);
        int yKeyLen = PackedInteger.readInt((byte[])this.buffer, (int)yoffSet);
        int yKey = PackedInteger.getReadIntLength((byte[])this.buffer, (int)yoffSet) + yoffSet;
        return this.evaluateReturnCode(this.comparator.compare(this.buffer, xKey, xKeyLen, xIndexID, (byte[])yKey, yKeyLen, yIndexID), op);
    }

    private boolean is(int x, byte[] yKey, CompareOp op, int yIndexID) {
        int xoffSet = this.getIntegerValue(x * 4);
        int xIndexID = this.getIntegerValue(xoffSet + 1);
        xoffSet += 5;
        xoffSet += PackedInteger.getReadIntLength((byte[])this.buffer, (int)xoffSet);
        int xKeyLen = PackedInteger.readInt((byte[])this.buffer, (int)xoffSet);
        int xKey = PackedInteger.getReadIntLength((byte[])this.buffer, (int)xoffSet) + xoffSet;
        return this.evaluateReturnCode(this.comparator.compare(this.buffer, xKey, xKeyLen, xIndexID, yKey, yKey.length, yIndexID), op);
    }

    public boolean compare(byte[] b, int bIndexID) {
        int offset = this.getIntegerValue(this.position * 4);
        int indexID = this.getIntegerValue(offset + 1);
        offset += 5;
        offset += PackedInteger.getReadIntLength((byte[])this.buffer, (int)offset);
        int keyLen = PackedInteger.readInt((byte[])this.buffer, (int)offset);
        int key = PackedInteger.getReadIntLength((byte[])this.buffer, (int)offset) + offset;
        return this.comparator.compare(this.buffer, key, keyLen, b, b.length) == 0 && indexID == bIndexID;
    }

    @Override
    public int compareTo(IndexOutputBuffer b) {
        ByteBuffer keyBuf = b.getKeyBuf(b.position);
        int offset = this.getIntegerValue(this.position * 4);
        int indexID = this.getIntegerValue(offset + 1);
        offset += 5;
        offset += PackedInteger.getReadIntLength((byte[])this.buffer, (int)offset);
        int keyLen = PackedInteger.readInt((byte[])this.buffer, (int)offset);
        int key = PackedInteger.getReadIntLength((byte[])this.buffer, (int)offset) + offset;
        int returnCode = this.comparator.compare(this.buffer, key, keyLen, keyBuf.array(), keyBuf.limit());
        if (returnCode == 0) {
            long otherBufferID;
            int bIndexID = b.getIndexID();
            returnCode = indexID == bIndexID ? (this.id == (otherBufferID = b.getBufferID()) ? 0 : (this.id < otherBufferID ? -1 : 1)) : (indexID < bIndexID ? -1 : 1);
        }
        return returnCode;
    }

    public void writeKey(DataOutputStream dataStream) throws IOException {
        int offSet = this.getIntegerValue(this.position * 4) + 5;
        offSet += PackedInteger.getReadIntLength((byte[])this.buffer, (int)offSet);
        int keyLen = PackedInteger.readInt((byte[])this.buffer, (int)offSet);
        offSet += PackedInteger.getReadIntLength((byte[])this.buffer, (int)offSet);
        dataStream.write(this.buffer, offSet, keyLen);
    }

    public boolean compare(int i) {
        return this.is(i, this.position, CompareOp.EQ);
    }

    public int getNumberKeys() {
        return this.keys;
    }

    public boolean hasMoreData() {
        return this.position + 1 < this.keys;
    }

    public void getNextRecord() {
        ++this.position;
    }

    private byte[] getIntBytes(int val) {
        for (int i = 3; i >= 0; --i) {
            this.intBytes[i] = (byte)(val & 0xFF);
            val >>>= 8;
        }
        return this.intBytes;
    }

    private int getIntegerValue(int index) {
        int answer = 0;
        for (int i = 0; i < 4; ++i) {
            byte b = this.buffer[index + i];
            answer <<= 8;
            answer |= b & 0xFF;
        }
        return answer;
    }

    private int med3(int a, int b, int c) {
        return this.is(a, b, CompareOp.LT) ? (this.is(b, c, CompareOp.LT) ? b : (this.is(a, c, CompareOp.LT) ? c : a)) : (this.is(b, c, CompareOp.GT) ? b : (this.is(a, c, CompareOp.GT) ? c : a));
    }

    private void sort(int off, int len) {
        int c;
        int a;
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && this.is(j - 1, j, CompareOp.GT); --j) {
                    this.swap(j, j - 1);
                }
            }
            return;
        }
        int m = off + (len >> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = this.med3(l, l + s, l + 2 * s);
                m = this.med3(m - s, m, m + s);
                n = this.med3(n - 2 * s, n - s, n);
            }
            m = this.med3(l, m, n);
        }
        byte[] mKey = this.getKey(m);
        int mIndexID = this.getIndexID(m);
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && this.is(b, mKey, CompareOp.LE, mIndexID)) {
                if (this.is(b, mKey, CompareOp.EQ, mIndexID)) {
                    this.swap(a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && this.is(c, mKey, CompareOp.GE, mIndexID)) {
                if (this.is(c, mKey, CompareOp.EQ, mIndexID)) {
                    this.swap(c, d--);
                }
                --c;
            }
            if (b > c) break;
            this.swap(b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        this.vectorSwap(off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        this.vectorSwap(b, n - s, s);
        s = b - a;
        if (s > 1) {
            this.sort(off, s);
        }
        if ((s = d - c) > 1) {
            this.sort(n - s, s);
        }
    }

    private void swap(int a, int b) {
        int aOffset = a * 4;
        int bOffset = b * 4;
        int bVal = this.getIntegerValue(bOffset);
        System.arraycopy(this.buffer, aOffset, this.buffer, bOffset, 4);
        System.arraycopy(this.getIntBytes(bVal), 0, this.buffer, aOffset, 4);
    }

    private void vectorSwap(int a, int b, int n) {
        int i = 0;
        while (i < n) {
            this.swap(a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private boolean evaluateReturnCode(int rc, CompareOp op) {
        boolean returnCode = false;
        switch (op) {
            case LT: {
                returnCode = rc < 0;
                break;
            }
            case GT: {
                returnCode = rc > 0;
                break;
            }
            case LE: {
                returnCode = rc <= 0;
                break;
            }
            case GE: {
                returnCode = rc >= 0;
                break;
            }
            case EQ: {
                returnCode = rc == 0;
            }
        }
        return returnCode;
    }

    public void setIndexKey(Importer.IndexKey indexKey) {
        this.indexKey = indexKey;
    }

    public Importer.IndexKey getIndexKey() {
        return this.indexKey;
    }

    public static class IndexComparator
    implements ComparatorBuffer<byte[]> {
        @Override
        public int compare(byte[] b, int offset, int length, int indexID, int otherOffset, int otherLength, int otherIndexID) {
            for (int i = 0; i < length && i < otherLength; ++i) {
                if (b[offset + i] > b[otherOffset + i]) {
                    return 1;
                }
                if (b[offset + i] >= b[otherOffset + i]) continue;
                return -1;
            }
            if (length == otherLength) {
                if (indexID == otherIndexID) {
                    return 0;
                }
                if (indexID > otherIndexID) {
                    return 1;
                }
                return -1;
            }
            if (length > otherLength) {
                return 1;
            }
            return -1;
        }

        @Override
        public int compare(byte[] b, int offset, int length, int indexID, byte[] other, int otherLength, int otherIndexID) {
            for (int i = 0; i < length && i < otherLength; ++i) {
                if (b[offset + i] > other[i]) {
                    return 1;
                }
                if (b[offset + i] >= other[i]) continue;
                return -1;
            }
            if (length == otherLength) {
                if (indexID == otherIndexID) {
                    return 0;
                }
                if (indexID > otherIndexID) {
                    return 1;
                }
                return -1;
            }
            if (length > otherLength) {
                return 1;
            }
            return -1;
        }

        @Override
        public int compare(byte[] b, int offset, int length, byte[] other, int otherLength) {
            for (int i = 0; i < length && i < otherLength; ++i) {
                if (b[offset + i] > other[i]) {
                    return 1;
                }
                if (b[offset + i] >= other[i]) continue;
                return -1;
            }
            if (length == otherLength) {
                return 0;
            }
            if (length > otherLength) {
                return 1;
            }
            return -1;
        }
    }

    public static interface ComparatorBuffer<T> {
        public int compare(T var1, int var2, int var3, int var4, int var5, int var6, int var7);

        public int compare(T var1, int var2, int var3, int var4, T var5, int var6, int var7);

        public int compare(T var1, int var2, int var3, T var4, int var5);
    }

    private static enum CompareOp {
        LT,
        GT,
        LE,
        GE,
        EQ;

    }
}

