/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.controls;

import java.io.IOException;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.controls.ControlDecoder;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1;
import org.opends.server.protocols.asn1.ASN1Reader;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.types.ByteString;
import org.opends.server.types.Control;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

public class EntryChangelogNotificationControl
extends Control {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private String cookie;
    public static final ControlDecoder<EntryChangelogNotificationControl> DECODER = new Decoder();

    public EntryChangelogNotificationControl(boolean isCritical, String cookie) {
        super("1.3.6.1.4.1.26027.1.5.4", isCritical);
        this.cookie = cookie;
    }

    @Override
    public void writeValue(ASN1Writer writer) throws IOException {
        writer.writeStartSequence((byte)4);
        writer.writeStartSequence();
        writer.writeOctetString(this.cookie.toString());
        writer.writeEndSequence();
        writer.writeEndSequence();
    }

    public String getCookie() {
        return this.cookie;
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("EntryChangelogNotificationControl(cookie=");
        buffer.append(this.cookie.toString());
        buffer.append(")");
    }

    private static final class Decoder
    implements ControlDecoder<EntryChangelogNotificationControl> {
        private Decoder() {
        }

        @Override
        public EntryChangelogNotificationControl decode(boolean isCritical, ByteString value) throws DirectoryException {
            if (value == null) {
                Message message = ProtocolMessages.ERR_ECLN_NO_CONTROL_VALUE.get();
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
            }
            String cookie = null;
            ASN1Reader reader = ASN1.getReader(value);
            try {
                reader.readStartSequence();
                cookie = reader.readOctetStringAsString();
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = ProtocolMessages.ERR_ECLN_CANNOT_DECODE_VALUE.get(StaticUtils.getExceptionMessage(e));
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, e);
            }
            return new EntryChangelogNotificationControl(isCritical, cookie);
        }

        @Override
        public String getOID() {
            return "1.3.6.1.4.1.26027.1.5.4";
        }
    }
}

