/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.controls;

import java.io.IOException;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.controls.ControlDecoder;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1;
import org.opends.server.protocols.asn1.ASN1Reader;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.protocols.ldap.LDAPReader;
import org.opends.server.protocols.ldap.SearchResultEntryProtocolOp;
import org.opends.server.types.ByteString;
import org.opends.server.types.Control;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.LDAPException;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchResultEntry;

public class LDAPPreReadResponseControl
extends Control {
    public static final ControlDecoder<LDAPPreReadResponseControl> DECODER = new Decoder();
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private SearchResultEntry searchEntry;

    public LDAPPreReadResponseControl(SearchResultEntry searchEntry) {
        this(false, searchEntry);
    }

    public LDAPPreReadResponseControl(boolean isCritical, SearchResultEntry searchEntry) {
        super("1.3.6.1.1.13.1", isCritical);
        this.searchEntry = searchEntry;
    }

    @Override
    public void writeValue(ASN1Writer writer) throws IOException {
        writer.writeStartSequence((byte)4);
        SearchResultEntryProtocolOp protocolOp = new SearchResultEntryProtocolOp(this.searchEntry);
        protocolOp.write(writer);
        writer.writeEndSequence();
    }

    public SearchResultEntry getSearchEntry() {
        return this.searchEntry;
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("LDAPPreReadResponseControl(criticality=");
        buffer.append(this.isCritical());
        buffer.append(",entry=");
        this.searchEntry.toSingleLineString(buffer);
        buffer.append(")");
    }

    private static final class Decoder
    implements ControlDecoder<LDAPPreReadResponseControl> {
        private Decoder() {
        }

        @Override
        public LDAPPreReadResponseControl decode(boolean isCritical, ByteString value) throws DirectoryException {
            SearchResultEntry searchEntry;
            if (value == null) {
                Message message = ProtocolMessages.ERR_PREREADRESP_NO_CONTROL_VALUE.get();
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
            }
            ASN1Reader reader = ASN1.getReader(value);
            try {
                SearchResultEntryProtocolOp searchResultEntryProtocolOp = LDAPReader.readSearchEntry(reader);
                searchEntry = searchResultEntryProtocolOp.toSearchResultEntry();
            }
            catch (LDAPException le) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, le);
                }
                Message message = ProtocolMessages.ERR_PREREADRESP_CANNOT_DECODE_VALUE.get(le.getMessage());
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, le);
            }
            return new LDAPPreReadResponseControl(isCritical, searchEntry);
        }

        @Override
        public String getOID() {
            return "1.3.6.1.1.13.1";
        }
    }
}

