/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opends.messages.CoreMessages;
import org.opends.messages.MessageBuilder;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.plugin.PluginResult;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.PluginConfigManager;
import org.opends.server.core.Workflow;
import org.opends.server.core.networkgroups.NetworkGroup;
import org.opends.server.loggers.AccessLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.ldap.LDAPAttribute;
import org.opends.server.protocols.ldap.LDAPModification;
import org.opends.server.types.AbstractOperation;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeBuilder;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.CancelResult;
import org.opends.server.types.CanceledOperationException;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.LDAPException;
import org.opends.server.types.Modification;
import org.opends.server.types.OperationType;
import org.opends.server.types.RawModification;
import org.opends.server.types.ResultCode;
import org.opends.server.types.operation.PostResponseModifyOperation;
import org.opends.server.types.operation.PreParseModifyOperation;
import org.opends.server.workflowelement.localbackend.LocalBackendModifyOperation;

public class ModifyOperationBasis
extends AbstractOperation
implements ModifyOperation,
PreParseModifyOperation,
PostResponseModifyOperation {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private ByteString rawEntryDN;
    private DN entryDN;
    private DN proxiedAuthorizationDN;
    private List<Control> responseControls;
    private List<RawModification> rawModifications;
    private List<Modification> modifications;
    private long changeNumber;

    public ModifyOperationBasis(ClientConnection clientConnection, long operationID, int messageID, List<Control> requestControls, ByteString rawEntryDN, List<RawModification> rawModifications) {
        super(clientConnection, operationID, messageID, requestControls);
        this.rawEntryDN = rawEntryDN;
        this.rawModifications = rawModifications;
        this.entryDN = null;
        this.modifications = null;
        this.responseControls = new ArrayList<Control>();
        this.cancelRequest = null;
    }

    public ModifyOperationBasis(ClientConnection clientConnection, long operationID, int messageID, List<Control> requestControls, DN entryDN, List<Modification> modifications) {
        super(clientConnection, operationID, messageID, requestControls);
        this.entryDN = entryDN;
        this.modifications = modifications;
        this.rawEntryDN = ByteString.valueOf(entryDN.toString());
        this.rawModifications = new ArrayList<RawModification>(modifications.size());
        for (Modification m : modifications) {
            this.rawModifications.add(new LDAPModification(m.getModificationType(), new LDAPAttribute(m.getAttribute())));
        }
        this.responseControls = new ArrayList<Control>();
        this.cancelRequest = null;
    }

    @Override
    public final ByteString getRawEntryDN() {
        return this.rawEntryDN;
    }

    @Override
    public final void setRawEntryDN(ByteString rawEntryDN) {
        this.rawEntryDN = rawEntryDN;
        this.entryDN = null;
    }

    @Override
    public final DN getEntryDN() {
        if (this.entryDN == null) {
            try {
                this.entryDN = DN.decode(this.rawEntryDN);
            }
            catch (DirectoryException de) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                }
                this.setResultCode(de.getResultCode());
                this.appendErrorMessage(de.getMessageObject());
            }
        }
        return this.entryDN;
    }

    @Override
    public final List<RawModification> getRawModifications() {
        return this.rawModifications;
    }

    @Override
    public final void addRawModification(RawModification rawModification) {
        this.rawModifications.add(rawModification);
        this.modifications = null;
    }

    @Override
    public final void setRawModifications(List<RawModification> rawModifications) {
        this.rawModifications = rawModifications;
        this.modifications = null;
    }

    @Override
    public final List<Modification> getModifications() {
        if (this.modifications == null) {
            this.modifications = new ArrayList<Modification>(this.rawModifications.size());
            try {
                for (RawModification m : this.rawModifications) {
                    Modification mod = m.toModification();
                    Attribute attr = mod.getAttribute();
                    AttributeType type = attr.getAttributeType();
                    if (type.isBinary()) {
                        if (!attr.hasOption("binary")) {
                            AttributeBuilder builder = new AttributeBuilder(attr);
                            builder.setOption("binary");
                            attr = builder.toAttribute();
                            mod.setAttribute(attr);
                        }
                    } else if (attr.hasOption("binary")) {
                        throw new LDAPException(17, CoreMessages.ERR_ADD_ATTR_IS_INVALID_OPTION.get(String.valueOf(this.entryDN), attr.getName()));
                    }
                    this.modifications.add(mod);
                }
            }
            catch (LDAPException le) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, le);
                }
                this.setResultCode(ResultCode.valueOf(le.getResultCode()));
                this.appendErrorMessage(le.getMessageObject());
                this.modifications = null;
            }
        }
        return this.modifications;
    }

    @Override
    public final void addModification(Modification modification) throws DirectoryException {
        this.modifications.add(modification);
    }

    @Override
    public final OperationType getOperationType() {
        return OperationType.MODIFY;
    }

    @Override
    public final String[][] getRequestLogElements() {
        return new String[][]{{"entryDN", String.valueOf(this.rawEntryDN)}};
    }

    @Override
    public final String[][] getResponseLogElements() {
        String referrals;
        String resultCode = String.valueOf(this.getResultCode().getIntValue());
        MessageBuilder errorMessageBuffer = this.getErrorMessage();
        String errorMessage = errorMessageBuffer == null ? null : errorMessageBuffer.toString();
        DN matchedDN = this.getMatchedDN();
        String matchedDNStr = matchedDN == null ? null : matchedDN.toString();
        List<String> referralURLs = this.getReferralURLs();
        if (referralURLs == null || referralURLs.isEmpty()) {
            referrals = null;
        } else {
            StringBuilder buffer = new StringBuilder();
            Iterator<String> iterator = referralURLs.iterator();
            buffer.append(iterator.next());
            while (iterator.hasNext()) {
                buffer.append(", ");
                buffer.append(iterator.next());
            }
            referrals = buffer.toString();
        }
        String processingTime = String.valueOf(this.getProcessingTime());
        return new String[][]{{"resultCode", resultCode}, {"errorMessage", errorMessage}, {"matchedDN", matchedDNStr}, {"referralURLs", referrals}, {"processingTime", processingTime}};
    }

    @Override
    public DN getProxiedAuthorizationDN() {
        return this.proxiedAuthorizationDN;
    }

    @Override
    public final List<Control> getResponseControls() {
        return this.responseControls;
    }

    @Override
    public final void addResponseControl(Control control) {
        this.responseControls.add(control);
    }

    @Override
    public final void removeResponseControl(Control control) {
        this.responseControls.remove(control);
    }

    @Override
    public final void toString(StringBuilder buffer) {
        buffer.append("ModifyOperation(connID=");
        buffer.append(this.clientConnection.getConnectionID());
        buffer.append(", opID=");
        buffer.append(this.operationID);
        buffer.append(", dn=");
        buffer.append(this.rawEntryDN);
        buffer.append(")");
    }

    @Override
    public final long getChangeNumber() {
        return this.changeNumber;
    }

    @Override
    public void setChangeNumber(long changeNumber) {
        this.changeNumber = changeNumber;
    }

    @Override
    public void setProxiedAuthorizationDN(DN proxiedAuthorizationDN) {
        this.proxiedAuthorizationDN = proxiedAuthorizationDN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        this.setResultCode(ResultCode.UNDEFINED);
        this.setProcessingStartTime();
        AccessLogger.logModifyRequest(this);
        PluginConfigManager pluginConfigManager = DirectoryServer.getPluginConfigManager();
        boolean workflowExecuted = false;
        try {
            this.checkIfCanceled(false);
            PluginResult.PreParse preParseResult = pluginConfigManager.invokePreParseModifyPlugins(this);
            if (!preParseResult.continueProcessing()) {
                this.setResultCode(preParseResult.getResultCode());
                this.appendErrorMessage(preParseResult.getErrorMessage());
                this.setMatchedDN(preParseResult.getMatchedDN());
                this.setReferralURLs(preParseResult.getReferralURLs());
                return;
            }
            this.checkIfCanceled(false);
            DN entryDN = this.getEntryDN();
            if (entryDN == null) {
                return;
            }
            NetworkGroup ng = this.getClientConnection().getNetworkGroup();
            Workflow workflow = ng.getWorkflowCandidate(entryDN);
            if (workflow == null) {
                this.updateOperationErrMsgAndResCode();
                return;
            }
            workflow.execute(this);
            workflowExecuted = true;
        }
        catch (CanceledOperationException coe) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, coe);
            }
            this.setResultCode(ResultCode.CANCELED);
            this.cancelResult = new CancelResult(ResultCode.CANCELED, null);
            this.appendErrorMessage(coe.getCancelRequest().getCancelReason());
        }
        finally {
            this.setProcessingStopTime();
            AccessLogger.logModifyResponse(this);
            if (this.cancelRequest == null || this.cancelResult == null || this.cancelResult.getResultCode() != ResultCode.CANCELED || this.cancelRequest.notifyOriginalRequestor() || DirectoryServer.notifyAbandonedOperations()) {
                this.clientConnection.sendResponse(this);
            }
            if (workflowExecuted) {
                this.invokePostResponseCallbacks();
            }
            this.invokePostResponsePlugins(workflowExecuted);
            if (this.cancelResult == null) {
                this.cancelResult = new CancelResult(ResultCode.TOO_LATE, null);
            }
        }
    }

    private void invokePostResponsePlugins(boolean workflowExecuted) {
        PluginConfigManager pluginConfigManager = DirectoryServer.getPluginConfigManager();
        if (workflowExecuted) {
            List localOperations = (List)this.getAttachment("LocalBackendOperations");
            if (localOperations != null) {
                for (LocalBackendModifyOperation localOperation : localOperations) {
                    pluginConfigManager.invokePostResponseModifyPlugins(localOperation);
                }
            }
        } else {
            pluginConfigManager.invokePostResponseModifyPlugins(this);
        }
    }

    private void updateOperationErrMsgAndResCode() {
        this.setResultCode(ResultCode.NO_SUCH_OBJECT);
        this.appendErrorMessage(CoreMessages.ERR_MODIFY_NO_SUCH_ENTRY.get(String.valueOf(this.getEntryDN())));
    }

    @Override
    public Entry getCurrentEntry() {
        return null;
    }

    @Override
    public List<AttributeValue> getCurrentPasswords() {
        return null;
    }

    @Override
    public Entry getModifiedEntry() {
        return null;
    }

    @Override
    public List<AttributeValue> getNewPasswords() {
        return null;
    }
}

