/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.opends.messages.CoreMessages;
import org.opends.server.api.Backend;
import org.opends.server.api.BackendInitializationListener;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.DITCacheMap;
import org.opends.server.api.SubentryChangeListener;
import org.opends.server.api.plugin.InternalDirectoryServerPlugin;
import org.opends.server.api.plugin.PluginResult;
import org.opends.server.api.plugin.PluginType;
import org.opends.server.controls.SubentriesControl;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.protocols.internal.InternalSearchOperation;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DereferencePolicy;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.Privilege;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SearchScope;
import org.opends.server.types.SubEntry;
import org.opends.server.types.SubtreeSpecification;
import org.opends.server.types.operation.PostOperationAddOperation;
import org.opends.server.types.operation.PostOperationDeleteOperation;
import org.opends.server.types.operation.PostOperationModifyDNOperation;
import org.opends.server.types.operation.PostOperationModifyOperation;
import org.opends.server.types.operation.PostSynchronizationAddOperation;
import org.opends.server.types.operation.PostSynchronizationDeleteOperation;
import org.opends.server.types.operation.PostSynchronizationModifyDNOperation;
import org.opends.server.types.operation.PostSynchronizationModifyOperation;
import org.opends.server.types.operation.PreOperationAddOperation;
import org.opends.server.types.operation.PreOperationDeleteOperation;
import org.opends.server.types.operation.PreOperationModifyDNOperation;
import org.opends.server.types.operation.PreOperationModifyOperation;
import org.opends.server.workflowelement.localbackend.LocalBackendSearchOperation;

public class SubentryManager
extends InternalDirectoryServerPlugin
implements BackendInitializationListener {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private HashMap<DN, List<SubEntry>> dn2SubEntry;
    private HashMap<DN, List<SubEntry>> dn2CollectiveSubEntry;
    private DITCacheMap<SubEntry> dit2SubEntry;
    private LinkedHashSet<String> requestAttrs;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private CopyOnWriteArrayList<SubentryChangeListener> changeListeners;
    private static final String CONFIG_DN = "cn=Subentry Manager,cn=config";

    public SubentryManager() throws DirectoryException {
        super(DN.decode(CONFIG_DN), EnumSet.of(PluginType.PRE_OPERATION_ADD, new PluginType[]{PluginType.PRE_OPERATION_DELETE, PluginType.PRE_OPERATION_MODIFY, PluginType.PRE_OPERATION_MODIFY_DN, PluginType.POST_OPERATION_ADD, PluginType.POST_OPERATION_DELETE, PluginType.POST_OPERATION_MODIFY, PluginType.POST_OPERATION_MODIFY_DN, PluginType.POST_SYNCHRONIZATION_ADD, PluginType.POST_SYNCHRONIZATION_DELETE, PluginType.POST_SYNCHRONIZATION_MODIFY, PluginType.POST_SYNCHRONIZATION_MODIFY_DN}), true);
        this.dn2SubEntry = new HashMap();
        this.dn2CollectiveSubEntry = new HashMap();
        this.dit2SubEntry = new DITCacheMap();
        this.changeListeners = new CopyOnWriteArrayList();
        this.requestAttrs = new LinkedHashSet();
        this.requestAttrs.add("*");
        this.requestAttrs.add("+");
        DirectoryServer.registerInternalPlugin(this);
        DirectoryServer.registerBackendInitializationListener(this);
    }

    public void finalizeSubentryManager() {
        DirectoryServer.deregisterInternalPlugin(this);
        DirectoryServer.deregisterBackendInitializationListener(this);
    }

    public void registerChangeListener(SubentryChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    public void deregisterChangeListener(SubentryChangeListener changeListener) {
        this.changeListeners.remove(changeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSubEntry(Entry entry) throws DirectoryException {
        SubEntry subEntry = new SubEntry(entry);
        SubtreeSpecification subSpec = subEntry.getSubTreeSpecification();
        DN subDN = subSpec.getBaseDN();
        List<SubEntry> subList = null;
        this.lock.writeLock().lock();
        try {
            subList = subEntry.isCollective() || subEntry.isInheritedCollective() ? this.dn2CollectiveSubEntry.get(subDN) : this.dn2SubEntry.get(subDN);
            if (subList == null) {
                subList = new ArrayList<SubEntry>();
                if (subEntry.isCollective() || subEntry.isInheritedCollective()) {
                    this.dn2CollectiveSubEntry.put(subDN, subList);
                } else {
                    this.dn2SubEntry.put(subDN, subList);
                }
            }
            this.dit2SubEntry.put(entry.getDN(), subEntry);
            subList.add(subEntry);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSubEntry(Entry entry) {
        this.lock.writeLock().lock();
        try {
            SubEntry subEntry;
            Iterator<SubEntry> listIterator;
            List<SubEntry> subList;
            Map.Entry<DN, List<SubEntry>> mapEntry;
            boolean removed = false;
            Iterator<Map.Entry<DN, List<SubEntry>>> setIterator = this.dn2SubEntry.entrySet().iterator();
            while (setIterator.hasNext()) {
                mapEntry = setIterator.next();
                subList = mapEntry.getValue();
                listIterator = subList.iterator();
                while (listIterator.hasNext()) {
                    subEntry = listIterator.next();
                    if (!subEntry.getDN().equals(entry.getDN())) continue;
                    this.dit2SubEntry.remove(entry.getDN());
                    listIterator.remove();
                    removed = true;
                    break;
                }
                if (subList.isEmpty()) {
                    setIterator.remove();
                }
                if (!removed) continue;
                return;
            }
            setIterator = this.dn2CollectiveSubEntry.entrySet().iterator();
            while (setIterator.hasNext()) {
                mapEntry = setIterator.next();
                subList = mapEntry.getValue();
                listIterator = subList.iterator();
                while (listIterator.hasNext()) {
                    subEntry = listIterator.next();
                    if (!subEntry.getDN().equals(entry.getDN())) continue;
                    this.dit2SubEntry.remove(entry.getDN());
                    listIterator.remove();
                    removed = true;
                    break;
                }
                if (subList.isEmpty()) {
                    setIterator.remove();
                }
                if (!removed) continue;
                return;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void performBackendPreInitializationProcessing(Backend backend) {
        SearchFilter filter;
        LinkedList<Control> requestControls;
        InternalClientConnection conn;
        block15: {
            conn = InternalClientConnection.getRootConnection();
            requestControls = new LinkedList<Control>();
            requestControls.add(new SubentriesControl(true, true));
            filter = null;
            try {
                filter = SearchFilter.createFilterFromString("(|(objectClass=subentry)(objectClass=ldapSubentry))");
                if (backend.getEntryCount() > 0L && !backend.isIndexed(filter)) {
                    ErrorLogger.logError(CoreMessages.WARN_SUBENTRY_FILTER_NOT_INDEXED.get(String.valueOf(filter), backend.getBackendID()));
                }
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) break block15;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        for (DN baseDN : backend.getBaseDNs()) {
            block16: {
                try {
                    if (!backend.entryExists(baseDN)) {
                    }
                    break block16;
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                continue;
            }
            InternalSearchOperation internalSearch = new InternalSearchOperation((ClientConnection)conn, InternalClientConnection.nextOperationID(), InternalClientConnection.nextMessageID(), requestControls, baseDN, SearchScope.WHOLE_SUBTREE, DereferencePolicy.NEVER_DEREF_ALIASES, 0, 0, false, filter, this.requestAttrs, null);
            LocalBackendSearchOperation localSearch = new LocalBackendSearchOperation(internalSearch);
            try {
                backend.search(localSearch);
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
                continue;
            }
            for (SearchResultEntry entry : internalSearch.getSearchEntries()) {
                if (!entry.isSubentry() && !entry.isLDAPSubentry()) continue;
                try {
                    this.addSubEntry(entry);
                    for (SubentryChangeListener changeListener : this.changeListeners) {
                        try {
                            changeListener.handleSubentryAdd(entry);
                        }
                        catch (Exception e) {
                            if (!DebugLogger.debugEnabled()) continue;
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                    }
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SubEntry> getSubentries() {
        if (this.dn2SubEntry.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SubEntry> subentries = new ArrayList<SubEntry>();
        this.lock.readLock().lock();
        try {
            for (List<SubEntry> subList : this.dn2SubEntry.values()) {
                subentries.addAll(subList);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return subentries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SubEntry> getSubentries(DN dn) {
        if (this.dn2SubEntry.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SubEntry> subentries = new ArrayList<SubEntry>();
        this.lock.readLock().lock();
        try {
            for (DN subDN = dn; subDN != null; subDN = subDN.getParent()) {
                List<SubEntry> subList = this.dn2SubEntry.get(subDN);
                if (subList == null) continue;
                for (SubEntry subEntry : subList) {
                    SubtreeSpecification subSpec = subEntry.getSubTreeSpecification();
                    if (!subSpec.isDNWithinScope(dn)) continue;
                    subentries.add(subEntry);
                }
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return subentries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SubEntry> getSubentries(Entry entry) {
        if (this.dn2SubEntry.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SubEntry> subentries = new ArrayList<SubEntry>();
        this.lock.readLock().lock();
        try {
            for (DN subDN = entry.getDN(); subDN != null; subDN = subDN.getParent()) {
                List<SubEntry> subList = this.dn2SubEntry.get(subDN);
                if (subList == null) continue;
                for (SubEntry subEntry : subList) {
                    SubtreeSpecification subSpec = subEntry.getSubTreeSpecification();
                    if (!subSpec.isWithinScope(entry)) continue;
                    subentries.add(subEntry);
                }
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return subentries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SubEntry> getCollectiveSubentries(DN dn) {
        if (this.dn2CollectiveSubEntry.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SubEntry> subentries = new ArrayList<SubEntry>();
        this.lock.readLock().lock();
        try {
            for (DN subDN = dn; subDN != null; subDN = subDN.getParent()) {
                List<SubEntry> subList = this.dn2CollectiveSubEntry.get(subDN);
                if (subList == null) continue;
                for (SubEntry subEntry : subList) {
                    SubtreeSpecification subSpec = subEntry.getSubTreeSpecification();
                    if (!subSpec.isDNWithinScope(dn)) continue;
                    subentries.add(subEntry);
                }
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return subentries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SubEntry> getCollectiveSubentries(Entry entry) {
        if (this.dn2CollectiveSubEntry.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SubEntry> subentries = new ArrayList<SubEntry>();
        this.lock.readLock().lock();
        try {
            for (DN subDN = entry.getDN(); subDN != null; subDN = subDN.getParent()) {
                List<SubEntry> subList = this.dn2CollectiveSubEntry.get(subDN);
                if (subList == null) continue;
                for (SubEntry subEntry : subList) {
                    SubtreeSpecification subSpec = subEntry.getSubTreeSpecification();
                    if (!subSpec.isWithinScope(entry)) continue;
                    subentries.add(subEntry);
                }
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return subentries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performBackendPostFinalizationProcessing(Backend backend) {
        this.lock.writeLock().lock();
        try {
            SubEntry subEntry;
            Iterator<SubEntry> listIterator;
            List<SubEntry> subList;
            Map.Entry<DN, List<SubEntry>> mapEntry;
            Iterator<Map.Entry<DN, List<SubEntry>>> setIterator = this.dn2SubEntry.entrySet().iterator();
            while (setIterator.hasNext()) {
                mapEntry = setIterator.next();
                subList = mapEntry.getValue();
                listIterator = subList.iterator();
                while (listIterator.hasNext()) {
                    subEntry = listIterator.next();
                    if (!backend.handlesEntry(subEntry.getDN())) continue;
                    this.dit2SubEntry.remove(subEntry.getDN());
                    listIterator.remove();
                    for (SubentryChangeListener changeListener : this.changeListeners) {
                        try {
                            changeListener.handleSubentryDelete(subEntry.getEntry());
                        }
                        catch (Exception e) {
                            if (!DebugLogger.debugEnabled()) continue;
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                    }
                }
                if (!subList.isEmpty()) continue;
                setIterator.remove();
            }
            setIterator = this.dn2CollectiveSubEntry.entrySet().iterator();
            while (setIterator.hasNext()) {
                mapEntry = setIterator.next();
                subList = mapEntry.getValue();
                listIterator = subList.iterator();
                while (listIterator.hasNext()) {
                    subEntry = listIterator.next();
                    if (!backend.handlesEntry(subEntry.getDN())) continue;
                    this.dit2SubEntry.remove(subEntry.getDN());
                    listIterator.remove();
                    for (SubentryChangeListener changeListener : this.changeListeners) {
                        try {
                            changeListener.handleSubentryDelete(subEntry.getEntry());
                        }
                        catch (Exception e) {
                            if (!DebugLogger.debugEnabled()) continue;
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                    }
                }
                if (!subList.isEmpty()) continue;
                setIterator.remove();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void performBackendPostInitializationProcessing(Backend backend) {
    }

    @Override
    public void performBackendPreFinalizationProcessing(Backend backend) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPostAdd(Entry entry) {
        if (entry.isSubentry() || entry.isLDAPSubentry()) {
            this.lock.writeLock().lock();
            try {
                try {
                    this.addSubEntry(entry);
                    for (SubentryChangeListener changeListener : this.changeListeners) {
                        try {
                            changeListener.handleSubentryAdd(entry);
                        }
                        catch (Exception e) {
                            if (!DebugLogger.debugEnabled()) continue;
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                    }
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPostDelete(Entry entry) {
        this.lock.writeLock().lock();
        try {
            for (SubEntry subEntry : this.dit2SubEntry.getSubtree(entry.getDN())) {
                this.removeSubEntry(subEntry.getEntry());
                for (SubentryChangeListener changeListener : this.changeListeners) {
                    try {
                        changeListener.handleSubentryDelete(subEntry.getEntry());
                    }
                    catch (Exception e) {
                        if (!DebugLogger.debugEnabled()) continue;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPostModify(Entry oldEntry, Entry newEntry) {
        boolean notify = false;
        this.lock.writeLock().lock();
        try {
            block11: {
                if (oldEntry.isSubentry() || oldEntry.isLDAPSubentry()) {
                    this.removeSubEntry(oldEntry);
                    notify = true;
                }
                if (newEntry.isSubentry() || newEntry.isLDAPSubentry()) {
                    try {
                        this.addSubEntry(newEntry);
                        notify = true;
                    }
                    catch (Exception e) {
                        if (!DebugLogger.debugEnabled()) break block11;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
            }
            if (notify) {
                for (SubentryChangeListener changeListener : this.changeListeners) {
                    try {
                        changeListener.handleSubentryModify(oldEntry, newEntry);
                    }
                    catch (Exception e) {
                        if (!DebugLogger.debugEnabled()) continue;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPostModifyDN(Entry oldEntry, Entry newEntry) {
        String oldDNString = oldEntry.getDN().toNormalizedString();
        String newDNString = newEntry.getDN().toNormalizedString();
        this.lock.writeLock().lock();
        try {
            Collection<SubEntry> setToDelete = this.dit2SubEntry.getSubtree(oldEntry.getDN());
            for (SubEntry subentry : setToDelete) {
                block9: {
                    this.removeSubEntry(subentry.getEntry());
                    oldEntry = subentry.getEntry();
                    try {
                        StringBuilder builder = new StringBuilder(subentry.getEntry().getDN().toNormalizedString());
                        int oldDNIndex = builder.lastIndexOf(oldDNString);
                        builder.replace(oldDNIndex, builder.length(), newDNString);
                        String subentryDNString = builder.toString();
                        newEntry = subentry.getEntry().duplicate(false);
                        newEntry.setDN(DN.decode(subentryDNString));
                        this.addSubEntry(newEntry);
                    }
                    catch (Exception e) {
                        if (!DebugLogger.debugEnabled()) break block9;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
                for (SubentryChangeListener changeListener : this.changeListeners) {
                    try {
                        changeListener.handleSubentryModify(oldEntry, newEntry);
                    }
                    catch (Exception e) {
                        if (!DebugLogger.debugEnabled()) continue;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public PluginResult.PreOperation doPreOperation(PreOperationAddOperation addOperation) {
        Entry entry = addOperation.getEntryToAdd();
        if (entry.isSubentry() || entry.isLDAPSubentry()) {
            ClientConnection conn = addOperation.getClientConnection();
            if (!conn.hasPrivilege(Privilege.SUBENTRY_WRITE, conn.getOperationInProgress(addOperation.getMessageID()))) {
                return PluginResult.PreOperation.stopProcessing(ResultCode.INSUFFICIENT_ACCESS_RIGHTS, CoreMessages.ERR_SUBENTRY_WRITE_INSUFFICIENT_PRIVILEGES.get());
            }
            for (SubentryChangeListener changeListener : this.changeListeners) {
                try {
                    changeListener.checkSubentryAddAcceptable(entry);
                }
                catch (DirectoryException de) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, de);
                    }
                    return PluginResult.PreOperation.stopProcessing(de.getResultCode(), de.getMessageObject());
                }
            }
        }
        return PluginResult.PreOperation.continueOperationProcessing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PluginResult.PreOperation doPreOperation(PreOperationDeleteOperation deleteOperation) {
        Entry entry = deleteOperation.getEntryToDelete();
        boolean hasSubentryWritePrivilege = false;
        this.lock.readLock().lock();
        try {
            for (SubEntry subEntry : this.dit2SubEntry.getSubtree(entry.getDN())) {
                if (!hasSubentryWritePrivilege) {
                    ClientConnection conn = deleteOperation.getClientConnection();
                    if (!conn.hasPrivilege(Privilege.SUBENTRY_WRITE, conn.getOperationInProgress(deleteOperation.getMessageID()))) {
                        PluginResult.PreOperation preOperation = PluginResult.PreOperation.stopProcessing(ResultCode.INSUFFICIENT_ACCESS_RIGHTS, CoreMessages.ERR_SUBENTRY_WRITE_INSUFFICIENT_PRIVILEGES.get());
                        return preOperation;
                    }
                    hasSubentryWritePrivilege = true;
                }
                for (SubentryChangeListener changeListener : this.changeListeners) {
                    try {
                        changeListener.checkSubentryDeleteAcceptable(subEntry.getEntry());
                    }
                    catch (DirectoryException de) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, de);
                        }
                        PluginResult.PreOperation preOperation = PluginResult.PreOperation.stopProcessing(de.getResultCode(), de.getMessageObject());
                        this.lock.readLock().unlock();
                        return preOperation;
                    }
                }
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return PluginResult.PreOperation.continueOperationProcessing();
    }

    @Override
    public PluginResult.PreOperation doPreOperation(PreOperationModifyOperation modifyOperation) {
        Entry oldEntry = modifyOperation.getCurrentEntry();
        Entry newEntry = modifyOperation.getModifiedEntry();
        if (newEntry.isSubentry() || newEntry.isLDAPSubentry() || oldEntry.isSubentry() || oldEntry.isLDAPSubentry()) {
            ClientConnection conn = modifyOperation.getClientConnection();
            if (!conn.hasPrivilege(Privilege.SUBENTRY_WRITE, conn.getOperationInProgress(modifyOperation.getMessageID()))) {
                return PluginResult.PreOperation.stopProcessing(ResultCode.INSUFFICIENT_ACCESS_RIGHTS, CoreMessages.ERR_SUBENTRY_WRITE_INSUFFICIENT_PRIVILEGES.get());
            }
            for (SubentryChangeListener changeListener : this.changeListeners) {
                try {
                    changeListener.checkSubentryModifyAcceptable(oldEntry, newEntry);
                }
                catch (DirectoryException de) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, de);
                    }
                    return PluginResult.PreOperation.stopProcessing(de.getResultCode(), de.getMessageObject());
                }
            }
        }
        return PluginResult.PreOperation.continueOperationProcessing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PluginResult.PreOperation doPreOperation(PreOperationModifyDNOperation modifyDNOperation) {
        Entry oldEntry = modifyDNOperation.getOriginalEntry();
        Entry newEntry = modifyDNOperation.getUpdatedEntry();
        String oldDNString = oldEntry.getDN().toNormalizedString();
        String newDNString = newEntry.getDN().toNormalizedString();
        boolean hasSubentryWritePrivilege = false;
        this.lock.readLock().lock();
        try {
            Collection<SubEntry> setToDelete = this.dit2SubEntry.getSubtree(oldEntry.getDN());
            for (SubEntry subentry : setToDelete) {
                block14: {
                    if (!hasSubentryWritePrivilege) {
                        ClientConnection conn = modifyDNOperation.getClientConnection();
                        if (!conn.hasPrivilege(Privilege.SUBENTRY_WRITE, conn.getOperationInProgress(modifyDNOperation.getMessageID()))) {
                            PluginResult.PreOperation preOperation = PluginResult.PreOperation.stopProcessing(ResultCode.INSUFFICIENT_ACCESS_RIGHTS, CoreMessages.ERR_SUBENTRY_WRITE_INSUFFICIENT_PRIVILEGES.get());
                            return preOperation;
                        }
                        hasSubentryWritePrivilege = true;
                    }
                    oldEntry = subentry.getEntry();
                    try {
                        StringBuilder builder = new StringBuilder(subentry.getEntry().getDN().toNormalizedString());
                        int oldDNIndex = builder.lastIndexOf(oldDNString);
                        builder.replace(oldDNIndex, builder.length(), newDNString);
                        String subentryDNString = builder.toString();
                        newEntry = subentry.getEntry().duplicate(false);
                        newEntry.setDN(DN.decode(subentryDNString));
                    }
                    catch (Exception e) {
                        if (!DebugLogger.debugEnabled()) break block14;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
                for (SubentryChangeListener changeListener : this.changeListeners) {
                    try {
                        changeListener.checkSubentryModifyAcceptable(oldEntry, newEntry);
                    }
                    catch (DirectoryException de) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, de);
                        }
                        PluginResult.PreOperation preOperation = PluginResult.PreOperation.stopProcessing(de.getResultCode(), de.getMessageObject());
                        this.lock.readLock().unlock();
                        return preOperation;
                    }
                }
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return PluginResult.PreOperation.continueOperationProcessing();
    }

    @Override
    public PluginResult.PostOperation doPostOperation(PostOperationAddOperation addOperation) {
        if (addOperation.getResultCode() == ResultCode.SUCCESS) {
            this.doPostAdd(addOperation.getEntryToAdd());
        }
        return PluginResult.PostOperation.continueOperationProcessing();
    }

    @Override
    public PluginResult.PostOperation doPostOperation(PostOperationDeleteOperation deleteOperation) {
        if (deleteOperation.getResultCode() == ResultCode.SUCCESS) {
            this.doPostDelete(deleteOperation.getEntryToDelete());
        }
        return PluginResult.PostOperation.continueOperationProcessing();
    }

    @Override
    public PluginResult.PostOperation doPostOperation(PostOperationModifyOperation modifyOperation) {
        if (modifyOperation.getResultCode() == ResultCode.SUCCESS) {
            this.doPostModify(modifyOperation.getCurrentEntry(), modifyOperation.getModifiedEntry());
        }
        return PluginResult.PostOperation.continueOperationProcessing();
    }

    @Override
    public PluginResult.PostOperation doPostOperation(PostOperationModifyDNOperation modifyDNOperation) {
        if (modifyDNOperation.getResultCode() == ResultCode.SUCCESS) {
            this.doPostModifyDN(modifyDNOperation.getOriginalEntry(), modifyDNOperation.getUpdatedEntry());
        }
        return PluginResult.PostOperation.continueOperationProcessing();
    }

    @Override
    public void doPostSynchronization(PostSynchronizationAddOperation addOperation) {
        Entry entry = addOperation.getEntryToAdd();
        if (entry != null) {
            this.doPostAdd(entry);
        }
    }

    @Override
    public void doPostSynchronization(PostSynchronizationDeleteOperation deleteOperation) {
        Entry entry = deleteOperation.getEntryToDelete();
        if (entry != null) {
            this.doPostDelete(entry);
        }
    }

    @Override
    public void doPostSynchronization(PostSynchronizationModifyOperation modifyOperation) {
        Entry entry = modifyOperation.getCurrentEntry();
        Entry modEntry = modifyOperation.getModifiedEntry();
        if (entry != null && modEntry != null) {
            this.doPostModify(entry, modEntry);
        }
    }

    @Override
    public void doPostSynchronization(PostSynchronizationModifyDNOperation modifyDNOperation) {
        Entry oldEntry = modifyDNOperation.getOriginalEntry();
        Entry newEntry = modifyDNOperation.getUpdatedEntry();
        if (oldEntry != null && newEntry != null) {
            this.doPostModifyDN(oldEntry, newEntry);
        }
    }
}

