/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.opends.messages.ConfigMessages;
import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.server.admin.std.meta.PasswordPolicyCfgDefn;
import org.opends.server.admin.std.server.PasswordValidatorCfg;
import org.opends.server.api.AccountStatusNotificationHandler;
import org.opends.server.api.PasswordGenerator;
import org.opends.server.api.PasswordStorageScheme;
import org.opends.server.api.PasswordValidator;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.PasswordPolicy;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.Operation;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SubEntry;

public final class SubentryPasswordPolicy
extends PasswordPolicy {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final String PWD_OC_POLICY = "pwdpolicy";
    private static final String PWD_ATTR_ATTRIBUTE = "pwdattribute";
    private static final String PWD_ATTR_MINAGE = "pwdminage";
    private static final String PWD_ATTR_MAXAGE = "pwdmaxage";
    private static final String PWD_ATTR_INHISTORY = "pwdinhistory";
    private static final String PWD_ATTR_CHECKQUALITY = "pwdcheckquality";
    private static final String PWD_ATTR_MINLENGTH = "pwdminlength";
    private static final String PWD_ATTR_EXPIREWARNING = "pwdexpirewarning";
    private static final String PWD_ATTR_GRACEAUTHNLIMIT = "pwdgraceauthnlimit";
    private static final String PWD_ATTR_LOCKOUT = "pwdlockout";
    private static final String PWD_ATTR_LOCKOUTDURATION = "pwdlockoutduration";
    private static final String PWD_ATTR_MAXFAILURE = "pwdmaxfailure";
    private static final String PWD_ATTR_MUSTCHANGE = "pwdmustchange";
    private static final String PWD_ATTR_ALLOWUSERCHANGE = "pwdallowuserchange";
    private static final String PWD_ATTR_SAFEMODIFY = "pwdsafemodify";
    private static final String PWD_ATTR_FAILURECOUNTINTERVAL = "pwdfailurecountinterval";
    private static final String PWD_ATTR_VALIDATOR = "ds-cfg-password-validator";
    private static final String PWD_OC_VALIDATORPOLICY = "pwdvalidatorpolicy";
    private final DN passwordPolicySubentryDN;
    private final Boolean pAllowUserPasswordChanges;
    private final Boolean pForceChangeOnReset;
    private final Integer pGraceLoginCount;
    private final Long pLockoutDuration;
    private final Integer pLockoutFailureCount;
    private final Long pLockoutFailureExpirationInterval;
    private final Long pMaxPasswordAge;
    private final Long pMinPasswordAge;
    private final AttributeType pPasswordAttribute;
    private final Boolean pPasswordChangeRequiresCurrentPassword;
    private final Long pPasswordExpirationWarningInterval;
    private final Integer pPasswordHistoryCount;
    private final Boolean pAuthPasswordSyntax;
    private final Set<DN> pValidatorNames;
    private final AtomicBoolean isAlreadyLogged;

    private PasswordPolicy getDefaultPasswordPolicy() {
        return DirectoryServer.getDefaultPasswordPolicy();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public SubentryPasswordPolicy(SubEntry subentry) throws DirectoryException {
        AttributeValue value;
        Map<ObjectClass, String> objectClasses;
        Entry entry;
        block62: {
            block63: {
                this.pValidatorNames = new HashSet<DN>();
                this.isAlreadyLogged = new AtomicBoolean();
                ObjectClass pwdPolicyOC = DirectoryServer.getObjectClass(PWD_OC_POLICY);
                entry = subentry.getEntry();
                objectClasses = entry.getObjectClasses();
                if (pwdPolicyOC == null) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugWarning("No %s objectclass is defined in the server schema.", PWD_OC_POLICY);
                    }
                    for (String ocName : objectClasses.values()) {
                        if (ocName.equalsIgnoreCase(PWD_OC_POLICY)) break;
                    }
                    Message message = CoreMessages.ERR_PWPOLICY_NO_PWDPOLICY_OC.get(subentry.getDN().toString());
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
                }
                if (!objectClasses.containsKey(pwdPolicyOC)) {
                    Message message = CoreMessages.ERR_PWPOLICY_NO_PWDPOLICY_OC.get(subentry.getDN().toString());
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
                }
                this.passwordPolicySubentryDN = subentry.getDN();
                value = this.getAttrValue(entry, PWD_ATTR_ATTRIBUTE);
                if (value == null || value.toString().length() <= 0) break block63;
                this.pPasswordAttribute = DirectoryServer.getAttributeType(value.toString().toLowerCase(), false);
                if (this.pPasswordAttribute == null) {
                    throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, CoreMessages.ERR_PWPOLICY_UNDEFINED_PASSWORD_ATTRIBUTE.get(this.passwordPolicySubentryDN.toNormalizedString(), value.toString()));
                }
                String syntaxOID = this.pPasswordAttribute.getSyntaxOID();
                if (syntaxOID.equals("1.3.6.1.4.1.4203.1.1.2")) {
                    this.pAuthPasswordSyntax = true;
                    break block62;
                } else if (syntaxOID.equals("1.3.6.1.4.1.26027.1.3.1")) {
                    this.pAuthPasswordSyntax = false;
                    break block62;
                } else {
                    String syntax = this.pPasswordAttribute.getSyntax().getSyntaxName();
                    if (syntax == null || syntax.length() == 0) {
                        syntax = syntaxOID;
                    }
                    Message message = CoreMessages.ERR_PWPOLICY_INVALID_PASSWORD_ATTRIBUTE_SYNTAX.get(String.valueOf(this.passwordPolicySubentryDN), this.pPasswordAttribute.getNameOrOID(), String.valueOf(syntax));
                    throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
                }
            }
            this.pPasswordAttribute = null;
            this.pAuthPasswordSyntax = null;
        }
        if ((value = this.getAttrValue(entry, PWD_ATTR_MINAGE)) != null && value.toString().length() > 0) {
            try {
                this.pMinPasswordAge = Long.parseLong(value.toString());
                this.checkIntegerAttr(PWD_ATTR_MINAGE, this.pMinPasswordAge, 0L, Integer.MAX_VALUE);
            }
            catch (NumberFormatException ne) {
                throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, ConfigMessages.ERR_CONFIG_ATTR_INVALID_INT_VALUE.get(PWD_ATTR_MINAGE, value.toString(), ne.getLocalizedMessage()));
            }
        } else {
            this.pMinPasswordAge = null;
        }
        value = this.getAttrValue(entry, PWD_ATTR_MAXAGE);
        if (value != null && value.toString().length() > 0) {
            try {
                this.pMaxPasswordAge = Long.parseLong(value.toString());
                this.checkIntegerAttr(PWD_ATTR_MAXAGE, this.pMaxPasswordAge, 0L, Integer.MAX_VALUE);
            }
            catch (NumberFormatException ne) {
                throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, ConfigMessages.ERR_CONFIG_ATTR_INVALID_INT_VALUE.get(PWD_ATTR_MINAGE, value.toString(), ne.getLocalizedMessage()));
            }
        } else {
            this.pMaxPasswordAge = null;
        }
        value = this.getAttrValue(entry, PWD_ATTR_INHISTORY);
        if (value != null && value.toString().length() > 0) {
            try {
                this.pPasswordHistoryCount = Integer.parseInt(value.toString());
                this.checkIntegerAttr(PWD_ATTR_INHISTORY, this.pPasswordHistoryCount.intValue(), 0L, Integer.MAX_VALUE);
            }
            catch (NumberFormatException ne) {
                throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, ConfigMessages.ERR_CONFIG_ATTR_INVALID_INT_VALUE.get(PWD_ATTR_MINAGE, value.toString(), ne.getLocalizedMessage()));
            }
        } else {
            this.pPasswordHistoryCount = null;
        }
        value = this.getAttrValue(entry, PWD_ATTR_CHECKQUALITY);
        if (value != null && value.toString().length() > 0) {
            try {
                int pwdCheckQuality = Integer.parseInt(value.toString());
                this.checkIntegerAttr(PWD_ATTR_CHECKQUALITY, pwdCheckQuality, 0L, 2L);
            }
            catch (NumberFormatException ne) {
                throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, ConfigMessages.ERR_CONFIG_ATTR_INVALID_INT_VALUE.get(PWD_ATTR_MINAGE, value.toString(), ne.getLocalizedMessage()));
            }
        }
        if ((value = this.getAttrValue(entry, PWD_ATTR_MINLENGTH)) != null && value.toString().length() > 0) {
            try {
                int pwdMinLength = Integer.parseInt(value.toString());
                this.checkIntegerAttr(PWD_ATTR_MINLENGTH, pwdMinLength, 0L, Integer.MAX_VALUE);
            }
            catch (NumberFormatException ne) {
                throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, ConfigMessages.ERR_CONFIG_ATTR_INVALID_INT_VALUE.get(PWD_ATTR_MINAGE, value.toString(), ne.getLocalizedMessage()));
            }
        }
        if ((value = this.getAttrValue(entry, PWD_ATTR_LOCKOUT)) != null && value.toString().length() > 0) {
            if (!value.toString().equalsIgnoreCase(Boolean.TRUE.toString())) {
                if (!value.toString().equalsIgnoreCase(Boolean.FALSE.toString())) throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, ConfigMessages.ERR_CONFIG_ATTR_INVALID_BOOLEAN_VALUE.get(PWD_ATTR_MUSTCHANGE, value.toString()));
            }
            Boolean.parseBoolean(value.toString());
        }
        if ((value = this.getAttrValue(entry, PWD_ATTR_EXPIREWARNING)) != null && value.toString().length() > 0) {
            try {
                this.pPasswordExpirationWarningInterval = Long.parseLong(value.toString());
                this.checkIntegerAttr(PWD_ATTR_EXPIREWARNING, this.pPasswordExpirationWarningInterval, 0L, Integer.MAX_VALUE);
            }
            catch (NumberFormatException ne) {
                throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, ConfigMessages.ERR_CONFIG_ATTR_INVALID_INT_VALUE.get(PWD_ATTR_MINAGE, value.toString(), ne.getLocalizedMessage()));
            }
        } else {
            this.pPasswordExpirationWarningInterval = null;
        }
        value = this.getAttrValue(entry, PWD_ATTR_GRACEAUTHNLIMIT);
        if (value != null && value.toString().length() > 0) {
            try {
                this.pGraceLoginCount = Integer.parseInt(value.toString());
                this.checkIntegerAttr(PWD_ATTR_GRACEAUTHNLIMIT, this.pGraceLoginCount.intValue(), 0L, Integer.MAX_VALUE);
            }
            catch (NumberFormatException ne) {
                throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, ConfigMessages.ERR_CONFIG_ATTR_INVALID_INT_VALUE.get(PWD_ATTR_MINAGE, value.toString(), ne.getLocalizedMessage()));
            }
        } else {
            this.pGraceLoginCount = null;
        }
        value = this.getAttrValue(entry, PWD_ATTR_LOCKOUTDURATION);
        if (value != null && value.toString().length() > 0) {
            try {
                this.pLockoutDuration = Long.parseLong(value.toString());
                this.checkIntegerAttr(PWD_ATTR_LOCKOUTDURATION, this.pLockoutDuration, 0L, Integer.MAX_VALUE);
            }
            catch (NumberFormatException ne) {
                throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, ConfigMessages.ERR_CONFIG_ATTR_INVALID_INT_VALUE.get(PWD_ATTR_MINAGE, value.toString(), ne.getLocalizedMessage()));
            }
        } else {
            this.pLockoutDuration = null;
        }
        value = this.getAttrValue(entry, PWD_ATTR_MAXFAILURE);
        if (value != null && value.toString().length() > 0) {
            try {
                this.pLockoutFailureCount = Integer.parseInt(value.toString());
                this.checkIntegerAttr(PWD_ATTR_MAXFAILURE, this.pLockoutFailureCount.intValue(), 0L, Integer.MAX_VALUE);
            }
            catch (NumberFormatException ne) {
                throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, ConfigMessages.ERR_CONFIG_ATTR_INVALID_INT_VALUE.get(PWD_ATTR_MINAGE, value.toString(), ne.getLocalizedMessage()));
            }
        } else {
            this.pLockoutFailureCount = null;
        }
        value = this.getAttrValue(entry, PWD_ATTR_MUSTCHANGE);
        if (value != null && value.toString().length() > 0) {
            if (!value.toString().equalsIgnoreCase(Boolean.TRUE.toString())) {
                if (!value.toString().equalsIgnoreCase(Boolean.FALSE.toString())) throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, ConfigMessages.ERR_CONFIG_ATTR_INVALID_BOOLEAN_VALUE.get(PWD_ATTR_MUSTCHANGE, value.toString()));
            }
            this.pForceChangeOnReset = Boolean.parseBoolean(value.toString());
        } else {
            this.pForceChangeOnReset = null;
        }
        value = this.getAttrValue(entry, PWD_ATTR_ALLOWUSERCHANGE);
        if (value != null && value.toString().length() > 0) {
            if (!value.toString().equalsIgnoreCase(Boolean.TRUE.toString())) {
                if (!value.toString().equalsIgnoreCase(Boolean.FALSE.toString())) throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, ConfigMessages.ERR_CONFIG_ATTR_INVALID_BOOLEAN_VALUE.get(PWD_ATTR_ALLOWUSERCHANGE, value.toString()));
            }
            this.pAllowUserPasswordChanges = Boolean.parseBoolean(value.toString());
        } else {
            this.pAllowUserPasswordChanges = null;
        }
        value = this.getAttrValue(entry, PWD_ATTR_SAFEMODIFY);
        if (value != null && value.toString().length() > 0) {
            if (!value.toString().equalsIgnoreCase(Boolean.TRUE.toString())) {
                if (!value.toString().equalsIgnoreCase(Boolean.FALSE.toString())) throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, ConfigMessages.ERR_CONFIG_ATTR_INVALID_BOOLEAN_VALUE.get(PWD_ATTR_SAFEMODIFY, value.toString()));
            }
            this.pPasswordChangeRequiresCurrentPassword = Boolean.parseBoolean(value.toString());
        } else {
            this.pPasswordChangeRequiresCurrentPassword = null;
        }
        value = this.getAttrValue(entry, PWD_ATTR_FAILURECOUNTINTERVAL);
        if (value != null && value.toString().length() > 0) {
            try {
                this.pLockoutFailureExpirationInterval = Long.parseLong(value.toString());
                this.checkIntegerAttr(PWD_ATTR_FAILURECOUNTINTERVAL, this.pLockoutFailureExpirationInterval, 0L, Integer.MAX_VALUE);
            }
            catch (NumberFormatException ne) {
                throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, ConfigMessages.ERR_CONFIG_ATTR_INVALID_INT_VALUE.get(PWD_ATTR_FAILURECOUNTINTERVAL, value.toString(), ne.getLocalizedMessage()));
            }
        } else {
            this.pLockoutFailureExpirationInterval = null;
        }
        ObjectClass pwdValidatorPolicyOC = DirectoryServer.getObjectClass(PWD_OC_VALIDATORPOLICY);
        if (pwdValidatorPolicyOC == null) return;
        if (!objectClasses.containsKey(pwdValidatorPolicyOC)) return;
        AttributeType pwdAttrType = DirectoryServer.getAttributeType(PWD_ATTR_VALIDATOR, true);
        List<Attribute> pwdAttrList = entry.getAttribute(pwdAttrType);
        if (pwdAttrList == null) return;
        if (pwdAttrList.isEmpty()) return;
        Iterator<Attribute> i$ = pwdAttrList.iterator();
        block21: while (i$.hasNext()) {
            Attribute attr = i$.next();
            Iterator<AttributeValue> i$2 = attr.iterator();
            while (true) {
                if (!i$2.hasNext()) continue block21;
                AttributeValue val = i$2.next();
                DN validatorDN = DN.decode(val.getValue());
                if (DirectoryServer.getPasswordValidator(validatorDN) == null) {
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, CoreMessages.ERR_PWPOLICY_UNKNOWN_VALIDATOR.get(this.passwordPolicySubentryDN.toNormalizedString(), validatorDN.toString(), PWD_ATTR_VALIDATOR));
                }
                this.pValidatorNames.add(validatorDN);
            }
            break;
        }
        return;
    }

    private void checkIntegerAttr(String attrName, long attrValue, long lowerBound, long upperBound) throws DirectoryException {
        if (attrValue < lowerBound) {
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, ConfigMessages.ERR_CONFIG_ATTR_INT_BELOW_LOWER_BOUND.get(attrName, attrValue, lowerBound));
        }
        if (attrValue > upperBound) {
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, ConfigMessages.ERR_CONFIG_ATTR_INT_ABOVE_UPPER_BOUND.get(attrName, attrValue, upperBound));
        }
    }

    private AttributeValue getAttrValue(Entry entry, String pwdAttrName) {
        AttributeType pwdAttrType = DirectoryServer.getAttributeType(pwdAttrName, true);
        List<Attribute> pwdAttrList = entry.getAttribute(pwdAttrType);
        if (pwdAttrList != null && !pwdAttrList.isEmpty()) {
            for (Attribute attr : pwdAttrList) {
                Iterator<AttributeValue> i$ = attr.iterator();
                if (!i$.hasNext()) continue;
                AttributeValue value = i$.next();
                return value;
            }
        }
        return null;
    }

    @Override
    public boolean isAllowExpiredPasswordChanges() {
        return this.getDefaultPasswordPolicy().isAllowExpiredPasswordChanges();
    }

    @Override
    public boolean isAllowMultiplePasswordValues() {
        return this.getDefaultPasswordPolicy().isAllowMultiplePasswordValues();
    }

    @Override
    public boolean isAllowPreEncodedPasswords() {
        return this.getDefaultPasswordPolicy().isAllowPreEncodedPasswords();
    }

    @Override
    public boolean isAllowUserPasswordChanges() {
        return this.pAllowUserPasswordChanges != null ? this.pAllowUserPasswordChanges.booleanValue() : this.getDefaultPasswordPolicy().isAllowUserPasswordChanges();
    }

    @Override
    public boolean isExpirePasswordsWithoutWarning() {
        return this.getDefaultPasswordPolicy().isExpirePasswordsWithoutWarning();
    }

    @Override
    public boolean isForceChangeOnAdd() {
        return this.getDefaultPasswordPolicy().isForceChangeOnAdd();
    }

    @Override
    public boolean isForceChangeOnReset() {
        return this.pForceChangeOnReset != null ? this.pForceChangeOnReset.booleanValue() : this.getDefaultPasswordPolicy().isForceChangeOnReset();
    }

    @Override
    public int getGraceLoginCount() {
        return this.pGraceLoginCount != null ? this.pGraceLoginCount.intValue() : this.getDefaultPasswordPolicy().getGraceLoginCount();
    }

    @Override
    public long getIdleLockoutInterval() {
        return this.getDefaultPasswordPolicy().getIdleLockoutInterval();
    }

    @Override
    public AttributeType getLastLoginTimeAttribute() {
        return this.getDefaultPasswordPolicy().getLastLoginTimeAttribute();
    }

    @Override
    public String getLastLoginTimeFormat() {
        return this.getDefaultPasswordPolicy().getLastLoginTimeFormat();
    }

    @Override
    public long getLockoutDuration() {
        return this.pLockoutDuration != null ? this.pLockoutDuration.longValue() : this.getDefaultPasswordPolicy().getLockoutDuration();
    }

    @Override
    public int getLockoutFailureCount() {
        return this.pLockoutFailureCount != null ? this.pLockoutFailureCount.intValue() : this.getDefaultPasswordPolicy().getLockoutFailureCount();
    }

    @Override
    public long getLockoutFailureExpirationInterval() {
        return this.pLockoutFailureExpirationInterval != null ? this.pLockoutFailureExpirationInterval.longValue() : this.getDefaultPasswordPolicy().getLockoutFailureExpirationInterval();
    }

    @Override
    public long getMaxPasswordAge() {
        return this.pMaxPasswordAge != null ? this.pMaxPasswordAge.longValue() : this.getDefaultPasswordPolicy().getMaxPasswordAge();
    }

    @Override
    public long getMaxPasswordResetAge() {
        return this.getDefaultPasswordPolicy().getMaxPasswordResetAge();
    }

    @Override
    public long getMinPasswordAge() {
        return this.pMinPasswordAge != null ? this.pMinPasswordAge.longValue() : this.getDefaultPasswordPolicy().getMinPasswordAge();
    }

    @Override
    public AttributeType getPasswordAttribute() {
        return this.pPasswordAttribute != null ? this.pPasswordAttribute : this.getDefaultPasswordPolicy().getPasswordAttribute();
    }

    @Override
    public boolean isPasswordChangeRequiresCurrentPassword() {
        return this.pPasswordChangeRequiresCurrentPassword != null ? this.pPasswordChangeRequiresCurrentPassword.booleanValue() : this.getDefaultPasswordPolicy().isPasswordChangeRequiresCurrentPassword();
    }

    @Override
    public long getPasswordExpirationWarningInterval() {
        return this.pPasswordExpirationWarningInterval != null ? this.pPasswordExpirationWarningInterval.longValue() : this.getDefaultPasswordPolicy().getPasswordExpirationWarningInterval();
    }

    @Override
    public int getPasswordHistoryCount() {
        return this.pPasswordHistoryCount != null ? this.pPasswordHistoryCount.intValue() : this.getDefaultPasswordPolicy().getPasswordHistoryCount();
    }

    @Override
    public long getPasswordHistoryDuration() {
        return this.getDefaultPasswordPolicy().getPasswordHistoryDuration();
    }

    @Override
    public SortedSet<String> getPreviousLastLoginTimeFormats() {
        return this.getDefaultPasswordPolicy().getPreviousLastLoginTimeFormats();
    }

    @Override
    public long getRequireChangeByTime() {
        return this.getDefaultPasswordPolicy().getRequireChangeByTime();
    }

    @Override
    public boolean isRequireSecureAuthentication() {
        return this.getDefaultPasswordPolicy().isRequireSecureAuthentication();
    }

    @Override
    public boolean isRequireSecurePasswordChanges() {
        return this.getDefaultPasswordPolicy().isRequireSecurePasswordChanges();
    }

    @Override
    public boolean isSkipValidationForAdministrators() {
        return this.getDefaultPasswordPolicy().isSkipValidationForAdministrators();
    }

    @Override
    public PasswordPolicyCfgDefn.StateUpdateFailurePolicy getStateUpdateFailurePolicy() {
        return this.getDefaultPasswordPolicy().getStateUpdateFailurePolicy();
    }

    @Override
    public boolean isAuthPasswordSyntax() {
        return this.pAuthPasswordSyntax != null ? this.pAuthPasswordSyntax.booleanValue() : this.getDefaultPasswordPolicy().isAuthPasswordSyntax();
    }

    @Override
    public List<PasswordStorageScheme<?>> getDefaultPasswordStorageSchemes() {
        return this.getDefaultPasswordPolicy().getDefaultPasswordStorageSchemes();
    }

    @Override
    public Set<String> getDeprecatedPasswordStorageSchemes() {
        return this.getDefaultPasswordPolicy().getDeprecatedPasswordStorageSchemes();
    }

    @Override
    public DN getDN() {
        return this.passwordPolicySubentryDN;
    }

    @Override
    public boolean isDefaultPasswordStorageScheme(String name) {
        return this.getDefaultPasswordPolicy().isDefaultPasswordStorageScheme(name);
    }

    @Override
    public boolean isDeprecatedPasswordStorageScheme(String name) {
        return this.getDefaultPasswordPolicy().isDeprecatedPasswordStorageScheme(name);
    }

    @Override
    public Collection<PasswordValidator<?>> getPasswordValidators() {
        if (!this.pValidatorNames.isEmpty()) {
            HashSet values = new HashSet();
            for (DN validatorDN : this.pValidatorNames) {
                PasswordValidator<? extends PasswordValidatorCfg> validator = DirectoryServer.getPasswordValidator(validatorDN);
                if (validator == null) {
                    RejectPasswordValidator errorValidator = new RejectPasswordValidator(validatorDN.toString(), this.passwordPolicySubentryDN.toString());
                    values.clear();
                    values.add(errorValidator);
                    return values;
                }
                values.add(validator);
            }
            this.isAlreadyLogged.set(false);
            return values;
        }
        return this.getDefaultPasswordPolicy().getPasswordValidators();
    }

    @Override
    public Collection<AccountStatusNotificationHandler<?>> getAccountStatusNotificationHandlers() {
        return this.getDefaultPasswordPolicy().getAccountStatusNotificationHandlers();
    }

    @Override
    public PasswordGenerator<?> getPasswordGenerator() {
        return this.getDefaultPasswordPolicy().getPasswordGenerator();
    }

    private final class RejectPasswordValidator
    extends PasswordValidator<PasswordValidatorCfg> {
        private final String validatorName;
        private final String pwPolicyName;

        public RejectPasswordValidator(String name, String policyName) {
            this.validatorName = name;
            this.pwPolicyName = policyName;
        }

        @Override
        public void initializePasswordValidator(PasswordValidatorCfg configuration) throws ConfigException {
        }

        @Override
        public boolean passwordIsAcceptable(ByteString newPassword, Set<ByteString> currentPasswords, Operation operation, Entry userEntry, MessageBuilder invalidReason) {
            invalidReason.append(CoreMessages.ERR_PWPOLICY_REJECT_DUE_TO_UNKNOWN_VALIDATOR_REASON.get());
            if (SubentryPasswordPolicy.this.isAlreadyLogged.compareAndSet(false, true)) {
                ErrorLogger.logError(CoreMessages.ERR_PWPOLICY_REJECT_DUE_TO_UNKNOWN_VALIDATOR_LOG.get(userEntry.getDN().toNormalizedString(), this.pwPolicyName, this.validatorName));
            }
            return false;
        }
    }
}

