/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core.networkgroups;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.opends.server.api.ClientConnection;
import org.opends.server.core.networkgroups.ConnectionCriteria;
import org.opends.server.types.AuthenticationType;
import org.opends.server.types.DN;

final class ANDConnectionCriteria
implements ConnectionCriteria {
    private final List<ConnectionCriteria> subCriteria;

    public ANDConnectionCriteria(Collection<? extends ConnectionCriteria> subCriteria) {
        this.subCriteria = new ArrayList<ConnectionCriteria>(subCriteria);
    }

    @Override
    public boolean matches(ClientConnection connection) {
        for (ConnectionCriteria filter : this.subCriteria) {
            if (filter.matches(connection)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean willMatchAfterBind(ClientConnection connection, DN bindDN, AuthenticationType authType, boolean isSecure) {
        for (ConnectionCriteria filter : this.subCriteria) {
            if (filter.willMatchAfterBind(connection, bindDN, authType, isSecure)) continue;
            return false;
        }
        return true;
    }
}

