/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core.networkgroups;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.opends.server.core.WorkflowTopologyNode;

public class NetworkGroupNamingContexts {
    private List<WorkflowTopologyNode> namingContexts = new CopyOnWriteArrayList<WorkflowTopologyNode>();
    private List<WorkflowTopologyNode> _namingContexts = Collections.unmodifiableList(this.namingContexts);
    private List<WorkflowTopologyNode> publicNamingContexts;
    private List<WorkflowTopologyNode> _publicNamingContexts;
    private List<WorkflowTopologyNode> privateNamingContexts = new CopyOnWriteArrayList<WorkflowTopologyNode>();
    private List<WorkflowTopologyNode> _privateNamingContexts = Collections.unmodifiableList(this.privateNamingContexts);

    public NetworkGroupNamingContexts() {
        this.publicNamingContexts = new CopyOnWriteArrayList<WorkflowTopologyNode>();
        this._publicNamingContexts = Collections.unmodifiableList(this.publicNamingContexts);
    }

    public void resetLists() {
        this.namingContexts.clear();
        this.privateNamingContexts.clear();
        this.publicNamingContexts.clear();
    }

    public void addNamingContext(WorkflowTopologyNode workflow) {
        this.namingContexts.add(workflow);
        if (workflow.isPrivate()) {
            this.privateNamingContexts.add(workflow);
        } else {
            this.publicNamingContexts.add(workflow);
        }
    }

    public Iterable<WorkflowTopologyNode> getNamingContexts() {
        return this._namingContexts;
    }

    public Iterable<WorkflowTopologyNode> getPrivateNamingContexts() {
        return this._privateNamingContexts;
    }

    public Iterable<WorkflowTopologyNode> getPublicNamingContexts() {
        return this._publicNamingContexts;
    }

    public StringBuilder toString(String leftMargin) {
        StringBuilder sb = new StringBuilder();
        String newMargin = leftMargin + "   ";
        sb.append(leftMargin + "List of naming contexts:\n");
        for (WorkflowTopologyNode w : this.namingContexts) {
            sb.append((CharSequence)w.toString(newMargin));
        }
        sb.append(leftMargin + "List of PRIVATE naming contexts:\n");
        for (WorkflowTopologyNode w : this.privateNamingContexts) {
            sb.append((CharSequence)w.toString(newMargin));
        }
        sb.append(leftMargin + "List of PUBLIC naming contexts:\n");
        for (WorkflowTopologyNode w : this.publicNamingContexts) {
            sb.append((CharSequence)w.toString(newMargin));
        }
        return sb;
    }
}

