/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import org.opends.messages.ExtensionMessages;
import org.opends.server.admin.std.server.AnonymousSASLMechanismHandlerCfg;
import org.opends.server.api.SASLMechanismHandler;
import org.opends.server.config.ConfigException;
import org.opends.server.core.BindOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.types.AdditionalLogItem;
import org.opends.server.types.AuthenticationInfo;
import org.opends.server.types.ByteString;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;

public class AnonymousSASLMechanismHandler
extends SASLMechanismHandler<AnonymousSASLMechanismHandlerCfg> {
    @Override
    public void initializeSASLMechanismHandler(AnonymousSASLMechanismHandlerCfg configuration) throws ConfigException, InitializationException {
        DirectoryServer.registerSASLMechanismHandler("ANONYMOUS", this);
    }

    @Override
    public void finalizeSASLMechanismHandler() {
        DirectoryServer.deregisterSASLMechanismHandler("ANONYMOUS");
    }

    @Override
    public void processSASLBind(BindOperation bindOperation) {
        String credString;
        ByteString saslCredentials = bindOperation.getSASLCredentials();
        if (saslCredentials != null && (credString = saslCredentials.toString()).length() > 0) {
            bindOperation.addAdditionalLogItem(AdditionalLogItem.quotedKeyValue(this.getClass(), "trace", credString));
            ErrorLogger.logError(ExtensionMessages.INFO_SASLANONYMOUS_TRACE.get(bindOperation.getConnectionID(), bindOperation.getOperationID(), credString));
        }
        AuthenticationInfo authInfo = new AuthenticationInfo();
        bindOperation.setAuthenticationInfo(authInfo);
        bindOperation.setResultCode(ResultCode.SUCCESS);
    }

    @Override
    public boolean isPasswordBased(String mechanism) {
        return false;
    }

    @Override
    public boolean isSecure(String mechanism) {
        return false;
    }
}

