/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import org.opends.messages.Message;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.EntryCacheCfg;
import org.opends.server.api.Backend;
import org.opends.server.api.BackendInitializationListener;
import org.opends.server.api.EntryCache;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.extensions.EntryCacheCommon;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.Attribute;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;

public class DefaultEntryCache
extends EntryCache<EntryCacheCfg>
implements ConfigurationChangeListener<EntryCacheCfg>,
BackendInitializationListener {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static EntryCache<? extends EntryCacheCfg>[] cacheOrder = new EntryCache[0];

    public DefaultEntryCache() {
        DirectoryServer.registerBackendInitializationListener(this);
    }

    @Override
    public void initializeEntryCache(EntryCacheCfg configEntry) throws ConfigException, InitializationException {
    }

    @Override
    public void finalizeEntryCache() {
        for (EntryCache<? extends EntryCacheCfg> entryCache : cacheOrder) {
            entryCache.finalizeEntryCache();
        }
        cacheOrder = new EntryCache[0];
    }

    @Override
    public boolean containsEntry(DN entryDN) {
        if (entryDN == null) {
            return false;
        }
        for (EntryCache<? extends EntryCacheCfg> entryCache : cacheOrder) {
            if (!entryCache.containsEntry(entryDN)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Entry getEntry(Backend backend, long entryID) {
        for (EntryCache<? extends EntryCacheCfg> entryCache : cacheOrder) {
            Entry entry = entryCache.getEntry(backend, entryID);
            if (entry == null) continue;
            return entry.duplicate(true);
        }
        if (cacheOrder.length != 0) {
            this.cacheMisses.getAndIncrement();
        }
        return null;
    }

    @Override
    public Entry getEntry(DN entryDN) {
        for (EntryCache<? extends EntryCacheCfg> entryCache : cacheOrder) {
            Entry entry = entryCache.getEntry(entryDN);
            if (entry == null) continue;
            return entry.duplicate(true);
        }
        if (cacheOrder.length != 0) {
            this.cacheMisses.getAndIncrement();
        }
        return null;
    }

    @Override
    public long getEntryID(DN entryDN) {
        for (EntryCache<? extends EntryCacheCfg> entryCache : cacheOrder) {
            long entryID = entryCache.getEntryID(entryDN);
            if (entryID == -1L) continue;
            return entryID;
        }
        return -1L;
    }

    @Override
    public DN getEntryDN(Backend backend, long entryID) {
        for (EntryCache<? extends EntryCacheCfg> entryCache : cacheOrder) {
            DN entryDN = entryCache.getEntryDN(backend, entryID);
            if (entryDN == null) continue;
            return entryDN;
        }
        return null;
    }

    @Override
    public void putEntry(Entry entry, Backend backend, long entryID) {
        for (EntryCache<? extends EntryCacheCfg> entryCache : cacheOrder) {
            if (!entryCache.filtersAllowCaching(entry)) continue;
            entryCache.putEntry(entry.duplicate(false), backend, entryID);
            break;
        }
    }

    @Override
    public boolean putEntryIfAbsent(Entry entry, Backend backend, long entryID) {
        for (EntryCache<? extends EntryCacheCfg> entryCache : cacheOrder) {
            if (!entryCache.filtersAllowCaching(entry)) continue;
            return entryCache.putEntryIfAbsent(entry.duplicate(false), backend, entryID);
        }
        return false;
    }

    @Override
    public void removeEntry(DN entryDN) {
        for (EntryCache<? extends EntryCacheCfg> entryCache : cacheOrder) {
            if (!entryCache.containsEntry(entryDN)) continue;
            entryCache.removeEntry(entryDN);
            break;
        }
    }

    @Override
    public void clear() {
        for (EntryCache<? extends EntryCacheCfg> entryCache : cacheOrder) {
            entryCache.clear();
        }
    }

    @Override
    public void clearBackend(Backend backend) {
        for (EntryCache<? extends EntryCacheCfg> entryCache : cacheOrder) {
            entryCache.clearBackend(backend);
        }
    }

    @Override
    public void clearSubtree(DN baseDN) {
        for (EntryCache<? extends EntryCacheCfg> entryCache : cacheOrder) {
            entryCache.clearSubtree(baseDN);
        }
    }

    @Override
    public void handleLowMemory() {
        for (EntryCache<? extends EntryCacheCfg> entryCache : cacheOrder) {
            entryCache.handleLowMemory();
        }
    }

    @Override
    public boolean isConfigurationChangeAcceptable(EntryCacheCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(EntryCacheCfg configuration) {
        ConfigChangeResult changeResult = new ConfigChangeResult(ResultCode.SUCCESS, false, new ArrayList<Message>());
        return changeResult;
    }

    @Override
    public ArrayList<Attribute> getMonitorData() {
        ArrayList<Attribute> attrs;
        block3: {
            attrs = new ArrayList<Attribute>();
            Long entryCacheHits = new Long(0L);
            Long entryCacheMisses = new Long(this.cacheMisses.longValue());
            Long currentEntryCacheCount = new Long(0L);
            for (EntryCache<? extends EntryCacheCfg> entryCache : cacheOrder) {
                entryCacheHits = entryCacheHits + entryCache.getCacheHits();
                currentEntryCacheCount = currentEntryCacheCount + entryCache.getCacheCount();
            }
            try {
                attrs = EntryCacheCommon.getGenericMonitorData(entryCacheHits, entryCacheMisses, null, null, currentEntryCacheCount, null);
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) break block3;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        return attrs;
    }

    @Override
    public Long getCacheCount() {
        Long cacheCount = new Long(0L);
        for (EntryCache<? extends EntryCacheCfg> entryCache : cacheOrder) {
            cacheCount = cacheCount + entryCache.getCacheCount();
        }
        return cacheCount;
    }

    @Override
    public String toVerboseString() {
        StringBuilder sb = new StringBuilder();
        for (EntryCache<? extends EntryCacheCfg> entryCache : cacheOrder) {
            String s = entryCache.toVerboseString();
            if (s == null) continue;
            sb.append(s);
        }
        String verboseString = sb.toString();
        return verboseString.length() > 0 ? verboseString : null;
    }

    public final EntryCache<? extends EntryCacheCfg>[] getCacheOrder() {
        return cacheOrder;
    }

    public final void setCacheOrder(SortedMap<Integer, EntryCache<? extends EntryCacheCfg>> cacheOrderMap) {
        cacheOrder = cacheOrderMap.values().toArray(new EntryCache[0]);
    }

    @Override
    public void performBackendPreInitializationProcessing(Backend backend) {
    }

    @Override
    public void performBackendPostFinalizationProcessing(Backend backend) {
        if (!DirectoryServer.getInstance().isShuttingDown()) {
            this.clearBackend(backend);
        }
    }

    @Override
    public void performBackendPostInitializationProcessing(Backend backend) {
    }

    @Override
    public void performBackendPreFinalizationProcessing(Backend backend) {
    }
}

